;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		File.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------
;;;
;;;	Files can contain
;;;	1. ":theory <theory-name>"
;;;	2. ":label <value> <label-structure-name>"
;;;	3. ":nolabel"
;;;	4. Logical sentences
;;;
;;;	Keywords apply to subsequent sentences

(defun dtp-load (filename)
  (unless (find #\/ filename)
    (setq filename (concatenate 'string *dtp-logic-directory* filename)) )
  (unless (find #\. filename)
    (setq filename (concatenate 'string filename ".dtp")) )
  (with-open-file (p filename :direction :input)
    (loop
	initially (when (trace-load *tracemap*) (format t "~&DTP Loading: "))
	with *package* = *dtp-package*
	with theory
	with theories = nil
	with keyword = (read p nil nil)	; :theory
	until (null keyword)
	finally
	  (when (trace-load *tracemap*) (format t "Done~%"))
	  (return (reverse theories))
	do (setq theory (read p nil nil))
	   (when (null theory) (loop-finish))
	   (pushnew theory theories)
	   (when (trace-load *tracemap*) (format t "~A..." theory))
	   (loop
	       with label = nil
	       with sentences = nil
	       for sexp = (read p nil nil)
	       until (or (null sexp) (eq sexp :theory))
	       do
		 (case sexp
		  (:label
		   (let* ((value (read p nil nil))
			  (structure-name (read p nil nil))
			  structure )
		     (setq structure (get-label-structure structure-name))
		     (if structure
			 (setq label
			   (make-label :value value :structure structure) )
		       (format t "~&Error: Label structure ~A not known~%"
			       structure-name ))))
		  (:nolabel
		   (setq label nil) )
		  (otherwise
		   (push (cons sexp label) sentences) ))
	       finally
		 (make-theory-from-sentences theory (reverse sentences)) ))
    ))

;;;----------------------------------------------------------------------------
