;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		DTP.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "USER")

;;;----------------------------------------------------------------------------

(defparameter *dtp-directory*
    #+allegro "~/Lisp/DTP-Old/"
    #+lucid "/lisp/dtp/"
    #-(or allegro lucid) "" )
(defparameter *dtp-logic-directory*
    #+allegro "~/Lisp/DTP-Old/Logic/"
    #+lucid "/lisp/dtp/"
    #-(or allegro lucid) "" )

(defparameter *dtp-files*
    '(
      "definitions"

      ;; Stolen from MVL
      "symbols" "bindings" "binding-dag" "match" ; Variables & binding lists
      "cnf"				; Database

      "internals" "database" "hierarchy"
      "literals" "clauses" "agenda"
      "labels" "answers"
      "residue" "cache" "inference" "proof-setup"
      "toplevel" "tracing"
      "file" "test"

      ;; Optional / untested
      "epikit-dtp"			; Interface to DTP with Epikit names
      "circuits"			; Example of residue: design synthesis
      ))

(defun load-dtp-system (&key (recompile nil))
  (when (eq recompile :optimize)
    (proclaim
     '(optimize speed (safety 1) (space 0) #+lucid (compilation-speed 0)) ))
  (dolist (file *dtp-files*)
    (setq file (concatenate 'string *dtp-directory* file))
    (if recompile
	(compile-file file)
      #+allegro (excl:compile-file-if-needed file) )
    (load file) ))

(eval-when (load eval)
  (load-dtp-system)
  (pushnew :dtp *features*) )

;;;----------------------------------------------------------------------------
