;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Answers.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------

(defstruct (answer
	    (:print-function answer-print-function) )
  logic
  label
  assumptions )

;;;----------------------------------------------------------------------------

(defun answer-print-function (structure stream depth)
  (declare (ignore depth))
  (format stream "<~A" (answer-logic structure))
  (when (answer-label structure)
    (format stream " with label ~A" (label-value (answer-label structure))) )
  (when (answer-assumptions structure)
    (when (answer-label structure) (format stream " and"))
    (format stream " with ~D assumption~:P"
	    (length (answer-assumptions structure)) ))
  (format stream ">") )

;;;----------------------------------------------------------------------------

(defun equal-answer-p (answer1 answer2)
  (and (equal (answer-logic answer1) (answer-logic answer2))
       (equal-label-p (answer-label answer1) (answer-label answer2))
       (equal (answer-assumptions answer1) (answer-assumptions answer2)) ))

;;;----------------------------------------------------------------------------

(defun answer-visible-label (answer)
  (when (answer-label answer)
    (label-value (answer-label answer)) ))

;;;----------------------------------------------------------------------------

(defun alter-form (bound-query query new-form)
  (let ((binding-list (my-unifyp bound-query query)))
    (plug new-form binding-list) ))

;;;----------------------------------------------------------------------------
