;;; -*- Mode: LISP; Syntax: Common-lisp; Package: DTP; Base: 10 -*-

;;;----------------------------------------------------------------------------
;;;
;;;	File		Agenda.Lisp
;;;	System		Don's Theorem Prover
;;;
;;;	Written by	Don Geddis (Geddis@CS.Stanford.Edu)

(in-package "DTP")

;;;----------------------------------------------------------------------------

(defun binding-list-of-node (node)
  (if (agenda-node-p node)
      (anode-binding-list node)
    '((t . t)) ))

(defun assumptions-of-node (node)
  (when (agenda-node-p node) (anode-assumptions node)) )

;;;----------------------------------------------------------------------------

(defun agenda-goal-ancestors (node)
  (let ((parents (anode-parents node)))
    (setq parents (mapcar #'id-to-node parents))
    (setq parents (remove-if-not #'agenda-node-p parents))
    (when parents
      (append parents
	      (apply #'append
		     (mapcar #'agenda-goal-ancestors parents)) ))
    ))

;;;----------------------------------------------------------------------------

(defun find-agenda-node-with-id (id)
  (or
   (loop
       for goal in (proof-negated-goals *proof*)
       when (eq id (node-id goal))
       return goal )
   (loop
       for goal in (proof-subgoals *proof*)
       when (eq id (node-id goal))
       return goal ) ))

;;;----------------------------------------------------------------------------

(defun advise-choose (nodes)
  (when nodes
    (if (null (cdr nodes))
	nodes
      (progn
	(do* ((ns nodes (cdr ns))
	      (node (car ns) (car ns))
	      (count 1 (1+ count)) )
	    ((null ns))
	  (format t "~4D  ~A~%" count (node-clause node)) )
	(format t "Continue with which clause? ")
	(list (nth (1- (read)) nodes)) ))))

;;;----------------------------------------------------------------------------

