/** xnetcore.h: macros for converting Suncore functions into X **/

extern char xMarker;				/* marker character */
extern float xX, xY,newX, newY, xCharSize;	/* for moving around */
extern short fCenterX, fCenterY;		/* center of font */
extern int XLineWidth, XLineStyle;		/* line parameters */

#define coreToX(x) (x)				/* scaling for x-axis */
#define coreToY(y) (YMAX-(y))			/* y-axis is upside down */

	/* segments are not supported in XNet */
#define create_retained_segment(seg)
#define close_retained_segment(seg) 
#define create_temporary_segment() 
#define close_temporary_segment() 
#define delete_retained_segment(seg)
#define delete_all_retained_segments() XClearWindow(netD, netW)
#define wipe_all_segments(nseg) XClearWindow(netD, netW)
	/* marker functions */
#define set_marker_symbol(m) xMarker=(m)

#define marker_abs_2(x,y) \
  XDrawString(netD,netW,netGC, \
	      (int) (xX=coreToX(x))-fCenterX, (int)(xY=coreToY(y))+fCenterY,\
	      &xMarker, 1)

#define marker_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
  XDrawString(netD, netW, netGC, \
	      (int)(xX=coreToX((x)*xscale+xshift))-fCenterX, \
	      (int)(xY=coreToY((y)*yscale+yshift))+fCenterY, \
	      &xMarker, 1)
	/* move functions */
#define move_abs_2(x,y) xX=coreToX(x), xY=coreToY(y)

#define move_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
 xX=coreToX((x)*xscale+xshift), xY=coreToY((y)*yscale+yshift)

#define move_rel_2(x,y) xX += (x), xY -= (y)


	/* line functions */
#define line_abs_2(x,y) \
  XDrawLine(netD,netW,netGC,(int)xX,(int)xY, \
	    (int)(newX=coreToX(x)),(int)(newY=coreToY(y))),\
  xX=newX, xY=newY

#define line_abs_2_transform(x,y,xscale,yscale,xshift,yshift) \
  XDrawLine(netD,netW,netGC,(int)xX,(int)xY, \
	    (int)(newX=coreToX((x)*xscale+xshift)), \
	    (int)(newY=coreToY((y)*yscale+yshift))),\
  xX=newX, xY=newY

#define line_rel_2(x,y) \
  XDrawLine(netD,netW,netGC,(int)xX,(int)xY,\
	    (int)(newX=xX+(x)), (int)(newY=xY-(y))),\
  xX=newX, xY=newY
#define set_linewidth(x) \
  XSetLineAttributes(netD, netGC, XLineWidth=x, XLineStyle,\
		     CapNotLast, JoinMiter )
#define set_linestyle(style) \
  XSetLineAttributes(netD, netGC, XLineWidth, XLineStyle=style,\
		     CapNotLast, JoinMiter )
#define set_charsize(x,y) xCharSize=(x)

#define text(str) XDrawString(netD, netW, netGC, \
			      (int)xX, (int)xY+fCenterY, str, strlen(str))

	/* unsupported (yet) functions */
#define new_frame() 		
#define set_charpath_2(x,y) 0
#define set_charup_2(x,y)
#define set_charprecision(prec) 
#define set_drag(onoff)
#define set_font( font ) 
#define set_fill_index(color) 
#define set_text_index(color) 
#define set_line_index(color) 
#define set_output_clipping(onoff) 
#define set_window_clipping(onoff) 
#define set_segment_visibility(seg,o) 
#define set_image_transformation_type(i) 
#define set_segment_image_transformation_2(seg,x,y,a,sx,sy) 
#define inquire_text_extent_2(str,xp,yp) 
#define inquire_retained_segment_names(seg,seg_array,np)
#define get_mouse_state(loc,n,xp,yp,ip)

/***	new functions that are not in SunCore ***/

#define rsh(str)

#define fill_box(x,y,w,h,color) \
  (color)==BLACK? \
  XFillRectangle(netD,netW,netGC,\
		 (int)(xX=coreToX(x)),(int)(xY=coreToY((y)+(h))), \
		 (unsigned) (w),(unsigned) (h)) : \
  XDrawRectangle(netD,netW,netGC,\
		 (int)(xX=coreToX(x)),(int)(xY=coreToY((y)+(h))), \
		 (unsigned) (w),(unsigned) (h))

#define clear_box(x,y,w,h) \
  XClearArea(netD,netW,(int)(xX=coreToX(x)),(int)(xY=coreToY((y)+(h))), \
	     (unsigned) (w+1),(unsigned) (h+1),False)

/*** this is a combination of move_abs_2() and text() ***/

#define text_location(str, x, y) \
  XDrawString(netD,netW,netGC, \
	      (int)(xX=coreToX(x)), (int)(xY=coreToY(y))+fCenterY,\
	      str,strlen(str))


