/* $Header: /soma/users/miyata/planet/src/RCS/sunnetio.c,v 5.6.0.5 91/02/13 15:41:58 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/sunnetio.c,v 5.6.0.5 91/02/13 15:41:58 miyata Exp $";
/******************* UPDATES *****************************
sunnetio.c:
2/7/91 fixed bug in print_weight so correct biases are printed for partial connection.
9/9/90  fixed str_to_float() so defined strings are interpreted in 'value'.
8/1/90   implemented close_file to be used to close files opened with open_file
6/5/90   changed find_file() and open_file() to read from a program.
5/27/90  fixed bug in read_vector() - used in c_value().
11/17/89 fixed bug in fread_..() functions for reading ahead (by Harada).
***********************************************************/
#include <stdio.h>
#include <sys/types.h>			/* sys/{type.h,stat.h} */
#include <sys/stat.h>			/* for stat() function */
#include <ctype.h>
#include "net.h"
#include "files.h"
#include "alloc.h"
#include "error.h"
#include "parameter.h"
#include "command.h"
#include "msg.h"

#define weightTrans 1

char _buf_[BUFSIZE];

/* fprint_xxx() routines are used to write into save file */
fprint_error ( file, step, error )
FILE	*file;
int	step; REAL error;
{
    fprintf(file,"step=%d Error=%f\n", step, error );
}

fprint_command ( file, command, argn, args )
FILE	*file;
char	*command, args[][ Largs ] ;
int	argn;
{
  register int i;
  fprintf( file, "command %s", command );
  for ( i=0 ; i < argn ; i++ ) fprintf ( file, " %s", args[i] );
  fprintf ( file, "\n" );
}

fprint_network_weight( file, net ) 
NETWORK *net; FILE *file; 
{
  CONNECT	*connectP ;
  register int n, i,j;
  WEIGHT   *weight;
  int	   maxi, symmetric;
  IfErr( net ) Erreturn ( "network not defined" );
  IfErr( file ) Erreturn( "file not open" );
  for ( n=0 ; n < net->n_connect ; n++ ) {
    connectP = &net->connect[n];
    symmetric = (connectP->type==SYMMETRIC)? 1 : 0;
#ifdef weightTrans
    weight = connectP->weight;
    for(j=0; j< connectP->to_nunit ; j++) {
      maxi = symmetric? j : connectP->from_nunit-1;
      for(i=0; i<= maxi ; i++, weight++ )
#else
    for(j=0; j< connectP->to_nunit ; j++) {
      weight = &connectP->weight[j];
      maxi = symmetric? j : connectP->from_nunit-1;
      for(i=0; i<= maxi ; i++, weight += connectP->to_nunit)
#endif weightTrans
	fprintf(file, "%g ", *weight);
      if(connectP->tolayer) fprintf(file, "%g ", connectP->tolayer->bias[j] );
      fprintf(file, "\n");
    }
  }
  fflush( file );
  return( OK );
}

/* readWeightFile() reads from save file.  It returns EOF upon reading EOF,
 * OK if step=.. line is read w/o weights, and 2 is step=.. line is read with
 * weights. */	
readWeightFile( file, netPP, stepP, errorP )
FILE *file;
REAL *stepP, *errorP;
NETWORK **netPP;	/* we need double ptr 'cause ptr may change when
			 * network file is read within weight file */
{
  char	command[Lcomm], args[Nargs][Largs];
  char command_line[BUFSIZE],c;
  int	argn, line, line_read,status;
  VECTOR *vector;

  for(line=1; (line_read = read_line( command_line, BUFSIZE, file )) !=EOF; 
	line += line_read-1 ) {

    parse_command( command_line, command, &argn, args );
    IF( command, "" ) continue;
    IF( command, "value" ) {
      if( argn<1 ) Erreturn1("invalid 'value' statement at line %d", line);
      if( Err( vector=eval_expression(find_expression( *netPP, args[0] ))) ||
	  Err(fread_vector( file, vector->value, vector->nvalue )))
	Erreturn2("%s: at line %d", ERR_MSG, line);
    }
    IF( command, "command" ) {
      IfErr(eval_command( args[0], argn-1, args[1])) return( ERR );
    }
    else if( sscanf(command, "step=%f", stepP) || 
	     sscanf(command, "epoch=%f", stepP) ) {
    /* reading a weight file */
      if(argn) sscanf(args[0], "Error=%f", errorP);
      if( isdigit(c=getc(file)) || c=='-' || c=='.' ) {  
	/* number - try reading weights */
        ungetc(c, file);
        if( OK==(status=fread_weight( file, *netPP )) )
	return( READWEIGHTS );	/* all weights read successfully */
        else return( status );
      }
      ungetc(c, file);
      return( OK );	/* return to check if we've read enough */
    }
  }
  return( EOF );
}

fread_weight( file, net )
NETWORK *net; FILE *file;
{
  register int n;
  int status;
  IfErr( net ) Erreturn( "network not defined" );
  for( n=0 ; n < net->n_connect ; n++ ) {
    IfErr( status = fread_weight_in_connection ( file, &net->connect[n] ) ) 
      Erreturn2("%s: for connection %s", ERR_MSG, net->connect[n].name);
    IfEOF( status ) return( EOF );  /* premature EOF - incomplete file */
  }
  return( OK );                       /* all weights are read OK */
}

extern void allocate_index();
#define alloc_index(ind) \

fread_weight_in_connection( file, connectP )
FILE	*file; CONNECT	*connectP;
{
  register int i,j, ij;
  int	status;
  WEIGHT *weight ;
  WINDEX *index = connectP->index;
  /* static char pre_buf[BUFSIZE];/* Added by Harada */
  int	from_nunit = connectP->from_nunit, to_nunit = connectP->to_nunit;
  float var=.0;	/* variance for random value */
  double nrandom();
  int	nind=0, nind_back=0, maxi;
  int   n;

#ifdef weightTrans
  weight = connectP->weight;
  for(j=0, ij=0 ; j< to_nunit ; j++) {
    maxi = ( connectP->type == SYMMETRIC )? j : from_nunit;
    for(i=0; i< maxi ; i++, weight++, ij++ ) {
#else
  for(j=0; j< to_nunit ; j++) {
    weight = &connectP->weight[j];
    ij = j;
    maxi = ( connectP->type == SYMMETRIC )? j : from_nunit;
    for(i=0; i< maxi ; i++, weight += to_nunit, ij += to_nunit ) {
#endif weightTrans
	/* if not indexing don't bother to look any further */
      if( index==NULL && fscanf(file, "%f ", weight ) ) continue;
      IfEOF( status=fscanf(file, BUFFMT, _buf_ )) return( EOF );
      IfErr( status ) Erreturn("Cannot read weights"); 
      substitute_defined_str( _buf_ );
	/* BUG: not necessary to make index just for 'r' weights */
      if(index==NULL) {
	if(i||j) Erreturn1("Invalid weight value %s", _buf_ )
	  /* it's too late to allocate index after reading some weights */
	  /* this could happen only if a weight file contains weight type 
	     specification - which should not happen.  */
	index = new(WINDEX);
		/* for now allocate maximum space */
	allocate_index(index, from_nunit*to_nunit, from_nunit, to_nunit);
      }

      if(_buf_[0]=='n' || (_buf_[0]=='.'&&_buf_[1]=='\0')) {/* no connection */
	*weight = 0.0;
	continue;
      }
/* Determine type & initial value of weight - First, whether its fixed */
      if(_buf_[0]=='f') {	/* fixed connection - no backward index */
	strcpy( _buf_, _buf_+1 );
      }
      else {			/* trainable weight -> make backward index */
	index->from_back[nind_back]=i; index->to_back[nind_back]=j; 
	index->weight_back[nind_back]=ij;
	nind_back++;
      }
/* Second, make forward index */
      index->from[nind]=i, index->to[nind]=j, index->weight[nind]=ij;

/* Third, determine initial value */
      if( _buf_[0]=='r' ) { 	  /* random initial value */
	var = .0;	      /* if var=.0 no variance is given- use default*/
	*weight = (sscanf(_buf_, "r%f", &var)==1? var : INITWEIGHT) *nrandom();
	index->type[nind] = RandConnect, index->init[nind] = var;
      }
      else if( _buf_[0]=='x' ) {	/* don't change it */
	index->type[nind] = KeepConnect, index->init[nind] = *weight;
      }
      else if(sscanf( _buf_, "%f ", weight )) {
	index->type[nind] = GivenConnect, index->init[nind] = *weight;
      }
      else {					/* error - cannot read weight*/
	Erreturn1("Invalid weight %s", _buf_ );
      }
      nind++;
    }
    if(connectP->tolayer) {
      IfEOF( status=fscanf(file, "%s ", _buf_ )) return( EOF );
      IfErr( status ) Erreturn("Cannot read bias"); 
      IfErr( str_to_float( _buf_, &connectP->tolayer->bias[j] )) {
        Erreturn1("Invalid bias %s", _buf_ );
      }
    }
  }
  if( index )  {
    index->n_weight = nind;
    index->n_weight_back = nind_back;
    connectP->index = index;
  }
  return ( OK );		/* all weights were read */
}
	/* convert string to a float.  'r' is a random value; 'r0.1' is random
	   value with variance 0.1; 'x' don't touch */
str_to_float( str, x )
char *str; float *x;
{
  float var=.0;	/* variance for random value */
  double nrandom();
  substitute_defined_str( str );
  if( str[0]=='r' ) { 	  /* random value */
    *x = (1==sscanf( str, "r%f", &var)? var : INITWEIGHT) * nrandom();
    return( OK );
  }
  if( str[0]=='x' ) return(OK);	/* don't change it */
  return( sscanf( str, "%f ", x ));
}

fprint_string( file, name, string, fmt )
FILE *file; char *name, *string, *fmt;
{
  register int i; char buf[BUFSIZE];
  IfErr(file) Erreturn("file not open");
  if( file == stdout ) {
    if( name ) addMsg1("value %s\n", name );
    sendMsg1( fmt? fmt: "%s ", string);
    return(OK);
  }
  if( name ) fprintf(file, "value %s\n", name );
  fprintf(file, fmt? fmt: "%s ", string);
  return( OK );
}

fprint_vector( file, name, vector, nvalue, ncol, fmt )
FILE *file; char *name, *fmt; REAL *vector; int nvalue, ncol;
{
  register int i; char buf[BUFSIZE];
  IfErr(file) Erreturn("file not open");
  if( file == stdout ) {
    if( name ) addMsg1("value %s\n", name );
    for( i = 0; i < nvalue; i++, vector++ ) {
      if( ncol > 0 && i && i%ncol == 0 ) addMsg( "\n" );
      sprintf(buf, fmt? fmt: "%g ", *vector);
      checkMsg( strlen( buf )+1 );
      addMsg( buf );
    }
    if( ncol >= 0 ) addMsg( "\n" );	/* no new-line if ncol < 0 */
    endMsg();
    return(OK);
  }
  if( name ) fprintf(file, "value %s\n", name );
  for( i = 0; i < nvalue; i++, vector++ ) {
    if( ncol > 0 && i && i%ncol == 0 ) fprintf(file, "\n" );
    fprintf(file, fmt? fmt: "%g ", *vector);
  }
  if( ncol >= 0 ) fprintf(file, "\n" );	/* no new-line if ncol < 0 */
  return( OK );
}
#if 0
fprint_vector_intv( file, name, vector, nvalue, ncol, fmt, intv )
FILE *file; char *name, *fmt; REAL *vector; int nvalue, ncol,intv;
{
  register int i; char buf[BUFSIZE];
  IfErr(file) Erreturn("file not open");
  if( file == stdout ) {
    if( name ) addMsg1("value %s\n", name );
    for( i = 0; i < nvalue; i++, vector += intv ) {
      if( ncol > 0 && i && i%ncol == 0 ) addMsg( "\n" );
      sprintf(buf, fmt? fmt: "%g ", *vector);
      checkMsg( strlen(buf )+1 );
      addMsg( buf );
    }
    if( ncol >= 0 ) addMsg( "\n" );	/* no new-line if ncol < 0 */
    endMsg();
    return(OK);
  }
  if( name ) fprintf(file, "value %s\n", name );
  for( i = 0; i < nvalue; i++, vector += intv ) {
    if( ncol > 0 && i && i%ncol == 0 ) fprintf(file, "\n" );
    fprintf(file, fmt? fmt: "%g ", *vector);
  }
  if( ncol >= 0 ) fprintf(file, "\n" );	/* no new-line if ncol < 0 */
  return( OK );
}
#endif 0

fprint_weight( file, name, connect, fmt )
FILE *file; char *name, *fmt; CONNECT *connect;
{
  register int i,j,k; char buf[BUFSIZE]; WEIGHT *weight;
  IfErr(file) Erreturn("file not open");
  if( file == stdout ) {
    if( name ) addMsg1("value %s\n", name );
#ifdef weightTrans
    weight = connect->weight;
	/* bug-fixed: tolayer->bias should be indexed differently */
    k = connect->tolayer? connect->to_start : 0;
    for ( j=0; j< connect->to_nunit ; j++, k++ ) {
      for ( i=0; i < connect->from_nunit ; i++, weight++ ){
#else
    for ( j=0; j< connect->to_nunit ; j++ ) {
      weight = &connect->weight[j];
      for ( i=0; i < connect->from_nunit ; i++, weight += connect->to_nunit){
#endif weightTrans
	sprintf(buf, fmt, *weight);
	checkMsg( strlen(buf)); addMsg( buf );
      }
      addMsg( "    " );
      if( connect->tolayer ) addMsg1( fmt, connect->tolayer->bias[k] );
      addMsg( "\n" ); endMsg();
    }
    return(OK);
  }
  if( name ) fprintf(file, "value %s\n", name );
#ifdef weightTrans
  weight = connect->weight;
  for ( j=0; j< connect->to_nunit ; j++ ) {
    for (i=0; i < connect->from_nunit ; i++, weight++ )
#else
  for ( j=0; j< connect->to_nunit ; j++ ) {
    weight = &connect->weight[j];
    for (i=0; i < connect->from_nunit ; i++, weight += connect->to_nunit)
#endif weightTrans
      fprintf ( file, fmt, *weight );
    fprintf( file, "    " );
    if( connect->tolayer ) fprintf ( file, fmt, connect->tolayer->bias[j] );
    fprintf( file, "\n" );
  }
  return( OK );
}

sprint_vector( str, name, vector, nvalue, ncol, fmt )
char *str; char *name, *fmt; REAL *vector; int nvalue, ncol;
{
  register int i; char buf[BUFSIZE];
  IfErr( str ) return(ERR);
  str[0] = NULL;
  for( i = 0; i < nvalue; i++, vector++ ) {
    if( ncol > 0 && i && i%ncol == 0 ) strcat( str, "\n" );
    sprintf( buf, fmt? fmt: "%g ", *vector);
    strcat( str, buf );
  }
  if( ncol >= 0 ) strcat( str, "\n" );	/* no new-line if ncol < 0 */
  return(OK);
}
#if 0
sprint_vector_intv( str, name, vector, nvalue, ncol, fmt, intv )
char *str, *name, *fmt; REAL *vector; int nvalue, ncol,intv;
{
  register int i; char buf[BUFSIZE];
  IfErr(str) return(ERR);
  str[0] = NULL;
  for( i = 0; i < nvalue; i++, vector += intv ) {
    if( ncol > 0 && i && i%ncol == 0 ) strcat( str, "\n" );
    sprintf( buf, fmt? fmt: "%g ", *vector);
    strcat( str,buf );
  }
  if( ncol >= 0 ) strcat( str, "\n" );	/* no new-line if ncol < 0 */
  return(OK);
}
#endif 0
sprint_weight( str, name, connect, fmt )
char *str, *name, *fmt; CONNECT *connect;
{
  register int i,j; char buf[BUFSIZE]; WEIGHT *weight;
  IfErr(str) return(ERR);
  str[0] = NULL;
#ifdef weightTrans
  weight = connect->weight;
  for ( j=0; j< connect->to_nunit ; j++ ) {
    for ( i=0; i < connect->from_nunit ; i++, weight++ ){
#else
  for ( j=0; j< connect->to_nunit ; j++ ) {
    weight = &connect->weight[j];
    for ( i=0; i < connect->from_nunit ; i++, weight += connect->to_nunit){
#endif weightTrans
      sprintf(buf, fmt? fmt:"%g ", *weight);
      strcat( str, buf );
    }
    strcpy( str, "    " );
    if( connect->tolayer ) 
      sprintf( buf, fmt? fmt:"%g ", connect->tolayer->bias[j] );
    strcat( str, buf );
    strcat( str, "\n" );
    }
  return(OK);
}

fread_vector( file, vector, nvalue )
     FILE *file; REAL *vector; int nvalue;
{
  register int i;
  int status;
  IfErr(file) Erreturn("file not open");
  for( i=0; i<nvalue; i++, vector++) {
    IfEOF( status=fscanf(file, "%s ", _buf_ )) break;
    IfErr( status ) Erreturn("Cannot read value"); 
    IfErr( str_to_float( _buf_, vector )) Erreturn1("Invalid value %s", _buf_);
  }
  if( nvalue && i == 0 ) Erreturn( "no value read" );
  return( i );
}

read_vector( vector, nvalue )
     REAL *vector; int nvalue;
{
  register int i;
  int status; char buf[BUFSIZE], *str, *next, *index();
 
  for( i=0; i<nvalue; ) {
    IfErr(status=getUserInput( buf, sizeof(buf))) return(ERR);
    if( EOF==status || EQL(buf, ".") ) break;	  /* no more input */
    for( str=buf ; i<nvalue; i++, vector++ ) {
      while( *str == ' ' || *str == '\t' ) str++; /* next non-white char */
      IfErr( *str ) break;			  /* end of this input */
      IfErr(str_to_float(str,vector)) Erreturn1("Invalid value %s",str);
      						  /* next white char */
      IfErr( str = (next=index(str,' '))? next : index(str,'\t') ) break;
    }
  }
  if( nvalue && i == 0 ) Erreturn( "no value read" );
  return( i );
}

find_file( name, argn, dir, path, fstatP )
char name[][Largs], *dir, *path; int argn; struct stat *fstatP;
{
  char *suffix, *rindex(); int i;
  align_pwd();
  if( name[0][0] == '|' ) {
    strcpy( path, name[0]+1 );
    for( i=1; i<argn; i++ ) {strcat(path," "); strcat( path, name[i] );}
    return( Piped );
  }
  if( !stat(  strcpy( path, name ), fstatP ) ||
     (sprintf( path, "%s/%s", dir, name ), !stat(path, fstatP)) ) {
    return( (suffix=rindex( name, '.' ))? EQL( suffix, ".Z" )? Compressed :
					  EQL( suffix, ".C" )? Compacted :
	   				  EQL( suffix, ".m4" )? M4 : Normal 
	   : Normal );
  }
  else if(sprintf( path, "%s.Z", name ), !stat( path, fstatP ) ) 
    return( Compressed );
  else if(dir && (sprintf( path, "%s/%s.Z", dir, name), !stat(path, fstatP)))
    return( Compressed );
  else if(sprintf( path, "%s.C", name ), !stat( path, fstatP)) 
    return( Compacted );
  else if(dir && (sprintf( path, "%s/%s.C", dir, name), !stat(path, fstatP))) 
    return( Compacted );
  else if(sprintf( path, "%s.m4", dir, name), !stat(path, fstatP)) 
    return( M4 );
  else if(dir && (sprintf( path, "%s/%s.m4", dir, name), !stat(path, fstatP))) 
    return( M4 );
  else return( ERR );
}

FILE *
open_file( path, ftype )
char *path; int ftype;
{
  FILE *fp, *popen(), *fopen();
  char	pname[ BUFSIZE ];		/* name of pipe */
  switch( ftype ) {
  case Normal:
    if( (fp = fopen( path, "r+" )) || (fp = fopen( path, "r" ))) return( fp );
    return( ERR );
  case Compressed:
    sprintf(pname, "/usr/ucb/zcat %s", path);
    return( popen( pname, "r" ) ) ;
  case Compacted:
    sprintf(pname, "/usr/ucb/uncompact < %s", path);
    return( popen( pname, "r" ) ) ;
  case M4:
    sprintf(pname, "/usr/bin/m4 %s", path);
    return( popen( pname, "r" ) ) ;
  case Piped:
    return( popen( path, "r" ) );
  default:
    Erreturn1("don't know the type of file %s", path );
  }
}

close_file( pfile, ptype )
FILE *pfile; int ptype;
{
  IfErr( pfile ) return(OK);
  (ptype==Normal)? fclose(pfile) : pclose( pfile );
  return(OK);
}

#define P_BUFSIZE 4096	/* buffer size for patterns in # of chars */
#define Blksize 32	/* block size (# of patterns) to allocate space */

read_pattern_file( Pfile, NpatternP, inputP, targetP, NinP, NoutP, labelP )
FILE	*Pfile; 			/* ptrs to pattern file */
int	*NpatternP, *NinP, *NoutP;	/* ptrs to #of patterns, sizes of
						input/output patters */
REAL	***inputP, ***targetP;	/*ptrs to 2-d arrays to store patterns*/
char	***labelP;
{
  register int	i;
  int	line;
		/* due to implementation of *
		 * pattern list, patterns are now stored permanently. *
		 * so space allocated for patterns is not freed. */
  int	Asize = 0 ;		/* current array size */
  char	buf [ P_BUFSIZE ];		/* buffer to store a line */
  char	in_buf[ P_BUFSIZE ];		/* buffer for input pattern */
  char	out_buf[ P_BUFSIZE ];		/* buffer for output pattern */
  char	label_buf[ P_BUFSIZE ];		/* buffer for pattern label */

  int	Nin=0, Nout=0;			/* sizes of input/output pattens */
  int	get_label = 0;			/* flag for reading labels */
  label_buf[0] = NULL;

	/**** this loop reads in one line from pattern file,**
	 **** stores patterns into input & target arrays *****/

  for( i=0, line=1; fgets( buf, P_BUFSIZE, Pfile ) != NULL ; i++, line++ ) { 
	  
    if ( sscanf( buf, "%s", in_buf ) == 0 || in_buf[0] == '#' ) 
	{ i-- ; continue ; }          /* blank or comment - skip this line */

    *out_buf = NULL;
    if( sscanf( buf,"%s %s %s", in_buf, out_buf, label_buf) < 1 ) 
          			/* couldn't read input/target from this line */
      Erreturn2("%s: invalid pattern at line %d", buf, line); 

    if( i == 0 ) {		/* allocate space for input/target arrays */
      Nin = strlen ( in_buf );		/* # of chars in input */
      Nout = strlen ( out_buf );		/* # of chars in output */
      Asize = Blksize;	/* initial array size */
				/* allocate space for input/target arrays */
      if Err( *inputP = new_2d_array_of( Asize, Nin, REAL ) ) 
	Erreturn("cannot allocate memory for patterns" );
      if( Nout && Err( *targetP = new_2d_array_of( Asize, Nout, REAL ) ) )
	Erreturn( "cannot allocate memory for patterns");
      get_label = (strlen(label_buf) && label_buf[0]!='#')? 1 : 0;
      if( Nout && !get_label 
	 && Err( get_pattern( out_buf, (*targetP)[0], Nout))) {
	/* if out_buf is illegal pattern, assume it's a label and no output */
	Nout = 0;	/* no output pattern */
	get_label = 2;   /* get_label==2 means no output pattern */
      }
      *NinP = Nin;		/* # of elements in input pattern */
      *NoutP = Nout;		/* # of elements in target pattern */
      				/* read in labels too */
      if( get_label==0 ) *labelP = NULL;
      else IfErr( *labelP = new_array_of( Asize, char* ))
	Erreturn( "cannot allocate memory for labels");
      
    }
	/* no output pattern -> copy out_buf to label_buf */
    if( get_label==2 ) { strcpy(label_buf, out_buf); *out_buf = NULL; }
				/* check input/target size consistency */
    else if(Nin!=strlen(in_buf) || Nout!=strlen(out_buf)) {
      if( line==2 )
	Erreturn("'set floatpattern on' for floating point pattern file");
      Erreturn1("inconsistent pattern size at line %d",line);
    }
				
    if( i >= Asize ) {     /* need to allocate more space for arrays */
      IfErr( *inputP = change_2d_array_size(
		     *inputP, Asize, Nin, Asize+Blksize, Nin, REAL ))  
	Erreturn( "cannot allocate memory for pattern " ); 
      if( Nout && Err( *targetP = change_2d_array_size(
        	      *targetP, Asize, Nout, Asize+Blksize, Nout, REAL )))
	Erreturn( "cannot allocate memory for pattern " );
      if( get_label && Err( *labelP = (char**)
			   change_array_size((char*) *labelP, Asize,
					     Asize+Blksize, sizeof(char*))))
	Erreturn( "cannot allocate memory for label " );
      Asize += Blksize;	/* array size is now Blksize bigger */
    }
				/* store input pattern into array */
    IfErr( get_pattern ( in_buf, (*inputP)[i], Nin ) ) 
      Erreturn2("invalid pattern: %s at line %d", in_buf, line );
				/* store target pattern into array */
    if( Nout && Err( get_pattern ( out_buf, (*targetP)[i], Nout ) ) )
      Erreturn2("invalid pattern: %s at line %d", out_buf, line );
    
    if( get_label && Err((*labelP)[i] = new_string( label_buf, (*labelP)[i] )))
	Erreturn( "cannot allocate memory for label " );
  }

  *NpatternP = i;		/* # of patterns read in from file */
  return( OK );		/* patterns were read in without error */
}
    /*** read_float_pattern_file () reads in from a file input/target ***
     * patterns given as floating point numbers. The first line of the **
     * file should contain two integers specifying the sizes of input/ **
     * target patterns. ***/

read_float_pattern_file( Pfile, NpatternP, inputP, targetP, NinP, NoutP,labelP)
FILE	*Pfile; 			/* ptrs to pattern file */
int	*NpatternP, *NinP, *NoutP;	/* ptrs to #of patterns, sizes of
						input/output patters */
REAL	***inputP, ***targetP;	/*ptrs to 2-d arrays to store patterns*/
char	***labelP;
{
  register int	i;
  int   npattern;
  int   status;
  int	Nin, Nout;		/* sizes of input/output pattens */
  int    get_label=0;
/*static */
  int	Asize = 0;		/* current array size */
  char	buf [ P_BUFSIZE ];		/* buffer to store a line */
  char	label_buf[ P_BUFSIZE ];		/* buffer for pattern label */
  int   nsize;

  IfErr( fgets( buf, P_BUFSIZE, Pfile)) Erreturn("cannot read the first line");
  if( (nsize = sscanf( buf, " %d %d %d", &Nin, &Nout, &get_label )) < 2 )
    Erreturn("The first line should specify input/target sizes");
  get_label = nsize==3? 1 : 0;
  Asize = Blksize;
				/* allocate space for input/target arrays */
  IfErr( *inputP = new_2d_array_of( Asize, Nin, REAL ))
    Erreturn("cannot allocate memory for patterns" );
  IfErr( *targetP = new_2d_array_of( Asize, Nout, REAL )) 
    Erreturn( "cannot allocate memory for patterns");
  if( get_label && Err( *labelP = new_array_of( Asize, char* )))
    Erreturn( "cannot allocate memory for labels");

  *NinP = Nin;			/* # of elements in input pattern */
  *NoutP = Nout;		/* # of elements in target pattern */

	/**** following loop reads in one pair of patterns ***
	 **** stores patterns into input & target arrays *****/

  for( npattern=0;  ; npattern++ ) { 
    if( npattern >= Asize ) {     /* need to allocate more space for arrays */
      IfErr( *inputP = change_2d_array_size(
		     *inputP, Asize, Nin, Asize+Blksize, Nin, REAL ))  
	Erreturn( "cannot allocate memory for pattern " ); 
      IfErr( *targetP = change_2d_array_size(
        	      *targetP, Asize, Nout, Asize+Blksize, Nout, REAL ))
	Erreturn( "cannot allocate memory for pattern " );
      if( get_label && Err( *labelP = (char**)
			   change_array_size((char*) *labelP, Asize,
					     Asize+Blksize, sizeof(char*))))
	Erreturn( "cannot allocate memory for label " );
      Asize += Blksize;	/* array size is now Blksize bigger */
    }
	
    for ( i=0; i< Nin ; i++ ) {
      IfEOF (status = fscanf (Pfile, "%f", &(*inputP)[npattern][i] ) ) {
	if ( i==0 ) break;
	Erreturn1("Incomplete file at input pattern # %d", npattern+1 );
      }
      IfErr ( status ) {
	if( Err( fgets( buf, P_BUFSIZE, Pfile)) || buf[0] != '#' )
	  Erreturn2("cannot read input[%d][%d]", npattern+1, i+1 );
	i--; continue;
      }
    }
    IfEOF ( status ) break;
	
    for ( i=0; i< Nout ; i++ ) 
      if ( fscanf (Pfile, "%f", &(*targetP)[npattern][i] ) !=1 )
	Erreturn2("cannot read target[%d][%d]", npattern+1, i+1 ); 

    if( get_label ) {
      if( fscanf( Pfile, "%s", label_buf) !=1 )
	Erreturn1("cannot read label for pattern #%d",npattern+1);
      replace_escape( label_buf );
      IfErr((*labelP)[npattern] = new_string( label_buf, (*labelP)[npattern] ))
	Erreturn( "cannot allocate memory for label " );
    }
  }

  *NpatternP = npattern;	/* # of patterns read in from file */
  return( OK );		/* patterns were read in without error */
}

/* read one line (at most bufsize chars) from file into buf 
 * discarding chars after # */

get_line ( file, buf, bufsize ) 
FILE 	*file ;
char	*buf ;
int     bufsize;
{
  char	c ;
  register int i;
  for( i=0; i< bufsize-1 && (c=getc(file)) != '\n' ; i++ ) {
    if ( c == EOF ) return ( EOF );
    if ( c == '#' ) {
      while ( getc(file) != '\n' ) ;
      return ( get_line ( file, buf, bufsize ) );
      /* BUG: # has to be the 1st char on the line for this to work */
    }
    buf[i] = c ;
  }
  buf[i] = '\0' ;
  return ( OK );
}

get_pattern ( buf, array, nvalue )
  char  buf[];
  REAL *array;
  int   nvalue;
{
  register int i;
  int n;

  for(i=0; i< nvalue; i++) {
    if( buf[i] == '*' ) { array[i] = DONT_CARE ; continue; }
    if( buf[i] == 'a' ) buf[i] = '0'+10 ;
    if( (n = buf[i] - '0' ) < 0 || n > 10 )  return ( ERR );
    array[i] = (MAXACTV-MINACTV) * (REAL) n/10.0+MINACTV ;
  }
  return ( OK );
}
