/* $Header: /soma/users/miyata/planet/src/RCS/sunnet.h,v 5.6.0.4 91/02/13 15:43:01 miyata Exp $ */
#define CheckNet()	if(Net==NULL) \
			{ Erreturn("network not defined. use 'network ..'"); }
#define CheckPattern()	if(Input==NULL) \
			{ Erreturn("pattern not defined. use 'pattern ..'"); }
char *getenv();
#if sunnet
#define CheckGraphics() if( !getenv("WINDOW_ME") || !getenv("WINDOW_GFX") || \
			!strcmp(getenv("WINDOW_ME"),getenv("WINDOW_GFX")))\
			{ Erreturn("not in a graphics window"); }
#else
#if planet|xnet|mgr
#define CheckGraphics() 
#endif
#endif

extern	int	Npattern;		/* # of patterns. */

extern	NETWORK *Net;			/* network pointer 		*/

extern	int	N_input;		/* # of input units in network	 */
extern	int	N_output;		/* # of output units in network	 */
extern	int	N_target;		/* # of target elements. if target is
					 a sequence, N_target=N_output*Nseq */
extern	int	Nseq ;			/* length of output sequence */

extern	NUMBER	Error;			/* total error at output layer	*/

extern	NUMBER	**Input,**Target;	/*2d arrays for input/target patterns */

#ifndef AtoI
#define AtoI( s, i ) sscanf( s, "%d", &i ) /* ascii to integer conversion */
#define AtoF( s, n ) sscanf( s, "%f", &n ) /* ascii to float conversion */
#endif

extern	char    InFileName[];		/* file name to read in weights */
extern	char	OutFileName[];		/* file name to save weights */
extern	FILE    *InFile, *OutFile;	/* file pointers for weight files */
extern	char	PatFileName[];		/* file name to read in patterns */
extern	char	NetFileComm[];		/* file name to read in network */

	/* parameters - actually declared & initialized in sunnetparam.c */
extern	NUMBER	Step;			/* current step #		*/

extern	int	StepPrint;  	        /* when learning, error is printed
					  every StepPrint steps (0->no print)*/
extern	int	StepSave;		/* weights are saved into file
					   every StepSave steps (0->no save)*/
extern	int	StepError;		/* error is saved into file
					   every StepError steps (0->no save)*/
extern	BINARY	SaveAppend;		/* save at the end of OutFile */

extern	int	StepCommand;		/* items in command list are exec'ed 
					   every StepCommand steps */
extern	BINARY	Randomize ;		/* whether or not to present patterns
					 * in random order.  */
extern	NUMBER	ErrLimit ;		/* cycle stops when Error reaches *
					 * ErrLimit */
extern  BINARY  FloatPattern;           /* patterns are specified by floating *
					 * point numbers */
extern  BINARY	Quiet;			/* print while clist/source */

#if sunnet|planet|xnet|mgr
extern	int	StepGraph;
extern  int     StepMark;
extern  int     StepDisplay;
extern	int	StepPlot;

extern	int	Ncol;			/* Patterns are displayed in
					 * Ncol x Npattern/Ncol matrix.   */
extern	BINARY	Normalize;		/* whether or not to normalize 
					 * values in displays */
extern	float	Threshold;		/* display below-threshold values 
					 * in different color */
extern	BINARY	Square;			/* display with squares (not bars) */

extern	BINARY	GraphLog;		/* graph error in log scale */

extern  BINARY  Label ;                 /* display label */

extern	BINARY	Number;			/* display numbers */

extern	float	Unit ;			/* unit value for display */

extern 	BINARY	Transpose ;		/* transpose weight matrix display */

extern	BINARY	Erase ;			/* erase window before display */
           /* end of parameters */

#define Graphit     ( Graph && StepGraph && ((int)Step)%StepGraph == 0 )
#define Markit      ( Graph && StepMark && ((int)Step)%StepMark==0 )
#define Displayit   ( StepDisplay && ((int)Step)%StepDisplay == 0 )
#define Plotit      ( StepPlot && ((int)Step)%StepPlot == 0 )

extern	GRAPH	*Graph;
extern  WINDOW  *Window[];

#endif disp

#define Printit 	( StepPrint && ((int)Step)%StepPrint == 0 )
#define Saveit  	( StepSave && ((int)Step)%StepSave == 0 )
#define SaveError  	( StepError && ((int)Step)%StepError == 0 )
#define DoCommand	( StepCommand && ((int)Step)%StepCommand == 0 )

extern	float	F();				/* ascci to float conversion */

extern	char * 	get_syntax();			/* get syntax of a command
						   defined in help.c */
