/* $Header: /soma/users/miyata/planet/src/RCS/setup.c,v 5.6.0.5 91/02/13 15:41:40 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/setup.c,v 5.6.0.5 91/02/13 15:41:40 miyata Exp $";
/********** UPDATES ***********************************************
setup.c:
12/15/90 changed eval_network_command() to read weight file (step=..Error=..).
12/7/90  open/find_file() for "load" command -> can load .m4 files etc.
12/3/90  changed "float" to "scalar"
11/10/90 implemented ELSE for IF/ENDIF.
10/20/90 implemented IF/ENDIF, IFDEF, IFNDEF in procedures.
9/28/90 in-expression evaluation of assignment operators. they don't
	distinguish between vector and matrix yet.
9/27/90	implemented assignment operators "+=" "-=" "*=" "/=" 
9/26/90     fixed "prune" setup and renamed it "rewire"
******************************************************************/
#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>                   /* for stat() function */
#include "command.h"
#include "alloc.h"
#include "net.h"
#include "arith.h"
#include "setup.h"
#include "list.h"
#include "error.h"
#include "msg.h"
#include "userdefs.h"

void delete_layer(), delete_connection(), delete_array(),delete_procedure();
void delete_expression(), delete_intvar(),delete_floatvar();
void delete_vector(), delete_vector_struct(); 

#define weightTrans 1

	/* defined strings should really be effective within each network */
#define Mdefine 64
typedef struct {
  char *str;
  char *substitute;
  BINARY online;	/* ON if given on-line -> cannot override */
} DEFINE;
DEFINE Define[Mdefine];
int    Ndefine = 0;

PROCED *procScope = NULL;

	/* setup scope for the procedure - procScope is used in *
	 * which_layer_arg() and find_expression_arg() etc. in netfind.c *
	 * If we are going to define a top-level procedure, set *
	 * procScope to its pointer */
PROCED *setScope( proc ) PROCED *proc; { 
  PROCED *origScope = procScope;
  procScope = proc; 
  return( origScope );
}

substitute_command( net, command, argn, args )
NETWORK *net;
char	command[], args[][Largs];
int argn;
{
  register int i;
  substitute_defined_str( command, net );
  for( i=0; i < argn; i++ ) substitute_defined_str( args[i], net );
}

setup_network( command_stream, net, init )
FILE	*command_stream; 
NETWORK	*net;
int init;	/* initialize weights only if init = 1 */
{
  char	command[Lcomm], args[Nargs][Largs];
  char command_line[BUFSIZE], *command_buf, *next_line;
  int	argn, line, i, n,n1, status;
  int readIt=1;

  for(line=1; (status = read_line( command_line, BUFSIZE, command_stream ))
      !=EOF; line += status-1 ) 

    for( command_buf = command_line; command_buf ; command_buf = next_line ) {
      handle_quote(command_buf, &next_line);
      parse_command( command_buf, command, &argn, args );
      IF( command, "" ) continue;

	/* "define", "IFDEF", or "IFNDEF" command line should not be changed */
      if( strcmp( command, "define") && strcmp( command,"IFDEF")
	  && strcmp( command, "IFNDEF" )) 
	substitute_command( net, command, argn, args );
/*
.NE "IF / ENDIF" "conditional reading of network commands"
.SY "IF <expression>"
.BB
If <expression> evaluates to true (1) keep reading, otherwise skip reading
lines in this file until next \fBENDIF\fP appears.  
.EE
*/
      IF( command, "IF" ) {
        if( argn < 1 ) Erreturn("syntax: IF <expression>");
        IfErr( eval_expression_value( net, args[0], &readIt ) ) 
	  Erreturn2("%s: in 'IF %s'", ERR_MSG, args[0] );
	continue;
      }
      else IF( command, "ENDIF" ) { readIt = 1; continue; }
/*
.NE "IFDEF / ENDIF" "conditional reading of network commands"
.SY "IF <string>"
.BB
If <string> has been defined with command "define" then keep reading, 
otherwise skip lines in this file until next \fBENDIF\fP appears.
.EE
*/
      else IF( command, "IFDEF" ) {
        if( argn < 1 ) Erreturn("syntax: IFDEF <string>");
        IfErr( isDefined( args[0] ) ) readIt = 0;
	continue;
      }
      else IF( command, "IFNDEF" ) {
        if( argn < 1 ) Erreturn("syntax: IFDEF <string>");
        if( isDefined( args[0] ) ) readIt = 0;
	continue;
      }
      else IF( command, "ELSE" ) {
	if( readIt ) readIt = 0;
	else readIt = 1;
	continue;
      }
      if( ! readIt ) continue;
      IF( command, "exit" ) return(OK);

      IfErr( eval_network_command(command,args,argn,net,command_stream,init,&line)) 
	Erreturn2("%s: at line %d", ERR_MSG, line);
    }
  if( ! readIt ) Erreturn("no 'ENDIF' for 'IF' or 'IFDEF'");
  return(OK);
}

eval_network_command(command,args,argn,net,command_stream,init,lines)
char	command[], args[][Largs];
NETWORK *net;
FILE *command_stream;
int init, *lines;
{
  int i,n,n1;
  char	buf[BUFSIZE];
  struct stat   fstat;int ftype;
  char *getenv();
  FILE  *fp,*open_file();
  VECTOR *vector;
/*
.NE "define" "define string substitution"
.SY "define <string1> <string2>"
.BB
Sets up a string substitution.  Every subsequent instance of
(white-space separated) <string1> in the network file will be replaced
by <string2>.
.EE
*/
  IF( command, "define" ) {
    if( argn < 2 ) Erreturn("syntax: define str1 str2");
    IfErr( make_define( args[0], args[1], OFF ) ) return( ERR );
  }
/*
.NE "command" "execute SunNet command"
.SY "command <command> [arguments ..]"
.BB
Executes a SunNet command.
.EE
*/
  else IF( command, "command" ) {
    IfErr( eval_command( args[0], argn-1, args[1] ) ) return( ERR );
  }
/*
.NE "load" "read in network file"
.SY "load <file>"
.BB
Read in network specifications in <file>.
.EE
*/
  else IF( command, "load" ) {
    if( args[0][0] == '~' ) replace_string( args[0], getenv("HOME"), 1 );
    /* BUG: find_file() and open_file() should be used here to enable *
     * reading of .m4 files etc. */

    /* IfErr( fp = fopen( args[0], "r" ) ) {
      strcpy( buf, "net/"); strcat( buf, args[0] );
      IfErr( fp = fopen( buf, "r" ) ) 
	Erreturn1("cannot open load file %s", args[0]);
    } */
    IfErr( ftype = find_file( args[0], 0, NetworkDir, buf, &fstat ) )
	Erreturn1("cannot file load file %s", args[0]);
    IfErr( fp = open_file( buf, ftype ) )
	Erreturn1("cannot open file %s", buf );
    IfErr( setup_network( fp, net, init ) ) { /* should initialize weights */
      close_file( fp, ftype );
      Erreturn2("%s: in %s", ERR_MSG, args[0] );
    }
    close_file( fp, ftype);
  }
/*
.NE "layer" "define a layer"
.SY "layer <name> N [logistic/linear]"
.BB
Defines a layer of N units.  Activation function of the units in the
layer can be specified (logistic (=default) or linear).  The
components of a layer are: activation values; net inputs; and deltas.
.EE
*/
  else IF( command, "layer" ) {
    if( argn < 2 ) Erreturn("syntax: layer <name> <# of units>");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid # of units %s for layer %s", args[1], args[0]);
    IfErr( make_layer( net, args[0], n, argn<3? NULL : args[2] ) )
      Erreturn2("%s: in making layer %s", ERR_MSG, args[0] );
  }
/*
.NE "connect" "define a connection"
.SY "connect <name> <layer1> to <layer2> [with <connect>] [batch]"
.BB
Defines a set of connections between two groups of units.  Each group
of units can be a whole layer specified by the layer name, a part of a
layer specified by <layer>[n-m], or a single unit specified by
<layer>[n].
.Bi
As a special case, 'connect <name> <layer> symmetric' specifies symmetric
connections within a layer.
.Ni
Either or both of <layer1> and <layer2> can be replaced by number(s) 
as in 'connect <name> 4 to 8'.  In this case the weights are defined but
not connected to any units.  The numbers specify the size of the weight 
matrix.  Weights defined this way cannot be used with actions \fBforward\fP,
\fBbackward\fP and \fBlearn\fP but can appear in expressions.
.Ni
\fBwith <connect>\fP means to use the same set of weights as another connection
<connect>.  This is useful when a set of weights is used between different
sets of layers.
.Ni
If the last argument is 'batch', learning of the connection will be
done in a "batch" mode, where the changes to the weights are accumulated
for multiple calls to the action 'learn' and then applied at once when 'learn'
is called with a second argument 'change'.  See 'learn'.  The 
default is to apply the changes each time the action 'learn' is called.
.EE
*/
  else IF( command, "connect" ) {
    if( argn < 2 ) Erreturn("syntax: connect <name> <layer1> to <layer2>");
    IfErr( make_connection( net, argn, args, init ) )
      Erreturn2("%s: in making connection %s", ERR_MSG, args[0] );
  }
/*
.NE "input" "define input buffer"
.SY "input N"
.BB
Defines the length of input pattern buffer.
.EE
*/
  else IF( command, "input" ) {
    if( argn < 1 ) Erreturn("syntax: input <# of units>");
    if( Err( eval_expression_value( net, args[0], &n ) ) || n<=0 )
      Erreturn1("invalid size %s of input buffer", args[0]);
    IfErr( make_input( net, n ) )
      Erreturn2("%s: in making input %s", ERR_MSG, args[0] );
  }
/*
.NE "target" "define target buffer"
.SY "target N"
.BB
Defines the length of target pattern buffer.
.EE
*/
  else IF( command, "target" ) {
    if( argn < 1 ) Erreturn("syntax: target <# of units>");
    if( Err( eval_expression_value( net, args[0], &n ) ) || n<=0 )
      Erreturn1("invalid size %s of array target buffer", args[0]);
    IfErr( make_target( net, n ))
      Erreturn2("%s: in making target %s", ERR_MSG, args[0] );
  }
/*
.NE "array" "define an array"
.SY "array <name> N"
.BB
Defines an array of N elements.  Each element contains a floating point number.
.EE
*/
  else if( EQL( command, "array" ) || EQL( command, "vector" )) {
    if( argn < 2 ) Erreturn("syntax: array <name> <# of values>");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid size %s of array %s", args[1], args[0]);
    IfErr( make_array( net, args[0], n ) )
      Erreturn2("%s: in making array %s", ERR_MSG, args[0] );
  }
  else if( EQL( command, "iarray" ) || EQL( command, "ivector" )) {
    if( argn < 2 ) Erreturn("syntax: ivector <name> <# of values>");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid size %s of ivector %s", args[1], args[0]);
    IfErr( make_ivector( net, args[0], n ) )
      Erreturn2("%s: in making ivector %s", ERR_MSG, args[0] );
  }
/*
.NE "matrix" "define a matrix"
.SY "matrix <name> N M"
.BB
Defines a matrix with N rows and M columns of float values.
.EE
*/
  else IF( command, "matrix" ) {
    if( argn < 3 ) Erreturn("syntax: matrix <name> #-of-rows #-of-columns");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid # of rows %s for matrix %s", args[1], args[0]);
    if( Err( eval_expression_value( net, args[2], &n1 ) ) || n1<=0 )
      Erreturn2("invalid # of columns %s for matrix %s", args[2], args[0]);
    IfErr( make_matrix( net, args[0], n, n1 ) )
      Erreturn2("%s: in making matrix %s", ERR_MSG, args[0] );
  }
/*
.NE "int" "define an integer variable"
.SY "int <name> [initial value]"
.BB
Defines an integer variable.  There is no use of an integer variable in current version.
A float variable should be used instead.
.EE
*/
  else IF( command, "int" ) {
    if( argn < 1 ) Erreturn("syntax: int <name> [initial value]");
    if( argn > 1 && Err( AtoI(args[1],n)))
      Erreturn2("invalid initial value %s for int %s", args[1], args[0]);
    IfErr( make_int( net, args[0], argn>1? n : 0 ) )
      Erreturn2("%s: in making variable %s", ERR_MSG, args[0]);
  }
/*
.NE "scalar" "define a float variable"
.SY "scalar <name> [initial value]"
.BB
Defines a scalar variable.
.EE
*/
  else if( EQL(command, "scalar") || EQL( command, "scaler" )|| EQL( command, "float")) {
    if( argn < 1 ) Erreturn("syntax: scalar <name> [initial value]");
    IfErr( make_float( net, args[0], argn>1? args[1]: NULL ) )
      Erreturn2("%s: in making variable %s", ERR_MSG, args[0]);
  }
/*
.NE "weight" "initialize a weight matrix"
.SY "weight <connection> (values for weight matrix and biases on next line(s))"
.BB
Initializes the weight matrix in <connection> and the biases for the
units receiving the connection.  It should be followed by lines containing values 
given in the following order (w[n][m] means weight from n'th unit 
to m'th unit; b[m] means bias for m'th unit): 
.sp 0
w[0][0] w[1][0] w[2][0] ... b[0]
.sp 0
w[0][1] w[1][1] w[2][1] ... b[1] 
.sp 0
w[0][2] w[1][2] w[2][2] ... b[2]
  .....
.BI
A value can be specified by (1) a floating point number; (2) the character
\fIr\fP optionally followed by a number as in \fIr0.1\fP, in which case a random
number will be assigned with a variance specified by the number (default 
variance is the value of the parameter \fIweight\fP); (3) the character \fIn\fP or \fI.\fP,
which results in no connection; or (4) the character \fIf\fP optionally followed 
by (1) or (2), which means the connection is "fixed" (not modified by 'learn').
.EE
*/
  else IF( command, "weight" ) {
    if( argn < 1 ) Erreturn("syntax: weight <connection>");
    IfErr( read_weight( command_stream, net, args[0] ) )
      Erreturn1("%s: in reading weights", ERR_MSG );
  }
/*
.NE "value" "initialize a vector"
.SY "value <vector>/<matrix> [< <file>]"
.BB
\fBvalue <vector>\fP initializes a vector or a matrix to a set of values.  The line(s) that
follow should contain the values as a series of floating point numbers.  The 
number of values must equal to the number of elements in the vector/matrix.
\fBvalue <vector> < <file>\fP reads in values from <file> into <vector>.
.EE
*/
  else IF( command, "value" ) {
    if( argn < 1 ) Erreturn("syntax: value <vector>");
    IfErr( vector=eval_expression(find_expression( net, args[0] )))
      return( ERR );
    if( argn == 1 ) {
      IfErr(fread_vector( command_stream, vector->value, vector->nvalue ))
	return( ERR );
    }
    else if( argn > 2 && EQL(args[1], "<") ) {
/*    IfErr( ftype = find_file( args[2], 1, NetDir, fname, &fstat) ) */
      IfErr( fp = fopen(args[2], "r") ) Erreturn1("cannot open %s", args[2]);
      n = fread_vector( fp, vector->value, vector->nvalue ); fclose(fp);
      IfErr( n ) Erreturn2( "%s: in file %s", ERR_MSG, args[2] );
      if( n < vector->nvalue )
	sendMsg3("warning: only %d values read into %s from %s.\n",
		 n, args[0], args[2]);
    }
    else Erreturn( get_syntax( "value" ) );
  }
/*
.NE "library" "specify library procedure file"
.SY "library <file>"
.BB
Adds a library procedure file to be used with this network file.  A library
file contains only procedure definitions.  Whenever an undefined procedure is
referred to in this network file by "call" or by commands "exec", "present"
or "response", this library file is looked upon for its definition.
.EE
*/
  else IF( command, "library" ) {
    if( argn < 1 ) Erreturn("syntax: library <file>");
    IfErr(add_library( net, args[0] )) 
      Erreturn2("%s: cannot add library file %s",ERR_MSG,args[0]);
  }
/*
.NE "procedure / end" "define a procedure"
.SY "procedure <name> [arguments]"
.BB
Defines a procedure.  See Section III for actions used in procedures.
.BI
A definition of procedures has the form:
.sp
procedure <name> [procedure arguments]
    [local variable declarations]
    [actions]
end
.sp
Optional procedure arguments are specified in the form:
.sp
type1 name1 type2 name2 ...
.sp
where typeN indicating the type of the argument is one of \fBlayer, connect\fP
and \fBvector\fP. An argument declared as the type 'layer' can be used in the
procedure body as a layer (as an argument to the actions \fBinput\fP, 
\fBactivation\fP, \fBdelta\fP, \fBlearnbias\fP and \fBtarget\fP).  
Similarly, an argument declared as type \fBconnect\fP can be used as an 
argument to the actions \fBforward\fP, \fBbackward\fP, and \fBlearn\fP.  
An argument declared as type \fBvector\fP can be used wherever an 
expression can be used, for example, as the rhs of a '=' assignment or inside 
an expression in the rhs of a '='.
.NI
When you call the procedure, you should pass a layer as the value of a 'layer'
argument, and a connection as the value of a 'connect' argument.  You can pass
any expression as the value of a 'vector' argument, including a float variable,
an array, and a matrix, with the exception that you cannot pass a procedure 
argument as an argument for a subprocedure within that procedure (first copy 
it to another variable and pass the variable to the subprocedure.)  
Also see 'call', 'exec', and 'present'.
.NI
Any number of of optional local variables can be declared anywhere in the 
procedure body before they are used.  Currently, a local variable can have 
one of the types 'float', 'array' (or 'vector') and 'matrix'.  Unlike local
variables in most programming language, a local variable is not initialized
upon each new call to the procedure, but keeps the value previously assigned
to it.  So, it behaves like a 'static' local variable in C functions.  Thus,
in a recursive call, a value assigned to a variable at a higher level gets
overwritten at a lower level.  [This may be changed in a future version.]
.EE
*/
  else IF( command, "procedure" ) {
    if( argn < 1 ) Erreturn("syntax: procedure <name>");
    
    IfErr( define_procedure( command_stream, net, args[0], lines, 
			     argn-1, args[1], 1 ) ) 
      Erreturn2("%s: in procedure %s",ERR_MSG, args[0]);
  }
  else return( eval_command( command, argn, args ) );
/*  Erreturn1("%s: not command for setting up network", command ); */

  return( OK );
}
	/* evaluate expression and get the first value */
eval_expression_value( net, str, n )
NETWORK *net; char *str; int *n;
{
  EXPRESS *expr;
  IfErr(eval_expression( expr = find_expression(net, str))) 
    { delete_expression( expr ); return(ERR); }
  *n= (int) expr->vector->value[0];
  delete_expression( expr );
  return(OK);
}

char *
get_string( argn, args )
int argn; char args[Nargs][Largs];
{
  register int i;
  char buf[ BUFSIZE ], *endstring, *index();

  for( i=0; i< argn ; i++ ) if( args[i][0] == '"' ) break;
  if( i == argn ) Erreturn("no string found");

  strcpy( buf, &args[i][1]) ;      /* args[i] starts with '"' */
  for( i++; i < argn ; i++ ) {    /* append args's until '"' */
    sprintf( buf, "%s %s", buf, args[i] );
    if((endstring = index( buf, '"' )) == NULL ) continue;
    *endstring = NULL;               /* endstring indexes ending '"' */
    return( new_string( buf, NULL ) );
  }
  Erreturn( "string not terminated by a \"" );
}

#define IntArg( ARG, VALUE ) { \
	  CheckIntArg();\
	  procP->iconst[ procP->n_int ] = VALUE ; \
	  actionP->args[ ARG ] =(char *) &procP->iconst[ procP->n_int++ ] ; }

#define FloatArg( ARG, VALUE ) { \
	  CheckFloatArg();\
	  procP->fconst[ procP->n_float ] = VALUE ; \
	  actionP->args[ ARG ] =(char *) &procP->fconst[ procP->n_float++ ] ; }

#define GetArg( ARG, VALUE )( actionP->args[ ARG ] =(char*) VALUE )

#define GetFunc( FUNC, ARGN ) { actionP->func = FUNC; actionP->argn = ARGN; }

define_procedure( command_stream, net, name, lines, pargn, pargs, top ) 
FILE	*command_stream;
NETWORK	*net;
char	*name;
int 	*lines;
int	pargn;
char	pargs[][Largs];		/* procedure arguments */
int	top;		/* if 1, its the top level - real procedure */
{
  char    command[Lcomm], args[Nargs][Largs];	/* command and arguments */
  char    command_line[MSGSIZE], *line, *next_line;
  int     argn;					/* # of arguments	 */
  int	status,leng;
  register int n;
  PROCED *procP, *origScope, *setScope();
  PROCARG *arg;
  static int readIt=1;

  IfErr( net ) Erreturn("network not given");
  if( procP = which_procedure( net, name ) ) {

 /* there's already procedure named "name". if procP->action==NULL, the 
    procedure has been called but not defined. */

    if( procP->action ) {	/* already defined procedure -> delete it */
      if( top )
	sendMsg1( "\twarning: overriding existing procedure %s.\n", name );
      delete_procedure( procP );
      procP->name = new_string( name, NULL );
    }
  }

  else {			/* new name */
    if( net->n_procedure >= MaxProcedure )
      Erreturn1("no more than %d procedure for a network", MaxProcedure);
    procP = &net->procedure[net->n_procedure++] ;
    procP->name = new_string( name, NULL );
  }

  if(Err( procP->action = new_array_of( MaxAction, ACTION )) ||
     Err( procP->iconst = new_array_of( MaxProcConst, int )) ||
     Err( procP->fconst = new_array_of( MaxProcConst, float )))
    Erreturn("cannot allocate memory for procedure");

  if( pargn ) {		/* procedure has arguments */
    IfErr( procP->arg = new_array_of( (pargn+1)/2, PROCARG ))
      Erreturn("cannot allocate memory for procedure arguments");
    for( n=0, arg = procP->arg; n<pargn; n += 2, arg++ ) {
      leng = strlen(pargs[n]);
      if( cmp_str( pargs[n], "vector")) arg->type = ItsExpr;
      else if(leng<=cmp_str( pargs[n], "matrix")) arg->type = ItsExpr;
      else if(leng<=cmp_str( pargs[n], "expression")) arg->type = ItsExpr;
      else if(leng<=cmp_str( pargs[n], "layer")) arg->type = ItsLayer;
      else if(leng<=cmp_str( pargs[n], "connect")) arg->type = ItsConnect;
      else if(leng<=cmp_str( pargs[n], "procedure" )) arg->type = ItsProc;
      else 
	Erreturn2("%s: unknown argument type for procedure %s", 
		  pargs[n], procP->name );
      if( n+1 >= pargn ) 
	Erreturn2("A missing argument #%d of type %s", (n+1)/2, pargs[n]);
      arg->name = new_string( pargs[n+1], NULL );
    }
    procP->n_parg = pargn/2;
  }

  if( top ) {
    readIt = 1;
    origScope = setScope( procP );
  }
  for( ; ; ) {
    if( command_stream ) {
      if(0 >= (status = read_line( command_line, BUFSIZE, command_stream )) ) {
	if( top ) setScope( origScope );
	if( status == EOF ) Erreturn("incomplete procedure" );
	return( status );
      }
    /* otherwise status = no. of lines read +1 */
      *lines += status-1;
    }
    else	/* its from the standard input */
      getUserInput( command_line, MSGSIZE );

    for( line = command_line; line ; line = next_line ) {
      handle_quote(line, &next_line);
      parse_command( line, command, &argn, args );

      IF( command, "" ) continue;

      if( strcmp( command, "define") && strcmp( command,"IFDEF")
	  && strcmp( command, "IFNDEF" )) 
	substitute_command( net, command, argn, args );

      IF( command, "IF" ) {
        if( argn < 1 ) Erreturn("syntax: IF <expression>");
        IfErr( eval_expression_value( net, args[0], &readIt ) ) 
	  Erreturn2("%s: in 'IF %s'", ERR_MSG, args[0] );
	continue;
      }
      else IF( command, "ENDIF" ) { readIt = 1; continue; }
      else IF( command, "IFDEF" ) {
        if( argn < 1 ) Erreturn("syntax: IFDEF <string>");
        IfErr( isDefined( args[0] ) ) readIt = 0;
	continue;
      }
      else IF( command, "IFNDEF" ) {
        if( argn < 1 ) Erreturn("syntax: IFDEF <string>");
        if( isDefined( args[0] ) ) readIt = 0;
	continue;
      }
      else IF( command, "ELSE" ) {
	if( readIt ) readIt = 0;
	else readIt = 1;
	continue;
      }
      if( ! readIt ) continue;

      status = add_action_to_procedure( command_stream, line, 
				        command, argn, args, net, procP,lines);
      if( status != OK ) {
	if( top ) { 
	  setScope( origScope );
	  IfErr(status) {  /* error-> treat it as a dummy procedure */
	    delete_procedure( procP );
	    procP->action = NULL; 
	    procP->name = new_string( name, NULL );
	  }
	  if( ! readIt ) Erreturn("no 'ENDIF' for 'IF' or 'IFDEF'");
	}
	return( status );	/* ERR or END/ENDWHILE/ENDIF etc. */
      }
    }
  }
}

/* add_action_to_procedure() reads one(or possibly more) line from 	     *
 * command_stream and setup an action in procedure pointed by procP  	     *
 * and increments procP->n_action  					     *
 * Returns: OK if ok. ERR if error. END when an "end" is read.  EOF upon EOF */

add_action_to_procedure( command_stream, line, command, argn, args, net, procP , lines)
FILE	*command_stream;
char	*line, *command, args[][Largs]; int argn;
NETWORK *net;
PROCED *procP;
int	*lines;
{
  ACTION *actionP ;
  LAYER	 *layerP;
  CONNECT *connectP;
  ARRAY	 *arrayP;
  INTVAR *intvarP;
  FLOATVAR *floatvarP;
  float  x;
  char   buf[ BUFSIZE ], *index();
  int	 n, n0, n1;
  int	 type0, type1;
  int	 n_from, n_to ;int status;

  if( procP->n_action >= MaxAction )
    Erreturn1("sorry, no more than %d actions in a procedure", MaxAction);


  if( EQL(command, "scalar") || EQL(command, "scaler") || EQL(command, "float" )) {
    if( argn < 1 ) Erreturn("syntax: scalar <name> [initial value]");
    IfErr( make_float( net, sprintf( buf, "%s.%s", procP->name, args[0] ),
		      argn>1? args[1]: NULL ) )
      Erreturn2("%s: in making variable %s", ERR_MSG, buf );
    return(OK);
  }
  if( EQL( command, "array" ) || EQL( command, "vector" )) {
    if( argn < 2 ) Erreturn("syntax: array <name> <# of values>");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid size %s of array %s", args[1], args[0]);
    IfErr( make_array( net,sprintf( buf, "%s.%s", procP->name, args[0]), n ) )
      Erreturn2("%s: in making array %s", ERR_MSG, args[0] );
    return(OK);
  }
  IF( command, "matrix" ) {
    if( argn < 3 ) Erreturn("syntax: matrix <name> #-of-rows #-of-columns");
    if( Err( eval_expression_value( net, args[1], &n ) ) || n<=0 )
      Erreturn2("invalid # of rows %s for matrix %s", args[1], args[0]);
    if( Err( eval_expression_value( net, args[2], &n1 ) ) || n1<=0 )
      Erreturn2("invalid # of columns %s for matrix %s", args[2], args[0]);
    IfErr( make_matrix( net,sprintf( buf, "%s.%s", procP->name, args[0]),n,n1))
      Erreturn2("%s: in making matrix %s", ERR_MSG, args[0] );
    return(OK);
  }

  actionP = &procP->action[procP->n_action] ;  /* ptr to the next action in *
						* the procedure */
  actionP->name = new_string( line, actionP->name );

/*********  A NOTE ON THE IMPLEMETATION OF PROCEDURE ACTIONS **********\
The following code interpretes a line in a procedure consisting of a
command followed by zero or more arguments and set up an action by
(1) fetching the ptr to the function implementing the action and (2)
finding the appropriate pointers to the arguments to be passed to the
function.  The result is a set of pointers to a function and its
arguments for each action in a procedure.  When the procedure is actually
executed, the series functions are called with the argument pointers.
Therefore there is no need for search at execution time, enabling a
speed very close to a compiled program.
\**********************************************************************/
/*
.AC "=" "evaluate expression and assign to a vector"
.SY "<variable> = <expression>"
.BB
Assigns the result of evaluating <expression> to <variable>.  
.BI
A variable is a float varialbe, a vector, or a matrix.  A vector or a
matrix can be subscripted.
Type \fBhelp vector\fP for details about vector/matrix. ~H
Type \fBhelp expression\fP for details about expression. ~H
See section 0 for details about vector/matrix and expression. ~R
.NI
There is no limit in the complexity of an expression except: An
expression can be specified by up to 14 white-space separated
character strings, each string can be up to 60 characters long.  A
new-line followed by an escape character '\\' is ignored, so that an
expression can be specified by multiple lines.
.EE
*/
/*
Code for setting up "=" statement should be here to avoid problems like
'input = expression ' which could be interpreted as command "input".
*/ 
  if(index( line, '=' ) && GetArg( 0, find_optimize_expression( net, line ))) {
    GetFunc( evalExpression, 1 );
  }
  /* NOTE: problem with having two different sets of syntax . it might be
  better to parse actions first with more strict parser (that would not confuse
  "input = ..." with the action input) and parse expression last. */
#if 0	/* this has been replaced by the above */
  else 
  if( argn && EQL(args[0], "=") ) {
    if( argn < 2 ) Erreturn( get_syntax( "=" ) );
    IfErr( GetArg( 0, find_variable_expression( net, command )))
      Erreturn3("%s: in %s = %s ...", ERR_MSG, command,args[1]);
    for( *buf = NULL,n=1; n<argn; n++ ) strcat( buf, args[n] );
    IfErr( GetArg( 1, find_optimize_expression( net, buf )))
      Erreturn3("%s: in %s = %s ...", ERR_MSG, command, args[1]);
    GetFunc( assign_expression, 2 ); 
  }
#endif 0
/*
.AC "command" "execute SunNet command"
.SY "command <command> [arguments ..]"
.BB
Executes a SunNet command.
.EE
*/
  else IF( command, "command" ) {
    if( argn < 1) Erreturn(get_syntax("command"));
    IfErr( GetArg( 0, make_citem( new( CLIST ), args[0], argn-1, args[1] )))
      Erreturn1("%s: in making command", ERR_MSG);
    GetArg( 1, procScope );
    GetFunc( exec_citem, 2 );
  }

/*
.AC "call" "call a procedure"
.SY "call <procedure>[(argument,...)]"
.BB
Call a procedure as a subprocedure.  Calls can be nested or recursive.
A procedure requiring arguments should be called as 
\fBcall <procedure>(argument1,argument2,..)\fP where argumentN is the Nth
argument which must be of the same type as declared in the procedure 
definition.  If the procedure has not been defined yet, the library files
(if any) will be searched.  See the network command 'library'.  If the
procedure is not found anywhere, it is assumed that it will be defined later.
A warning message will be presented if such procedure has not been defined
when the end of the network file is reached.
.EE
*/
  else IF( command, "call" ) {
    if( argn < 1 ) Erreturn( get_syntax( "call" ) );
	/* the 4th argument '0' means not to look at library yet */
    IfErr( GetArg(0, find_procedure( net, args[0], 1, 0)))
      Erreturn2("%s: in call %s", ERR_MSG, args[0] );
    GetFunc(executeAprocCheck, 1);
  }
/*
.AC "input" "copy input pattern to a layer"
.SY "input <layer>"
.BB
Copy content of input buffer into the activation values of <layer>.
If the lengths of the buffer and <layer> differ, copies up to the end of
the shorter.  Equivalent to \fB<layer> = input\fP.
.EE
*/
  else IF( command, "input" ) {
    if( GetArg(1, which_layer_arg( net, args[0] ) )) {
      GetFunc( input_layer_arg, 2 );
    }
    else if( GetArg( 1, which_layer( net, args[0] ) )) {
      GetFunc( input_layer, 2 );
    }
    else
      Erreturn2("%s: input to %s ?", ERR_MSG, args[0] );
    GetArg( 0, &net->input );
  }
/*
.AC "forward" "send activation forward through connection"
.SY "forward <connection>"
.BB
Send activation forward through a connection.  Let a[i] be the activation
value of the i'th unit sending the connection, net[j] the net input
of the j'th unit receiving the connection, and w[j][i] the connection
weight between these units.  Then the effect of \fBforward\fP is that
for all j, net[j] is incremented by sum-for-all-i( a[i]*w[j][i] ) ~H
for all j, net[j] is incremented by: ~R
.ce 1 ~R
.EQ ~R
DELTA net[j] = sum from i a[i] w[i][j] ~R
.EN ~R
If <connection> connects from <layer1> to <layer2> \fBforward <connection>\fP 
is equivalent to \fB<layer2>:net = <layer2>:net + <layer1>**<connection>\fP.
.EE
*/
  else IF( command, "forward" ) {
    if( GetArg(0, which_connection_arg( net, args[0] ) )) {
      GetFunc( forward_arg, 1 );
    }
    else {
      IfErr( connectP = which_connection( net, args[0] ) )
	Erreturn2("%s: forward %s ?", ERR_MSG, args[0] );
      if( Err(connectP->fromlayer) || Err(connectP->tolayer))
	Erreturn1("forward %s: not connected", args[0]);
      GetArg( 0, connectP );
      GetFunc( forward, 1 );
    }
  }
/*
.AC "resize" "resize a data structure"
.SY "resize <layer> <value> [connect]/ resize <array> <value> / resize <row> <column>"
.BB
\fBResize\fP is used to change the size of a layer, array or a matrix.
.Ni
\fBresize <layer> <value>\fP changes the number of units in <layer> to <value>.
<value> can be given as an expression.  Optional 'connect' flag means to resize
the connections going into and coming out of <layer> too.  In this case, only 
connections with full connectivities are resized.  In case of connections with 
sparse connectivities, new connectivity pattern should be specified with 'rewire' 
action to create new weights to or from the resized layer.
.Ni
\fBresize <array> <value>\fP changes the size of <array> to <value>.
<value> can be an expression.
.Ni
\fBresize <matrix> <row> <column>\fP changes the size of <matrix> to <row> 
rows by <column> columns.  <row> and <columns> can be expressions.
.Ni
By default, when resizing a data the values in the data are not changed.
When resizing a matrix or an array an optional last argument \fBnocopy\fP means 
that it is not be necessary to keep the old values.  In this case, the content
of the matrix or the array after resizing is undefined.
.EE
*/
  else IF( command, "resize" ) {
    if( argn < 2 ) Erreturn( get_syntax( "resize" ) );
    if( GetArg( 0, which_layer_arg( net, args[0] ) ) ) {
      if( argn>1 && EQL( args[2], "connect" ) ) 
	{ GetFunc( resize_layer_connect_arg, 2 );}
      else GetFunc( resize_layer_arg, 2 );
    }
    else if( GetArg( 0,  which_layer( net, args[0] ))) {
      if( argn>2 && EQL( args[2], "connect" ) ) 
	{ GetFunc( resize_layer_connect, 2 ); }
      else GetFunc( resize_layer, 2 );
    }
    else if( GetArg( 0, which_array( net, args[0] ) ) ) {
      GetFunc( resize_array, 3 ); 
      if( argn>3 && EQL(args[3],"nocopy") ) { IntArg(2, 0); }
      else { IntArg(2, 1); }
    }
    else if( GetArg( 0, which_matrix( net, args[0] ) ) ) {
      GetFunc( resize_matrix, 4 ); 
      if( argn==2 ) Erreturn("syntax: resize <matrix> row col");
      IfErr( GetArg( 2, find_optimize_expression(net, args[2] ) ) )
	Erreturn2( "%s: in resize %s ..", ERR_MSG, args[0]);
      if( argn>3 && EQL(args[3],"nocopy") ) { IntArg(3, 0); }
      else { IntArg(3, 1); }
    }
    else 
      Erreturn1("%s not found: syntax: resize layer/connect/vector/matrix ..",
		   args[0] );
    IfErr( GetArg( 1, find_optimize_expression(net, args[1] ) ) )
      Erreturn2( "%s: in resize %s ..", ERR_MSG, args[0]);
  }
/*
.AC "activation" "compute activations in a layer"
.SY "activation <layer>"
.BB
Compute activation values in <layer>.  This should follow 'forward'.
Let a[i] be the activation value, net[i] the net input, and bias[i] the
bias of i'th unit in the layer, and let f() be the activation function
for the layer.  Then the effect of \fBactivation\fP is for all i,
a[i] = f( net[i] + bias[i] ) ~H
.ce 1 ~R
.EQ ~R
a[i]~=~f(~net[i]~+~bias[i]~) ~R
.EN ~R
It is equivalent to \fB<layer> = logistic( <layer>:net + <layer>:bias )\fP for
a logistic layer, and \fB<layer> = <layer>:net + <layer>:bias\fP for a linear
layer.
.EE
*/
  else IF( command, "activation" ) {
    if( GetArg(0, which_layer_arg( net, args[0] ) )) {
      GetFunc( activation_arg, 1 ) ;/* check type at run-time */
    }
    else {
      IfErr( layerP = which_layer( net, args[0] )) 
	Erreturn2("%s: activation %s ?", ERR_MSG, args[0] );
      GetArg( 0, layerP );
      GetFunc((layerP->type==Linear)? linear :logistic, 1 ) ;
    }
  }
/*
.AC "target" "compare activations in a layer to target pattern"
.SY "target <layer>"
.BB
Compare activation pattern in a layer with content of target buffer
and Compute deltas for the layer.  Let a[i] be the activation value
delta[i] the delta, net[i] the net input, and bias[i] the bias of the
i'th unit in the layer, target[i] the i'th value in the target buffer,
and f'() the derivative of the activation function for the layer.
Then the effect of \fBtarget\fP is, for all i: 
delta[i] = ( target[i] - a[i] ) * f'( net[i] + bias[i] ) ~H
.ce 1 ~R
.EQ ~R
delta[i]~=~(~target[i]~-~a[i]~) f dot (~net[i]~+~bias[i]~) ~R
.EN ~R
It is equivalent to \fB<layer>:delta = target\(mi<layer>\fP for a linear layer, and
\fB<layer>:delta = (target-<layer>)*(<layer>\(mi$min)*($max\(mi<layer>)/($max\(mi$min)\fP 
for a logistic layer.
.Bi
The squared error averaged across all units in <layer> is stored in
the variable $Error.
.EQ ~R
$Error~=~1 over 2N sum from i (~target[i]~-~a[i]~) sup 2 roman "\t(N = # of units in the layer)" ~R
.EN ~R
which is equivalent to \fB$Error = average((target\(mi<layer>)^2)/(2*sizeof(<layer>))\fP.
.Bi
If 'careoff' is set to a value other than 1.0, output errors are
weighed differentially for ON targets and OFF targets.  For example,
if it is set to 0.1 only 10 percent of the error is propagated back from the
output units that are supposed to be OFF compared to those that are
supposed to be ON.  This is useful for a classification network with
local output representation in which only one of many output units
gets ON target and all others get OFF targets because if the output
units are told to turn themselves off most of the time it may be
difficult to learn to turn on when necessary.  It is equivalent to
\fB<layer>:delta = <layer>:delta*((target<middle)*$careoff+(target>=middle))\fP.
where middle = ($max-$min)/2+$min.
.EE
*/
  else IF( command, "target" ) {
    if( GetArg(0, which_layer_arg(net, args[0]))) {
      GetFunc( delta_out_arg, 2 );
    }
    else {
      IfErr( layerP = which_layer( net, args[0] )) 
	Erreturn2("%s: target %s ?", ERR_MSG, args[0] );
      GetArg( 0, layerP );
      GetFunc((layerP->type==Linear)? delta_out_linear :
    				      delta_out_logistic, 2 ) ;
    }
    GetArg( 1, &net->target  );
  }
/*
.AC "backward" "propagate error back through connection"
.SY "backward <connection>"
.BB
Propagate error/delta back through a connection.  Let delta[i] be the
delta of the i'th unit sending the connection, delta[j] the delta of
the j'th unit receiving the connection, and w[i][j] the connection
weight between these units.  Then the effect of \fBbackward\fP is that
for all i, delta[i] is incremented by sum-for-all-j( delta[j]*w[i][j] ) ~H
for all i, delta[i] is incremented by : ~R
.ce 1 ~R
.EQ ~R
DELTA delta[i]~=~sum from j delta[j] w[i][j] ~R
.EN ~R
It is equivalent to \fB<layer1>:delta = <layer1>:delta + <connection>**T(layer2)\fP.
.EE
*/
  else IF( command, "backward" ) {
    if(GetArg( 0, which_connection_arg( net, args[0] ))) {
      GetFunc( backward_arg, 1 );
    }
    else {
      IfErr( GetArg(0, (connectP = which_connection( net, args[0] ) )))
	Erreturn2("%s: backward %s ?", ERR_MSG, args[0] );
      if( Err(connectP->fromlayer) || Err(connectP->tolayer))
	Erreturn1("%s: not connected", args[0]);
      GetFunc( backward, 1 );
    }
  }
/*
.AC "delta" "compute deltas in a layer"
.SY "delta <layer>"
.BB
Compute delta's for units in <layer>. this should follow 'backward'.
Let net[i] be the net input, bias[i] the bias, and delta[i] the delta of
i'th unit in the layer, and let f'() be the derivative of the activation
function for the layer.  Then the effect of \fBdelta\fP is, for all i:
delta[i] = delta[i] * f'( net[i] + bias[i] ) ~H
.ce 1 ~R
.EQ ~R
delta[i]~=~delta[i] cdot f dot (~net[i]~+~bias[i]~) ~R
.EN ~R
It is equivalent to:
\fB<layer>:delta = <layer>:delta*(<layer>\(mi$min)*($max\(mi<layer>)/($max\(mi$min)\fP for a logistic layer.  It is no-op for a linear layer.
.EE
*/
  else IF( command, "delta" ) {
    if(argn < 1 ) Erreturn( get_syntax( "delta" ) );
    if( GetArg(0, which_layer_arg( net, args[0]))) {
      GetFunc( delta_arg, 1 );
    }
    else {
      IfErr( GetArg(0, (layerP=which_layer( net, args[0]) )) )
	Erreturn2("%s: delta %s ?", ERR_MSG, args[0] );
      GetFunc((layerP->type==Linear)?   delta_linear : delta_logistic, 1 ) ;
    }
  }
/*
.AC "learn" "modify connection"
.SY "learn <connection>"
.BB
Modify weights in <connection> using appropriate deltas and
activations.  Let a[i] be the activation value of the i'th unit sending
the connection, delta[j] the delta of the j'th unit receiving the
connection, w[i][j] the connection weight between these units, and
^w[i][j] the previous change to this weight.  Let $eta be the learning rate ~H
parameter, and $alpha the momentum parameter.  Then the effect of 'learn' is ~H
for all i and j, w[i][j] is incremented by : ~H
$eta * delta[j] * a[i] + $alpha * ^w[i][j] ~H
.EQ ~R
DELTA w[i][j] sub {t-1} roman " the previous change to this weight. Let" ~R
eta ~roman and~ alpha ~R
.EN ~R
be the learning rate, and momentum parameters, respectively. Then the effect of
\fBlearn\fP is, for all i and j, w[i][j] is incremented by: ~R
.ce 1 ~R
.EQ ~R
DELTA w[i][j] sub t~=~ eta cdot delta[j] cdot a[i]~+~ alpha cdot DELTA w[i][j] sub {t-1} ~R
.EN ~R
It is equivalent to \fB<connection>:delta = $eta*T(<layer1>)**<layer2>:delta
+ $alpha*<connection>:delta; <connection> = <connection>+<connection>:delta\fP.
.sp
The default is to apply the changes each time the action 'learn' is called.
However, if <connection> is defined as "batch" (see 'connect'), learning is
done in a "batch" mode: the changes to the weights are accumulated
for multiple calls to the action 'learn' and then applied at once when a
call is made with a third argument "change" as in 'learn <connection> change'.
If the changes are to be accumulated for each cycle through the training
patterns, define another procedure, eg. "change_wts" in which you call "learn
<connection> change" for each connection and run "cycle N learn -E change_wts".
.EE
*/
  else IF( command, "learn" ) {
    if( GetArg(0, which_connection_arg( net, args[0] ))) {
      if(argn>1 && EQL(args[1],"change")) 
	{ GetFunc( change_weight_batch_do_arg, 1); }
      else { GetFunc( change_weight_arg, 1 ); }
    }
    else {
      IfErr( connectP = which_connection( net, args[0] ) )
	Erreturn2("%s: learn %s ?", ERR_MSG, args[0] );
      if( Err(connectP->fromlayer) || Err(connectP->tolayer))
	Erreturn1("%s: not connected", args[0]);
      if(argn>1 && EQL(args[1],"change")) 
	{ GetFunc( change_weight_batch_do, 1); }
      else if( connectP->change ) { GetFunc( change_weight_batch, 1 ); }
      else { GetFunc( change_weight, 1 ); }
      GetArg( 0, connectP );
    }
  }
/*
.AC "learnbias" "modify biases in a layer"
.SY "learnbias <layer>"
.BB
Modify bias of units in <layer> using appropriate deltas.  Let
delta[i] the delta, and bias[i] the bias of i'th units in the layer, and
^bias[i] the previous change to this bias. Then the effect of \fBlearnbias\fP is: ~H
bias[i] = bias[i] + $eta * delta[i] + $alpha * ^bias[i] ~H
.EQ ~R
DELTA bias[i] sub {t-1} ~R
.EN ~R
the previous change to this bias. Then the effect of \fBlearnbias\fP is ~R
that for all i, bias[i] is incremented by: ~R
.ce 1 ~R
.EQ ~R
DELTA bias[i] sub t~=~ eta cdot delta[i]~+~ alpha cdot  DELTA bias[i] sub {t-1} ~R
.EN ~R
.EE
*/
  else IF( command, "learnbias" ) {
    if( GetArg(0, which_layer_arg( net, args[0] ) ) ) {
      GetFunc( change_bias_arg, 1 );
    }
    else {
      IfErr( GetArg(0, which_layer( net, args[0] ) ))
	Erreturn2("%s: learnbias %s ?", ERR_MSG, args[0] );
      GetFunc(  change_bias, 1 ) ;
    }
  }
/*
.AC "clear" "clear net inputs and deltas in a layer"
.SY "clear <layer>"
.BB
Clears net inputs and deltas (but not activations) of units in <layer>.  
.Ni
\fBclear\fP is necessary before accumulating new net inputs and deltas by
\fBforward\fP and \fBbackward\fP.  This is done automatically (1) before each
pattern presentation in \fBcycle\fP or \fBpresent\fP, and (2) before
running the first procedure called by \fBexec\fP.
.Ni
So, it is necessary to call this action explicitly only if the action
\fBactivation <layer>\fP or the action \fBdelta <layer>\fP is called on a same
layer more than once in a procedure including its subprocedures. This usually
happens when <layer> has recurrent connections.
In this case, \fBclear <layer>\fP should be called between a call of
\fBactivation\fP and/or \fBdelta\fP on <layer>, and the next call of
\fBforward\fP and/or \fBbackward\fP on the same <layer>.
.EE
*/
  else IF( command, "clear" ) {
    if( argn < 1 ) Erreturn(get_syntax("clear"));
    if( GetArg( 0, which_layer_arg( net, args[0] ))) {
      GetFunc( clear_layer_arg, 1 );
    }
    else {
      IfErr( GetArg( 0, which_layer( net, args[0] ) ) )
	Erreturn2("%s: clear %s ?", ERR_MSG, args[0] );
      GetFunc(  clear_layer, 1 ) ;
    }
  }
/*
.AC "cleardelta" "clear deltas in a layer"
.SY "cleardelta <layer>"
.BB
Let delta[i] be the delta of i'th unit in the layer. Then the effect of
\fBcleardelta\fP is delta[i] = 0.0 ~H
\fBcleardelta\fP is: ~R
.ce 1 ~R
.EQ ~R
delta[i]~=~0.0 ~R
.EN ~R
.Bi
See the command \fBclear\fP also.
.EE
*/
  else IF( command, "cleardelta" ) {	
    if( argn < 1 ) Erreturn(get_syntax("cleardelta"));
    if( GetArg( 0, which_layer_arg( net, args[0] ) )) {
      GetFunc( clear_delta_arg, 1 );
    }
    else {
      IfErr( GetArg( 0, which_layer( net, args[0] ) ) )
	Erreturn2("%s: clear %s ?", ERR_MSG, args[0] );
      GetFunc(  clear_delta, 1 ) ;
    }
  }
/*
.AC "rewire" "rewire weights in a connection"
.SY "rewire <connect> <matrix>"
.BB
<matrix> specifies which of the weights should be regarded existing
and which are non-existing.  Non-zero elements in <matrix> mark
corresponding weights in <connect> to be existing, and the other
weights are marked to be non-existing.  Only weights marked as
existing will have effect in actions "forward", "backward", and
"learn", even though the values of non-existing ones can be displayed
or printed.  Execution time is proportional to the number of existing
weights.  This action has no effect if <connect> is used in
expressions, but <connect>*<matrix> can be used in place of <connect>
in expressions to achieve the same effect.
.EE
*/
  else if( EQL(command, "prune") || EQL(command, "rewire") ) {
    if( GetArg( 0, which_connection_arg( net, args[0] ))) {
      GetFunc( prune_connection_arg, 2 );
    }
    else {
      IfErr( GetArg( 0, which_connection( net, args[0] ) ))
	Erreturn2("%s: prune %s ?", ERR_MSG, args[0] );
      GetFunc( prune_connection, 2 );
    }
    IfErr( GetArg( 1, find_optimize_expression(net, args[1] )) )
      Erreturn3("%s: prune %s %s ?", ERR_MSG, args[0], args[1] );
    /* IntArg( 2, n_from ); */
  }
/*
.AC "copy" "copy a vector to a vector"
.SY "copy <vector1> <vector2>"
.BB
Equivalent to <vector2> = <vector1>.  See help for "=".
.EE
*/
  else IF( command, "copy" ) {
    if( argn < 2 ) Erreturn( get_syntax( "copy" ) );
    IfErr( GetArg( 1, find_optimize_expression(net, args[0] )) )
      Erreturn1("copy from %s ?", args[0] );
    IfErr( GetArg( 0, find_variable_expression(net, args[1] )) )
      Erreturn1("copy to %s ?", args[1] );
    GetFunc( assign_expression, 2 );
    /* IntArg( 2, min( n_from, n_to ) ) ;
    GetFunc( copy_vector_, 2 ) ; */
  }
/*
.AC "push" "push a vector into a vector"
.SY "push <vector1> <vector2>"
.BB
Push content of <vector1> into <vector2>.  Content of <vector2> is 
shifted to the right.
.EE
*/
  else IF( command, "push" ) {
    if( argn < 2 ) Erreturn( get_syntax( "push" ) );
    IfErr( GetArg( 0, find_optimize_expression(net, args[0])) )
      Erreturn1("push %s ?", args[0] );
    IfErr( GetArg( 1, find_variable_expression(net, args[1])) )
      Erreturn1("push to %s ?", args[1] );
    GetFunc( push_vector, 2 );
    /* if( n_from > n_to) Erreturn2("push: %s is bigger than %s",args[0],args[1]);
    IntArg( 2, n_from);
    IntArg( 3, n_to ) ;
    GetFunc( push_vector, 4 ) ; */
  }
/*
.AC "pushend" "push a vector from end of a vector"
.SY "pushend <vector1> <vector2>"
.BB
Push content of <vector1> from the end of <vector2>.  Content of <vector2> 
is shifted to the left.
.EE
*/
  else IF( command, "pushend" ) {
    if( argn < 2 ) Erreturn( get_syntax( "pushend" ) );
    IfErr( GetArg( 0, find_optimize_expression(net, args[0])) )
      Erreturn1("push %s ?", args[0] );
    IfErr( GetArg( 1, find_variable_expression(net, args[1])) )
      Erreturn1("pushend to %s ?", args[1] );
    GetFunc( push_from_end, 2 );
    /* if( n_from > n_to ) 
      Erreturn2("pushend: %s is bigger than %s",args[0],args[1]);
    IntArg( 2, n_from);
    IntArg( 3, n_to ) ;
    GetFunc( push_from_end, 4 ) ; */
  }
/*
.AC "pop" "pop from a vector to a vector"
.SY "pop <vector1> <vector2>"
.BB
Pop content of <vector1> into <vector2>.  Content of <vector1> is
shifted to the left (zero-padding on the right).
.EE
*/
  else IF( command, "pop" ) {
    if( argn < 2 ) Erreturn( get_syntax( "pop" ) );
    IfErr( GetArg( 0, find_optimize_expression(net, args[0])) )
      Erreturn1("pop from %s ?", args[0] );
    IfErr( GetArg( 1, find_variable_expression(net, args[1])) )
      Erreturn1("pop to %s ?", args[1] );
    GetFunc( pop_vector, 2);
    /*
    if( n_from < n_to) Erreturn2("pop: %s is shorter than %s",args[0],args[1]);
    IntArg( 2, n_from);
    IntArg( 3, n_to ) ;
    GetFunc( pop_vector, 4 ) ; */
  }
/*
.AC "popend" "pop from the end of a vector to a vector"
.SY "popend <vector1> <vector2>"
.BB
Pop the end of <vector1> into <vector2>.  Content of <vector1> is
shifted to the right (zero-padding on the left).
.EE
*/
  else IF( command, "popend" ) {
    if( argn < 2 ) Erreturn( get_syntax( "popend" ) );
    IfErr( GetArg( 0, find_optimize_expression(net, args[0])) )
      Erreturn1("popend from %s ?", args[0] );
    IfErr( GetArg( 1, find_variable_expression(net, args[1])) )
      Erreturn1("popend to %s ?", args[1] );
    GetFunc( pop_from_end, 2 );
    /*
    if( n_from < n_to) Erreturn2("pop: %s is shorter than %s",args[0],args[1]);
    IntArg( 2, n_from);
    IntArg( 3, n_to ) ;
    GetFunc( pop_from_end, 4 ) ; */
  }
/*
.AC "shift" "shift a vector"
.SY "shift <value> <vector>"
.BB
Shifts values in <vector> <value> elements to the right (left if <value> < 0),
zero-padding.  <value> can be an expression.
.EE
*/
  else IF( command, "shift" ) {
    if( argn<2 ) Erreturn( get_syntax( "shift" ) );
    /* if( intvarP = which_intvar( net, args[0] )) GetArg( 0, &intvarP->value );
    else if( AtoI( args[0], n ) ) { IntArg( 0, n ); } */
    IfErr( GetArg( 0, find_variable_expression( net, args[1] )))
      Erreturn2("shift %s %s ?", args[0],args[1] );
    IfErr( GetArg( 1, find_optimize_expression( net, args[0] )))
      Erreturn1("shift %s ?", args[0] );
    GetFunc( shift_vector, 2 ) ;
  }
/*
.AC "set" "set variable/vector to expression"
.SY "set <variable> <expression>"
.BB
Equivalent to <variable> = <expression>.  See help for "=".
.EE
*/
  else IF( command, "set" ) {
    if( argn < 2 ) Erreturn( get_syntax( "set" ) );
    for( *buf = NULL,n=1; n<argn; n++ ) strcat( buf, args[n] );
    if( Err( GetArg( 0, find_variable_expression( net, args[0] ))) ||
       Err( GetArg( 1, find_optimize_expression( net, buf ))) )
      Erreturn3("%s: in 'set %s %s'", ERR_MSG, args[0], buf);
    GetFunc( assign_expression, 2 );
  }
/*
.AC "choosemax" "choose largest value in a vector"
.SY "choosemax <vector1> <vector2> [threshold]"
.BB
If the largest value in vector1 is greater than threshold (default=0)
then sets the corresponding value in vector2 to $max and other values
to $min.  Example: if vector1 is (0.6, 0.0, 0.9, 0.3) then vector2 becomes
($min, $min, $max, $min).  The function choosemax() is similar but does not 
use threshold.  
Equivalent to \fB<vector2>=choosemax(<vector1>)*(max(<vector1>)>threshold)\fP.
.EE
*/
  else IF( command, "choosemax" ) {
    if( argn < 2 ) Erreturn( get_syntax( "choosemax" ) );
    IfErr( GetArg( 0, find_optimize_expression(net, args[0])) )
      Erreturn1("choosemax from %s ?", args[0] );
    IfErr( GetArg( 1, find_variable_expression(net, args[1] )) )
      Erreturn1("choosemax to %s ?", args[1] );
    /* IntArg( 2,(n_from > n_to)? n_to : n_from ) ; */
    if( argn > 2 ) {
      IfErr( GetArg(2, find_optimize_expression(net, args[2] )))
	Erreturn1("%s: invalid threshold for choosemax",args[2]);
      /* if( floatvarP = which_floatvar( net, args[2]))
	GetArg( 3, &floatvarP->value );
      else if( AtoF( args[2], x ) )
	{ FloatArg( 3, x ); }
      else
	Erreturn( get_syntax( "choosemax" ) );*/
      GetFunc( choose_max_threshold, 3 ) ;
    }
    else {
      GetFunc( choose_max, 2 ) ;
    }
  }
/*
.AC "indexmax" "index largest value in a vector"
.SY "indexmax <vector> <variable>"
.BB
Disabled command. Converted to <variable>=indexmax(<vector>) for now.
.EE
*/
  else IF( command, "indexmax" ) {
    if( argn < 2 ) Erreturn( get_syntax( "indexmax" ) );
    sprintf(line, "%s=indexmax(%s)", args[1],args[0]);
    sendMsg1("Warning: action 'indexmax' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /* IfErr( GetArg( 0, find_vector(net, args[0], &n_from)) )
      Erreturn1("indexmax %s ?", args[0] );
    IfErr( GetArg( 1, find_vector(net, args[1], &n_to  )) )
      Erreturn2("indexmax %s %s ?", args[0], args[1] );
    IntArg( 2, n_from );
    GetFunc( index_max, 3 ) ; */
  }
/*
.AC "noise" "add noise to a vector"
.SY "noise <vector> Noise"
.BB
Add gausian noise with variance 'Noise' to each element of <vector>.
.EE
*/
  else IF( command, "noise" ) {
    if( argn < 2 ) Erreturn( get_syntax( "noise" ) );
    IfErr( GetArg( 0, find_variable_expression( net, args[0] ))) 
      Erreturn2("%s: noise in %s ?", ERR_MSG, args[0] );
    IfErr( GetArg( 1, find_optimize_expression( net, args[1] )))
      Erreturn1("noise .. %s ?", args[1] );
    /* IntArg( 1, n );
    if( floatvarP=which_floatvar(net, args[1])) GetArg( 2, &floatvarP->value);
    else if( AtoF( args[1], x ) ) { FloatArg( 2, x ); }
    else Erreturn( get_syntax( "noise" ) ); */
    GetFunc( add_noise_to_vector, 2 ) ;
  }
/*
.AC "randomstate" "turn on vector elements probabilistically"
.SY "randomstate <vector> <pvector>"
.BB
Disabled command. Converted to <vector>=randomstate(pvector) for now.
.EE
*/
  else IF( command, "randomstate" ) {
    if( argn < 2 ) Erreturn( get_syntax( "randomstate" ) );
    sprintf(line, "%s=randomstate(%s)", args[0],args[1]);
    sendMsg1("Warning: action 'randomstate' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /* IfErr( GetArg(0, find_vector( net, args[0], &n0))) 
      Erreturn1("cannot find %s?",args[0]);
    IfErr( GetArg(1, find_vector( net, args[1], &n1))) 
      Erreturn1("cannot find %s?",args[1]);
    GetFunc( random_state, 3 ); IntArg( 2, (n0>n1)? n1 : n0 ); */
  }
/*
.AC "threshold" "threshold values in a vector"
.SY "threshold <vector1> <threshold> <vector2>"
.BB
For all i: <vector2>[i] = $max if <vector1>[i] is greater than <threshold>[i], 
$min otherwise.
.EE
*/
  else IF( command, "threshold" ) {
    if( argn < 3 ) Erreturn( get_syntax( "threshold" ) );
    IfErr( GetArg(0, find_optimize_expression( net, args[0]))) 
      Erreturn1("threshold %s?",args[0]);
    IfErr( GetArg(1, find_optimize_expression( net, args[1])))
      Erreturn1("threshold .. %s?",args[1]);
    /*if( n1 < n0 ) Erreturn2("threshold %s shorter than %s", args[1],args[0]);
    */
    IfErr( GetArg(2, find_variable_expression( net, args[2])))
      Erreturn1("threshold .. %s?",args[2]);
    GetFunc( threshold, 3 ); /*IntArg( 3, min( n0, n1 ) );*/
  }
/*
.AC "copyerror" "copy error to a variable"
.SY "copyerror <variable>"
.BB
Disabled command. Converted <variable> = $Error for now.
.EE
*/
  else IF( command, "copyerror" ) {
    sprintf(line, "%s=$Error", args[0]);
    sendMsg1("Warning: action 'copyerror' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /* if( argn < 1 ) Erreturn( get_syntax( "copyerror" ) );
    IfErr( GetArg( 0, find_vector(net,args[0], &n_to) ) )
      Erreturn2("%s: copyerror %s ?", ERR_MSG, args[0] );
    GetFunc( copy_error, 2 ) ;
    GetArg( 1, &net->target ); */
  }
/*
.AC "erroraverage" "set error to average value of a vector"
.SY "erroraverage <vector>"
.BB
Disabled command.  Converted to \fB$Error = average(<vector>)\fP for now.
.EE
*/
  else IF( command, "erroraverage" ) {
    if( argn < 1 ) Erreturn("syntax: erroraverage <vector>");
    sprintf(line, "$Error=average(%s)", args[0]);
    sendMsg1("Warning: action 'erroraverage' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /* IfErr( GetArg( 0, find_vector( net, args[0], &n )) )
      Erreturn2("%s: erroraverage %s ?", ERR_MSG, args[0] );
    IntArg( 1 , n );
    GetArg( 2, &net->target.error_sum ) ;
    GetFunc( average_vector_, 3 ) ; */
  }
/*
.AC "average" "set variable to average value of vector"
.SY "average <vector> <variable>"
.BB
Disabled command. Converted to \fB<variable> = average(<vector>)\fP for now.
.EE
*/
  else IF( command, "average" ) {
    if( argn < 1 ) Erreturn( get_syntax( "average" ) );
    sprintf(line, "%s=average(%s)", args[1],args[0]);
    sendMsg1("Warning: action 'average' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /*IfErr( GetArg( 0, find_vector( net, args[0], &n )) )
      Erreturn2("%s: average %s ?", ERR_MSG, args[0] );
    IfErr( GetArg( 2, find_vector( net, args[1], &n_to )) )
      Erreturn2("%s: put average to %s ?", ERR_MSG, args[1] );
    IntArg( 1 , n );
    GetFunc( average_vector_, 3 ) ; */
  }
/*
.AC "sum" "set variable to sum of values in vector"
.SY "sum <vector> <variable>"
.BB
Disabled command. Converted to \fB<variable> = sum(<vector>)\fP for now.
.EE
*/
  else IF( command, "sum" ) {
    if( argn < 2 ) Erreturn( get_syntax( "sum" ) );
    sprintf(line, "%s=sum(%s)", args[1],args[0]);
    sendMsg1("Warning: action 'sum' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression,1);
    /*IfErr( GetArg( 0, find_vector( net, args[0], &n )) )
      Erreturn2("%s: sum %s ?", ERR_MSG, args[0] );
    IfErr( GetArg( 2, find_vector( net, args[1], &n_to )) )
      Erreturn2("%s: put sum to %s ?", ERR_MSG, args[1] );
    IntArg( 1 , n );
    GetFunc( sum_vector_, 3 ) ;*/
  }
/*
.AC "oproduct" "compute outer product of two vectors"
.SY "oproduct <vector1> <vector2> <matrix>"
.BB
Disabled command.  Converted to \fB<matrix> = T(<vector1>)\(**\(**<vector2>)\fP.
.EE
*/
  else IF( command, "oproduct" ) {
    if( argn < 3 ) Erreturn( get_syntax( "oproduct" ) );
    sprintf(line, "%s=T(%s)**%s", args[2],args[0],args[1]);
    sendMsg1("Warning: action 'oproduct' disabled. converting to %s\n", line);
    IfErr( GetArg( 0, find_optimize_expression(net, line)))
      Erreturn2("%s: in %s", ERR_MSG, line);
    GetFunc(evalExpression, 1);
    /* IfErr( GetArg( 0, find_vector( net, args[0], &n0 )) )
      Erreturn2("%s: oproduct %s ?", ERR_MSG, args[0] );
    IntArg( 1, n0 );
    IfErr( GetArg( 2, find_vector( net, args[1], &n1 )) )
      Erreturn3("%s: oproduct %s %s ?", ERR_MSG, args[0], args[1] );
    IntArg( 3 , n1 );
    IfErr( GetArg( 4, find_vector( net, args[2], &n_to )) )
      Erreturn2("%s: oproduct .. %s ?", ERR_MSG, args[2] );
    GetFunc( outer_product, 5 ) ; */
  }
  else IF( command, "iproduct" ) {
    if( argn < 3 ) Erreturn( get_syntax( "iproduct" ) );
    IfErr( GetArg( 0, which_ivector( net, args[0] )) )
      Erreturn2("%s: iproduct %s ?", ERR_MSG, args[0] );
    IfErr( GetArg( 1, find_vector( net, args[1], &n1 )) )
      Erreturn3("%s: iproduct %s %s ?", ERR_MSG, args[0], args[1] );
    if( args[2][0]=='+' ) {
      IfErr( GetArg( 2, find_vector( net, args[2]+1, &n_to )) )
	Erreturn2("%s: iproduct .. %s ?", ERR_MSG, args[2] );
      if( n1 == 1 ) {
	IntArg( 3, n_to );
	GetFunc( ivector_times_float_inc, 4 ) ;
      }
      else {
	IntArg( 3, n1 );
	GetFunc( ivector_dot_vector_inc, 4 ) ;
      }
    }
    else {
      IfErr( GetArg( 2, find_vector( net, args[2], &n_to )) )
	Erreturn2("%s: iproduct .. %s ?", ERR_MSG, args[2] );
      if( n1 == 1 ) {
	IntArg( 3, n_to );
	GetFunc( ivector_times_float, 4 ) ;
      }
      else {
	IntArg( 3, n1 );
	GetFunc( ivector_dot_vector, 4 ) ;
      }
    }
  }
  else IF( command, "makeindex" ) {
    if( argn < 2 ) Erreturn( get_syntax( "makeindex" ) );
    IfErr( GetArg( 0, which_ivector( net, args[0] )) )
      Erreturn2("%s: makeindex %s ?", ERR_MSG, args[0] );
    IfErr( GetArg( 1, find_vector( net, args[1], &n1 )) )
      Erreturn3("%s: makeindex %s %s ?", ERR_MSG, args[0], args[1] );
    IntArg( 2, n1 );
    GetFunc( make_index, 3 );
  }
  else IF( command, "sortindex" ) {
    if( argn < 1 ) Erreturn( get_syntax( "sortindex" ) );
    IfErr( GetArg( 0, which_ivector( net, args[0] )) )
      Erreturn2("%s: sortindex %s ?", ERR_MSG, args[0] );
    GetFunc( sort_index, 1 );
  }
/*
.AC "clamp" "clamp vector to a vector"
.SY "clamp <vector1> <vector2>"
.BB
Clamps elements in <vector1> to values of <vector2>.  same as
"set <vector1> <vector2>" except that if a value in <vector2> is
DONT_CARE (specified by a '*' in a pattern file), the corresponding 
element in <vector1> is left unchanged.
.EE
*/
  else IF( command, "clamp" ) {
    if( argn < 2 ) Erreturn( get_syntax( "clamp" ) );
    IfErr( GetArg(0, find_variable_expression(net,args[0])))
      Erreturn2("%s: clamp %s ?", ERR_MSG, args[0] );
    /*IntArg( 1, n0 );*/
    IfErr( GetArg(1, find_optimize_expression(net,args[1])))
      Erreturn3("%s: clamp %s %s?", ERR_MSG, args[0], args[1] );
    /*IntArg( 3, n1 );*/
    GetFunc( clamp_vector, 2 );
  }
/*
.AC "if / endif" "conditional execution of actions"
.SY "if <expression> [end/stop/endwhile/endrepeat/endif/do/then/continue] [; ...;[else; ...;] endif]"
.BB
If all elements of evaluated <expression> are TRUE (1), one of the
following actions is taken depending on the last argument.
\fIif, repeat\fP, and \fIwhile\fP can be nested with each other.
.Bi
\fBif <expression> end\fP : terminate this procedure.
.Ni
\fBif <expression> stop\fP: terminate this and all, if any, parent procedures.
.Ni
\fBif <expression> endrepeat\fP: terminate a repeat loop.
.Ni
\fBif <expression> endwhile\fP: terminate a while loop.
.Ni
\fBif <expression> continue\fP: continue a repeat/while loop.
.Ni
\fBif <expression>\fP : execute the next action.  No \fBendif\fP in this case.
.Ni
\fBif <expression> then; .... ; endif\fP : execute any number of actions 
between \fBif\fP and \fBendif\fP.
.Ni
\fBif <expression> then; .... ; else; ... ; endif\fP : execute actions
between \fBif\fP and \fBendif\fP if <expression> is TRUE, otherwise 
execute actions between \fBelse\fP and \fBendif\fP.  Currently only one
\fBelse\fP is allowed. \fBelse if ..\fP does not work.  
Use \fBif ... then; ...; else; if ... then; ...; endif; endif\fP.
The syntax \fBif .. do\fP used in older versioin is equivalent to \fBif .. then\fP.
.EE
*/
  else IF( command, "if" ) {
    if( argn < 1 ) Erreturn( get_syntax("if") );
    GetFunc( if_, 2 );
    IF( args[argn-1], "end" )  { IntArg( 1, END ); }
    else IF( args[argn-1], "stop" ) { IntArg( 1, STOP ); }
    else IF( args[argn-1], "endwhile" ) { IntArg( 1, ENDWHILE ); }
    else IF( args[argn-1], "continue" ) { IntArg( 1, CONTINUE ); }
    else IF( args[argn-1], "endrepeat" ) { IntArg( 1, ENDREPEAT ); }
    else IF( args[argn-1], "endif" ) { IntArg( 1, ENDIF ); }
    else if( EQL( args[argn-1], "do" ) || EQL(args[argn-1], "then") ) {
      sprintf( buf, "%s.if%d", procP->name, procP->n_action );
      IfErr( status = define_procedure( command_stream, net, buf, lines, 0,
				      NULL, 0) ) 
	Erreturn2("%s: in 'if %s .. then'",ERR_MSG, args[0] );
      if( status == ELSE ) {
	GetArg( 1, which_procedure( net, buf ));
	sprintf( buf, "%s.else%d", procP->name, procP->n_action );
	IfErr( status = define_procedure( command_stream, net, buf,lines,
					  0, NULL, 0 ) ) 
	  Erreturn2("%s: in 'if %s .. then .. else'",ERR_MSG, args[0]);
	if( status!=ENDIF ) 
	  Erreturn1("no 'endif' for 'if %s then .. else'", args[0]);
	GetFunc( if_then_else, 3 ); GetArg( 2, which_procedure( net, buf ));
      }
      else if( status == ENDIF ) {
	GetFunc( if_then, 2 ); GetArg( 1, which_procedure( net, buf ));
      }
#if 0	/* not worked out yet */
      else if( status == ELSEIF ) {
	GetFunc( if_then_elseif, 1 );
	GetArg( 2, new( if_
	while( status == ELSEIF ) {
	  GetArg( 1, which_procedure( net, buf ));
	  sprintf( buf, "%s.elseif%d", procP->name, procP->n_action );
	  IfErr( status = define_procedure( command_stream, net, buf,lines,
					  0, NULL, 0 ) ) 
	    Erreturn2("%s: in 'if %s then .. elseif'",ERR_MSG, args[0]);
	  ifthen->ex = ex; ifthen->proc = which_procedure( net, buf ));
	    if( status==ELSE ) 
	}
	if( status==ENDIF ) 
	Erreturn1("no 'endif' for 'if %s then .. else'", args[0]);
      }
#endif 0
      else Erreturn1("no 'endif' for 'if %s then'", args[0]);
    }
    else { IntArg( 1, NOTSKIP ); argn++; /* pretend there was an argument*/ }
    if( argn < 2 ) Erreturn1("no expression for 'if %s'", args[0]);
    for(*buf=NULL, n=0; n<argn-1; n++) strcat(buf,args[n]);
    IfErr(GetArg(0, find_optimize_expression(net, buf)))
      Erreturn2("%s: in 'if %s'", ERR_MSG, buf);
      /* BUG: cannot free this expression */
  }
/*
.AC "here" "unconditional control statement"
.SY "here [end/stop/endwhile/endrepeat/continue]"
.BB
One of the following control actions indicated by the argument is taken.
.Bi
\fBhere end\fP : terminate this procedure.
.Ni
\fBhere stop\fP: terminate this and all, if any, parent procedures.
.Ni
\fBhere endrepeat\fP: terminate a repeat loop.
.Ni
\fBhere endwhile\fP: terminate a while loop.
.Ni
\fBhere continue\fP: continue a repeat/while loop.
.EE
*/
  else IF( command, "here" ) { 
    if( argn < 1 ) Erreturn( get_syntax("here") );
    GetFunc( here_, 1 ); 
    IF( args[0], "end" )  { IntArg( 0, END ); }
    else IF( args[0], "stop" ) { IntArg( 0, STOP ); }
    else IF( args[0], "endwhile" ) { IntArg( 0, ENDWHILE ); }
    else IF( args[0], "continue" ) { IntArg( 0, CONTINUE ); }
    else IF( args[0], "endrepeat" ) { IntArg( 0, ENDREPEAT ); }
    else IF( args[0], "endif" ) { IntArg( 0, ENDIF ); }
  }
/*
.AC "while / endwhile" "conditional looping"
.SY "while <expression>; .... ; endwhile"
.BB
Repeats actions between \fBwhile\fP and \fBendwhile\fP while 
all elements of evaluated <expression> are TRUE ($max).
\fIif, repeat\fP, and \fIwhile\fP can be nested with each other.
.EE
*/
  else IF( command, "while" ) {
    if( argn < 1 ) Erreturn(get_syntax("while"));
    for(*buf=NULL, n=0; n<argn; n++) strcat(buf,args[n]);
    IfErr( GetArg(0, find_optimize_expression(net, buf )))
      Erreturn2("%s: in 'while %s'", ERR_MSG, buf);
    GetFunc( while_do, 2 );
    					/* name of subprocedure */
    sprintf( buf, "%s.while%d", procP->name, procP->n_action );
    IfErr( status = define_procedure( command_stream, net, buf,lines,
				  0, NULL,0 ) ) 
      Erreturn3("%s: in 'while %s%s'", ERR_MSG, args[0], argn>1? " ..":"" );
    GetArg( 1, which_procedure( net, buf ) );
    if( status!=ENDWHILE )
      Erreturn2("no 'endwhile' for 'while %s%s'", args[0], argn>1? " ..":"" );
  }
/*
.AC "repeat / endrepeat" "repeat actions"
.SY "repeat N/<expression> ; ... ; endrepeat"
.BB
Repeat actions between \fBrepeat\fP and \fBendrepeat\fP N times, where N is
an integer constant or the first element of evaluated <expression>.
\fIif, repeat\fP, and \fIwhile\fP can be nested with each other.
.EE
*/ 
  else IF( command, "repeat" ) {
    if( argn < 1 ) Erreturn(get_syntax("repeat"));
    for(*buf=NULL, n=0; n<argn; n++) strcat(buf,args[n]);
    IfErr( GetArg(0, find_optimize_expression(net, buf) ))
      Erreturn2("%s: in 'repeat %s ..'", ERR_MSG, args[0]);
    GetFunc( repeat, 2 );
    					/* name of subprocedure */
    sprintf( buf, "%s.repeat%d", procP->name, procP->n_action );
    IfErr( status=define_procedure( command_stream, net, buf,lines,
				  0, NULL,0 ) ) 
      Erreturn2("%s: in repeat %s", ERR_MSG, args[0]);
    GetArg( 1, which_procedure( net, buf ) );	/* this gets the right one */
    if( status!=ENDREPEAT ) 
      Erreturn1("no 'endrepeat' for 'repeat %s'", args[0]);
  }

  else IF( command, "end" ) return( END );

  else IF( command, "endif" ) return( ENDIF );

  else IF( command, "else" ) return( ELSE );

  else IF( command, "endwhile" ) return( ENDWHILE );
  
  else IF( command, "endrepeat" ) return( ENDREPEAT );

  else if( GetArg( 0, make_citem( new( CLIST ), command, argn, args ))) {
    GetArg( 1, procScope );
    GetFunc( exec_citem, 2 );
  }

  else if( index( line, '=' ) ) {
    IfErr( GetArg( 0, find_optimize_expression( net, line ))) return(ERR);
    GetFunc( evalExpression, 1 ); 
  }

  else Erreturn1("%s: unknown action in procedure",command );

  procP->n_action++ ;
  
  return( OK );
}

make_define( str1, str2, online )
char *str1, *str2; BINARY online;
{
  register int i;
  if(Ndefine>=Mdefine) Erreturn1("no more than %d define statements", Mdefine);
  for(i=0; i<Ndefine; i++)
    IF( Define[i].str, str1 ) {
      if( online==OFF && Define[i].online ==ON ) return(OK); /*cannot override*/
      if( strcmp( Define[i].substitute, str2 ) )
	Define[i].substitute = new_string( str2, Define[i].substitute );
      Define[i].online = online;
      return( OK );
    }
  Define[Ndefine].str = new_string( str1, NULL );
  Define[Ndefine].substitute = new_string( str2, NULL );
  Define[Ndefine].online = online;
  Ndefine++;
  return( OK );
}

isDefined( str )
char *str;
{
  register int i;
  for(i=0; i<Ndefine; i++) { IF( Define[i].str, str ) return(OK); }
  return( ERR );
}

delete_define()
{
  register int i;
  for( i=0; i< Ndefine; i++ ) {
    free( Define[i].str ); free( Define[i].substitute );
  }
  Ndefine = 0;
}

void print_define( net )
NETWORK *net;
{
  register int i;
  for( i=0; i<Ndefine; i++ ) {
    sendMsg2("%s	%s\n",Define[i].str, Define[i].substitute);
  }
}

#define Nrepeat 1024	/* repeat substitution until nothing changes */
void substitute_defined_str( string, net )
char *string;
NETWORK *net;
{
  register int i,n,k;
  int oleng, dleng, size;
  char buf[BUFSIZE];
  char *dstr, *start, *end, *index();
  DEFINE *def;
  int changed;
			/* length of original string */
  if( 0==(oleng=strlen( string ))) return;

  for( k=0; k < Nrepeat; k++ ) {
		/* test each alpha-numeric substring */
    for( start=string, changed=0 ; strlen(start) ; start = end ) {
		/* first, find an alpha-numeric substring */
	        /* start = first alpha-numeric char */
      while( *start && !isalnum( *start ) && *start != '_' ) start++; 
      if( ! *start ) break;
		/* end = next non-alpha-numeric char */
      for( end = start+1; isalnum( *end ) || *end == '_' ; end++ ) ;
		/* from *start to *end is our alpha-numeric substring *
		 * compare it with each defined str */
      for( i=Ndefine, def=Define ; i; i--, def++ ) {
	dleng = strlen( dstr = def->str );	/* length of defined string */
		/* check if this matches */
	if(*start==*dstr && (end-start) == dleng &&
	   strncmp( start, dstr, dleng ) == 0 ) {
		/* it matches, so substitute the substring */
	  sprintf(buf, "%s%s", def->substitute, end );
	  strcpy( start, buf );
		/* need to find end again since start changed */
/*	  for( end = start+1; isalnum( *end ) || *end == '_' ; end++ ) ;*/
		/* no need to look at inside substitute yet, so */
	  end = start+strlen(def->substitute); 
	  changed = 1;
	}
      }
    }
    if( !changed ) break;	     /* no substitution took place */
  }
}

get_sizeof( net, str )
NETWORK *net;
char *str;
{
  char name[BUFSIZE], *end, *index();
  int size;
  if(end = index( strcpy( name, str ), ')') ) *end = NULL;
	/* if it's a procedure argument, can't get size */
	/* should take care of it in find_expression */
  if( find_expression_arg( net, name )) return( ERR );
  if( find_name_vector( net, name, &size ) ) return( size );
  return( ERR );
}

add_library( net, name )	/* add library file */
NETWORK *net; char *name;
{
  if( net->n_libfile >= MaxLibFile ) 
    Erreturn1("no more than %d library file", MaxLibFile);
  net->libfile[net->n_libfile] = new_string(name, net->libfile[net->n_libfile]);
  net->n_libfile ++;
  return(OK);
}
