/* $Header: /soma/users/miyata/planet/src/RCS/screen.c,v 5.6.0.4 91/02/13 15:42:25 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/screen.c,v 5.6.0.4 91/02/13 15:42:25 miyata Exp $";
/***** UPDATES **********************************************************
12/17/90 fixed 'arrow angle/head' command bug.
************************************************************************/
#if sunnet
#include <usercore.h>
#endif sunnet
#include <stdio.h>
#include <math.h>
#include "error.h"
#include "alloc.h"
#include "command.h"
#include "graph.h"

#define Lname 128
#define MaxItem 128
#define Srange 0.986
#define Smargin 0.007
#define Lbuf 160
#define Mwind 64
#define Mpoint 128

extern BINARY Erase;

struct Wind {
  int  number;
  float start_x, end_y;
} ;

struct Point {
  char  name;
  float x,y,radius;
  int   length;
} ;

struct SCREEN {
  WINDOW *window;     /* Window representing the whole screen */
  float    y_row;   /* amount of y per row */
  float    x_col;   /* amount of x per col */
  struct Point *point[Mpoint]; /* points on screen */
  int npoint;
} Screen;

erase_screen ( )
{
  if( Screen.window )  delete_window ( Screen.window );
  Screen.window = NULL ;
}

get_screen_size ( in_stream, nrow, ncol )
     FILE  *in_stream;
     int    *nrow, *ncol;
{
  char   buf[Lbuf];
  int    skip_row ;

  *nrow = 0; *ncol = 80;

  while( fgets( buf, Lbuf, in_stream )!=NULL && strncmp(buf,"end",3 )) {
     if ( sscanf ( buf, ".%d", &skip_row ) == 1 ) (*nrow) += skip_row ;
    else  (*nrow)++;
  }
}

static float Pi = 3.14159274101;
void init_arrow();

get_screen ( in_stream, window, nrow, ncol, erase, frame, color )
     FILE  *in_stream;
     WINDOW *window[];
     int    nrow, ncol;      /* total # of rows/cols used to describe screen */
     int    erase, frame;
     char   *color;
{
  char name[Lname];
  int  col=0, row=1;          /* current column and row on the screen */
  float    x, y ;
  int  skip_row;
  int      i,j,n;
  char     para_str[Lname];           /* parameter value in ascii */
  float range_x = (XMAX-XMIN)*Srange;
  float	range_y = (YMAX-YMIN)*Srange;
  float	min_x = XMIN + (XMAX-XMIN)*Smargin;
  float	min_y = YMIN + (YMAX-YMIN)*Smargin;
  float	max_y = YMIN + (YMAX-YMIN)*(Smargin+Srange);
   
  float    char_x, char_y;
  float    char_size;
  struct Point *point;
  struct Wind *w[Mwind]; int nwin = 0;     /* temporary window buffer */
  char	   fontname[Lname];
  char     c;
  int	   status;

  Screen.y_row = range_y / (nrow? nrow:1) ;   /* amount of y per row */
  Screen.x_col = range_x / (ncol? ncol:1) ;   /* amount of x per col */
  Screen.npoint = 0;
  char_x = Screen.x_col * 0.9;      /* size of character in text */
  char_y = Screen.y_row * 0.7;      /* printed on screen */

  adjust_set_charsize ( &char_x, &char_y, char_y * 0.6 , char_y );
  if ( Screen.window == NULL ) /*actually, size doesn't matter*/
    Screen.window = new_window( min_x, min_y, range_x, range_y );
  if( erase ) wipe_window ( Screen.window );

  while( (status=fget_str(in_stream, name, &row, &col)) !=EOF ) {

    IfErr( status ) return( ERR );
    if( col == 0 && EQL(name, "end")) break;

    if ( sscanf ( name, ".%d", &skip_row ) == 1 ) {
      row += skip_row ;
      col += strlen(name);
      continue;
    }
    if ( sscanf ( name, ".f%f", &char_size ) == 1 ) {
      char_x = Screen.x_col * char_size * 0.9;
      char_y = Screen.y_row * char_size * 0.7;
      adjust_set_charsize( &char_x, &char_y, char_y*0.6, char_y );
      col += strlen(name);
      continue;
    }
    if ( sscanf ( name, ".F.%s", fontname ) == 1 ) {
      IfErr( set_graphics_font( fontname ) ) return( ERR );
      col += strlen(name);
      continue;
    }

    y = max_y - Screen.y_row * row ;       /* compute x & y corresponding to */
    x = min_x + Screen.x_col * col ;       /* current row & col              */
    col += strlen ( name ) ;	    /* next position after the string */
    
    		/* upper-left corner of a window -> store the position */
    if ( sscanf ( name, "[%d", &n ) == 1 ) {
      if( !erase ) continue;
      if( n < 1 ) Erreturn1("%d: invalid window #", n );
      if( nwin >= Mwind ) Erreturn("sorry, too many windows on screen");
      w[nwin] = new( struct Wind );
      w[nwin]->number = n ;
      w[nwin]->start_x = x;
      w[nwin]->end_y = y + Screen.y_row*0.5;
      nwin++ ;
    }
		/* lower-right corner of a window -> make window */
    else if ( name[strlen(name)-1] == ']' && sscanf(name, "%d]", &n) == 1 ) {
      if( !erase ) continue;
      for ( i=0; i< nwin ; i++ ) 
	if( w[i]->number == n ) {
	  if( window[n] ) {
	    IfErr( set_window_size(window[n],w[i]->start_x, 
				   y - Screen.y_row*0.5,
				   x-w[i]->start_x+ Screen.x_col*strlen(name),
				   w[i]->end_y - (y-Screen.y_row*0.5)))
	      Erreturn1 ( "cannot open window %d", n );
	  }
	  else {
	    IfErr( window[n]
		   = new_window(w[i]->start_x,
				   y - Screen.y_row*0.5,
				   x-w[i]->start_x+Screen.x_col*strlen(name), 
				   w[i]->end_y - (y-Screen.y_row*0.5)))
	      Erreturn1( "cannot open window %d", n );
	  }
	  break;
	}
      if ( i == nwin ) Erreturn1("no matching [ for %d]", n );
    }

    else if ( name[0] == '$' ) {         /* it's a parameter   */
      IfErr ( get_parameter_string ( name+1, para_str ) )
	Erreturn1 ( "%s: cannot print parameter", ERR_MSG );
      text_location_in_window(Screen.window, x, y, char_x, char_y, para_str );
    }

    else if ( name[0] == '@' ) {
      if ( Screen.npoint >= Mpoint )
	Erreturn1("sorry, no more than %d points on screen", Mpoint );
      point = Screen.point[Screen.npoint] = new ( struct Point );
      point->name = name[1];
      point->x = x;
      point->y = y;
      point->length = strlen(name)-1 ;
      point->radius = 0.0;
      Screen.npoint++;
    }
      
    else  text_location_in_window(Screen.window, x, y, char_x, char_y, name);
  }

  (void) init_arrow( Screen.x_col, Screen.y_row );

  IfErr( read_eval_screen_command( in_stream, window ) ) return( ERR );
#ifndef xnet
  if( frame ) for ( n=0; n < nwin ; n++ ) 
    frame_window( window[w[n]->number], w[n]->number );
#endif
  return( OK );
}

read_eval_screen_command( in_stream, window )
FILE *in_stream;
WINDOW *window[];
{
  char     command[Lcomm], args[Nargs][Largs];
  char	   command_buf[BUFSIZE], *line, *next_line;
  int      argn, status;

  while( (status=read_line( command_buf, BUFSIZE, in_stream )) != EOF ) {
    IfErr( status ) return( ERR );

    for( line = command_buf; line ; line = next_line ) {
      handle_quote(line, &next_line);
      IF( line, "" ) continue;
      parse_command( line, command, &argn, args );
      IF( command, "" ) continue;
      IfErr( eval_screen_command( command, argn, args, window )) return( ERR );
    }
  }
  return( OK );
}

static float arrow_head, arrow_angle;
static float arrow_head_scale = 1.0;
void init_arrow(x_col,y_row)
float x_col,y_row;
{
  arrow_head = (x_col+y_row)*0.5;
  arrow_angle=Pi/6.0;   /* size and angle of arrow head */
  arrow_head_scale = 1.0;
}

eval_screen_command( command, argn, args, window )
char     command[Lcomm], args[Nargs][Largs];
int      argn;
WINDOW *window[];
{
  struct Point *point;
  float    x_col = Screen.x_col, y_row = Screen.y_row;
  float	   line_width;
  float	   circle_radius=(x_col+y_row)*0.5;
  int	   i,j,n,m,k, n1,n2;
  int	   nx, ny, w1,w2;
  float	   x_adjust=0.0,y_adjust=0.0;

  if ( Screen.window == NULL ) 
    Screen.window = new_window( 0.0, 0.0, 0.0, 0.0 );
						     /* prompt, alias */
  for( i=0; i< argn; i++ ) substitute_parameter_string( args[i] );

  IF( command, "linestyle" ) {
    if ( argn < 1 )
      Erreturn("syntax: linestyle solid/dotted/dashed/dotdashed" ) ;
    IfErr( set_line_style( args[0] ) ) return( ERR );
  }
  else IF( command, "linewidth" ) {
    if( argn < 1 ) Erreturn("syntax: linewidth w" );
    IfErr(AtoF(args[0],line_width)) Erreturn("syntax: linewidth w");
    set_line_width( line_width );
  }
  else IF( command, "font" ) {
    if( argn < 1 ) 
#ifdef xnet
      Erreturn("syntax: font <font-name>");
    set_graphics_font( args[0] );
#else
      Erreturn("syntax: font roman/greek/script/oldenglish/stick/symbols");
    IF( args[0], "roman" ) set_graphics_font( 0 );
    else IF( args[0], "greek" ) set_graphics_font( 1 );
    else IF( args[0], "script" ) set_graphics_font( 2 );
    else IF( args[0], "oldenglish" ) set_graphics_font( 3 );
    else IF( args[0], "stick" ) set_graphics_font( 4 );
    else IF( args[0], "symbols" ) set_graphics_font( 5 );
    else Erreturn("syntax: font roman/greek/script/oldenglish/stick/symbols");
#endif
  }
  else IF( command, "circle" ) {
    IF( args[0], "radius" ) {
      IfErr(AtoF(args[1],circle_radius)) Erreturn("syntax: circle radius r");
      circle_radius *= (x_col+y_row)*0.5;
    }
    else if( argn > 1 && get_flag_i( argn, args, "w%d", &w1 ) ) {
      if(w1<1 || Err(window[w1])) Erreturn1("window #%d not open", w1);
      if( !get_flag_ii( argn, args, "%dx%d", &ny, &nx )) { ny=nx=1; }
      IfErr(circle_in_window( window[w1], nx, ny )) return(ERR);
    }
    else {
      n = strlen(args[0]);
      for( i=0; i< n; i++ ) 
	IfErr(circle(args[0][i], circle_radius, x_col))
	  return(ERR);
    }
  }
  else IF( command, "line" ) {
    if ( argn < 2 ) Erreturn ("syntax: line point1 point2 ..." ) ;
    for( k = 1; k < argn; k++ ) {
      n = strlen(args[k-1]);
      m = strlen(args[k]);
      for ( i=0; i< n ; i++ )
	for ( j=0 ; j< m ; j++ )
	  IfErr(line_two_points(args[k-1][i],args[k][j], x_col))
	    return(ERR);
    }
  }
  else IF( command, "arrow" ) {
    if( argn < 2 ) 
      Erreturn("syntax: arrow {head/angle} X / arrow point1 point2");
    IF( args[0], "head" ) {
      IfErr( AtoF(args[1], arrow_head_scale)) Erreturn("syntax: arrow head X");
    }
    else IF( args[0], "angle" ) {
      IfErr( AtoF(args[1], arrow_angle)) 
	Erreturn("syntax: arrow angle X");
      arrow_angle *= Pi/180;	/* convert degree to radian */
    }
    else if( get_flag_ii(argn, args, "w%d-%d", &w1, &w2 )) {
      if(w1<1 || Err(window[w1])) Erreturn1("window #%d not open", w1);
      if(w2<1 || Err(window[w2])) Erreturn1("window #%d not open", w2);
      if( !get_flag_ii(argn, args, "%dx%d", &n1, &n2) ) { n1=n2=1; }
      if( get_flag_f(argn, args, "x%f", &x_adjust) ) x_adjust *= x_col;
      if( get_flag_f(argn, args, "y%f", &y_adjust) ) y_adjust *= y_row;
      IfErr(arrow_two_windows(window[w1],window[w2],n1,n2,
			      arrow_head*arrow_head_scale, arrow_angle,
			      x_adjust,y_adjust))
	return(ERR);
    }
    else {
      n = strlen(args[0]), m = strlen(args[1]);
      if( get_flag_f(argn, args, "x%f", &x_adjust) ) x_adjust *= x_col;
      if( get_flag_f(argn, args, "y%f", &y_adjust) ) y_adjust *= y_row;
      for ( i=0; i< n ; i++ )
	for ( j=0 ; j< m ; j++ )
	  IfErr(arrow_two_points(args[0][i], args[1][j], x_col,
				 arrow_head*arrow_head_scale, arrow_angle, 
				 x_adjust,y_adjust))
	    return(ERR);
    }
  }
  else IF( command, "box" ) {
    IfErr( get_flag_i(argn, args, "w%d", &w1 ) ) Erreturn("syntax: box wN");
    if(w1<1 || Err(window[w1])) Erreturn1("window #%d not open", w1);
    frame_window( window[w1], -1 );
  }
  else IF( command, "command" )
    return ( eval_command ( args[0], argn-1, args[1] ) ) ;
  else 
    return( eval_command ( command, argn, args ) );

  return ( OK );
}
 
line_two_points ( c1, c2, x_col )
     char  c1,c2;
     float x_col;
{
  struct Point **point = Screen.point;
  int npoint = Screen.npoint;
  struct Point *p1=NULL,*p2=NULL;
  register int   i,j;
  float x1,x2,y1,y2;
  float move1,move2;

  for ( i=0; i<npoint ; i++ ) {
    if ( point[i]->name == c1 ) p1 = point[i];
    if ( point[i]->name == c2 ) p2 = point[i];
  }
  if ( p1 == NULL ) { Erreturn1("# %c not defined on screen", c1 ); }
  if ( p2 == NULL ) { Erreturn1("# %c not defined on screen", c2 ); }

  move1 = (p1->radius>0)? p1->radius*2.4 : x_col ;
  move2 = (p2->radius>0)? p2->radius*2.4 : x_col ;
  y1 = p1->y, y2 = p2->y;

  if( p1->radius >0 )  y1 += y1>y2? -p1->radius : p1->radius ;
  if( p2->radius >0 )  y2 += y2>y1? -p2->radius : p2->radius ;

  for ( i=0,   x1 = p1->x ; i< p1->length ; i++, x1 += move1 )
    for ( j=0, x2 = p2->x ; j< p2->length ; j++, x2 += move2 ) 
      IfErr(line_in_window ( Screen.window, x1, y1, x2, y2 ))
	Erreturn( "cannot draw line on screen ");

  return ( OK );
}

arrow_two_windows(W1, W2, n1, n2, head, angle, x_adjust,y_adjust)
WINDOW *W1,*W2;
int n1, n2;
float head, angle;
float x_adjust,y_adjust;
{
  register int i,j;
  float x1,x2,y1,y2;
  float x2_init, y2_init;
  float x1_move, x2_move, y1_move, y2_move;
  
  if( n1<1 || n2<1 ) Erreturn2("invalid no. of arrows: %dx%d", n1, n2 );

  if( (y1=W1->frame.y) > (y2=W2->frame.y+W2->frame.height) ||
      (y1=W1->frame.y+W1->frame.height) < (y2=W2->frame.y) ) { 
    x1_move = W1->frame.width / n1 ; y1_move = y2_move = 0.0;
    x2_move = W2->frame.width / n2 ;
    x1 = W1->frame.x + x1_move*0.5 ; x2 = W2->frame.x + x2_move*0.5 ;
  }
  else if((x1=W1->frame.x) > (x2=W2->frame.x+W2->frame.width) ||
	  (x1=W1->frame.x+W1->frame.width) < (x2=W2->frame.x) ) { 
    y1_move = W1->frame.height / n1 ; x1_move = x2_move = 0.0;
    y2_move = W2->frame.height / n2 ;
    y1 = W1->frame.y + y1_move*0.5 ; y2 = W2->frame.y + y2_move*0.5 ;
  }
  else Erreturn("cannot draw arrows between these windows");

  x2_init = x2; y2_init = y2;
  for ( i=0 ; i< n1 ; i++, x1 += x1_move, y1 += y1_move )
    for(j=0, x2=x2_init,y2=y2_init ;j<n2 ; j++, x2 += x2_move, y2 += y2_move) 
      IfErr(draw_arrow ( x1+x_adjust, y1+y_adjust, x2+x_adjust, y2+y_adjust,
			head, angle )) 
	Erreturn( "cannot draw arrow on screen ");
  return( OK );
}  

arrow_two_points ( c1, c2, x_col, head, angle,x_adjust,y_adjust)
     char  c1,c2;
     float x_col;
     float head, angle;
     float x_adjust,y_adjust;
{
  struct Point **point = Screen.point;
  int npoint = Screen.npoint;
  struct Point *p1=NULL,*p2=NULL;
  register int   i,j;
  float x1,x2,y1,y2;
  float move1,move2;

  for ( i=0; i<npoint ; i++ ) {
    if ( point[i]->name == c1 ) p1 = point[i];
    if ( point[i]->name == c2 ) p2 = point[i];
  }
  if ( p1 == NULL ) { Erreturn1("# %c not defined on screen", c1 ); }
  if ( p2 == NULL ) { Erreturn1("# %c not defined on screen", c2 ); }

  move1 = (p1->radius>0)? p1->radius*2.4 : x_col ;
  move2 = (p2->radius>0)? p2->radius*2.4 : x_col ;
  y1 = p1->y, y2 = p2->y;

  if( p1->radius >0 )  y1 += y1>y2? -p1->radius : p1->radius ;
  if( p2->radius >0 )  y2 += y2>y1? -p2->radius : p2->radius ;

  for ( i=0,   x1 = p1->x ; i< p1->length ; i++, x1 += move1 )
    for ( j=0, x2 = p2->x ; j< p2->length ; j++, x2 += move2 ) 
      IfErr(draw_arrow ( x1+x_adjust, y1+y_adjust, x2+x_adjust, y2+y_adjust,
			head, angle ))
	Erreturn( "cannot draw arrow on screen ");

  return ( OK );
}

draw_arrow( x1, y1, x2, y2, head, angle )
float x1, y1, x2, y2, head, angle;
{
  return( draw_arrow_in_window( Screen.window,
			       x1, y1, x2, y2, head, angle ));
}

draw_arrow_in_window( win, x1, y1, x2, y2, head, angle )
WINDOW *win;
float x1, y1, x2, y2, head, angle;
{
  float a_angle;
  if( x1 == x2 && y1 == y2 ) return( OK );
  if( x1 == x2 ) a_angle = y2>y1? Pi*0.5 : -Pi*0.5;
  else a_angle = atan( (y2-y1)/(x2-x1) );
  if( x2 < x1 ) a_angle = a_angle + Pi;
  if(Err(line_in_window( win, x1, y1, x2, y2 )) ||
     Err(line_in_window( win, x2, y2, x2-head * cos(a_angle+angle),
		        		 y2-head * sin(a_angle+angle))) ||
     Err(line_in_window( win, x2, y2, x2-head * cos(a_angle-angle),
					 y2-head * sin(a_angle-angle))))
    Erreturn("error in drawing arrow");
  return( OK );
}

draw_arrow_in_graph( G, x1, y1, x2, y2 )
GRAPH *G;
float x1, y1, x2, y2;
{
  float a_angle;
  float head = 0.05, angle=Pi*0.1;
  if( x1 == x2 && y1 == y2 ) return( OK );
  if( x1 == x2 ) a_angle = y2>y1? Pi*0.5 : -Pi*0.5;
  else a_angle = atan( (y2-y1)/(x2-x1) );
  if( x2 < x1 ) a_angle = a_angle + Pi;
  if(Err(draw_line_in_graph( G, x1, y1, x2, y2 )) ||
     Err(draw_line_in_graph( G, x2, y2, x2-head * cos(a_angle+angle),
		        		 y2-head * sin(a_angle+angle))) ||
     Err(draw_line_in_graph( G, x2, y2, x2-head * cos(a_angle-angle),
					 y2-head * sin(a_angle-angle))))
    Erreturn("error in drawing arrow");
  return( OK );
}

circle_in_window( W, nx, ny )
WINDOW *W;
int	nx, ny;
{
  register int i,j;
  float x,y;
  float move_x = W->frame.width / nx;
  float move_y = W->frame.height / ny;
  float xinit = W->frame.x + move_x * 0.5;
  float yinit = W->frame.y + move_y * 0.5;
  float radius = (move_x>move_y)? move_y*0.4 : move_x*0.4 ;

  if( ny<1 || nx<1 ) Erreturn2("invalid no. of circles: %dx%d", ny, nx);
  for( j=0, y = yinit; j < ny; j++, y += move_y )
    for( i=0, x = xinit; i<nx; i++, x += move_x ) 
      draw_circle( Screen.window, x, y, radius );
	/* BUG: this erases the screen ! */
  return( OK );
}

circle( c, radius, x_col )
     char  c;
     float radius;
     float x_col;
{
  struct Point **point = Screen.point;
  int npoint = Screen.npoint;
  struct Point *center=NULL;
  register int   i,j;
  float x1,y1, move = radius * 2.4;

  for ( i=0; i<npoint ; i++ ) if ( point[i]->name == c ) center = point[i];

  if ( center == NULL ) { Erreturn1("# %c not defined on screen", c ); }

  for ( i=0, x1=center->x, y1=center->y ; i< center->length ; i++, x1+=move )
      IfErr(draw_circle ( Screen.window, x1, y1, radius ))
	Erreturn( "cannot draw circle on screen ");

  center->radius = radius;
  return ( OK );
}

#define Ntab 8

fget_str ( fp, str, row, col )
     FILE *fp;
     char *str;
     int  *row, *col;
{
  char c;

  while (( c = getc ( fp ))==' ' ) (*col)++ ;  /* skip white spaces */
  if ( c == '\t' ) {
    *col = ( *col/ Ntab + 1 ) * Ntab ;
    return ( fget_str ( fp, str, row, col ) );
  }
  if ( c == '\n' ) {
    *col = 0;
    (*row)++ ;
    return ( fget_str ( fp, str, row, col ) );
  }
  if ( c == '"' ) {
    *(str++) = ' ';
    while( ( c = getc( fp )) != '"' ) {
      IfErr( c ) { *str=NULL; Erreturn1( "unmatched \" in \"%s", str ); }
      *(str++) = c;
    }
    *(str++) = ' '; *str = NULL;
    return( OK );
  }
  ungetc ( c, fp );
  return ( fscanf ( fp, "%s", str ) );
}
