/* $Header: /soma/users/miyata/planet/src/RCS/print.c,v 5.6.0.5 91/02/13 15:41:35 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/print.c,v 5.6.0.5 91/02/13 15:41:35 miyata Exp $";
#include <stdio.h>
#include <sys/types.h>			/* sys/{type.h,stat.h} */
#include <sys/stat.h>			/* for stat() function */
#include "net.h"
#include "command.h"
#include "error.h"
#include "alloc.h"
#include "msg.h"

extern  int Pprecision;
	
FILE   *Pfile = NULL ;
char   PrintFname[ Lname ];

open_print_file ( fname )
char *fname;
{
  FILE *fp; struct stat fstat;
  if( !stat( fname, &fstat ) ) {	/* file exists */
    sendMsg("overwrite file ");
    IfErr(confirm( fname ) ) return(ERR);
  }
  if( Pfile ) fclose( Pfile );
  IfErr( fp = fopen ( fname, "w" ) ) Erreturn1("cannot open %s", fname );
  Pfile = fp;
  strcpy ( PrintFname, fname );
  return ( OK );
}

close_print_file ()
{
  if( Pfile==NULL ) Erreturn( "Print file not open. Do 'printfile <file>'" );
  fclose ( Pfile );
  Pfile = NULL ;
  PrintFname[0] = NULL ;
  return( OK );
}

char *
whatis_print_file() { return (PrintFname);}

void
flush_printfile ()
{
  if ( Pfile ) fflush ( Pfile );
}

print_it ( net, name, ncol, precision )
NETWORK *net;
char    *name;
int     ncol, precision;
{
  register int i,j;
  CONNECT *connect;
  REAL  *value;
  EXPRESS *expr;
  VECTOR *vector;
  WEIGHT  *weight;
  int     nvalue, nint;
  char	  fmt[ 8 ];

  if( precision == 0 ) precision = Pprecision;
  if( precision < 1 ) Erreturn("precision must be positive");
  sprintf ( fmt, "%%%d.%df ", precision, precision-1 );
     	/* print an entire weight matrix - this should be before looking *
	 * for a vector since a weight matrix is a vector */
  if( connect = which_connection ( net, name ) ) 
    fprint_weight(stdout,NULL,connect,fmt);

  	/* evaluate and print an expression */
  else if ( expr = find_expression( net, name )) {
    IfErr( vector = eval_expression( expr ) ) {
      delete_expression( expr );
      Erreturn2("%s: in %s", ERR_MSG, name );
    }
    if(!ncol && vector->nvalue1) ncol = vector->nvalue2; /* its a matrix */
    fprint_vector( stdout,NULL,vector->value,vector->nvalue,ncol,fmt );
    delete_expression( expr );
  }
  else return(ERR);
  return ( OK );
}

printf_it ( net, name, fmt, ncol )
NETWORK *net;
char    *name,*fmt;
int     ncol;
{
  register int i,j;
  CONNECT *connect;
  REAL  *value;
  EXPRESS *expr;
  VECTOR *vector;
  WEIGHT  *weight;
  char	*string, *find_string();
  int     nvalue, nint;

     	/* print an entire weight matrix - this should be before looking *
	 * for a vector since a weight matrix is a vector */
  if( connect = which_connection ( net, name ) ) 
    fprint_weight(stdout,NULL,connect,fmt);

  	/* evaluate and print an expression */
  else if ( expr = find_expression( net, name )) {
    IfErr( vector = eval_expression( expr ) ) {
      delete_expression( expr );
      Erreturn2("%s: in expression %s", ERR_MSG, name );
    }
    if(!ncol && vector->nvalue1) ncol = vector->nvalue2; /* its a matrix */
    fprint_vector( stdout,NULL,vector->value,vector->nvalue,ncol,fmt );
    delete_expression( expr );
  }
#if 0  	/* print a vector */
  else if ( value = find_vector ( net, name, &nvalue))
    fprint_vector( stdout,NULL, value, nvalue,ncol,fmt );
#endif 0
  else if( string = find_string ( net, name ) )
    fprint_string( stdout,NULL, string, fmt );
  else
    Erreturn1 ("%s not found in network", name );  
  return ( OK );
}

sprintf_it ( str, net, name, fmt, ncol )
char    *str;
NETWORK *net;
char    *name,*fmt;
int     ncol;
{
  register int i,j;
  CONNECT *connect;
  REAL  *value;
  EXPRESS *expr;
  VECTOR *vector;
  WEIGHT  *weight;
  char	*string, *find_string();
  int     nvalue, nint;

     	/* print an entire weight matrix - this should be before looking *
	 * for a vector since a weight matrix is a vector */
  if( connect = which_connection ( net, name ) ) 
    sprint_weight(str,NULL,connect,fmt);

  	/* evaluate and print an expression */
  else if ( expr = find_expression( net, name )) {
    IfErr( vector = eval_expression( expr ) ) {
      delete_expression( expr );
      Erreturn2("%s: in expression %s", ERR_MSG, name );
    }
    if(!ncol && vector->nvalue1) ncol = vector->nvalue2; /* its a matrix */
    sprint_vector( str, NULL,vector->value,vector->nvalue,ncol,fmt );
    delete_expression( expr );
  }
#if 0  	/* print a vector */
  else if ( value = find_vector ( net, name, &nvalue))
    sprint_vector( str, NULL, value, nvalue,ncol,fmt );
#endif 0
  else if( string = find_string ( net, name ) )
    strcpy( str, string );
  else
    strcpy( str, fmt );
/*    Erreturn1 ("%s not found in network", name );  */
  return ( OK );
}

