/* $Header: /soma/users/miyata/planet/src/RCS/parameter.c,v 5.6.0.4 91/02/13 15:41:33 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/parameter.c,v 5.6.0.4 91/02/13 15:41:33 miyata Exp $";
#include <stdio.h>
#include <signal.h>
#include <strings.h>
#include "net.h"
#include "error.h"
#include "parameter.h"
#include "msg.h"

#ifndef EQL
#define EQL( x, y ) (!strcmp( x, y ))
#endif
#define Nfmt 6
#ifndef BUFSIZE
#define BUFSIZE 256
#endif

extern NETWORK *Net;

set_parameter( name, value )
char	*name,*value;
{
  PARA 	*paraP ;
  char	fmt[ Nfmt ];

  IfErr( paraP = which_parameter( name ) )
    Erreturn1( "%s: unknown parameter.", name );
  IF( fmt_of( paraP->type, fmt ), "%b" ) {
    IF( value, "on" ) *((BINARY*) paraP->ptr) = ON ;
    else IF( value, "off" ) *((BINARY*) paraP->ptr) = OFF ;
    else Erreturn2( "%s: value for %s must be on/off.", value, paraP->name ) ;
  }
  else IfErr( fmt )
    { Erreturn2("unknown type %s of parameter %s",paraP->name,paraP->type); }
	
  else if( 1 != sscanf( value, fmt, paraP->ptr ) ) 
    Erreturn3("%s: value for %s must be %s", value, paraP->name, paraP->type);

  return( OK );
}

char * strpad();

whatis_parameter( name )
char	*name;
{
  PARA 	*paraP ;

  IfErr( paraP = which_parameter( name ) )
    Erreturn1( "%s: unknown parameter.", name );
  print_parameter( paraP, stdout );
  return( OK );
}

#ifdef shellinput
print_parameter( paraP )
PARA *paraP;
{
  char	msg[ Nmsg ];
  IfErr( paraP ) return( ERR );
  sprintf(msg, "\t%s (%s) = ", paraP->name, paraP->longname );
  sendMsg( strpad( msg, 50 ) );

  IF( paraP->type, "BINARY" ) {
    sendMsg1("%s\n", (*((BINARY*) paraP->ptr)==ON) ? "on" : "off" );
    return( OK );
  }
  else IF( paraP->type, "int" ) sendMsg1( "%d", *((int*) paraP->ptr) );
  else IF( paraP->type, "float" ) sendMsg1( "%g", *paraP->ptr );
  else IF( paraP->type, "REAL" ) sendMsg1( "%g", *paraP->ptr );
  else 
    Erreturn2("unknown type %s of parameter %s",paraP->name,paraP->type);
  sendMsg( "\n" );

  return( OK );
}

#else

print_parameter( paraP, fp )
PARA *paraP;
FILE *fp;
{
  char	msg[ Nmsg ];
  IfErr( paraP ) return( ERR );
  sprintf(msg, "\t%s (%s) = ", paraP->name, paraP->longname );
  fprintf(fp, strpad( msg, 50 ) );

  IF( paraP->type, "BINARY" ) {
    fprintf(fp,"%s\n", (*((BINARY*) paraP->ptr)==ON) ? "on" : "off" );
    return( OK );
  }
  else IF( paraP->type, "int" ) fprintf(fp, "%d", *((int*) paraP->ptr) );
  else IF( paraP->type, "float" ) fprintf(fp, "%g", *paraP->ptr );
  else IF( paraP->type, "REAL" ) fprintf(fp, "%g", *paraP->ptr );
  else 
    Erreturn2("unknown type %s of parameter %s",paraP->name,paraP->type);
  fprintf(fp, "\n" );

  return( OK );
}
#endif

get_parameter_string( name, str )
char	*name;
char    *str;
{
  PARA 	*paraP ;

  IfErr( paraP = which_parameter( name ) )
    Erreturn1( "%s: unknown parameter.", name );

  IF( paraP->type, "BINARY" ) {
    strcpy(str, (*((BINARY*) paraP->ptr)==ON) ? "on" : "off" );
    return( OK );
  }
  else IF( paraP->type, "int" ) sprintf(str, "%d", *((int*) paraP->ptr) );
  else IF( paraP->type, "float" ) sprintf(str, "%g", *paraP->ptr );
  else IF( paraP->type, "REAL" ) sprintf(str, "%g", *paraP->ptr );
  else 
    Erreturn2("unknown type %s of parameter %s",paraP->name,paraP->type);

  return( OK );
}

save_parameter( file, name )
FILE	*file;
char	*name;
{
  PARA 	*paraP ;
  
  IfErr( paraP = which_parameter( name ) )
    Erreturn1( "%s: unknown parameter", name );

  fprintf(file, "set %s ", paraP->name );

  IF( paraP->type, "BINARY" ) {
    fprintf(file, "%s\n", (*((BINARY*) paraP->ptr)==ON) ? "on" : "off" );
    return( OK );
  }
  else IF( paraP->type, "int" ) fprintf(file, "%d\n", *((int*) paraP->ptr) );
  else IF( paraP->type, "float" ) fprintf(file, "%f\n", *paraP->ptr );
  else IF( paraP->type, "REAL" ) fprintf(file, "%f\n", *paraP->ptr );
  else 
    Erreturn2("unknown type %s of parameter %s",paraP->name,paraP->type);

  return( OK );
}

PARA *
which_parameter( name )
char	*name;
{
  register int i;
  for(i=0; i< Npara ; i++ ) 
    IF( name, Para[i].name ) return( &Para[i] );
  return( NULL );
}

is_float_parameter( name )
char *name;
{
  PARA * paraP = which_parameter(name);
  return( (paraP && EQL(paraP->type, "float"))? OK : ERR );
}

void
substitute_parameter_string( str )
char *str;
{
  char *param, *end, *rest, *index();
  void replace_string(); char *find_string();
  char buf[20];
  rest = str;
  while( (param=index(rest,'$')) || (param=index(rest,'@')) ) {
    if( param>str && *(param-1) == '\\' ) { /* quoted->don't touch. remove '\'*/
      strcpy( buf, param ); strcpy( param-1, buf ); 
      rest = param+1 ; 
      continue;
    }
    if( *(param+1) == '(' && (end = index( param, ')' )) ) {
      *end = NULL;	/* pretend the string ends before ')' */
      if( get_parameter_string(param+2, buf) ||
	 ( Net && get_variable_string(Net, param+2, buf))) {
	*end = ')';
	replace_string( param, buf, end-param+1 );
	rest = param+strlen(buf);
      }
      else {
	*end = ')';
	rest = param+1;
      }
      continue;
    }
    if( get_parameter_string(param+1, buf) ||
       ( Net && get_variable_string(Net, param+1, buf))) {
      strcpy( param, buf );
      break;
    }
    if( Net && find_string(Net, param)) {
      strcpy(buf, find_string(Net, param));
      strcpy( param, buf);
      break;
    }
    else rest ++;
  }
}
	/* replace the substring of s1 of length n with s2 */
void replace_string( s1, s2, n )
char *s1, *s2; int n;
{
  char buf[BUFSIZE];
  strcpy( buf, s1+n );	/* save the tail of string */
  strcpy( s1, s2 );	/* put s2 onto s1 */
  strcat( s1, buf );	/* put the tail back */
}

char *
fmt_of( type , fmt )
char	*type, *fmt;
{
  IF( type, "float" ) return( strcpy( fmt, "%f") );
  IF( type, "REAL" ) return( strcpy( fmt, "%f" ) );
  IF( type, "int" ) return( strcpy( fmt, "%d" ) );
  IF( type, "BINARY" ) return( strcpy( fmt, "%b" ) );
  return( NULL );
}

void
print_all_parameters()
{
  register int i;
  FILE *outf, *open_pager();
  void close_pager();

#ifdef shellinput
  for( i=0 ; i< Npara; i++ ) print_parameter( &Para[i] );
#else
  IfErr( outf = open_pager() ) outf = stdout;

  for( i=0 ; i< Npara; i++ ) print_parameter( &Para[i], outf );
  close_pager( outf );
#endif
}

FILE *OutPipe;
void pipe_err()
{
  close_pager( OutPipe );
}

FILE *
open_pager()
{
  char pagername[BUFSIZE];
/*int max_lines = get_lines_in_window();*/
  FILE *popen();
  
/* sprintf(pagername, "/usr/ucb/more -%d", max_lines ); */
  sprintf(pagername, "/usr/ucb/more -c" );
  if( OutPipe = popen(pagername, "w") ) {
    signal(SIGPIPE, pipe_err);
    signal(SIGQUIT, SIG_IGN);
    setbuf(OutPipe, NULL);
  }
  return( OutPipe );
}

void
close_pager( outf )
FILE *outf;
{
  if (outf == stdout) fflush(outf);

  else {
    pclose(outf);
    signal(SIGPIPE, SIG_DFL);
    signal(SIGQUIT, SIG_DFL);
  }
}

char	*
strpad( str, n )
char	*str;
int	n;
{
  register int i, m ;
  if((m = strlen( str ) - n) <= 0 ) return( str );
  for( i=0; i < m; i++ ) strcat( str, " " );
  return( str );
}
