/* $Header: /soma/users/miyata/planet/src/RCS/netfind.c,v 5.6.0.5 91/02/13 15:41:30 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/netfind.c,v 5.6.0.5 91/02/13 15:41:30 miyata Exp $";
/**** UPDATES ***********************************************************
netfind.c:
10/4/90: mouseButton accesses mouse button clicked.
9/27/90: find_object() and access_xx functions to allow objects to change ptrs.
3/2/90: modified find_string() to access net file, pat file, input/output file.
***********************************************************************/
#include <stdio.h>
#include "net.h"
#include "parameter.h"
#include "error.h"
#include "alloc.h"
#include "setup.h"
#include "command.h"
#include "stack.h"
#include "arith.h"
 
/* which_unit() looks for "layer" or "layer[n1-n2]" given by "arg" *
 * and assign layer pointer, where to start, and how many units.   **/

which_unit( net, layerP, start, nunit, arg )
NETWORK	*net;
LAYER	**layerP;
int     *start, *nunit;
char	*arg;
{
  int	n1, n2;
  char  *range, *index();
  char  name[ Lname ];

  strcpy( name, arg );
  if( range = index( name, '[' ) ) {   /*  layer[n1-n2]  */
    if(Err( find_range( range+1, &n1, &n2 )) || n1<0 || n2<n1 ) return( ERR );
    *range = NULL ;       /* end of name */
    IfErr( *layerP = which_layer( net, name ) ) return( ERR ) ;
    if((*start = n1) >=(*layerP)->n_unit || n2 >=(*layerP)->n_unit ) 
      Erreturn2("layer %s has only %d units", name,(*layerP)->n_unit );
    *nunit = n2 - n1 + 1;
    return( OK );
  }

  IfErr( *layerP = which_layer( net, name ) ) return( ERR ) ;
  *start = 0;
  *nunit =(*layerP)->n_unit;
  return( OK );
}

extern NETWORK *Net;

find_range( str, startP, endP )
char	*str;
int	*startP, *endP ;
{
  char str1[Largs], str2[Largs], *hook, *index(), *end;
  void substitute_defined_str(); int n;
  EXPRESS *expr1,*expr2;

  if( Err(startP)||Err(endP) ) return( ERR );	/* null pointer */
  end = index( str, ']' );			/* end of string */
	/* N-M -> from N through M; N,M -> M values starting from N */
		/* BUG: expression may contain a '-' */
  if( (hook = index( str, '-' )) || (hook = index( str, ',')) ) {
    strncpy( str1, str, n = hook-str ); str1[n] = NULL;
    if(end) { strncpy( str2, hook+1, n = end-hook-1 ); str2[n] = NULL; }
		/* BUG: expression may contain a ']' */
    else strcpy( str2, hook+1 );
    if( Err(eval_expression_value( Net, str1, startP )) ||
       Err(eval_expression_value( Net, str2, endP ))) return( ERR );
    if( *hook == '-' ) return( OK );
    *endP = *startP + *endP - 1; 	/* else hook == ',' */
    return( OK );
  }
  else {	/* [N] -> single value */
    if(end) { strncpy( str1, str, n = end-str ); str1[n] = NULL; }
		/* BUG: expression may contain a ']' */
    else strcpy( str1, str );
    IfErr(eval_expression_value( Net, str1, startP )) return( ERR );
    *endP = *startP ;
    return( OK );
  }
}

find_range_int( str, startP, endP, intP )
char	*str;
int	*startP, *endP, *intP ;
{
  if( Err(startP)||Err(endP)||Err(intP) ) return( ERR ); /* null pointer */
  *intP = 0;					/* default interval */
  if( sscanf( str, "%d-%d@%d", startP, endP, intP ) >= 2 );
  else if( sscanf( str, "%d,%d@%d", startP, endP, intP ) >= 2 )
    *endP = *startP + *endP - 1 ;
  else if( sscanf( str, "%d@%d", startP, intP ) >= 1 ) 
    *endP = *startP ;
  else return( ERR );
  if( *intP==0 ) *intP = ( *startP <= *endP )? 1 : -1 ;
  return( OK );
}
/* this is no longer needed. expression connect[][n] will get the nth column. */
REAL *
find_matrix_column( net, arg, nvalueP, intervalP )
NETWORK	*net;
char	*arg;
int	*nvalueP, *intervalP;
{
  int	n1,n2;
  char	*index(), *range, *kind ;
  char  name[ Lname ];
  CONNECT *connectP;
  MATRIX *matrixP;
  if( Err(range = index(arg, '[')) || strncmp( range, "[]", 2 ) ||
      Err(range = index(range+1, '[') ) )
    Erreturn1("%s: invalid index for matrix", arg );
  if( Err( find_range( range+1, &n1, &n2 ) ) || n1 < 0 || n2 < n1 )
    Erreturn1( "invalid range %s", arg );
  strcpy( name, arg );
  *index(name, '[') = NULL; 	/* end of name */
  if( connectP = which_connection( net, name ) ) {
    if( n1 >= connectP->to_nunit )
      Erreturn3("%s has %d x %d weights", name, 
		connectP->from_nunit, connectP->to_nunit );
    *nvalueP = connectP->from_nunit ;
    *intervalP = connectP->to_nunit;
    return( &connectP->weight[ n1 ] );
  }
  else Erreturn1("matrix %s not found", name );
}

extern REAL *ErrPattern;
extern int    Npattern;
extern REAL Error, cumError;
#if xnet|sunnet|planet
REAL hasGraphics = 1.0;
#else
REAL hasGraphics = 0.0;
#endif

typedef union {
  LAYER *layer;
  ARRAY *array;
  IVECTOR *ivec;
  MATRIX *matrix;
  CONNECT *connect;
  FLOATVAR *floatvar;
  LAYER **layerP;
  CONNECT **connectP;
  VECTOR **vectorP;
} OBJECT;

/* find_name_vector() finds a single valued variable, eg.
 * float parameter, or $xx variable by its name. */

REAL *
find_name_vector( net, arg, nvalueP )
NETWORK	*net;
char	*arg;
int	*nvalueP;
{
  char	name[ Lname ];
  OBJECT obj;
  PARA  *paraP;

  strcpy( name, arg );

  if( obj.floatvar = which_floatvar( net, name ) ) {
    *nvalueP = 1;
    return( &obj.floatvar->value );
  }
  *ERR_MSG = NULL;
        
  if( EQL(name, "$err") || EQL( name, "$errorPattern" ) ) {
    if( ErrPattern == NULL ) 
      Erreturn("err not initialized. pattern not defined?");
    *nvalueP = Npattern ;           /* err */
    return( ErrPattern );
  }
	/* error computed by 'target' action */
  IF( name, "$Error" ) { *nvalueP = 1; return( &net->target.error_sum );  }

	/* average error computed by 'cycle' or 'response' */
  IF( name, "$globalError" ) { *nvalueP = 1; return( &Error );  }

	/* cumulative error computed during 'cycle' */
  IF( name, "$cumError" ) { *nvalueP = 1; return( &cumError );  }

	/* indicates whether we have graphics */
  IF( name, "$hasGraphics" ) { *nvalueP = 1; return( &hasGraphics ); }

  if( name[0]=='$' ) {
    IfErr(paraP = which_parameter( name+1 )) 
      Erreturn1("parameter %s not found", name+1);
    *nvalueP = 1;
    IF( paraP->type, "float" ) return( paraP->ptr );
    IF( paraP->type, "REAL" ) return( paraP->ptr );
    else Erreturn1("%s not float parameter", name+1);
  }
  *ERR_MSG = NULL;

  Erreturn1("%s not found", name );
}

/* NOTE: the access_xx_yy() functions are used to access an object of the type
 * yy in a structure xx (eg. 'actv' or 'net' in a layer) in an expression.
 * This is implemented in order to handle objects that may change their
 * pointers (eg. when a layer is resized the pointers for actv, net, etc. may
 * change.)  To access such an object, we use the pointer to a higher level
 * object (eg. a layer does not change its pointer when it is resized), plus a 
 * function to access the lower objects given the higher object pointer
 * (eg. access the pointer for 'actv' from the layer pointer.)
 * When an object of type 'xx in yy' is found in an expression, a terminal
 * expression is constructed, and the higher level 'yy' pointer and the
 * pointer to an appropriate access function to access 'xx' are stored in it.
 *  When the function 
 * eval_terminal_expression() evaluates a terminal expression, it checks
 * if it has an access function pointer and uses it to access the object. 
 * This method avoids run-time search.  Only pointer-following.  */

REAL *
access_layer_actv( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->actv );
}

REAL *
access_layer_net( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->net );
}

REAL *
access_layer_bias( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->bias );
}

REAL *
access_layer_delta( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->delta );
}

REAL *
access_layer_user1( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->user1 );
}

REAL *
access_layer_user2( layer, nvalue, row, col )
LAYER *layer;
int *nvalue,*row,*col;
{
  *nvalue = layer->n_unit; *row = 0; *col = 0;
  return( layer->user2 );
}

REAL *
access_layerP_actv( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  return( (*layer)->actv );
}

REAL *
access_layerP_net( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  return( (*layer)->net );
}

REAL *
access_layerP_bias( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  return( (*layer)->bias );
}

REAL *
access_layerP_delta( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  return( (*layer)->delta );
}

REAL *
access_layerP_user1( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  IfErr( (*layer)->user1 ) (*layer)->user1 = new_array_of( *nvalue, REAL );
  return( (*layer)->user1 );
}

REAL *
access_layerP_user2( layer, nvalue, row, col )
LAYER **layer;
int *nvalue,*row,*col;
{
  *nvalue = (*layer)->n_unit; *row = 0; *col = 0;
  IfErr( (*layer)->user2 ) (*layer)->user2 = new_array_of( *nvalue, REAL );
  return( (*layer)->user2 );
}

REAL *
access_array_value( array, nvalue, row, col )
ARRAY *array;
int *nvalue,*row,*col;
{
  *nvalue = array->n_value; *row = 0; *col = 0;
  return( array->value );
}

REAL *
access_ivector_value( ivector, nvalue, row, col )
IVECTOR *ivector;
int *nvalue,*row,*col;
{
  *nvalue = ivector->nindex; *row = 0; *col = 0;
  return( ivector->value );
}

REAL *
access_ivector_index( ivector, nvalue, row, col )
IVECTOR *ivector;
int *nvalue,*row,*col;
{
  *nvalue = ivector->nindex; *row = 0; *col = 0;
  return( ivector->index );
}

REAL *
access_ivector_nvalue( ivector, nvalue, row, col )
IVECTOR *ivector;
int *nvalue,*row,*col;
{
  *nvalue = 1; *row = 0; *col = 0;
  return( &ivector->nvalue );
}

REAL *
access_connect_weight( connect, nvalue, row, col )
CONNECT *connect;
int *nvalue,*row,*col;
{
  *row = connect->to_nunit; *col = connect->from_nunit; *nvalue = *row * *col; 
  return( connect->weight );
}

REAL *
access_connect_delta( connect, nvalue, row, col )
CONNECT *connect;
int *nvalue,*row,*col;
{
  *row = connect->to_nunit; *col = connect->from_nunit; *nvalue = *row * *col; 
  return( connect->d_weight );
}

REAL *
access_connect_user1( connect, nvalue, row, col )
CONNECT *connect;
int *nvalue,*row,*col;
{
  *row = connect->to_nunit; *col = connect->from_nunit; *nvalue = *row * *col; 
  return( connect->user1 );
}

REAL *
access_connect_user2( connect, nvalue, row, col )
CONNECT *connect;
int *nvalue,*row,*col;
{
  *row = connect->to_nunit; *col = connect->from_nunit; *nvalue = *row * *col; 
  return( connect->user2 );
}

REAL *
access_connectP_weight( connect, nvalue, row, col )
CONNECT **connect;
int *nvalue,*row,*col;
{
  *row = (*connect)->to_nunit; *col = (*connect)->from_nunit; *nvalue = *row * *col; 
  return( (*connect)->weight );
}

REAL *
access_connectP_delta( connect, nvalue, row, col )
CONNECT **connect;
int *nvalue,*row,*col;
{
  *row = (*connect)->to_nunit; *col = (*connect)->from_nunit; *nvalue = *row * *col; 
  return( (*connect)->d_weight );
}

REAL *
access_connectP_user1( connect, nvalue, row, col )
CONNECT **connect;
int *nvalue,*row,*col;
{
  *row = (*connect)->to_nunit; *col = (*connect)->from_nunit; *nvalue = *row * *col; 
  IfErr( (*connect)->user1 ) (*connect)->user1=new_array_of( *row * *col, REAL);
  return( (*connect)->user1 );
}

REAL *
access_connectP_user2( connect, nvalue, row, col )
CONNECT **connect;
int *nvalue,*row,*col;
{
  *row = (*connect)->to_nunit; *col = (*connect)->from_nunit; *nvalue = *row * *col; 
  IfErr( (*connect)->user2 ) (*connect)->user2=new_array_of( *row * *col, REAL);
  return( (*connect)->user2 );
}

REAL *
access_matrix_value( matrix, nvalue, row, col )
MATRIX *matrix;
int *nvalue,*row,*col;
{
  *row = matrix->n_row; *col = matrix->n_col; *nvalue = *row * *col; 
  return( matrix->value );
}

REAL *
access_target_value( target, nvalue, row, col )
TARGET *target;
int *nvalue,*row,*col;
{
  *nvalue = target->n_value; *row = 0; *col = 0;
  IfErr( target->value ) Erreturn("target buffer not initialized")
  return( target->value );
}

REAL *
access_input_value( input, nvalue, row, col )
INPUT *input;
int *nvalue,*row,*col;
{
  *nvalue = input->n_value; *row = 0; *col = 0;
  IfErr( input->value ) Erreturn("input buffer not initialized")
  return( input->value );
}

REAL *
access_vectorP_value( vector, nvalue, row, col )
VECTOR **vector;
int *nvalue,*row,*col;
{
  IfErr( *vector ) return( ERR );  /* argument ptr not given yet */
  *nvalue = (*vector)->nvalue, *row = (*vector)->nvalue1, *col = (*vector)->nvalue2;
  return( (*vector)->value );
}

#if xnet
static REAL mouseInfo[3];

REAL *
access_mouse_info(dummy,nvalue,row,col)
char *dummy; int *nvalue,*row,*col;
{
  getMouseClick( mouseInfo );
  *nvalue=3, *row=0, *col=0;
  return( mouseInfo );
}

#endif xnet
#if xnet|sunnet
static REAL windowClick;

REAL *
access_window_click(dummy,nvalue,row,col)
char *dummy; int *nvalue,*row,*col;
{
  IfErr( windows_opened() ) Erreturn("windowClick: no open window");
  windowClick = (REAL) which_window();
  *nvalue=1, *row=0, *col=0;
  return( &windowClick );
}
#endif

REAL nPatternVal;

REAL *	 /* convert int variable nPattern to real nPatternVal. */
access_npattern(dummy,nvalue,row,col)
char *dummy; int *nvalue,*row,*col;
{
  nPatternVal = (REAL) Npattern;
  *nvalue = 1, *row=0, *col=0;
  return( &nPatternVal );
}

VECTOR ** find_expression_arg();

find_object( net, arg, vector )
NETWORK	*net;
char	*arg;
VECTOR  *vector;
{
  char	name[ Lname ];
  char	*component ;
  OBJECT obj;
  PARA  *paraP;

  if( Err(arg) || Err( vector ) ) return(ERR);
  vector->name = new_string(arg, vector->name);
  strcpy( name, arg );
	/* we first look at objects that don't belong to net structure */
  IF( name, "$mouseClick" ) {
#if xnet  
    vector->accessfunc = access_mouse_info;
    vector->object = NULL;
    return( OK );
#else
    Erreturn("'$mouseClick' available only in XNet");
#endif xnet
  }

  IF( name, "$windowClick" ) {
#if xnet|sunnet
    vector->accessfunc = access_window_click;
    vector->object = NULL;
    return( OK );
#else
    Erreturn("'$windowClick' available only in XNet/SunNet");
#endif xnet
  }

  IF( name, "$nPattern" ) {	/* number of patterns */
    vector->accessfunc = access_npattern;	/* implemented as accessfunc */
    vector->object = NULL;			/* to convert int to real  */
    return(OK);
  }

  IfErr( net ) return(ERR);

  if((component = index(name, ':')) ) {      /*  name:delta name:net etc */
    *component = NULL ;     /* end of name string */
    component++ ;           /* start of 'delta/net/actv/bias' */
  }
	/* we should look for procedure argument first */
  *ERR_MSG = NULL;
  if( obj.layerP = which_layer_arg( net, name ) ) {
    if( component ) {
      IF( component, "actv" ) vector->accessfunc = access_layerP_actv  ;
      else IF( component, "delta" ) vector->accessfunc = access_layerP_delta ;
      else IF( component, "net" ) vector->accessfunc = access_layerP_net ;
      else IF( component, "bias" ) vector->accessfunc = access_layerP_bias ;
      else IF( component, "user1" ) vector->accessfunc = access_layerP_user1 ;
      else IF( component, "user2" ) vector->accessfunc = access_layerP_user2 ;
      else Erreturn2("cannot find %s in layer %s", component, name );
    }
    else vector->accessfunc = access_layerP_actv ;
    vector->object = (char*) obj.layerP ;
    return( OK );
  }

  *ERR_MSG = NULL;
  if( obj.connectP = which_connection_arg( net, name ) ) {
    if( component ) {
      IF( component, "weight" ) vector->accessfunc = access_connectP_weight;
      else IF( component, "delta" ) vector->accessfunc = access_connectP_delta;
      else IF( component, "user1" ) vector->accessfunc = access_connectP_user1;
      else IF( component, "user2" ) vector->accessfunc = access_connectP_user2;
      else Erreturn2("cannot find %s in connection %s", component, name );
    }
    else vector->accessfunc = access_connectP_weight;
    vector->object = (char*) obj.connectP ;
    return( OK );
  }
  *ERR_MSG = NULL;

  if( obj.vectorP = find_expression_arg( net, name ) ) {
    vector->accessfunc = access_vectorP_value;
    vector->object = (char*) obj.vectorP;
    vector->value = NULL; 
    return( OK );
  }
	/* now we look for global variables */
  if( obj.layer = which_layer( net, name ) ) {
    if( component ) {
      IF( component, "actv" ) vector->accessfunc = access_layer_actv  ;
      else IF( component, "delta" ) vector->accessfunc = access_layer_delta ;
      else IF( component, "net" ) vector->accessfunc = access_layer_net ;
      else IF( component, "bias" ) vector->accessfunc = access_layer_bias ;
      else IF( component, "user1" ) {
	vector->accessfunc = access_layer_user1 ;
	IfErr( obj.layer->user1 ) {
	  obj.layer->user1 = new_array_of( obj.layer->n_alloc, REAL );
	}
      }
      else IF( component, "user2" ) {
	vector->accessfunc = access_layer_user2 ;
	IfErr( obj.layer->user2 ) 
	  obj.layer->user2 = new_array_of( obj.layer->n_alloc, REAL );
      }
      else Erreturn2("cannot find %s in layer %s", component, name );
    }
    else vector->accessfunc = access_layer_actv ;
    vector->object = (char*) obj.layer ;
    return( OK );
  }

  if( obj.array = which_array( net, name ) ) {
    if( component ) Erreturn1("%s: not a layer", name);
    vector->accessfunc = access_array_value ;
    vector->object = (char*) obj.array ;
    return( OK );
  }
  *ERR_MSG = NULL;

  if( obj.ivec = which_ivector( net, name ) ) {
    if( component ) {
      IF( component, "value" ) vector->accessfunc = access_ivector_value;
      else IF( component, "index" ) vector->accessfunc = access_ivector_index;
      else IF( component, "nvalue" ) vector->accessfunc = access_ivector_nvalue;
      else Erreturn1("specify :value/:index/:nindex for ivector %s",name);
    }
    else vector->accessfunc = access_ivector_value;
    vector->object = (char*) obj.ivec ;
    return( OK );
  }
  *ERR_MSG = NULL;

  if( obj.connect = which_connection( net, name ) ) {
    if( component ) {
      IF( component, "weight" ) vector->accessfunc = access_connect_weight;
      else IF( component, "delta" ) vector->accessfunc = access_connect_delta;
      else IF( component, "user1" ) {
      	vector->accessfunc = access_connect_user1;
	IfErr( obj.connect->user1 )
	  obj.connect->user1 = new_array_of( obj.connect->n_alloc, REAL );
      }
      else IF( component, "user2" ) {
	vector->accessfunc = access_connect_user2;
	IfErr( obj.connect->user2 )
	  obj.connect->user2 = new_array_of( obj.connect->n_alloc, REAL );
      }
      else Erreturn2("cannot find %s in connection %s", component, name );
    }
    else vector->accessfunc = access_connect_weight;
    vector->object = (char*) obj.connect ;
    return( OK );
  }
  *ERR_MSG = NULL;

  if( obj.matrix = which_matrix( net, name ) ) {
    vector->accessfunc = access_matrix_value;
    vector->object = (char*) obj.matrix ;
    return( OK );
  }

  if( EQL( name, "$target" ) || EQL( name, "target" )) {
    vector->accessfunc = access_target_value;
    vector->object = (char*) &net->target ;
    return( OK );
  }

  if( EQL( name, "$input" ) || EQL( name, "input" )) {
    vector->accessfunc = access_input_value;
    vector->object = (char*) &net->input ;
    return( OK );
  }

  *ERR_MSG = NULL;
  Erreturn1("object %s not found", name );
}

/* this should be used only when the return value is used immediately.  the
 * ptr may change */
/* find_vector() finds <vector> or <vector>[range] with constant range */

REAL *
find_vector( net, name, nvalue )
NETWORK *net; char *name; int *nvalue;
{
  EXPRESS *ex;
  IfErr( net ) return( ERR );
  IfErr(ex = find_optimize_expression( net, name ) ) return( ERR );
  if( ex->type == Terminal ) { 
    IfErr(evalExpression( ex )) return( ERR );
    *nvalue = ex->vector->nvalue; return(ex->vector->value);
  }
  Erreturn1("%s: variable vector expression", name );
}

extern char	**Plabel;			/*labels for patterns */
extern int	Npattern;			/* # of patterns. */
extern char    InFileName[];		/* file name to read in weights */
extern char	OutFileName[];		/* file name to save weights */
extern char	PatFileName[];	/* file name to read in patterns */
extern char	NetFileComm[];		/* command used to read in network */

char *
find_string( net, name )
NETWORK *net; char *name;
{
  int npat; char *ind, *end, *index(), *rindex();
  EXPRESS *expr;
  IF( name, "weightfile" ) return( InFileName );
  IF( name, "savefile" ) return( OutFileName );
  IF( name, "network" ) return( NetFileComm );
  IF( name, "pattern" ) return( PatFileName );

  if( Err( Plabel ) || strncmp( name, "$plabel[", 8 ) ) return( ERR );
  IfErr( sscanf( name, "$plabel[%d", &npat )) {
    ind = index( name, '[' )+1;
    if( end = rindex( ind, ']' ) ) *end = NULL;	/* this is crude */
    IfErr( eval_expression_value( net, ind, &npat )) return( ERR );
  }
  if( npat<0 || npat>=Npattern ) Erreturn1("%d: invalid pattern #",npat);
  return( Plabel[npat] );
}

dmatrix_of( net, arg )
NETWORK *net;
char    arg[];
{
  char  *str;
  char  name[ Lname ];
  LAYER *layerP;
  ARRAY *arrayP;
  MATRIX *matrixP;

	/* fixed bug - strcpy(name, arg) can overflow. */
  strncpy(name, arg, Lname-1 ); name[Lname-1] = NULL;
  if( str = index( name, '[' ) ) *str = NULL;
  if( str = index( name, ':' ) ) *str = NULL;
  if( layerP = which_layer( net, name ) ) return( layerP->dmatrix );
  else if( arrayP = which_array( net, name ) ) return( arrayP->dmatrix );
  else if( matrixP = which_matrix( net, name ) ) return( matrixP->dmatrix );
  else IF( "target", name ) return( net->target.dmatrix );
  else IF( "input", name ) return( net->input.dmatrix );
  else return(ERR);
}

/* this is a hack to implement local float/vector/matrix variables 
 * by attaching the procedure name to the variable names.  they should
 * really be declared in procedure structure. */

LAYER *
which_layer( net, name )
NETWORK	*net; char *name;
{
  register int i;
  if( net == 0 ) Erreturn("network not defined");
  for( i=0; i<net->n_layer ; i++ ) 
    IF( net->layer[i].name, name ) 
      return( &( net->layer[i] ));
	
  Erreturn1( "layer %s not found in network", name );
}

LAYER **
which_layer_arg( net, name )
NETWORK	*net; char *name;
{
  register int i;
  PROCARG *parg;

  IfErr( procScope ) return( ERR );
  parg = procScope->arg;
  for( i = 0; i < procScope->n_parg; i++, parg++ ) {
    if( parg->type == ItsLayer && EQL(name, parg->name) ) 
      return( (LAYER**) &parg->ptr );
  }
  return( ERR );
}

CONNECT *
which_connection( net, name )
NETWORK	*net; char *name;
{
  register int i;
  if( net == 0 ) Erreturn("network not defined");
  for( i=0; i<net->n_connect ; i++ ) 
    IF( net->connect[i].name, name ) 
      return( &( net->connect[i] ));
	
  Erreturn1( "connection %s not found in network", name );
}

CONNECT **
which_connection_arg( net, name )
NETWORK	*net; char *name;
{
  register int i;
  PROCARG *parg;

  IfErr( procScope ) return( ERR );
  parg = procScope->arg;
  for( i = 0; i < procScope->n_parg; i++, parg++ ) {
    if( parg->type == ItsConnect && EQL(name, parg->name) ) 
      return( (CONNECT**) &parg->ptr );
  }
  return( ERR );
}

VECTOR **
find_expression_arg( net, name )
NETWORK *net; char *name;
{
  register int i;
  PROCARG *parg;
  IfErr( procScope ) return(ERR);
  parg = procScope->arg;
  for( i = 0; i < procScope->n_parg; i++, parg++ ) {
/*  if( (parg->type == ItsVector || parg->type == ItsMatrix)*/
    if( parg->type == ItsExpr && EQL(name, parg->name) ) 
      return( (VECTOR**) &parg->ptr );
  }
  return(ERR);
}

ARRAY *
which_array( net, name )
NETWORK	*net; char *name;
{
  register int i;
  char buf[BUFSIZE];
  IfErr( net ) Erreturn("network not defined");
  if( procScope ) {
    sprintf( buf, "%s.%s", procScope->name, name );
    for( i=0; i<net->n_array ; i++ ) 
      IF( net->array[i].name, buf ) 
	return( &net->array[i] );
  }
  for( i=0; i<net->n_array ; i++ ) 
    IF( net->array[i].name, name ) 
      return( &( net->array[i] ));

  Erreturn1( "array %s not found in network", name );
}

IVECTOR *
which_ivector( net, name )
NETWORK	*net; char *name;
{
  register int i;
  if( net == 0 ) Erreturn("network not defined");
  for( i=0; i<net->n_ivector ; i++ ) 
    IF( net->ivector[i].name, name ) 
      return( &( net->ivector[i] ));

  Erreturn1( "ivector %s not found in network", name );
}

MATRIX *
which_matrix( net, name )
NETWORK	*net; char *name;
{
  register int i;
  char buf[BUFSIZE];
  IfErr( net ) Erreturn("network not defined");
  if( procScope ) {
    sprintf( buf, "%s.%s", procScope->name, name );
    for( i=0; i<net->n_matrix ; i++ ) 
      IF( net->matrix[i].name, buf ) 
	return( &net->matrix[i] );
  }
  for( i=0; i<net->n_matrix ; i++ ) 
    IF( net->matrix[i].name, name ) 
      return( &net->matrix[i] );

  Erreturn1( "matrix %s not found in network", name );
}

INTVAR *
which_intvar( net, name )
NETWORK	*net; char *name;
{
  register int i;
  IfErr( net ) Erreturn("network not defined");
  for( i=0; i<net->n_intvar ; i++ ) 
    IF( net->intvar[i].name, name ) 
      return( &( net->intvar[i] ));
	
  Erreturn1( "integer variable %s not found in network", name );
}

FLOATVAR *
which_floatvar( net, name )
NETWORK	*net; char *name;
{
  register int i;
  char buf[BUFSIZE];
  IfErr( net ) Erreturn("network not defined");
  if( procScope ) {
    sprintf( buf, "%s.%s", procScope->name, name );
    for( i=0; i<net->n_floatvar ; i++ ) 
      IF( net->floatvar[i].name, buf )
	return( &net->floatvar[i] );
  }
  for( i=0; i<net->n_floatvar ; i++ ) 
    IF( net->floatvar[i].name, name ) 
      return( &net->floatvar[i] );
	
  Erreturn1( "float variable %s not found in network", name );
}

get_variable_string( net, name, str )
NETWORK	*net;
char	*name, *str;
{
  FLOATVAR	*floatvar;
  INTVAR	*intvar;
  if( floatvar = which_floatvar(net,name)) sprintf(str, "%g", floatvar->value);
  else if( intvar = which_intvar(net,name)) sprintf(str, "%d", intvar->value);
  else Erreturn1("variable %s not found", name );
  return( OK );
}


