/* $Header: /soma/users/miyata/planet/src/RCS/net.c,v 5.6.0.5 91/02/13 15:41:17 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/net.c,v 5.6.0.5 91/02/13 15:41:17 miyata Exp $";
/********** UPDATES ***********************************************
net.c:
9/26/90  fixed prune_connection() - set index->n_weight properly.
6/5/90 changed weight matrix representation to be consistent with 'display'etc.
5/3/90   implemented ..._arg() functions for actions passing procedure
  	 arguments.
3/22/90  batch mode for sparse connection
******************************************************************/
#include <stdio.h>
#include <math.h>
#include "net.h"
#include "command.h"
#include "arith.h"
#include "error.h"
#include "alloc.h"
#include "setup.h"
#include "vector.h"
#include "msg.h"

void delete_layer(), delete_connection(), delete_array(),delete_procedure();
void delete_expression(), delete_intvar(),delete_floatvar();
void delete_vector(), delete_vector_struct(); 

#define weightTrans 1

#define _ON MAXACTV
#define _OFF MINACTV

#ifndef min
#define min(x,y) ((x)<(y)? (x) : (y))
#endif

NETWORK *
new_net( )
{
  NETWORK	*net;
  IfErr(net = new( NETWORK ))
    Erreturn("cannot allocate memory for network");
    
  return( net );
} 

make_layer( net, name, nunit, type )
NETWORK *net;
char	name[];
int	nunit;
char    *type;
{
  LAYER	*layerP;
  IfErr( net ) Erreturn("network not given");
  if( nunit <= 0 ) Erreturn("#of units in layer must be positive") ;
  if( MaxLayer <= net->n_layer ) 
    Erreturn1("Sorry, no more than %d layers in a network", MaxLayer);
  if( which_layer( net, name ) ) { 
    sendMsg1("\twarning: layer %s already defined - ignored.\n", name);
    return( OK );
  }
  layerP = &net->layer[ net->n_layer ++ ] ;

  layerP->name = new_string( name, NULL );
  if( Err( layerP->actv = new_array_of( nunit, REAL ) ) ||
      Err( layerP->net = new_array_of( nunit, REAL ) ) ||
      Err( layerP->delta = new_array_of( nunit, REAL ) ) ||
      Err( layerP->bias = new_array_of( nunit, REAL ) ) ||
      Err( layerP->d_bias = new_array_of( nunit, REAL ) ) )
    Erreturn1( "cannot allocate memory for layer %s", name );
  layerP->n_unit = layerP->n_alloc = nunit ;
  if( type == NULL ) layerP->type = Logistic;
  else IF( type, "logistic" ) layerP->type = Logistic;
  else IF( type, "linear" ) layerP->type = Linear;
  else Erreturn1("unknown activation function %s", type );
/*  layerP->dmatrix =(int) sqrt((double) nunit ); */
  layerP->dmatrix = nunit ;
  layerP->etascale = 1.0 ;
  init_bias( layerP );

  return( OK );
}

add_connection_below( layerP, connectP )
LAYER *layerP; CONNECT *connectP;
{
  if( MaxConnectPerLayer <= layerP->n_connect_below ) 
    Erreturn1("no more than %d full connections to a layer", MaxConnectPerLayer );
  layerP->connect_below[layerP->n_connect_below++] = (char*) connectP;
  return( OK );
}

add_connection_above( layerP, connectP )
LAYER *layerP; CONNECT *connectP;
{
  if( MaxConnectPerLayer <= layerP->n_connect_above ) 
    Erreturn1("no more than %d full connections from a layer", MaxConnectPerLayer );
  layerP->connect_above[layerP->n_connect_above++] = (char*) connectP;
  return( OK );
}

resize_array( arrayP, exp, copyIt )
ARRAY *arrayP; EXPRESS *exp; int *copyIt;
{
  int nval0, nval; REAL *new_value;
  if( Err(exp) || Err( evalExpression(exp) )) return( ERR );
  nval = (int) exp->vector->value[0];

  if( arrayP->n_alloc < nval )  {	/* making larger - allocate memory */
    IfErr( new_value=new_array_of( nval, REAL) )
      Erreturn1("cannot allocate memory to resize %s", arrayP->name);
    if( *copyIt )
      copy_vector_( arrayP->value, new_value, &arrayP->n_value );

    free( arrayP->value );
    arrayP->value = new_value;
    arrayP->n_alloc = nval;
  }
  arrayP->n_value = nval;
  arrayP->dmatrix = nval;
  return(OK);
}

resize_matrix( matrixP, row,col, copyIt )
MATRIX *matrixP; EXPRESS *row,*col; int *copyIt;
{
  int nrow,ncol,nval;
  REAL *new_value;
  if( Err(row) || Err( evalExpression(row) )) return( ERR );
  if( Err(col) || Err( evalExpression(col) )) return( ERR );
  nrow = (int) row->vector->value[0];
  ncol = (int) col->vector->value[0];
  if( nrow<=0 || ncol<=0 ) Erreturn("%d x %d: invalid matrix size");
  nval = nrow*ncol;

  if( matrixP->n_alloc < nval )  {	/* need to allocate more memory */
    IfErr(new_value = new_array_of( nval, REAL ))
      Erreturn1("cannot allocate memory to resize %s", matrixP->name);
	/* copy values from old matrix to new matrix */
    if(*copyIt &&
       Err(copy_matrix(matrixP->value,matrixP->n_row,matrixP->n_col,
		      new_value,nrow,ncol, 0 /* not randomize new values */ )))
      Erreturn2("%s: in resizing matrix %s", ERR_MSG,matrixP->name );
    free( matrixP->value );	/* free old matrix */
    matrixP->value = new_value;	/* new matrix */
    matrixP->n_alloc = nval;
  }
  else if( *copyIt ) {	/* copy from old matrix to itself */
    IfErr(copy_matrix(matrixP->value,matrixP->n_row,matrixP->n_col,
		      matrixP->value,nrow,ncol, 0 ))
      Erreturn2("%s: in resizing matrix %s", ERR_MSG, matrixP->name );
  }  
  matrixP->n_row = nrow;
  matrixP->n_col = ncol;
  matrixP->dmatrix = ncol;
  return(OK);
}

resize_layer_arg( layerP, exp )
LAYER **layerP; EXPRESS *exp;
{ return( resize_layer( *layerP, exp ) ); }

resize_layer( layerP, exp )
LAYER *layerP; EXPRESS *exp;
{
  register int i;
  int nunit0, nunit;
  double nrandom();
  if( Err(exp) || Err( evalExpression(exp) ) ) return( ERR );
  nunit0 = layerP->n_alloc, nunit = (int) exp->vector->value[0];
  if ( nunit0 < nunit) {
    if( Err( layerP->actv = (REAL*)change_array_size( (char*) layerP->actv, 
						nunit0,nunit, sizeof(REAL))) ||
        Err( layerP->net = (REAL*)change_array_size( (char*) layerP->net, 
						nunit0, nunit, sizeof(REAL))) ||
        Err( layerP->delta = (REAL*)change_array_size( (char*) layerP->delta, 
						nunit0, nunit, sizeof(REAL))) ||
        Err( layerP->bias = (REAL*)change_array_size( (char*) layerP->bias, 
						nunit0, nunit, sizeof(REAL))) ||
        Err( layerP->d_bias = (REAL*)change_array_size( (char*) layerP->d_bias, 
						nunit0, nunit, sizeof(REAL))) ||
	(layerP->user1 &&
	 Err( layerP->user1 = (REAL*)change_array_size( (char*) layerP->user1,
						nunit0, nunit, sizeof(REAL))))||
	(layerP->user2 &&
	 Err( layerP->user2 = (REAL*)change_array_size( (char*) layerP->user2,
						nunit0, nunit, sizeof(REAL))))
	)
      Erreturn1( "cannot allocate memory for resizing layer %s", layerP->name );

    for( i = nunit0; i< nunit; i++ ) layerP->bias[i] = nrandom()*INITWEIGHT;
    layerP->n_alloc = nunit;
  }
    
  layerP->n_unit = nunit ;
  layerP->dmatrix = nunit ;
  return( OK );
}
	/* resize layer and resize connections below and above the layer */

resize_layer_connect_arg( layerP, expr )
LAYER **layerP; EXPRESS *expr;
{ return( resize_layer_connect( *layerP, expr ) ); }

resize_layer_connect( layerP, expr )
LAYER *layerP; EXPRESS *expr;
{
  CONNECT *connectP;
  register int i;
  IfErr( resize_layer( layerP, expr ) ) return( ERR );

  for(i=0; i< layerP->n_connect_below; i++ )  {
    connectP = (CONNECT*) layerP->connect_below[i];
    IfErr(resize_connect( connectP ))
      Erreturn3("%s: in resizing connection %s to layer %s", ERR_MSG,
		connectP->name, layerP->name);
  }
  for(i=0; i< layerP->n_connect_above; i++ ) {
    connectP = (CONNECT*) layerP->connect_above[i];
    IfErr(resize_connect( connectP ))
      Erreturn3("%s: in resizing connection %s from layer %s", ERR_MSG,
		connectP->name, layerP->name);
  }
  return( OK );
}

make_array( net, name, nvalue )
NETWORK *net;
char	name[];
int	nvalue;
{
  ARRAY	*arrayP ;

  IfErr( net ) Erreturn("network not given");
  if( nvalue <= 0 ) Erreturn("size of array must be positive") ;
  if( MaxArray <= net->n_array ) 
    Erreturn1("no more than %d arrays in a network", MaxArray);
  if( which_array( net, name ) ) {
    sendMsg1("\twarning: array %s already defined - ignored.\n", name);
    return( OK );
  }

  arrayP = &net->array[ net->n_array ++ ] ;

  arrayP->name = new_string( name, NULL );
  IfErr( arrayP->value = new_array_of( nvalue, REAL ) )
    Erreturn1( "cannot allocate memory for array %s", name );
  arrayP->n_value = nvalue ;
  arrayP->dmatrix = nvalue ;

  return( OK );
}

make_ivector( net, name, nvalue )
NETWORK *net;
char	name[];
int	nvalue;
{
  IVECTOR  *ivecP ;

  IfErr( net ) Erreturn("network not given");
  if( nvalue <= 0 ) Erreturn("size of ivector must be positive") ;
  if( MaxIvector <= net->n_ivector ) 
    Erreturn1("no more than %d ivectors in a network", MaxArray);
  if( which_ivector( net, name ) ) {
    sendMsg1("\twarning: ivector %s already defined - ignored.\n", name);
    return( OK );
  }

  ivecP = &net->ivector[ net->n_ivector ++ ] ;

  ivecP->name = new_string( name, NULL );
  if( Err( ivecP->value = new_array_of( nvalue, REAL ) ) ||
     Err( ivecP->index = new_array_of( nvalue, REAL ) ))
    Erreturn1( "cannot allocate memory for ivector %s", name );
  ivecP->nindex = nvalue ;	/* size of index table */
  ivecP->nvalue = 0.0;		/* no. of values in table */
  ivecP->dmatrix = nvalue ;

  return( OK );
}

make_matrix( net, name, nrow, ncol )
NETWORK *net;
char	name[];
int	nrow, ncol;
{
  MATRIX *matrixP;

  IfErr( net ) Erreturn("network not given");
  if( nrow <= 0 || ncol <=0 ) Erreturn("size of matrix must be positive") ;
  if( MaxMatrix <= net->n_matrix ) 
    Erreturn1("no more than %d matrices in a network", MaxMatrix);
  if( which_matrix( net, name ) ) {
    sendMsg1("\twarning: matrix %s already defined - ignored.\n", name);
    return( OK );
  }

  matrixP = &net->matrix[ net->n_matrix ++ ] ;

  matrixP->name = new_string( name, NULL );
  IfErr( matrixP->value = new_array_of( nrow*ncol, REAL ) )
    Erreturn1( "cannot allocate memory for matrix %s", name );
  matrixP->n_row = nrow, matrixP->n_col = ncol ;
  matrixP->dmatrix = ncol ;

  return( OK );
}

make_int( net, name, value )
NETWORK	*net;
char	name[];
int	value;
{
  INTVAR	*intvar;
  IfErr( net ) Erreturn("network not given");
  if( MaxIntVar <= net->n_intvar )
    Erreturn1("no more than %d integer variables in a network", MaxIntVar);
  if( which_intvar( net, name ) ) {
    sendMsg1("\twarning: int %s already defined - ignored.\n", name);
    return( OK );
  }
  intvar = &net->intvar[ net->n_intvar ++ ];
  intvar->value = value;
  intvar->name = new_string( name, NULL );

  return( OK );
}

make_float( net, name, value )
NETWORK	*net;
char	name[];
char	*value;
{
  FLOATVAR	*floatvar;
  IfErr( net ) Erreturn("network not given");
  if( MaxFloatVar <= net->n_floatvar )
    Erreturn1("no more than %d float variables in a network", MaxFloatVar);
  IfErr( floatvar = which_floatvar( net, name ) ) { /* not already defined */
    floatvar = &net->floatvar[ net->n_floatvar ++ ];
    if( value == NULL ) floatvar->value = 0.0;
    IfErr(floatvar->name = new_string(name, NULL)) Erreturn("not enough core");
  }
  if( value && Err( AtoF( value, floatvar->value)))
    Erreturn1("%s: invalid value", value);

  return( OK );
}

make_input( net, nvalue )
NETWORK *net;
int	nvalue;
{
  IfErr( net ) Erreturn("network not given");
  if( net->input.value ) {
    sendMsg("\twarning: input buffer already defined - ignored.\n");
    return( OK );
  }
  IfErr( net->input.value = new_array_of( nvalue, REAL ) )
    Erreturn("cannot allocate memory for input ") ;

  net->input.n_value = net->input.n_alloc = nvalue ;
  net->input.dmatrix = nvalue ;

  return( OK );
}

make_target( net,  nvalue )
NETWORK *net;
int	nvalue;
{
  IfErr( net ) Erreturn("network not given");

  if( net->target.value )  {
    sendMsg("\twarning: target buffer already defined - ignored.\n");
    return( OK );
  }
  IfErr( net->target.value = new_array_of( nvalue, REAL ) )
    Erreturn("cannot allocate memory for target" ) ;

  IfErr( net->target.error = new_array_of( nvalue, REAL ) )
    Erreturn("cannot allocate memory for target") ;

  net->target.n_value = net->target.n_alloc = nvalue ;
  net->target.dmatrix = nvalue ;

  return( OK );
}

make_connection( net, argn, args, init )
NETWORK	*net;
int	argn;
char	args[][Largs];
int	init;	/* initialize weights only if init = 1 */
{
  register int i = 0;
  LAYER	*fromlayer, *tolayer;
  int   from_start, to_start;
  int	from_nunit, to_nunit;
  CONNECT *connectP, *with_connectP;

  IfErr( net ) Erreturn("network not given");
  if( argn < 3 ) Erreturn("syntax: connect <name> <layer1> to <layer2>");

  if( net->n_connect >= MaxConnect ) 
    Erreturn1("sorry, no more than %d connections in a network", MaxConnect );
  if( which_connection( net, args[0] ) ) {
    sendMsg1("\twarning: connection %s already defined - ignored.\n", args[0]);
    return( OK );
  }
  connectP = &net->connect[ net->n_connect ] ;

  IfErr( which_unit( net, &connectP->fromlayer, &connectP->from_start,
		    &connectP->from_nunit, args[1] )) {
    if( eval_expression_value( net, args[1], &connectP->from_nunit )) {
      connectP->fromlayer = NULL, connectP->from_start = 0;
    }
    else
      Erreturn1("%s: don't know where to connect from", ERR_MSG );
  }
	/* register this connection in fromlayer - only for resizing*/
  if(connectP->fromlayer && connectP->from_start==0 && 
    connectP->from_nunit== connectP->fromlayer->n_unit )
      add_connection_above( connectP->fromlayer, connectP );

  IF( args[2], "symmetric" ) {
    connectP->type = SYMMETRIC;
    connectP->tolayer = connectP->fromlayer;
    connectP->to_start = connectP->from_start;
    connectP->to_nunit = connectP->from_nunit;
  }
  else {
    if( argn < 4 ) Erreturn("syntax: connect <name> <layer1> to <layer2>");
    IfErr( which_unit( net, &connectP->tolayer, &connectP->to_start,
		      &connectP->to_nunit, args[3]  ))
    if( eval_expression_value( net, args[3], &connectP->to_nunit )) {
      connectP->tolayer = NULL, connectP->to_start = 0;
    }
    else
      Erreturn1("%s: don't know where to connect to", ERR_MSG );
	/* register this connection in tolayer - only for resizing*/
    if(connectP->tolayer && connectP->to_start==0 && 
      connectP->to_nunit== connectP->tolayer->n_unit )
     add_connection_below( connectP->tolayer, connectP );
  }

  if( argn > 4 && get_flag(argn-4, args[4], "batch") )
					/* buffer for batch mode */
    connectP->change = 
      new_array_of(connectP->from_nunit*connectP->to_nunit, WEIGHT);

  connectP->name = new_string( args[0], NULL );

  if( argn > 5 && EQL(args[4], "with" )) {
    IfErr( with_connectP = which_connection( net, args[5] ) ) 
      Erreturn1("connection %s not defined", args[5] );
    if( with_connectP->from_nunit != connectP->from_nunit ||
       with_connectP->to_nunit != connectP->to_nunit )
      Erreturn2("incompatible size: %s and %s",connectP->name, args[5]);
    connectP->weight = with_connectP->weight;
    connectP->d_weight = with_connectP->d_weight;
  }
  else {
    if(Err(connectP->weight = 
	   new_array_of(connectP->from_nunit*connectP->to_nunit, WEIGHT)) ||
       Err(connectP->d_weight = 
	   new_array_of(connectP->from_nunit*connectP->to_nunit, WEIGHT)) )
      Erreturn("not enough memory");
  }
  connectP->n_alloc = connectP->from_nunit*connectP->to_nunit;
  connectP->index = NULL;

  if(connectP->type == SYMMETRIC ) init_symmetric_weight( connectP );
  else if( init ) init_connection( connectP );

  net->n_connect++ ;

  return( OK );
}

resize_connect( connect )
  CONNECT *connect;
{
  LAYER	*fromlayer, *tolayer;
  WEIGHT *weight_save, *d_weight_save, *change_save, *weight,*d_weight,*change;
  REAL *user1_save, *user2_save, *user1, *user2;
  int   n_weight, from_nunit0, to_nunit0, from_nunit1, to_nunit1;
  register int i,j,ij,ij0;
  double nrandom ();

  IfErr( connect ) return( ERR );

  IfErr( fromlayer = connect->fromlayer )
      Erreturn1("%s has no layer to connect from", connect->name );
  IfErr( tolayer = connect->tolayer )
      Erreturn1("%s has no layer to connect to", connect->name );

/*  PROBLEM: if this connection shares weights with another connection, we
 * should check if the other connection is resized consistently with this one 
 */
  if( connect->to_start !=0 || connect->from_start !=0 )
    Erreturn1("%s: not full connection - cannot resize",connect->name );

  /* size of old weight matrix */
  from_nunit0 = connect->from_nunit;  to_nunit0 = connect->to_nunit;
  /* size of new weight matrix */
  from_nunit1 = fromlayer->n_unit; to_nunit1 = tolayer->n_unit;
  n_weight = from_nunit1*to_nunit1;

  /* if there are enough weights allocated, no need to reallocate
   * just need to resize and copy. 
   */
  if( connect->n_alloc >= n_weight ) {
	/* copy old values to appropriate places in each matrix */
    if(Err(copy_matrix(connect->weight, to_nunit0, from_nunit0,
		       connect->weight, to_nunit1, from_nunit1, 1)) ||
       Err(copy_matrix(connect->d_weight, to_nunit0, from_nunit0,
		       connect->d_weight, to_nunit1, from_nunit1, 0)))
      Erreturn2("%s: in resizing connection %s",ERR_MSG,connect->name);
    if( connect->change &&
       Err(copy_matrix(connect->change, to_nunit0, from_nunit0,
		       connect->change, to_nunit1, from_nunit1,0)))
      Erreturn2("%s: in resizing connection %s",ERR_MSG,connect->name);
    if( connect->user1 &&
       Err(copy_matrix(connect->user1, to_nunit0, from_nunit0,
		       connect->user1, to_nunit1, from_nunit1,0)))
      Erreturn2("%s: in resizing connection %s",ERR_MSG,connect->name);
    if( connect->user2 &&
       Err(copy_matrix(connect->user2, to_nunit0, from_nunit0,
		       connect->user2, to_nunit1, from_nunit1,0)))
      Erreturn2("%s: in resizing connection %s",ERR_MSG,connect->name);
	/* resize */
    connect->to_nunit = to_nunit1;
    connect->from_nunit = from_nunit1;
    return( OK );
  }

 /* we need to allocate more weights - save old weights, d_weights */
  weight_save = connect->weight;
  d_weight_save = connect->d_weight;
  change_save = connect->change;
  user1_save = connect->user1;
  user2_save = connect->user2;

	  /* allocate new data */
  connect->weight = weight = new_array_of( n_weight, WEIGHT);
  connect->d_weight = d_weight = new_array_of( n_weight, WEIGHT);
  	/* buffer for batch mode */
  if( connect->change ) connect->change = new_array_of( n_weight, WEIGHT);
  change = connect->change;
  if( connect->user1 ) connect->user1 = new_array_of( n_weight, WEIGHT);
  user1 = connect->user1;
  if( connect->user2 ) connect->user2 = new_array_of( n_weight, WEIGHT);
  user2 = connect->user2;

	  /* copy old weights and initialize new weights */
#ifdef weightTrans
  for (i=0,ij=0; i< to_nunit1 ; i++) 
    for (j=0; j< from_nunit1 ; j++, ij++, weight++,d_weight++) {
      if( i< to_nunit0 && j< from_nunit0) {
	ij0 = i*from_nunit0 + j; /* index for old weights */
	*weight = weight_save[ij0];
	*d_weight = d_weight_save[ij0];
	if(change) *(change++) = change_save[ij0];
	if(user1) *(user1++) = user1_save[ij0];
	if(user2) *(user2++) = user2_save[ij0];
      }
      else
        *weight = INITWEIGHT * nrandom();
    }
#else
  for (i=10,ij=0; i< from_nunit1 ; i++) 
    for (j=0; j< to_nunit1 ; j++, ij++,weight++, d_weight++) {
      if( i< from_nunit0 && j< to_nunit0)  {
	ij0 = i*to_nunit0 + j;
	*weight = weight_save[ij0];
	*d_weight = d_weight_save[ij0];
	if(change) *(change++) = change_save[ij0];
      }
      else
        *weight = INITWEIGHT * nrandom();
    }
#endif weight

  free( weight_save );
  free( d_weight_save );
  if( change_save ) free( change_save );

  connect->from_nunit = from_nunit1;
  connect->to_nunit = to_nunit1;
  connect->n_alloc = n_weight;

/* note: connect->index is not touched.  its up to the user to reindex when
   a sparse connection is resized. */

  return( OK );
}


copy_matrix( m0, row0,col0, m1, row1,col1, randomize )
REAL *m0,*m1; int row0,col0,row1,col1, randomize;
{
  register int i,j; double nrandom();
  int nval=0;
  if( m0==m1 ) {	/* same matrix */
	/* same no of cols & fewer rows -> nothing to do */
    if( col0==col1 && row0>=row1 ) return(OK);
	/* same no of cols & more rows -> just randomize new rows */
    if( col0==col1 && row0<row1 ) {
      if( !randomize ) return(OK);
      for( i=row0, m1 += col0*row0; i<row1; i++ ) 
	for( j=col1; j; j--, m1++) 
	  *m1 = INITWEIGHT *nrandom();
      return(OK);
    }
        /* cols change -> let's copy all (can be cleverer) */
	/* allocate new memory to m0 and copy from m1 */
    IfErr( m0 = new_array_of((nval = row0 * col0), REAL) )
      Erreturn("not enough memory");
    copy_vector_( m1, m0, &nval );
  }
	/* now copy from m0 to m1 */
  for (i=0 ; i< row1 ; i++)
    for (j=0; j< col1 ; j++, m1++) {
      if( i< row0 && j< col0) *m1 = m0[i*col0 + j];

      else if( randomize ) *m1 = INITWEIGHT * nrandom();
    }
  if(nval) free(m0);	/* we allocated m0 */
  return(OK);
}

/* network parameters are declared & initialized in sunnetparam.c */

REAL	_logistic();
REAL	rlogistic();
REAL	_logistic_der();

init_weight( n_from, weight, n_to )
WEIGHT	weight[];
int	n_from, n_to;
{
  register int i,j,ij;
  double nrandom ();

#ifdef weightTrans
  for (i=0,ij=0; i< n_to ; i++) 
    for (j=0; j< n_from ; j++, ij++)
      weight[ij] = INITWEIGHT * nrandom();
#else
  for (i=0,ij=0; i< n_from ; i++) 
    for (j=0; j< n_to ; j++, ij++)
      weight[ij] = INITWEIGHT * nrandom();
#endif weight
  return ( OK );
}

  /* don't initialize non-existing weights & fixed weights 
   * (BUG) cannot recover variance for random weights
   * (BUG) cannot distinguish b/w specified & random weights
   */
init_sparse_weight( connect )
CONNECT *connect;
{
  register int i;
  double nrandom ();
  WEIGHT *weight = connect->weight;
  int	*w_ind = connect->index->weight;
  char	*type_ind = connect->index->type;
  REAL	*init_ind = connect->index->init;
  int	n_weight = connect->index->n_weight;

  for( i=0; i< n_weight; i++, w_ind++, type_ind++, init_ind++ ) {
    if( *type_ind == RandConnect ) 
      weight[*w_ind] =  nrandom() * (*init_ind==.0? INITWEIGHT : *init_ind);
    else if( *type_ind == GivenConnect ) weight[*w_ind] = *init_ind;
  }
  return ( OK );
}

init_symmetric_weight( connect )
CONNECT *connect;
{
  register int i,j,ij;
  double nrandom ();
  WEIGHT   *weight = connect->weight;
  WINDEX   *index;
  int   nunit = connect->from_nunit;
  int	*w_indP, *from_indP, *to_indP, *w_backP, *from_backP, *to_backP;
  char  *type_indP;
  REAL  *init_indP;
  int	n_weight;
  void	 delete_index(), allocate_index();

  IfErr( connect->index ) connect->index = new( WINDEX );
  index = connect->index;
  allocate_index( index, index->n_weight=(nunit+1)*nunit/2 );

  w_indP = index->weight, 
  from_indP = index->from,
  to_indP = index->to,
  w_backP = index->weight_back,
  from_backP = index->from_back,
  to_backP = index->to_back;
  type_indP = index->type;
  init_indP = index->init ;

  for (i=0,ij=0, n_weight=0 ; i< nunit ; i++) {
    for (j=0; j <= i ; j++,ij++)  weight[ij] = 0.0;
    for (; j < nunit ; j++,ij++) {
      weight[ij] = INITWEIGHT * nrandom();
#ifdef weightTrans
      *(w_indP++) = ij, *(from_indP++) = j, *(to_indP++) = i;
      *(w_backP++) = ij, *(from_backP++) = j, *(to_backP++) = i;
#else
      *(w_indP++) = ij, *(from_indP++) = i, *(to_indP++) = j;
      *(w_backP++) = ij, *(from_backP++) = i, *(to_backP++) = j;
#endif weight
      *(type_indP++) = RandConnect, *(init_indP++) = INITWEIGHT;
      n_weight++ ;
    }
  }
  index->n_weight = n_weight; 
  return ( OK );
}

init_bias ( layer )	/* initialize biases of units in a layer */
LAYER	*layer;
{
  register int i;
  for ( i=0 ; i < layer->n_unit ; i++ ) 
    layer->bias[i] = INITWEIGHT * nrandom();
  clear_array( layer->d_bias, layer->n_unit );
  return ( OK );
}

forward_arg( ptr )
CONNECT **ptr;
{
  return( forward( *ptr ) );
}

forward( connect )	/* propagate activation forward in connection */
CONNECT *connect;
{
#if allie
  if( connect->index ) 
    return(forward_sparse_(&connect->fromlayer->actv[connect->from_start],
			   connect->weight,
			   &connect->tolayer->net[connect->to_start],
			   connect->index->from,
			   connect->index->weight,
			   connect->index->to,
			   connect->index->fan_out,
			   &connect->from_nunit ) );
  else
    return( forward_(&connect->fromlayer->actv[connect->from_start],
		     connect->weight,
		     &connect->tolayer->net[connect->to_start],
		     &connect->from_nunit,
		     &connect->to_nunit ));
#else 
  if( connect->index ) return( forward_sparse_( connect ) );
  else return( forward_( connect ) );
#endif allie
}

#ifndef allie		/* defined in fnet.f for Alliant */

forward_( connect )	/* forward propagation through full connection*/
CONNECT *connect;
{
  register int	i,j;
  WEIGHT *weightP = connect->weight;
  int    from_nunit = connect->from_nunit;
  int    to_nunit = connect->to_nunit;
#ifdef weightTrans
  REAL *fromactvP;
  REAL *fromactvP_start = &connect->fromlayer->actv[ connect->from_start ];
  REAL *tonetP = &connect->tolayer->net[ connect->to_start ] ;
#else
  REAL *fromactvP = &connect->fromlayer->actv[ connect->from_start ];
  REAL *tonetP;
  REAL *tonetP_start = &connect->tolayer->net[ connect->to_start ] ;
#endif weightTrans

#ifdef weightTrans
  for( i=0 ; i< to_nunit ; i++, tonetP++ ) {
    fromactvP = fromactvP_start;
    for ( j=0; j < from_nunit ; j++, fromactvP++, weightP++ )
      *tonetP += *weightP * *fromactvP ;
  }
#else
  for( i=0 ; i< from_nunit ; i++, fromactvP++ ) {
    tonetP = tonetP_start;
    for ( j=0; j < to_nunit ; j++, tonetP++, weightP++ )
      *tonetP += *weightP * *fromactvP ;
  }
#endif
  return ( OK );
}

forward_sparse_( connect ) /* non-uniform connectivity */
CONNECT *connect;
{
  register int	n;
  WEIGHT *weightP = connect->weight ;
  REAL *fromactvP = &connect->fromlayer->actv[ connect->from_start ];
  REAL *tonetP = &connect->tolayer->net[ connect->to_start ] ;
  int	 *w_indP = connect->index->weight;
  int	 *from_indP = connect->index->from;
  int	 *to_indP = connect->index->to;
  int	 n_weight = connect->index->n_weight;

  for( n=0; n < n_weight ; n++, to_indP++, w_indP++, from_indP++ )
    tonetP[*to_indP] += weightP[*w_indP] * fromactvP[*from_indP];
  if( connect->type != SYMMETRIC ) return( OK );

  for(w_indP = connect->index->weight,
      from_indP = connect->index->from,
      to_indP = connect->index->to,
      n=0; n < n_weight ; n++, to_indP++, w_indP++, from_indP++ )
    if(*from_indP != *to_indP ) /* only non-diagonal ones */
      tonetP[*from_indP] += weightP[*w_indP] * fromactvP[*to_indP];
  /* this won't be most efficient - 
     diagonal weights shold be treated separately?*/
			  
  return ( OK );
}
#endif not-allie

void
delete_index( index )
WINDEX *index;
{
  if( index->from ) free( index->from );
  if( index->to ) free( index->to );
  if( index->weight ) free(index->weight );
  if( index->type ) free( index->type );
  if( index->from_back ) free( index->from_back );
  if( index->to_back ) free( index->to_back );
  if( index->weight_back ) free( index->weight_back );
}

void
#if allie
allocate_index( index, n_weight, from_nunit, to_nunit )
int  from_nunit, to_nunit;
#else
allocate_index( index, n_weight )
#endif
WINDEX *index;
int	n_weight;
{
  IfErr( index ) return;
  index->from  = new_array_of( n_weight, int );
  index->to  = new_array_of( n_weight, int );
  index->weight = new_array_of( n_weight, int );
  index->type = new_array_of( n_weight, char );
  index->init = new_array_of( n_weight, REAL );
  index->from_back  = new_array_of( n_weight, int );
  index->to_back  = new_array_of( n_weight, int );
  index->weight_back  = new_array_of( n_weight, int );
  index->n_weight = n_weight;
#if allie	/* AllieNet needs no. of indexed wts for each unit */
  IfErr( index->fan_out )
    index->fan_out = new_array_of( from_nunit, int );
  IfErr( index->fan_in ) 
    index->fan_in = new_array_of( to_nunit, int);
#endif allie
}

prune_connection_arg( ptr, mask )
CONNECT **ptr; EXPRESS *mask; 
{
  return( prune_connection( *ptr, mask ));
}

prune_connection( connect, maskExp )
CONNECT *connect; EXPRESS *maskExp; 
{
  register int	i,j,ij;
  WEIGHT *weightP = connect->weight;
  WINDEX *index;
  int	 *w_indP, *from_indP, *to_indP;
  int	 *w_backP, *from_backP, *to_backP;
#if allie
  int    *fanP;
#endif
  int    from_nunit = connect->from_nunit;
  int    to_nunit = connect->to_nunit;
  int	 n_weight =0, n_weight_back =0;
  int    masksize;
  REAL   *mask;

  IfErr( evalExpression( maskExp ) ) 
    Erreturn1("%s: in mask expression", ERR_MSG);

  if( (masksize=maskExp->vector->nvalue) < from_nunit*to_nunit ) 
    Erreturn1("prune: mask too small for connection %s", connect->name );
	/* count number of weights to keep */
#ifdef weightTrans
  for( mask=maskExp->vector->value,i=0; i<to_nunit ; i++ ) 
    for( j=0; j<from_nunit ; j++, mask++ ) {
#else
  for( mask=maskExp->vector->value,i=0; i<from_nunit ; i++ ) 
    for( j=0; j<to_nunit ; j++, mask++ ) {
#endif weightTrans
      if( *mask != 0.0 ) n_weight++;
      if( *mask < 0.0 ) n_weight_back++;
    }
  mask = maskExp->vector->value;

  IfErr( connect->index ) connect->index = new( WINDEX );
  index = connect->index;

  if( n_weight > index->n_weight ) {	/* need to allocate index space */
    delete_index( index );
#if allie
    allocate_index( index, n_weight, from_nunit, to_nunit );
#else
    allocate_index( index, n_weight );
#endif
  }

#if allie
  fanP = index->fan_out;
#endif

  for(w_indP = index->weight,
      from_indP = index->from,
      to_indP = index->to,
      w_backP = index->weight_back,
      from_backP = index->from_back,
      to_backP = index->to_back,
#ifdef weightTrans
      i=0,ij=0; i<to_nunit ; i++ ) 
    for( j=0; j<from_nunit ; j++, mask++, ij++ )
#else
      i=0,ij=0; i<from_nunit ; i++ ) 
    for( j=0; j<to_nunit ; j++, mask++, ij++ )
#endif weightTrans
      if( *mask != 0.0 ) {
#ifdef weightTrans
	*(from_indP++) = j; 
	*(to_indP++) = i;
	if( *mask < 0.0 ) {
	  *(from_backP++) = j; 
	  *(to_backP++) = i;
	}
#else
	*(from_indP++) = i; 
	*(to_indP++) = j;
	*(from_backP++) = i; 
	*(to_backP++) = j;
#endif weightTrans
	*(w_indP++) = ij;
	*(w_backP++) = ij;
      }
  index->n_weight = n_weight;
  index->n_weight_back = n_weight;
  return( OK );
}

backward_arg( ptr )
CONNECT **ptr;
{
  return( backward( *ptr ) );
}

backward( connect )	/* propagate error back through connection */
CONNECT *connect ;
{
#if allie
  if( connect->index )
    return(backward_sparse_(&connect->fromlayer->delta[connect->from_start],
			    connect->weight,
			    &connect->tolayer->delta[connect->to_start],
			    connect->index->from_back,
			    connect->index->weight_back,
			    connect->index->to_back,
			    connect->index->fan_in,
			    &connect->to_nunit ) );
  else
    return(backward_(&connect->fromlayer->delta[connect->from_start],
		     connect->weight,
		     &connect->tolayer->delta[connect->to_start],
		     &connect->from_nunit,
		     &connect->to_nunit ) );
#else
  if( connect->index )
    return(backward_sparse_( connect ));
  else
    return(backward_(connect ));
#endif
}

#ifndef allie
#include "msg.h"
backward_( connect )	/* propagate back through full connectivity */
CONNECT *connect;
{
  WEIGHT *weightP = connect->weight ;
  int	 from_nunit = connect->from_nunit;
  int	 to_nunit   = connect->to_nunit;
  REAL *fromdeltaP_start = &connect->fromlayer->delta[ connect->from_start ];
  REAL *fromdeltaP;
  REAL *todeltaP = &connect->tolayer->delta[ connect->to_start ];
  register int	i,j; 

  for ( i=to_nunit; i; i--, todeltaP++ ) {
    fromdeltaP = fromdeltaP_start ;
    for( j=from_nunit; j; j--, weightP++, fromdeltaP++ ) {
      *fromdeltaP += *weightP * *todeltaP ;
    }
  }
  return ( OK );
}

backward_sparse_( connect )	/* non-uniform connection */
CONNECT *connect ;
{
  WEIGHT *weight = connect->weight;
  REAL *fromdelta = &connect->fromlayer->delta[ connect->from_start ];
  REAL *todelta = &connect->tolayer->delta[ connect->to_start ];
  int	 *w_indP, *from_indP, *to_indP;
  int	n_weight;
  register int	n;

  for(w_indP = connect->index->weight_back,
      from_indP = connect->index->from_back,
      to_indP = connect->index->to_back,
      n_weight = connect->index->n_weight_back,
      n=0; n < n_weight ; n++, to_indP++, w_indP++, from_indP++ )
    fromdelta[*from_indP] += weight[*w_indP] * todelta[*to_indP];

  if(connect->type!=SYMMETRIC) return( OK );

  for(w_indP = connect->index->weight_back,
      from_indP = connect->index->from_back,
      to_indP = connect->index->to_back,
      n_weight = connect->index->n_weight_back,
      n=n_weight; n ; n--, to_indP++, w_indP++, from_indP++ )
    if(*to_indP != *from_indP)	/* only non-diagonal ones */
      fromdelta[*to_indP] += weight[*w_indP] * todelta[*from_indP];
  return ( OK );
}
#endif allie

change_bias_arg( ptr )
LAYER **ptr;
{
  return( change_bias( *ptr ) );
}

change_bias ( layer )		/* modify bias of units in layer */
LAYER	*layer ;
{  
  REAL *biasP = layer->bias ;
  REAL *d_biasP = layer->d_bias ;
  REAL *deltaP = layer->delta ;
  REAL lrate = layer->etascale * ETA ;
  register int i;
  
  for ( i=0; i < layer->n_unit ; i++, biasP++, d_biasP++, deltaP++ ) {
    *d_biasP = *deltaP * lrate + *d_biasP * ALPHA ;
    *biasP += *d_biasP ;
  }
  return ( OK );
}

change_weight_arg( ptr )
CONNECT **ptr;
{
  if( (*ptr)->change ) return( change_weight_batch( *ptr ) );
  return( change_weight( *ptr ) );
}

change_weight( connect )	/* modify weights in connection */
CONNECT	*connect ;
{
#if allie
  if( connect->index ) 
    return( ch_wts_sprs_( &connect->fromlayer->actv[ connect->from_start ],
				  connect->weight,
				  connect->d_weight,
				  &connect->tolayer->delta[connect->to_start],
				  connect->index->from_back,
				  connect->index->weight_back,
				  connect->index->to_back,
				  &connect->index->n_weight ) );
  else return( change_weight_(&connect->fromlayer->actv[ connect->from_start ],
			      connect->weight,
			      connect->d_weight,
			      &connect->tolayer->delta[connect->to_start],
			      &connect->from_nunit,
			      &connect->to_nunit ) );
#else
  if( connect->index ) return( change_weight_sparse_( connect ));
  else return( change_weight_( connect ));
#endif allie
}

/*  cannot do this - cannot tell if connection as arg is batch.
change_weight_batch_arg( ptr ) CONNECT **ptr;
{  return( change_weight_batch( *ptr ) ); }
*/

change_weight_batch( connect )	/* batch mode */
CONNECT *connect;
{
  if( connect->index ) return( change_weight_sparse_batch( connect ));
  return( change_weight_batch_( connect ));
}

change_weight_batch_( connect )	/* batch mode for full connectivity */
CONNECT *connect;
{
#ifdef weightTrans
  register WEIGHT *changeP ;
#else
  WEIGHT *change = connect->change;
  register WEIGHT *changeP ;
#endif weightTrans
  int	 from_nunit = connect->from_nunit;
  int	 to_nunit   = connect->to_nunit;
  REAL *todeltaP  = &connect->tolayer->delta[ connect->to_start ];
  register REAL *fromactvP;
  REAL *fromactvP_start = &connect->fromlayer->actv[ connect->from_start ];
  register int	i,j; 
  
#ifdef weightTrans
  changeP = connect->change;
  for( j=to_nunit; j ; j--, todeltaP++ ) {
    fromactvP = fromactvP_start ;
    for(i=from_nunit; i ; i--, fromactvP++, changeP++ )
      *changeP += *todeltaP * *fromactvP;
  }
#else
  for( j=0; j< to_nunit ; j++, todeltaP++ ) {
    fromactvP = fromactvP_start ;
    for(i=from_nunit, changeP = &change[j]; i ;  i--,
	fromactvP++, changeP += to_nunit )
      *changeP += *todeltaP * *fromactvP;
  }
#endif weightTrans
  return ( OK );
}

change_weight_batch_do_arg( ptr )
CONNECT **ptr;
{
  return( change_weight_batch_do( *ptr ) );
}
  
change_weight_batch_do( connect )
CONNECT *connect;
{
  if( connect->index ) return( change_weight_sparse_batch_do( connect ));
  return( change_weight_batch_do_( connect ));
}
		/* batch mode for full connectivity */
change_weight_batch_do_( connect )
CONNECT *connect;
{
  register WEIGHT *changeP = connect->change, *weightP = connect->weight;
  register WEIGHT *d_weightP = connect->d_weight;
  register int i,j;
  int	 from_nunit = connect->from_nunit;
  int	 to_nunit   = connect->to_nunit;
  REAL lrate = connect->tolayer->etascale * ETA ;

  IfErr( changeP ) Erreturn("connection not set up for batch mode");
#ifdef weightTrans
  for( i=to_nunit; i; i-- )
    for( j=from_nunit; j; j--, changeP++, weightP++, d_weightP++ ) {
#else
  for( i=from_nunit; i ; i-- )
    for( j=to_nunit; j ; j--, changeP++, weightP++, d_weightP++ ) {
#endif weightTrans
      *d_weightP = *changeP * lrate + *d_weightP * ALPHA;
      *weightP += *d_weightP;
      *changeP = 0;
    }
  return( OK );
}

#ifndef allie
change_weight_( connect )
CONNECT *connect;
{
#ifdef weightTrans
  register WEIGHT *weightP = connect->weight;
  register WEIGHT *d_weightP = connect->d_weight ;
#else
  register WEIGHT *weightP, *d_weightP ;
  WEIGHT *weight = connect->weight;
  WEIGHT *d_weight = connect->d_weight ;
#endif weightTrans
  int	 from_nunit = connect->from_nunit;
  int	 to_nunit   = connect->to_nunit;
  REAL *todeltaP  = &connect->tolayer->delta[ connect->to_start ];
  register REAL todelta_x_lrate ;
  register REAL *fromactvP;
  REAL *fromactvP_start = &connect->fromlayer->actv[ connect->from_start ];
  REAL lrate = connect->tolayer->etascale * ETA ;
  int	i,j; 
  
#ifdef weightTrans
  for( j=0; j< to_nunit ; j++, todeltaP++ ) {
    todelta_x_lrate = *todeltaP * lrate ;
    fromactvP = fromactvP_start ;
    for(i=0; i < from_nunit ; i++, fromactvP++, weightP++, d_weightP++ ) {
      *d_weightP = todelta_x_lrate * *fromactvP + ALPHA* *d_weightP;
      *weightP += *d_weightP;
    }
  }
#else
  for( j=0; j< to_nunit ; j++, todeltaP++ ) {
    todelta_x_lrate = *todeltaP * lrate ;
    fromactvP = fromactvP_start ;
    for(i=0, weightP = &weight[j], d_weightP = &d_weight[j];
	i < from_nunit ; 
	i++, fromactvP++, weightP += to_nunit, d_weightP += to_nunit ) {
      *d_weightP = todelta_x_lrate * *fromactvP + ALPHA* *d_weightP;
      *weightP += *d_weightP;
    }
  }
#endif weightTrans
  return ( OK );
}

change_weight_sparse_batch( connect )
CONNECT *connect;
{
  WEIGHT *changeP = connect->change;
  REAL *todelta  = &connect->tolayer->delta[ connect->to_start ];
  REAL *fromactv = &connect->fromlayer->actv[ connect->from_start ];
  int	 *w_indP = connect->index->weight_back;
  int	 *from_indP = connect->index->from_back;
  int	 *to_indP = connect->index->to_back;
  int	 n_weight = connect->index->n_weight_back;
  register int	n; 

  for( n=0; n < n_weight ; n++, to_indP++, w_indP++, from_indP++ ) {
    changeP[*w_indP] += todelta[*to_indP] * fromactv[*from_indP];
  }
  return( OK );
}

change_weight_sparse_batch_do( connect )	/* non-uniform connection */
CONNECT	*connect ;
{
  int	 *w_indP = connect->index->weight_back;
  int	 n_weight = connect->index->n_weight_back;
  WEIGHT *weight   = connect->weight;
  WEIGHT *d_weight = connect->d_weight;
  WEIGHT *changeP = connect->change;
  REAL lrate = connect->tolayer->etascale * ETA ;
  register int	n;
  for( n=0; n < n_weight ; n++, w_indP++ ) {
    d_weight[*w_indP] = changeP[*w_indP] * lrate + ALPHA* d_weight[*w_indP];
    weight[*w_indP] += d_weight[*w_indP];
  }
  w_indP = connect->index->weight_back;
  for( n=0; n < n_weight ; n++, w_indP++ ) {
    changeP[*w_indP] = 0;
  }
  return( OK );
}

change_weight_sparse_( connect )	/* non-uniform connection */
CONNECT	*connect ;
{
  int	 *w_indP = connect->index->weight_back;
  int	 *from_indP = connect->index->from_back;
  int	 *to_indP = connect->index->to_back;
  int	 n_weight = connect->index->n_weight_back;
  WEIGHT *weight   = connect->weight;
  WEIGHT *d_weight = connect->d_weight;
  REAL *todelta  = &connect->tolayer->delta[ connect->to_start ];
  REAL *fromactv = &connect->fromlayer->actv[ connect->from_start ];
  REAL lrate = connect->tolayer->etascale * ETA ;
  register int	n;

  for( n=0; n < n_weight ; n++, to_indP++, w_indP++, from_indP++ ) {
    d_weight[*w_indP] = todelta[*to_indP] * lrate * fromactv[*from_indP] 
      			+ ALPHA* d_weight[*w_indP];
    weight[*w_indP] += d_weight[*w_indP];
  }

  return ( OK );
}
#endif non-allie

input_to_layer ( layer, input ) /* copy input to a layer */
LAYER	*layer;
INPUT	*input;
{
  register int i;
  REAL   *actvP = layer->actv ;
  REAL   *valueP = input->value ;

  for( i = min(input->n_value, layer->n_unit); i ; i--, actvP++, valueP++ )
    *actvP = *valueP ;
  return ( OK );
}

delta_out_arg( ptr, target )
LAYER **ptr; TARGET *target;
{
  return( (*ptr)->type == Linear? delta_out_linear( *ptr, target ) :
	 			  delta_out_logistic( *ptr, target ) );
}

delta_out_logistic ( layer, target ) 	/* compute delta at output layer */
LAYER	*layer;
TARGET	*target;
{
  register int	i;
  int    n_unit = layer->n_unit;
  int    n_target = target->n_value;
  REAL *targetP = target->value;
  REAL *errorP = target->error;
  REAL *deltaP = layer->delta;
  REAL *actvP = layer->actv;
  REAL delta1;
  REAL range = MAXACTV-MINACTV;
  REAL middle = range*0.5+MINACTV;
/*REAL careoff_delta = CAREOFF/(MAXACTV-MINACTV)? (MAXACTV-MINACTV):1;*/
  target->error_sum =.0;
  for(i=0; i<n_unit && i<n_target;i++, targetP++, errorP++, deltaP++, actvP++){
    if ( *targetP == DONT_CARE ) { *errorP = *deltaP = 0.0; continue; }
    delta1 = *targetP - *actvP ;
    if( CAREOFF != 1.0 && *targetP < middle ) delta1 *= CAREOFF;
    *errorP = delta1*delta1 ;
    target->error_sum += *errorP ;
    *deltaP = delta1 * (*actvP - MINACTV) * (MAXACTV - *actvP) ;
    if( range != 1.0) *deltaP /= range;
  }
  target->error_sum /= 2 * i ;	/* error per unit */
  target->outlayer = layer ;
  return ( OK );
}
 	/* compute delta at a linear output layer */
delta_out_linear ( layer, target )
LAYER	*layer;
TARGET	*target;
{
  register int	i;
  int    n_unit = layer->n_unit;
  int    n_target = target->n_value;
  REAL *targetP = target->value;
  REAL *errorP  = target->error;
  REAL *deltaP  = layer->delta;
  REAL *actvP   = layer->actv;

  target->error_sum =.0;
  for(i=0; i<n_unit && i<n_target;i++, targetP++, errorP++, deltaP++, actvP++){
    if ( *targetP == DONT_CARE )
      { *errorP = *deltaP = 0.0; continue; }
    *deltaP = *targetP - *actvP ;     /* actv func is linear */
    if ( *targetP == MINACTV && CAREOFF != 1.0 ) *deltaP *= CAREOFF;
    *errorP = *deltaP * *deltaP ;
    target->error_sum += *errorP ;
  }
  target->error_sum /= 2 * i ;	/* error per unit */
  target->outlayer = layer ;
  return ( OK );
}

#ifndef allie	/* defined in farith.f for AllieNet */
copy_vector_( vector1, vector2, nvector )
REAL	*vector1, *vector2;
int	*nvector;
{
  bcopy( vector1, vector2, sizeof(REAL) * *nvector);
  return ( OK );
}
#endif

increment_vector_( vector1, vector2, nvector )
REAL	*vector1, *vector2;
int	*nvector;
{
  register int i;
  for( i= *nvector; i; i--, vector1++, vector2++ ) *vector2 += *vector1;
  return ( OK );
}

decrement_vector_( vector1, vector2, nvector )
REAL	*vector1, *vector2;
int	*nvector;
{
  register int i;
  for( i= *nvector; i; i--, vector1++, vector2++ ) *vector2 -= *vector1;
  return ( OK );
}

multiply_vector_( vector1, vector2, nvector )
REAL	*vector1, *vector2;
int	*nvector;
{
  register int i;
  for( i= *nvector; i; i--, vector1++, vector2++ ) *vector2 *= *vector1;
  return ( OK );
}

divide_vector_( vector1, vector2, nvector )
REAL	*vector1, *vector2;
int	*nvector;
{
  register int i;
  REAL *divider=vector1;
  for( i= *nvector; i; i--, divider++ ) 
    if( *divider == 0.0 ) Erreturn("division by zero");
  for( i= *nvector; i; i--, vector2++, vector1++ ) *vector2 /= *vector1;
  return ( OK );
}

input_layer_arg( input, layer )
LAYER **layer; REAL *input;
{
  return( input_layer( input, *layer ));
}

input_layer( input, layer )
LAYER *layer; INPUT *input;
{
  bcopy( input->value, layer->actv, 
	sizeof(REAL) * min( layer->n_unit, input->n_value ) );
  return(OK);
}

/* no set_vector_to_vector(). use copy_vector() to set  vector to vector */

set_vector_to_int ( n, vector, nvector )	/* vector = n */
int	*n;
REAL	*vector;
int     *nvector;
{
  register int i;
  for( i = 0 ; i < *nvector ; i++ ) vector[i] = (REAL) *n ;
  return ( OK );
}

set_int_to_int ( n1, n2 )	/* n2 = n1 */
int	*n1, *n2;
{
  *n2 = *n1 ;
  return ( OK );
}

set_vector_to_float ( x, vector, nvector ) /* vector = x */
REAL	*x, *vector;
int     *nvector;
{
  register int i;
  for( i = 0 ; i < *nvector ; i++ ) vector[i] = *x ;
  return ( OK );
}

increment_vector_with_float ( x, vector, nvector ) /* vector += x */
REAL	*x, *vector;
int     *nvector;
{
  register int i;
  for( i = *nvector ; i ; i--, vector++ ) *vector += *x ;
  return ( OK );
}

decrement_vector_with_float ( x, vector, nvector ) /* vector += x */
REAL	*x, *vector;
int     *nvector;
{
  register int i;
  for( i = *nvector ; i ; i--, vector++ ) *vector -= *x ;
  return ( OK );
}

multiply_vector_with_float ( x, vector, nvector ) /* vector *= x */
REAL	*x, *vector;
int     *nvector;
{
  register int i;
  for( i = *nvector ; i ; i--, vector++ ) *vector *= *x ;
  return ( OK );
}

divide_vector_with_float ( x, vector, nvector ) /* vector /= x */
REAL	*x, *vector;
int     *nvector;
{
  register int i;
  for( i = *nvector ; i ; i--, vector++ ) *vector /= *x ;
  return ( OK );
}

choose_max ( ex1, ex2 )
EXPRESS *ex1, *ex2;
{
  register int i;
  REAL max = MINACTV;
  int    max_i = -1;
  REAL *vec1, *vec2; int nvalue1,nvalue2;

  if( Err(evalExpression(ex1)) || Err(evalExpression(ex2))) return(ERR);
  vec1 = ex1->vector->value; nvalue1 = ex1->vector->nvalue;
  vec2 = ex2->vector->value; nvalue2 = ex2->vector->nvalue;

  for ( i=0; i< nvalue1 ; i++, vec1++ ) 
    if ( max < *vec1 ) {
      max = *vec1 ;
      max_i = i;
    }

  for ( i=0; i< nvalue2 ; i++ )  vec2[i] = MINACTV;
  if( max_i >= nvalue2 ) 
    Erreturn1("index for maximum value %d output range",max_i )
  if( max_i >= 0 ) vec2[max_i] = MAXACTV ;

  return ( OK );
}

choose_max_threshold ( ex1, ex2, expThresh )
EXPRESS *ex1, *ex2, *expThresh;
{
  register int i;
  REAL max = MINACTV;
  int    max_i = -1;
  REAL *vec1, *vec2, threshold; int nvalue1,nvalue2;

  if( Err(evalExpression(ex1)) || Err(evalExpression(ex2)) ||
      Err(evalExpression(expThresh)) ) return(ERR);
  vec1 = ex1->vector->value; nvalue1 = ex1->vector->nvalue;
  vec2 = ex2->vector->value; nvalue2 = ex2->vector->nvalue;
  threshold = expThresh->vector->value[0];

  for ( i=0; i< nvalue1 ; i++, vec1++ ) 
    if ( max < *vec1 && *vec1 >= threshold ) {
      max = *vec1 ;
      max_i = i;
    }

  for ( i=0; i< nvalue2 ; i++ )  vec2[i] = MINACTV;
  if( max_i >= nvalue2 ) 
    Erreturn1("index for maximum value %d output range",max_i )
  if( max_i >= 0 ) vec2[max_i] = MAXACTV ;

  return ( OK );
}

index_max ( vector1, vector2, nvector )
     REAL *vector1, *vector2;
     int    *nvector;
{
  register int i;
  REAL max;
  int    max_i = 0;

  for ( max= *(vector1++), i= *nvector-1; i ; i--, vector1++ ) 
    if ( max < *vector1 ) {
      max = *vector1 ;
      max_i = *nvector-i;
    }
  *vector2 = max_i ;
  return ( OK );
}

if_( ex, doit)
EXPRESS *ex; int *doit;
{
  register int i, nval; register REAL *val;
  VECTOR *vec = (*ex->evalfunc)( ex );
  IfErr( vec ) return( ERR );
  for( val=vec->value,nval=vec->nvalue, i=0; i<nval; i++, val++ ) 
    if( *val != TrueVal ) { return( *doit==NOTSKIP? SKIP : OK ); }
  return( *doit==NOTSKIP? OK : *doit );
}

here_(doit)
int *doit;
{
  return( *doit );
}

if_then( ex, procP )
EXPRESS *ex; PROCED *procP;
{
  register int i, nval; register REAL *val; int status;
  VECTOR *vec = (*ex->evalfunc)( ex );
  IfErr( vec ) return( ERR );
  for( val=vec->value, nval=vec->nvalue, i=0; i< nval ; i++, val++ ) 
    if( *val != TrueVal ) return( OK );
  return( ENDIF==(status=execute_procedure( procP))? OK : status );
}

if_then_else( ex, proc1, proc2 )
EXPRESS *ex; PROCED *proc1, *proc2;
{
  register int i, nval; register REAL *val;int status;
  VECTOR *vec = (*ex->evalfunc)( ex );
  IfErr( vec ) return( ERR );
  for( val=vec->value, nval=vec->nvalue, i=nval; i ; i--, val++ ) 
    if( *val != TrueVal ) 
      return( ENDIF==(status=execute_procedure( proc2))? OK : status );
  return( ENDIF==(status=execute_procedure( proc1))? OK : status );
}
#if 0 /* if then .. elseif .. -- not worked out yet in setup.c */
if_then_elseif( ifthen )
IFTHEN *ifthen;
{
  EXPRESS *ex = ifthen->ex;
  register int i, nval; register REAL *val;int status;
  VECTOR *vec;
  IfErr( ex ) /* just 'else' so do it unconditionally */
    return( ENDIF==(status=execute_procedure(ifthen->proc))? OK : status );
  IfErr(vec = (*ex->evalfunc)( ex )) return( ERR );
  for( val=vec->value, nval=vec->nvalue, i=nval; i ; i--, val++ ) 
    if( *val != TrueVal )
      return( ifthen->next? if_then_elseif( ifthen->next ): OK );
  return( ENDIF==(status=execute_procedure(proc))? OK : status );
}
#endif 0
while_do( ex, procP )
EXPRESS *ex; PROCED *procP;
{
  int status, i, nval;
  VECTOR *vec;
  REAL *val;
  while( 1 ) {
    IfErr( vec = (*ex->evalfunc)(ex)) return(ERR);
    for(i=0, nval=vec->nvalue, val=vec->value; i<vec->nvalue; i++, val++) 
      if( *val != TrueVal ) return(OK);		/* condition failed */
    if( (status = execute_procedure(procP)) != OK ) {
      if( status == CONTINUE ) continue;
      return(status==ENDWHILE? OK : status);
    }
  }
}

repeat( ex, procP )
     EXPRESS *ex; PROCED    *procP;
{
  register int i, repeat;
  int status; VECTOR *vec;
  IfErr( vec = (*ex->evalfunc)(ex)) return(ERR);
  repeat = (int) vec->value[0]+0.00001;   /* value may not be accurate*/  
  for( i=repeat; i; i-- )
    if( (status = execute_procedure(procP)) != OK ) {
      if( status == CONTINUE ) continue;
      return(status==ENDREPEAT? OK : status);
    }
  return( OK );
}

REAL squish_();

logistic ( layer )
LAYER	*layer;
{
  register int i;
  REAL *actvP = layer->actv;
  REAL *netP  = layer->net;
  REAL *biasP = layer->bias;
  int    n_unit = layer->n_unit;

  for ( i=0; i< n_unit ; i++, actvP++, netP++, biasP++ )
    *actvP = _logistic( *netP  + *biasP );
  return ( OK );
}

activation_arg ( ptr ) LAYER **ptr; 
{ return( (*ptr)->type==Linear? linear(*ptr) : logistic( *ptr ) ); }

linear ( layer )
LAYER   *layer;
{
  register int i;
  REAL *actvP = layer->actv;
  REAL *netP  = layer->net;
  REAL *biasP = layer->bias;
  int    n_unit = layer->n_unit;

  for ( i=0; i< n_unit ; i++, actvP++, netP++, biasP++ ) {
    *actvP = *netP + *biasP ;
  }
  return ( OK );
}

delta_logistic ( layer )     /* compute delta's in logistic layer */
LAYER	*layer;
{
  register int i;
  int    n_unit = layer->n_unit;
  REAL *actvP = layer->actv;
  REAL *deltaP = layer->delta;
  REAL der , range = MAXACTV-MINACTV;

  for ( i=0; i< n_unit ; i++, deltaP++, actvP++ ) {
    der = (*actvP - MINACTV) * (MAXACTV - *actvP) ;
    if( range != 1.0) der /= range;
    *deltaP *= der;
  }
  return ( OK );
}

delta_arg ( ptr ) LAYER **ptr; 
{ return( (*ptr)->type==Linear? delta_linear(*ptr) : delta_logistic( *ptr ) );}

delta_linear ( layer )        /* compute delta's in linear layer */ 
LAYER	*layer;
{               /* delta's are already computed by 'backward' */
  return( OK );
}

clear_delta ( layer )
LAYER	*layer ;
{
  bzero( layer->delta, sizeof(REAL)*layer->n_unit );
  return ( OK );
}

clear_delta_arg( ptr ) LAYER **ptr; { return( clear_delta( *ptr )); }

clear_delta_net ( net )
NETWORK *net;
{
  register int n;
  for ( n = 0 ; n < net->n_layer ; n++ ) 
    clear_layer ( &net->layer[n] );
  return ( OK );
}

clear_layer ( layer )	/* clears net input and delta in a layer */
LAYER	*layer ;
{
  int nbyte = sizeof(REAL)*layer->n_unit;
  bzero( layer->delta, nbyte );
  bzero( layer->net, nbyte );
  return ( OK );
}

clear_layer_arg( ptr ) LAYER **ptr; { return( clear_layer( *ptr )); }

put_target ( net, values, nvalue ) /* copy values to target */
NETWORK *net;
REAL	*values;
int	nvalue;
{
  if ( net->target.n_alloc < nvalue ) {
/*  sendMsg("target buffer too small - resizing\n"); */
    IfErr( resize_target( &net->target, &nvalue ) ) return(ERR);
  }
  copy_vector_(values, net->target.value, &nvalue );
  net->target.n_value = nvalue;
  return ( OK );
}

resize_target( target, nvalue )
TARGET *target; int *nvalue;
{
  if( target->n_alloc >= *nvalue ) { target->n_value = *nvalue; return(OK); }
  if( target->value ) free( target->value );
  if( Err( target->value = new_array_of( *nvalue, REAL ) ) ||
      Err( target->error = new_array_of( *nvalue, REAL ) ))
    Erreturn("not enough memory");
  target->n_alloc = target->n_value = *nvalue;
  return( OK );
}

put_input ( net, values, nvalue ) /* copy values to input */
NETWORK *net;
REAL	*values;
int	nvalue;
{
  if ( net->input.n_alloc < nvalue ) {
/*  sendMsg("input buffer too small - resizing\n"); */
    IfErr( resize_input( &net->input, &nvalue ) ) return(ERR);
  }
  copy_vector_(values, net->input.value, &nvalue );
  net->input.n_value = nvalue;
  return ( OK );
}

resize_input( input, nvalue )
INPUT *input; int *nvalue;
{
  if( input->n_alloc >= *nvalue ) { input->n_value = *nvalue; return(OK); }
  if( input->value ) free( input->value );
  IfErr( input->value = new_array_of( *nvalue, REAL ) )
    Erreturn("not enough memory");
  input->n_alloc = input->n_value = *nvalue;
  return( OK );
}

copy_error ( value, target )
REAL	*value;
TARGET	*target;
{
    *value = target->error_sum ;
    return( OK );
}

REAL
get_error( net )
NETWORK	*net;
{
    return( net->target.error_sum );
}

clear_net( net )
NETWORK	*net;
{
  register int n;
  LAYER *layerP;
  int    nunit;

  for ( n = 0 ; n < net->n_layer ; n++ ) {
    layerP = &net->layer[n] ;
    nunit = layerP->n_unit;
    clear_array( layerP->actv, nunit );
    clear_array( layerP->net, nunit );
    clear_array( layerP->delta, nunit );
    clear_array( layerP->d_bias, nunit );
    if( layerP->user1 ) clear_array( layerP->user1, nunit );
    if( layerP->user2 ) clear_array( layerP->user2, nunit );
    init_bias( layerP );
  }
  for ( n = 0 ; n < net->n_connect ; n++ )
    init_connection( &net->connect[n] );
  return( OK );
}

init_connection( connectP )
CONNECT *connectP;
{
  int nweight;
  if( connectP->index ) 
    init_sparse_weight( connectP );
/*  this has been moved to make_connection() because symmetric weights
    needs to be initialized when it's first defined .
  else if(connectP->type == SYMMETRIC )
    init_symmetric_weight( connectP );  */
  else
    init_weight( connectP->from_nunit, connectP->weight, connectP->to_nunit);
  clear_array(connectP->d_weight,
	      nweight=connectP->from_nunit*connectP->to_nunit);
  if( connectP->user1 ) clear_array( connectP->user1, nweight );
  if( connectP->user2 ) clear_array( connectP->user2, nweight );
  
  return ( OK );
}

clear_dweight( net )
NETWORK *net;
{
  CONNECT *connectP;
  register int n;
  for( n = 0 ; n<net->n_connect ; n++ ) {
    connectP = &net->connect[n];
    clear_array(connectP->d_weight,connectP->to_nunit*connectP->from_nunit);
  }
  for( n=0; n < net->n_layer ; n++ ) 
    clear_array( net->layer[n].d_bias, net->layer[n].n_unit );

  return( OK );
}

clear_array( value, nvalue )
REAL value[];
int nvalue;
{
  bzero( value, sizeof(REAL)*nvalue );
  return( OK );
}

clear_2d_array( value, n1, n2 )
REAL **value;
int    n1, n2;
{
  register int i;
  for( i=0; i< n1 ; i++ ) bzero( value[i], sizeof(REAL)*n2 );
  return( OK );
}
	/* look-up table implementation of logistic function */
#define Ntbl 1024      /* logistic table size */
#define Nrange 512     /* Ntbl/2 */
/**
Netmax is the maximum net input to each unit.  It is imposed
when you compute its activation with "activation" or "logistic()" so
that the net input is bounded between netmax and -netmax.  The reason
for doing this is that, if the net input is unbounded and the weights
become sufficiently large the unit may get stuck in a flat region of
the logistic function, unable to get out because such a region has
very small derivative.
**/
REAL
_logistic( x ) REAL x;
{
  static	REAL logi_tbl[ Ntbl ];
  static	REAL	Max, Min;
  static	REAL scale, netmax;
  register int index;
  REAL y;

  /*if any of MAXACTV/MINACTV/NETMAX has been changed, recalculate the table */

  if( Max != MAXACTV || Min != MINACTV || netmax != NETMAX ) {
    Max = MAXACTV; Min = MINACTV;
    netmax = NETMAX; scale = ((REAL) Nrange) / netmax ;
    for( index = 0; index < Ntbl; index++ ) {
      y = ((REAL) (index-Nrange))/  scale ;
      logi_tbl[index] = (Max-Min) / (1. + exp( -y )) +Min;
    }
  }

  /* convert x [-netmax,netmax] into index [0, 2*Nrange] */

  y = (REAL) Nrange + x *  scale ;
  index = (int) y ;
  if( index >= Ntbl-1 ) 	return( logi_tbl[ Ntbl-1 ] );
  if( index < 0 ) 		return( logi_tbl[ 0 ] );
  return( logi_tbl[index]
	 + (y - (REAL) index) * (logi_tbl[index+1] - logi_tbl[index]));
}

REAL
rlogistic( x ) REAL x; {
	return( (MAXACTV-MINACTV) / (1.+(REAL)exp((double) -x)) +MINACTV);
}

REAL
_logistic_der( o ) REAL o;
{
	return( (o - MINACTV) * (MAXACTV - o) / ( MAXACTV - MINACTV ) );
}


read_weight( stream, net, name )/* read in weight type specification matrix */
FILE	*stream;
NETWORK	*net;
char	*name;
{
  CONNECT	*connectP;
  IfErr( connectP = which_connection( net, name ) ) return( ERR );
	/* need to allocate index here because fread_weight_in_connection()
	   doesn't know if it's from weight file or weight specification 
	   so may go on reading without allocating index. */
  IfErr( connectP->index ) {
    connectP->index = new( WINDEX );
    allocate_index(connectP->index, connectP->from_nunit*connectP->to_nunit, 
		   connectP->from_nunit, connectP->to_nunit);
  }
  IfErr( fread_weight_in_connection( stream, connectP ) )
    Erreturn2("%s: reading weights for connection %s", ERR_MSG,connectP->name);
  return( OK );
}

void delete_net( net )
NETWORK	*net;
{
  register int n;
  for( n = 0 ; n < net->n_layer ; n++ ) delete_layer( &net->layer[n] );
  for( n = 0 ; n < net->n_array ; n++ ) delete_array( &net->array[n] );
  for( n = 0 ; n<net->n_connect ; n++ ) delete_connection( &net->connect[n]);
  for( n=0 ; n<net->n_procedure ; n++ ) delete_procedure( &net->procedure[n]);
  for( n = 0 ; n < net->n_intvar; n++ )	delete_intvar( &net->intvar[n]);
  for( n= 0 ; n< net->n_floatvar; n++ ) delete_floatvar( &net->floatvar[n]);
  for( n= 0; n< net->n_libfile; n++ ) free( net->libfile[n] );
  delete_define();
  if( net->input.value ) free( net->input.value );
  if( net->target.value ) free( net->target.value );
  if( net->target.error ) free( net->target.error );

  free( net );
}

void delete_layer( layerP )
  LAYER   *layerP ;
{
  free( layerP->name );
  free( layerP->actv );
  free( layerP->net );
  free( layerP->delta );
  free( layerP->bias );
  free( layerP->d_bias );
  if( layerP->user1 ) free( layerP->user1 );
  if( layerP->user2 ) free( layerP->user2 );
}

void delete_connection( connectP )
  CONNECT *connectP ;
{
  free( connectP->name );
  free( connectP->weight );
  free( connectP->d_weight );
  if( connectP->user1 ) free( connectP->user1 );
  if( connectP->user2 ) free( connectP->user2 );
}

void delete_array( arrayP )
     ARRAY *arrayP;
{
  free( arrayP->name );
  free( arrayP->value );
}

void delete_procedure( procP )
     PROCED *procP;
{
  int i;
  if( procP->name ) free( procP->name );
  if( procP->iconst ) free( procP->iconst );
  if( procP->fconst ) free( procP->fconst );
  if( procP->action ) {
    for( i=0; i< procP->n_action; i++ )
      if( procP->action[i].name ) free( procP->action[i].name );
    free( procP->action );
  }
  for( i=0; i< procP->n_expr; i++ ) {
    delete_expression( procP->expr[i] ); procP->expr[i] = NULL;
  }
  for( i=0; i< procP->n_vector; i++ ) {
    delete_vector( procP->vector[i] ); procP->vector[i] = NULL;
  }
  procP->name = NULL, procP->iconst = NULL,
  procP->fconst = NULL, procP->action = NULL;
  procP->n_action = procP->n_int = procP->n_float = procP->n_expr = 0;
}

void delete_expression( ex )
EXPRESS *ex;
{
  if( ex == NULL ) return;
  switch( ex->type ) {
  case Assign:		/* delete both arguments (vector not used) */
    delete_expression( ex->arg1 ), delete_expression( ex->arg2 );
    break;
  case BinaryOp:	/* delete both arguments and vector */
    delete_expression( ex->arg1 ), delete_expression( ex->arg2 );
    delete_vector( ex->vector ); break;
  case UnaryFunc:	/* only one argument */
    delete_expression( ex->arg1 ); delete_vector( ex->vector ); break;
  case RangeOp:		/* vector is terminal - don't delete */
    delete_expression( ex->start ); delete_expression(ex->end); 
    delete_vector_struct( ex->vector ); break;
  case Terminal:
    delete_vector_struct( ex->vector ); break;
    			/* don't delete terminal values */
  default:
    break;
  }
  if(ex->name) free( ex->name );
  ex->arg1 = ex->arg2 = ex->start = ex->end = NULL;
  ex->vector=NULL, ex->name =NULL; 
  free( ex );
}

void delete_vector( vector )
VECTOR *vector;
{
  IfErr(vector) return;
  if(vector->value) free( vector->value );
  if(vector->name) free( vector->name );
  vector->value = NULL, vector->name = NULL;
  free( vector );
}

void delete_vector_struct( vector )	/* free vector except the value */
VECTOR *vector;
{
  IfErr(vector) return;
  if(vector->name) free( vector->name );
  vector->value = NULL, vector->name = NULL;
  free( vector );
}

void delete_intvar( intvarP )
     INTVAR *intvarP;
{
  if( intvarP->name ) free( intvarP->name ); intvarP->name = NULL;
}

void delete_floatvar( floatvarP )
     FLOATVAR *floatvarP;
{
  if( floatvarP->name ) free( floatvarP->name ); floatvarP->name = NULL;
}
