/* $Header: /soma/users/miyata/planet/src/RCS/graphcomm.c,v 5.6.0.4 91/02/13 15:42:17 miyata Exp $ */
static char rcsid[] = "$Header: /soma/users/miyata/planet/src/RCS/graphcomm.c,v 5.6.0.4 91/02/13 15:42:17 miyata Exp $";
/********************** source file graphcomm.c ***************************
  	Graphcomm.c contains functions that implements user commands
involving graphics.  Functions for non-graphics user commands are in
sunnet.c.  Each function corresponds to a user command.  E.g., the
function c_display is called when the user types in the user command
"display".  For each function, the argument argn contains the number of
arguments typed in by the user.  The argument args contains the
arguments typed by the user as an array of character strings.  See
the file sunnetcomm.c for the list of user commands and their
corresponding functions.  Graphics routines used in the functions
defined here are defined either in display.c (sunnet dependent
routines) or in graph.c (sunnet independent general basic routines).
*****************************************************************************/
/******************************** UPDATES **********************************
graphcomm.c:
12/4/90:  can transpose a vector.  transpose in 'response'.
12/4/90:  fixed bug in c_display - do transpose right.
10/19/90: fixed bug in c_screen - unclosed file pointer.
4/15/90: X/Y range specification for plots.
4/6/90:  'window' generates commands to recreate current windows.
2/6/90: fixed c_graph() so that graph is erased before being moved in xnet.
2/6/90: fixed c_response() so flag names can match any substring.
1/31/90: worked on c_display(), c_dlist(), c_response(), so flag and -flag
  	   both work properly; if no flag, parameter is the default.
1/25/90: changed c_dlist() so flags can be expressions. also flag name can
  	   match any substring of it.
****************************************************************************/

#include <stdio.h>
#include <math.h>
#include <sys/file.h>
#include <sys/types.h>			/* types.h & stat.h */
#include <sys/stat.h>			/* for stat() function */
#include "net.h"
#include "error.h"
#include "alloc.h"
#include "command.h"
#include "graph.h"
#include "sunnet.h"
#include "userdefs.h"
#include "msg.h"
#include "version.h"
#include "color.h"

#ifdef use_mouse
#undef use_mouse
#endif
#if sunnet|xnet
#define use_mouse 1
#endif

#define Nfilename Largs			/* max length of file name */

#define min(x,y) ((x)>(y)? (y):(x))
#define max(x,y) ((x)>(y)? (x):(y))

GRAPH	*Graph;				/* graph window pointer */

#define Ntext 160			/* max length of text in text window */
char	Text[ Ntext ];

#define MaxWindow 256			/* max # of windows */ 
int	Nwindow;			/* # of windows currently open */
WINDOW	*Window[ MaxWindow ];		/* window pointers */ 
int	wind;
#define Llabel 128			/* # of characters for labels */

extern	char **Plabel;

#define MaxPlot 100
int	Nplot = 0;
GRAPH	*Plot[ MaxPlot ];

void reset_prompt(), add_prompt();

/**
.CO "graph" "initialize/manipulate graph for plotting"	GRAPH-COMMAND
.SY "graph new [place]/graph {erase/clear/same/extend/close/open}/ graph"
.BI
\fBgraph new\fP initialize a graph display for plotting various
network states.  It prompts the user for ranges of X (steps) and Y
(values in network) values, and how the axes should be numbered.  The
X and Y ranges can be specified by a flag starting with 'x' or 'y':
for example, if \fBx0-300@50\fP appears anywhere on the line, the graph
will be initialized with the X ranging from 0 to 300, and with the X axis
numbered at intervals of 50.
.NI
\fBgraph new place\fP initializes a graph and lets the user position
the graph with a mouse button.  For SunNet, click any button twice to
position two opposite corners of the graph.  For XNet, depress a
button at one corner and release it at the opposite corner.  This
feature is not available in PlaNet or AllieNet.  Use a wN flag below
instead.
.NI
\fBgraph new wN\fP initializes a graph and places it within window #N.
.NI
\fBgraph extend\fP changes the ranges of X and Y axes of the graph.
It prompts the user for the new values.  The minimum values cannot be
changed in the current version.  The original content of graph is
properly scaled and reappears in the new graph.  This has not been
implemented in XNet, however, and the original content will be lost.
.NI
\fBgraph move\fP lets the user reposition the graph with a mouse button.
.NI
\fBgraph erase\fP deletes the current graph.
.NI
\fBgraph clear\fP and \fBgraph same\fP clear the content of the
current graph, and redraw the axes.
.NI
\fBgraph close\fP closes (hides) the current graph, \fBgraph open\fP opens it.
.NI
\fBgraph\fP plots the current items in graph list.  Parameters \fIgraph\fP
and \fImark\fP can be set to periodically plot items in graph list while
running \fBcycle\fP.
See help for \fBcycle\fP and \fBglist\fP.~H
See commands \fBcycle\fP and \fBglist\fP.~R
.EE
**/
c_graph( argn, args )
int	argn; char args[][ Largs ];
{
  static float	start_x=0.0, range_x = 300.0, end_x, num_x=100.0;
  static float	start_y=0.0, end_y=0.1, num_y=0.02;
/* static float	graph_x=0.0, graph_y=0.0, graph_width=0.0,graph_height=0.0;
*/
  BOX gFrame ;
  int	i,nwin; char label[BUFSIZE];
  CheckGraphics();
  if( argn < 1 ) return( graph_items( Graph, Step,(GraphLog==ON)? 1:0, 0 ));
  IF( args[0], "command" ) {
    if(Err(Graph)||Err(Graph->Window)) return(OK);
    copy_box_size( &Graph->Window->frame, &gFrame );
    sendMsg6("graph new x%g-%g@%g y%g-%g@%g", 
	     start_x,end_x,num_x,start_y,end_y,num_y);
    sendMsg4(" X%g,%g Y%g,%g\n",
	     gFrame.x, gFrame.width,gFrame.y,gFrame.height);
    return(OK);
  }
  IF(args[0], "new" ) {
    start_x = Step; end_x = Step+range_x;
    IfErr(get_flag_fff(argn-1, args[1], "x%f-%f@%f", &start_x,&end_x,&num_x)) {
      get_value_for( "X start", &start_x );
      get_value_for( "X end", (end_x=start_x+range_x, &end_x) ); 
      if((range_x = end_x - start_x)< num_x) num_x * 0.5;
      get_value_for( "X number", &num_x );
    }
    IfErr(get_flag_fff(argn-1, args[1], "y%f-%f@%f", &start_y,&end_y,&num_y)) {
      get_value_for( "Y start", &start_y );
      get_value_for( "Y end", &end_y );
      get_value_for( "Y number", &num_y );
    }
    range_x = end_x - start_x;
    if( Graph ) wipe_graph( Graph );
    else {
      IfErr( Graph = new( GRAPH ) ) Erreturn("not enough core");
      IfErr(initialize_graph( Graph )) return(ERR);
    }
    IfErr( make_graph( Graph, start_x, end_x, num_x, start_y, end_y, num_y,
		     (GraphLog==ON)? "log error as a function of epoch":
		      "error as a function of epoch" ))
      Erreturn1( "%s: in initializing graph.", ERR_MSG);
    if( argn > 1 ) {
      IF( args[1], "place" ) {
#ifdef use_mouse
	sendMsg("Use mouse button to locate two corners of graph.\n");
	IfErr( locate_graph( Graph ) ) return( ERR );
#else
	Erreturn("Please specify window (wN): mouse available only in SunNet");
#endif
      }
      else if( get_flag_i( argn, args, "w%d", &nwin ) ) {
	IfErr( Window[nwin] ) Erreturn1("window #%d not open", nwin);
	IfErr(copy_window_size( Window[nwin], Graph->Window )) return( ERR );
	wipe_window( Window[nwin] );
      }
      else {
	if(get_flag_ff(argn-1, args[1], "X%f,%f",&gFrame.x,&gFrame.width)&&
	   Err(set_graph_size( Graph, 
			      gFrame.x,gFrame.y,gFrame.width,gFrame.height)))
	  return(ERR);
	if(get_flag_ff(argn-1,args[1], "Y%f,%f",&gFrame.y,&gFrame.height)&&
	   Err(set_graph_size( Graph, 
			      gFrame.x,gFrame.y,gFrame.width,gFrame.height)))
	  return(ERR);
      }
    }
    IfErr( draw_graph(Graph )) Erreturn1("%s: cannot clear graph", ERR_MSG);
#if 0
    IfErr( plot_error( Graph, Npattern+1, 0, 0.0, 0 ) ) 
      Erreturn1("%s: in initializing graph.",ERR_MSG);
#endif 
    initialize_graph_list();
  }
  else IfErr( Graph ) { Erreturn("graph not open - use 'graph new'"); }

  else IF(args[0], "move" ) {
#if xnet
    wipe_graph( Graph );
#endif
    if( argn > 1 && get_flag_i( argn, args, "w%d", &nwin ) ) {
      IfErr( Window[nwin] ) Erreturn1("window #%d not open", nwin);
      IfErr(copy_window_size( Window[nwin], Graph->Window )) return(ERR);
      wipe_window( Window[nwin] );
    }
    else {
#ifdef use_mouse
      sendMsg("Use mouse button to locate two corners of graph.\n");
      IfErr( locate_graph( Graph ) ) return( ERR );
#else
      Erreturn("Please specify window (wN): mouse available only in SunNet/XNet");
#endif
    }
    if(Err( extend_graph( Graph, end_x, num_x, end_y, num_y )) ||
       Err(graph_saved_items( Graph ))) return(ERR);
    return(OK);
  }
  else IF(args[0], "extend" ) {
    get_value_for( "X end", &end_x ); 
    get_value_for( "X number", &num_x ); 
    get_value_for( "Y end", &end_y ); 
    get_value_for( "Y number", &num_y ); 
    if(Err(extend_graph( Graph, end_x, num_x, end_y, num_y )) || 
       Err(graph_saved_items( Graph ))) return(ERR);
    return(OK);
  }
  else IF( args[0], "clear" ) {
    IfErr( clear_graph(Graph )) Erreturn1("%s: cannot clear graph", ERR_MSG);
    IfErr( plot_error( Graph, Npattern+1, 0, 0.0, 0 ) ) 
      Erreturn1("%s: in initializing graph.",ERR_MSG);
    visible_graph( Graph );
    initialize_graph_list();
  }
  else IF(args[0],"mark") 
    return(graph_items(Graph,Step,(GraphLog==ON)? 1:0, 1 ));
  else IF( args[0], "erase" ) wipe_graph( Graph );

  else IF( args[0], "same" ) return( c_graph( 1, "clear" ) );

  else IF( args[0], "close" ) invisible_graph( Graph );

  else IF( args[0], "open" ) visible_graph( Graph );

  else IF( args[0], "label" ) {
    for( label[0] = NULL, i=1; i < argn; i++ ) 
      sprintf( label, "%s %s", label, args[i]);
    label_graph( Graph, label );
  }
  else Erreturn( get_syntax( "graph" ));
  return( OK );
}

get_value_for( name, value )
char	*name; float	*value;
{
  sprintf( Msg, "  %s=%g change to: ", name, *value );
  IfErr( askUserInput( Msg, sizeof(Msg), Msg, sizeof(Msg) ) ) return(ERR);
  sscanf( Msg, "%f", value );
  return(OK);
}
/**
.CO "glist" "specify items to be plotted in graph"	LIST-COMMAND
.SY "glist <variable> Mark [Scale] "
.BI
Adds an item to the graph list, a list of items be plotted in the
graph.  An item is any single value in a vector.
Type \fBhelp vector\fP about vectors.~H 
See the section on \fBvector\fP.~R
.Ni
Mark is a character used for marking each item in the graph (eg. +,
-, $, 0, 1, 2,..)  Scale is the scale factor multiplied to the
value before plotting.
.Ni
The graph list is initialized for plotting the average error across all
patterns ($globalError) with no scaling.
.Ni
See command \fBgraph\fP for how to initialize a graph.
.Ni
The parameters \fIgraph\fP and \fImark\fP can be set to specify how
often items should be plotted and marked, respectevely, while running
\fBcycle\fP.
.NI
\fBglist\fP prints a numbered list of the current items.  A \fI*\fP after
a number means that item is turned on.
Type \fBhelp list\fP for how to turn on/off or remove items.~H
See \fBlist commands\fP for how to turn on/off or remove itesm.~R
.NI
\fBglist command\fP prints out glist commands that can be saved in a file
('glist command > file') and later used to set up the same glist
('source file').
.EE
**/
c_glist( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  int   nitem;
  float	scale = 1.0;
  CheckGraphics(); 
  if( argn < 1 ) return( print_glist_names() );
  if( argn == 1 ) {
    IF( args[0], "clear" ) return( graph_list( Net, "clear", NULL ) );
    IF( args[0], "error" ) return( graph_list( Net, "error", NULL ) );
    IF( args[0], "command" ) return( print_glist_commands() );
    Erreturn(get_syntax( "glist" ) );
  }
  if( EQL(args[0], "+") || EQL(args[0], "-") || EQL(args[0], "all"))
    return( list( "Graph", argn, args ));
  if( argn > 2 && Err( AtoF( args[2], scale ))) Erreturn(get_syntax("glist"));
  CheckNet();
  return( graph_list( Net, args[0], args[1][0], scale ) );
}
/**
.CO "window" "open windows for dispaly"	DISPLAY-COMMAND
.SY "window N / window NxM [W] [wN] / window {frame/erase} [N/N-M ...]"
.BI
\fBwindow N\fP (N>0) opens window # N.  Click mouse button twice to locate
two corners of the window.
.NI
\fBwindow NxM W\fP opens N times M windows and arrange them in an NxM
matrix starting from window #W (default=1, if not given).  If a flag
\fBwN\fP is present, windows are opened within window #N, which must
already exist.  Otherwise, use the mouse to locate the window(s).  In
SunNet, click mouse button twice to locate two corners of the region
in which to open windows.  In XNet, depress a button at one corner and
release it at the opposite corner.  This feature is not available in
PlaNet or AllieNet.  Use the wN flag instead.
.NI
\fBwindow frame [N/N-M ...]\fP draws frames for specified windows (or
all windows if none is specified).  Windows are specified by a list of
the form N or N-M (N through M).  Thus, \fB3 5-8 10\fP specify windows
#3, #5 through #8, and #10.  This command erases the current content
of the windows.
.NI
\fBwindow erase [window#s]\fP erases specified windows (or all windows
if none is specified).  Window #s are specified in the same way in
\fBwindow frame\fP.
.NI
\fBwindow label N <label>\fP displays the text <label> in the bottom margin
of window #N.  \fBwindow leftlabel N <label>\fP displays the label in the left margin.
.NI
\fBwindow command\fP prints out a window command for opening each of the windows
that are currently open.  This can be saved in a file ('window command > file')
and used later to create the same window configuration ('source file').
.NI
Windows can also be opened in a screen specification file. 
See section on screen specification in the SunNet documentation.
.EE
**/
/* #define GetWindowNumber( str, n ) \
    if(Err(AtoI(str,n)) || n<1 ) Erreturn1("invalid window # %s", str )
*/
#define GetWindowNumber( str, n ) \
  if(Err(eval_expression_value(Net,str,&n)) || n<1) \
  Erreturn1("invalid window # %s", str )
#define CheckWindow( n ) \
  if( n < 0 || n > MaxWindow || Err( Window[n] ) ) \
    IfErr( Window[n] ) Erreturn1("window #%d not open", n)
#define Wframe( wid ) Window[wid]->frame
void print_window_command();

c_window( argn, args )
int	argn; char args[][ Largs ];
{
  int	nwin=0;			/* number of windows to create */
  int	lwin=0, lwin2=0;	/* window no to open windows in */
  int	wstart=1;		/* open windows starting #wstart */
  int	ncol, nrow;		/* size of window matrix */
  int   i, n, n1, n2;
  char  label[BUFSIZE];
  BOX   box;
  float x=0,y=0,height=0,width=0;	/* size of window */
  CheckGraphics();
  if( argn < 1 ) {
    sendMsg2("%d window%s open.\n",
	     nwin=windows_opened(),nwin>1?"s are":" is");
    return(OK);
  }
  if( argn == 1 && EQL(args[0], "command") ) {
    print_window_command(); return( OK );
  }
  if( sscanf( args[0], "%dx%d", &nrow, &ncol ) == 2 ) { /* NxM windows */
    if( (nwin = ncol*nrow) < 1 ) Erreturn1("% windows?", args[0] );
    if( argn > 1 && AtoI( args[1], wstart )) {
      if( wstart < 1 )	Erreturn1("invalid window # %d", wstart );
      if( wstart+nwin > MaxWindow ) 
	Erreturn1("Sorry, cannot open more than %d windows",MaxWindow);
    }
    if( argn > 1 ) {	/* open windows in a region spanning two windows */
      if( get_flag_ii( argn, args, "w%d-%d", &lwin, &lwin2 ) ) {
	CheckWindow(lwin); CheckWindow(lwin2);
	merge_box( &Wframe( lwin ), &Wframe( lwin2 ), &box );
      }		/* open windows inside an existing window */
      else if( get_flag_i( argn, args, "w%d", &lwin ) ) {
	CheckWindow(lwin);
	copy_box_size( &Wframe( lwin ), &box );
      }
    }
    IfErr(open_windows(Window+wstart, nwin, ncol, MaxWindow, lwin? &box:NULL))
      return( ERR );
    if( !get_flag( argn, args, "-f" ) )	/* flag '-f' => don't frame windows */
      for( i=wstart; i< wstart+nwin; i++ ) frame_window( Window[i], i );
    sendMsg2( "opened %d window%s.\n", nwin, nwin>1? "s":"");
  }
  else IF( args[0], "frame" ) {	/* draw window frames */
    if( argn==1 ) {		/* all windows */
      for(i=0;i<MaxWindow;i++) if( Window[i] ) frame_window( Window[i], i );
    }
    else
      for( i=1; i < argn ; i++ ) {	/* draw some window frames */
	if( find_range(args[i], &n1, &n2))
	  for( n=n1; n<= n2 && n<MaxWindow; n++ ) 
	    if( n > 0 && Window[n] ) frame_window( Window[n], n );
      }
  }
  else IF( args[0], "erase" ) {
    strcpy( args[0], "window" );
    return( c_erase( argn, args ) );
  }
  else IF( args[0], "label" ) {	/* display a label below a window */
    if( argn == 1 ) Erreturn( get_syntax( "window" ) );
    GetWindowNumber( args[1], nwin );
    CheckWindow( nwin );
    label[0] = NULL;
    for( i=2; i < argn; i++ ) sprintf( label, "%s %s", label, args[i]);
    label_window( Window[nwin], label, 0 );
  }
  else IF( args[0], "leftlabel" ) { /* display a label on the left side */
    if( argn == 1 ) Erreturn( get_syntax( "window" ) );
    GetWindowNumber( args[1], nwin );
    CheckWindow( nwin );
    label[0] = NULL;
    for( i=2; i < argn; i++ ) sprintf( label, "%s %s", label, args[i]);
    label_window_left( Window[nwin] , label, 0 );
  }
  else {	/* open a single window */
    GetWindowNumber( args[0], nwin );
    if( Err(Window[nwin]) && Err( Window[nwin] = new(WINDOW)))
       Erreturn("not enough memory");
#if xnet
    wipe_window( Window[nwin] );
#endif
    if( argn == 5 ) {
      for( n=1; n < argn ; n++ ) {
	if( get_flag_eval_expr(args[n],"x",&x));
	else if( get_flag_eval_expr(args[n],"y",&y));
	else if( get_flag_eval_expr(args[n],"height",&height));
	else if( get_flag_eval_expr(args[n],"width",&width));
	else return(ERR);
      }
      if( x<=0 ) Erreturn1("invalid window position x=%g", x);
      if( y<=0 ) Erreturn1("invalid window position y=%g", x);
      if( height<=0 ) Erreturn1("invalid window size height=%g", height);
      if( width<=0 ) Erreturn1("invalid window size width=%g", width);
      IfErr(set_window_size( Window[nwin],x,y,width,height)) return(ERR);
      frame_window( Window[nwin], nwin );
      return( OK );
    }
#ifdef use_mouse
    sendMsg("Use mouse button to locate two corners of window.\n");
    IfErr( locate_window( Window[nwin] ))
      Erreturn1("%s: in creating window", ERR_MSG ); 
#else			/* use the entire display region */
    IfErr( set_window_size( Window[nwin], XMIN, YMIN, XMAX-XMIN, YMAX-YMIN))
      return(ERR);
#endif
    frame_window( Window[nwin], nwin );
  }
  return( OK );
}

/**
.CO "display" "display network states"	DISPLAY-COMMAND
.SY "display {<vector>/<connection>/<expression>} [>W] [flags]/ display"
.BI
displays <vector>, weight matrix in <connection>, or evaluated <expression>
in window #W, as a display matrix. 
Type \fBhelp vector\fP or \fBhelp expression\fP for how to specify a vector/expression.~H
See the sections on \fBvector\fP and \fBexpression\fP for how to specify ~R
a vector or an expression.~R
.Ni
If W is not given, a window should be selected with a mouse click.
.Ni
Type \fBhelp window\fP for how to open windows.~H
See \fBwindow\fP for how to open windows.~R
.Ni
Type \fBhelp display-matrix\fP for attributes of display matrix.~H
See \fBdisplay attributes\fP below for attributes of display matrix.~R
.Ni
Flags can be given to \fBdisplay\fP to specify these parameters temporarily.
Type \fBhelp display-flags\fP for details.~H
See \fBdisplay flags\fP for details.~H
.Ni
Example: \fBdisplay <connection> t s u4.0 >2\fP will display weight
matrix in <connection>, in transposed form, arranged in a matrix of
squares with display unit of 4.0 to window #2.
.Ni
As a special case, \fBdisplay <connection>[][n] ..\fP displays the weights going
into the n'th unit receiving the connections.
.NI
\fBdisplay\fP displays the items in display list.
Type \fBhelp dlist\fP for how to set up display list.~H
See command \fBdlist\fP for how to set up display list.~R
.EE
**/
c_display( argn, args )
int	argn; char args[][ Largs ];
{
  REAL *valueP; VECTOR *vecP;
  EXPRESS *exP;
  CONNECT *connectP ;
  int   nvalue, nwin = -1, n, ncol=0, interval;
  REAL unit = Unit, flagval;
  char  label[Largs];
  long flags=0, flagsOn=0, flagsOff=0;

  get_default_flags( &flags );

  CheckGraphics();  CheckNet();
  if( argn < 1 ) return( display_items( Window ) );

  strcpy( label, args[0] );
  for( n=1; n < argn ; n++ ) {
    if( get_display_flags( args[n], &flagsOn, &flagsOff ) );
    else if( get_flag_eval_expr(args[n],"column",&flagval)) ncol= (int)flagval;
    else if( get_flag_eval_expr(args[n],"window",&flagval)) nwin= (int)flagval;
    else if( get_flag_eval_expr(args[n], ">", &flagval )) nwin= (int)flagval;
    else if( get_flag_eval_expr(args[n], "unit", &unit ));
    else return(ERR); 
  }
  flags = (flags|flagsOn)&(~flagsOff);

  if( connectP = which_connection( Net, args[0] ) );
  else if( exP = find_expression( Net, args[0] ) ) {
    IfErr( vecP = eval_expression( exP ) ) {
      delete_expression( exP );
      Erreturn2("%s: cannot evaluate %s", ERR_MSG, args[0]);
    }
    if( ncol < 1 ) {	/* column flag not given */
      if( flags&TransFlag ) 	/* transpose */
	ncol = vecP->nvalue1? vecP->nvalue1: 1;     /* matrix ? */
      else if( Err(ncol = dmatrix_of( Net, args[0])) )
	ncol = vecP->nvalue1? vecP->nvalue2: vecP->nvalue;
    }
  }
  else Erreturn2( "%s: in %s", ERR_MSG, args[0] );

  if( nwin < 0 ) {	/* window not given - ask the user to select one */
    IfErr( windows_opened() ) 
      Erreturn("no open window to display in - use 'window' to open some");
#ifdef use_mouse
    sendMsg("Select a window with mouse\n");
    while((nwin=which_window())<=0 ) {
      IfErr( nwin ) return( ERR );
      if(nwin==-1) sendMsg("no window there.");
      if(nwin==-2) 
	sendMsg( "picked multiple windows." );
    }
#else
    Erreturn("specify window (wN): mouse available only in SunNet");
#endif
  }

  CheckWindow( nwin );
  if( flags&EraseFlag ) wipe_window( Window[nwin] );
			/* now ready to display it */
  if( connectP ) 
    display_weight(Window[nwin], connectP,
		   unit, (long) flags|XnumFlag|YnumFlag );
  else if( vecP ) {
    display_vector(Window[nwin], vecP->value, vecP->nvalue, ncol, 1, label,
		   unit, (long) flags|XnumFlag|YnumFlag );
    delete_expression( exP );
  }
  return( OK );
}
/**
.CO "response" "display response to patterns"	DISPLAY-COMMAND
.SY "response {<vector>/<expression>} [<procedure>] [>W] [flags]"
.BI
Displays responses of <vector> or <expression> to all patterns as the
result of running <procedure>. Default procedure is the one previously
used (\fIactivate\fP initially).
Type 'help vector' or 'help expression' for how to specify a vector/expression.~H
See the sections on \fBvector\fP and \fBexpression\fP for how to specify ~R
a vector or an expression.~R
.Ni
W is the window # in which to display the responses.  If W is not
given, a window should be selected by clicking a mouse button in an
open window.  
.Ni
If there are N patterns, the window is divided up into N small
rectangular areas and response to each pattern is displayed in each
area as a display matrix.  The N small areas are arranged in a matrix
with M columns where M is the value of the parameter \fBmatrix\fP.
For example, if there are 12 patterns and \fBmatrix\fP is set to 4,
then displays of the responses to 12 patterns are arranged in a 3x4
matrix of display matrices.
.Ni
Type \fBhelp display-matrix\fP for attributes of display matrix.~H
See \fIdisplay attributes\fP below for attributes of display matrix.~R
.Ni
Flags can be given to \fBresponse\fP to specify these parameters temporarily.
Type \fBhelp display-flags\fP for details about display flags.~H
See \fBdisplay flags\fP for details about display flags.~R
.Ni
Example: \fBresponse <vector> >2 C5 c12 u4.0\fP will display responses of 
<vector> to window #2, each display matrix with 12 columns, arranged in
a big matrix with 5 columns, with display unit of 4.0.
.EE
*/

c_response( argn, args )
int	argn; char args[][ Largs ];
{
  static char proc_name[ Lname ] = "activate"; /*default procedure*/
  APROC  *aproc;
  VECTOR *vecP;				/* pointer to vector to display */
  static EXPRESS *exP=NULL;
  int	i,j;
  int	status, nchar;
  int	n1=0, n2=Npattern-1, n3=1, npattern = Npattern;	/* pattern #s */
  int	d_int=1;			/* interval to display */
  static int	*order=NULL;		/* order random presentation */
  static int norder=0;			/* memory size alloc'ed to order */
  char  label[Llabel];			/* label for each display matrix */
  int   ncol=0, nCol=0, Col = Ncol ;	/* arrangement of display matrices */
  REAL unit = Unit;			/* display unit */
  int	nwin = -1;			/* window # to display in */
  unsigned flags=0, flagsOn=0, flagsOff=0;
  REAL flagval;
  WINDOW **windows, **subwindows_in_window();	/* subwindow ptrs */

  get_default_flags( &flags );

  CheckGraphics(); CheckPattern(); CheckNet();
  if( argn < 1 ) Erreturn( get_syntax( "response" ) );

  if( exP ) delete_expression( exP );
  IfErr( exP = find_expression( Net, args[i=0] ) ) return(ERR);

  if( argn > 1 && (aproc = find_procedure( Net, args[1], 0, 1 ) ))
    strcpy( proc_name, args[i=1] );
  else IfErr( aproc = find_procedure( Net, proc_name, 0, 1) )
    Erreturn1("procedure %s not defined in network", proc_name);
		
  for(i++ ; i < argn ; i++ ) {		/* parse flags */
    if( get_display_flags( args[i], &flagsOn, &flagsOff ) );
    else if( get_flag_eval_expr(args[i],"Column",&flagval)) Col =(int)flagval;
    else if( get_flag_eval_expr(args[i],"column",&flagval)) ncol =(int)flagval;
    else if( get_flag_eval_expr(args[i],"window",&flagval)) nwin =(int)flagval;
    else if( get_flag_eval_expr(args[i],">",&flagval)) nwin = (int)flagval;
    else if( get_flag_eval_expr(args[i],"unit",&unit));
    else if( get_flag_eval_expr(args[i],"dint",&flagval)) d_int = (int)flagval;

    else if( (nchar = cmp_str(args[i],"pattern")) && nchar<strlen(args[i])
	    && find_range_int(args[i]+nchar,&n1,&n2,&n3)) {
      if( n1<0 || n2<0 ) Erreturn1("%s: invalid range of patterns", args[i]+nchar );
      if( n1>=Npattern ) 
	{ n1 = Npattern-1; sendMsg1("warning: only %d patterns.\n", Npattern);}
      if( n2>=Npattern )
	{ n2 = Npattern-1;sendMsg1("warning: only %d patterns.\n", Npattern); }
      if( n3 == 0 ) 
	Erreturn1("%s: invalid interval", args[i] );
      if( (n1>n2 && n3>0) || (n1<n2 && n3<0) )
	Erreturn1("%s: invalid range or interval of patterns", args[i]+nchar );
      npattern = abs(n2-n1)/n3+1;
    }
    else Erreturn1("%s: unknown flag", args[i]);
  }
  flags = (flags|flagsOn)&(~flagsOff);

	/* arrange display matrices in a square by default */
  if( Col < 1 ) Col = (int) sqrt( (double) npattern ) ; /* n2-n1+1 ); */
	
  if( nwin < 0 ) {  /* need to determine which window to display in */
    IfErr( windows_opened() ) 
      Erreturn("no open window to display in - use 'window' to open some");
#ifndef use_mouse
    Erreturn("specify window (wN): mouse available only in SunNet");
#else
    sendMsg("Select a window with mouse\n");
    while((nwin=which_window())<=0 ) {
      IfErr( nwin ) return( ERR );
      if(nwin==-1) sendMsg("no window there.\n" );
      if(nwin==-2) 
	sendMsg( "picked multiple windows.\n" );
    }
#endif
  }
  if( d_int <= 0 ) d_int = 1;	/* What is this for??? */
	/* open subwindows within this window for displaying display matrices*/
  IfErr(windows = subwindows_in_window( Window[nwin], 
				       Col/d_int, npattern/d_int ))
    Erreturn1("%s: cannot create subwindows for display", ERR_MSG);

  Starting(inPattern);
  if( flags&EraseFlag ) wipe_window( Window[nwin] );
  sprintf( label, "response %s", args[0] );
/*
  label_window_2sides( Window[nwin], "response", args[0], flags );
*/
  label_window( Window[nwin], label, flags );

			/* determine the order of pattern presentation */
  if( npattern > norder ) {	/* allocate space for order */
    if(order) free(order);
    order = new_array_of( npattern, int );
    norder = npattern;
  }
  for( i=0; i < npattern ; i++ ) order[i]=i*n3+n1;
  if( Randomize == ON ) permut( order, npattern, sizeof(*order) );

	     		/* start presenting patterns and displaying responses*/
  for( j=0; j<npattern; j++) {
    i = order[j];
    if( INTERRUPT == INTR_PAT ) {
      sendMsg1("interrupt at pattern %d", i);
      if( DoInterrupt("response") == EXIT ) 
	{ Ending(inPattern); Erreturn1("exit at pattern %d", i); }
    }
		/* present pattern */
    if( Err( put_input( Net, Input[i], N_input ) ) ||
       Err( put_target( Net, Target[i], N_target ) ) ) {
      Ending(inPattern);
      return( ERR ); 
    }
		/* execute procedure */
    clear_delta_net( Net );
    IfErr( executeAproc( aproc ) ) { Ending(inPattern); return( ERR ); }
		/* evaluate expression to be displayed */
    IfErr( vecP = eval_expression(exP) ) 
      {Ending(inPattern);Erreturn2("%s: in evaluating %s", ERR_MSG, args[0] );}

	/* if column flag is given or if args[0] is a simple object, we *
	 * know the number of columns to use for this display; otherwise *
	 * we need to compute no. of columns after the expression *
	 * is evaluated for each display matrix. */

    	/* column flag given -> use it */
    if( ncol > 0 ) nCol = ncol;
 	/* it's a simple object -> use dmatrix value */
	/* if transposing ignore dmatrix */
    else if( !flags&TransFlag && (nCol = dmatrix_of(Net, args[0] )));
	/* now it depends on whether it's a matrix or a vector *
	 * and whether we are transposing it */
    else if( vecP->nvalue1 )  /* matrix */
      nCol = flags&TransFlag? vecP->nvalue1 : vecP->nvalue2;
    else 	/* vector */
      nCol = flags&TransFlag? 1 : vecP->nvalue;

    if( Label == ON ) {
      if( Plabel ) strcpy( label, Plabel[i] );
      else sprintf( label, "pattern %d", i );
    }
	/* BUG: shouldn't randomize windows - use (i-n1)/n3 instead of j? */
    if( (j+1)%d_int == 0 &&
       Err(display_vector(windows[j/d_int], vecP->value, vecP->nvalue,
			  nCol, 1, label, unit,
			  flags|(j<Col? XnumFlag:0)|(j%Col? 0:YnumFlag)))) {
      Ending(inPattern);
      Erreturn2("%s: in display for pattern # %d", ERR_MSG, j);
    }
  }
  deleteProcArgs(aproc);
  Ending(inPattern);
  return(OK);
}

/**
.CO "dlist" "specify items to be displayed"	LIST-COMMAND
.SY "dlist {<vector>/<connection>/<expression>} [>W] [flags] "
.BI
Adds an item to \fIdisplay list\fP, the list of things to be displayed
by \fBdisplay\fP or \fBpresent\fP.  \fBdlist\fP takes the same arguments
and flags as \fBdisplay\fP.
.Ni
Type \fBhelp display\fP for details about arguments and flags.~H
See command \fBdisplay\fP for details about arguments and flags.~R
.Ni
If the parameter \fBdisplay\fP is set to N,  items in the list will be
displayed after every N cycles during running \fBcycle\fP.
.NI
\fBdlist\fP, without argument, prints the current list with a number
associated with each item.  A \fI*\fP after a number means that item is
turned on.
Type \fBhelp list\fP for how to turn on/off or remove items.~H
See \fBlist commands\fP for how to turn on/off or remove itesm.~R
.NI
\fBdlist command\fP prints out dlist commands that can be saved in a file
('dlist command > file') and later used to set up the same dlist
('source file').
.EE
**/
c_dlist( argn, args )
int	argn; char args[][ Largs ];
{
  EXPRESS *nwin=NULL,*ncol=NULL,*unit=NULL;
  EXPRESS *get_flag_expr(), *constant_expression();
  register int i,n;
  int    nitem, nwin1;
  unsigned flagsOn=0, flagsOff=0;

  CheckGraphics();
  if( argn < 1 ) return( print_dlist_names() );
  if( EQL(args[0], "+") || EQL(args[0], "-") || EQL(args[0], "all"))
    return( list( "Display", argn, args ));

  else IF( args[0], "clear" ) return( display_list( Net, "clear", 0, 0 ) );
  else IF( args[0], "command" ) return( print_dlist_commands() );
  CheckNet();
  for( n=1; n< argn; n++ ) {	/* interpret flags */
    if( get_display_flags( args[n], &flagsOn, &flagsOff ) );
    else if( !ncol && (ncol = get_flag_expr( args[n], "column" )));
    else if( !nwin && (nwin = get_flag_expr( args[n], "window")));
    else if( !nwin && (nwin = get_flag_expr( args[n], ">" )));
    else if( !unit && (unit = get_flag_expr( args[n], "unit" )));
    else return(ERR); 
  }

  IfErr( nwin ) {
    IfErr( windows_opened() ) 
      Erreturn("no open window to display in - use 'window' to open some");
#ifndef use_mouse
    Erreturn("specify window (wN): mouse available only in SunNet/XNet");
#else
    sendMsg("Select a window with mouse\n");
    while((nwin1=which_window())<=0 ) {
      IfErr( nwin1 ) return( ERR );
      if(nwin1==-1) sendMsg( "no window there.\n" );
      if(nwin1==-2) sendMsg( "picked multiple windows.\n" );
    }
    nwin = constant_expression((REAL) nwin1);
#endif
  }
  return( display_list( Net, args[0], nwin, ncol, unit, flagsOn, flagsOff ));
}
/**
.HE "display-matrix"  ~H
.HE "display attributes" "attributes of display matrix" DISPLAY-HELP ~R
.BB
A display matrix is a matrix of bars or squares representing values in
a vector or a weight matrix.  The following attributes affect all 
display matrices created by the commands \fBdisplay, response\fP and \fBdlist\fP.
Some attributes can be overridden by display flags given to individual
commands (see 'display-flags').
.BI
\fBset squareshape off\fP to use bars instead of the default squares.
.NI
\fBset dunit X\fP (X>0.0) to set unit value for display (default=1.0).
.NI
\fBset normalize on\fP to normalize display matrix (default=off)
(dunit is ignored if normalize is on.)
.NI
\fBset transpose on\fP to transpose display matrix (default=off).  This can
be used for a vector or a matrix.
.NI
Below-threshold value is displayed as a white bar/square.
\fBset threshold N\fP to change the threshold (default=0.0).
.NI
\fBset label off\fP to turn off display of label for display matrix.
.NI
\fBset number off\fP to turn off display of numbers along the columns/rows of 
display matrix.
.NI
\fBhelp dmatrix\fP for how to specify #of columns for display matrix.
.EE

.HE "display-flags" ~H
.HE "display flags" "how to control display attributes" DISPLAY-HELP ~R
.BB
flags for \fBdisplay/dlist/response\fP. N and M are integers (>0); X is a real
value.  These flags can be abbreviated by its initial substring sufficient
to distinguish from other flags (1 character in most cases).  For example, 
'window5' can be shortened to 'w5' or 'win5', etc..
These flags can be given in any order.
.BI
\fB>N\fP or \fBwindowN\fP - display in window #N.  If this is not specified, 
a window should be picked by clicking a mouse button in it.
.NI
\fBcolumnN\fP - display matrix has N columns.  This can be used to display a 
vector as a matrix.
.NI
\fBColumnN\fP - dislay matrices are arranged in a matrix with N
columns.  (this flag is for \fBresponse\fP only)
.NI
\fBunitX\fP - display unit is set to X (default=1.0)
.NI
\fBpatternN-M\fP - Present only patterns #N to #M. 
(only for \fBresponse\fP)
.NI
\fBsquare\fP - display with (default) squares.
\fB-square\fP - display with bars.
.NI
\fBnormalize\fP - normalize display values (display unit is ignored.)
\fB-normalize\fP - do not normalize.
.NI
\fBnumber\fP - display numbers for columns/rows.
\fB-number\fP - display numbers for columns/rows.
.NI
\fBlabel\fP - display label (the name of the object being displayed.)
\fB-label\fP - do not display label.
.NI
\fBtranspose\fP - transpose display matrix (in case of a weight matrix, display
it so that each column represents weights going to a unit, instead of weights 
coming out of a unit which is the default.)  This can be used for a vector or
a matrix.
\fB-transpose\fP - do not transpose.
.NI
\fB-bg\fP - do not paint the window with grey background.
.EE
**/

/* get_display_flags() parses a display flag.  if name matches any flag,
corresponding bit in flagsOn is turned on.  if name matches -flag, 
corresponding bit in flagsOff is turned off.  defaul_flag|flagsOn&(~flagsOff)
gives the resulting flag.
*/
get_display_flags( name, flagsOn, flagsOff )
char name[]; unsigned *flagsOn, *flagsOff;
{
  int leng = strlen(name);
       if(leng<=cmp_str(name, "normalize")) *flagsOn |= NormFlag;
  else if(leng<=cmp_str(name, "transpose")) *flagsOn |= TransFlag;
  else if(leng<=cmp_str(name, "square"))    *flagsOn |= SquareFlag;
  else if(leng<=cmp_str(name, "erase") )    *flagsOn |= EraseFlag;
  else if(leng<=cmp_str(name, "number") )   *flagsOn |= NumberFlag;
  else if(leng<=cmp_str(name, "label") )    *flagsOn |= LabelFlag;
  else if( name[0] == '-' ) {
    if((--leng)<=cmp_str( ++name, "normalize")) *flagsOff |= NormFlag;
    else if(leng<=cmp_str(name, "square"))    *flagsOff |= SquareFlag;
    else if(leng<=cmp_str(name, "transpose")) *flagsOff |= TransFlag;
    else if(leng<=cmp_str(name, "bg") )	*flagsOff |= BgFlag;
    else if(leng<=cmp_str(name, "erase"))	*flagsOff |= EraseFlag;
    else if(leng<=cmp_str(name, "number"))	*flagsOff |= NumberFlag;
    else if(leng<=cmp_str(name, "label"))	*flagsOff |= LabelFlag;
    else Erreturn1("%s: unknown flag", --name);
  }
  else Erreturn1("%s: unknown flag", name);
  return( OK );
}

/* get_default_flag() returns the flag combination given by display
attribute parameters.
*/
get_default_flags( flagsP )
unsigned *flagsP;
{
  *flagsP = (Normalize==ON? NormFlag:0)
	  |(Transpose==ON? TransFlag:0)
	  |(Square==ON? SquareFlag:0)
	  |(Number==ON? NumberFlag:0)
	  |(Label==ON? LabelFlag:0)
	  |(Erase==ON? EraseFlag:0)
	  | BgFlag ;
}

/* interprete flag of the form <name>X.  the value of X is assigned to *val.
returns OK if successful, ERR otherwise.  X can be an expression.
*/
get_flag_eval_expr( str, flag, val )
char *str, *flag; REAL *val;
{
  EXPRESS *ex, *get_flag_expr();
/* BUG: inefficient if its not an expression */
  if( Err( ex = get_flag_expr( str, flag )) ||
     Err( eval_expression( ex )) ) return( ERR );
  *val = ex->vector->value[0]; delete_expression( ex );
  return(OK);
}

/* interpret flag of the form <name><expr>.  return &<expr> if successful,
ERR otherwise.
*/
EXPRESS *
get_flag_expr( str, flag )
char *str, *flag;
{
  int nflag;
  EXPRESS *find_optimize_expression();
  if( nflag = cmp_str( str, flag ) )
    return( find_optimize_expression( Net, str+nflag ) );
  return( ERR );
}

/**
.CO "dmatrix" "set # of columns in display matrix"	DISPLAY-COMMAND
.SY "dmatrix {<layer>/<array>} [N]"
.BI
Sets # of columns in display matrix for <layer> or <array> to N. 
Type \fBhelp display-matrix\fP for other attributes of display matrix.~H
See \fBdisplay attributes\fP too.~R
.NI
If N is not given, current value is printed.  Default is the vector size.
.EE
**/
c_dmatrix( argn, args )
int	argn; char args[][ Largs ];
{
  LAYER	*layerP;
  ARRAY	*arrayP;
  int	ncol;
  CheckGraphics(); CheckNet();
  if( argn < 1 ) Erreturn( get_syntax( "dmatrix" ) ) ;
    
  if( argn < 2 ) {
    IfErr( ncol = dmatrix_of( Net, args[0] ) )
      Erreturn1( "%s: not found in network", args[0] ) ;
    sendMsg2("\t# of columns for %s = %d\n", args[0], ncol );
    return( OK );
  }
  if( AtoI( args[1], ncol ) != 1 || ncol < 1 ) 
    Erreturn1("invalid # of columns %s", args[1] ) ;
  if(layerP = which_layer(Net, args[0])) layerP->dmatrix = ncol;
  else if(arrayP = which_array(Net, args[0])) arrayP->dmatrix = ncol;
  else IF( args[0], "target" ) Net->target.dmatrix = ncol;
  else IF( args[0], "input" ) Net->input.dmatrix = ncol;
  else Erreturn1( "%s: not found in network", args[0] ) ;
  return( OK );
}
#if sunnet|xnet
/*
.CO "movie" "store/play back screen images"	MOVIE-COMMAND
.SY "movie {take/frame/time/all/+/-/=/clear/save <file> [+]/read <file> [+]}"
.BI
\fBmovie\fP is available only in SunNet.
.NI
\fBmovie take\fP stores current screen image (within \fIframe\fP, see below).
.NI
\fBmovie frame\fP lets the user select a rectangular region (with mouse)
as the frame for movie.  If a flag \fBwN\fP is given, window #N is used as the
frame.  The default frame is the entire screen.
.NI
\fBmovie all\fP plays back all stored frames.
.NI
\fBmovie time T\fP sets time to show each frame of movie to T (>0 msec).
.NI
\fBmovie +\fP, \fBmovie -\fP, and \fBmovie =\fP show next, previous,
and same frame.  \fB+\fP and \fB-\fP can be followed by a positive
integer N (eg. \fBmovie +5\fP) in which case the Nth frame forward
(back) from the current frame is shown.  Any number of these can be
given to a \fBmovie\fP command, and each can be optionally preceded by
a flag \fBwN\fP, which changes the frame to window #N, and/or a flag
\fBtT\fP, which changes the time to T msec.
.Ni
For example, \fBmovie w1 t1000 + t500 +3 w2 = -3\fP which means "show
next frame in window 1 for 1000 msec, go 3 frames forward and show it for
500 msec in window 1 and then in window 2, and go 3 frames back and
show it in window 2".
.NI
\fBmovie clear\fP erases all frames stored.
.NI
\fBmovie save <file>\fP saves the movie into <file>.
.NI
\fBmovie read <file>\fP retrieve movie from <file>. Current movie is cleared.
.EE
*/
#define MaxFrame 1024	/* maximum number of movie frames */

#ifdef xnet
static int frame[MaxFrame];
#define start_movie()
#define end_movie()
#else
RASTER *take_frame();
static RASTER *frame[MaxFrame];
#endif
static int nframe=0;		/* no. of frames */

#define CheckMovie() if( nframe >= MaxFrame ) \
	Erreturn1("cannot take more than %d frames", MaxFrame)
#define DoOrCut( x ) IfErr( x ) { end_movie(); return(ERR); }

c_movie( argn, args )
     int	argn; char args[][ Largs ];
{
  register int i,j;
  int i1, i2, inc;
  static float x1, x2, y1, y2;	/* picture frame */
  static BOX box = { .0, .0, -1.0, -1.0 };
  static int istart=0, iend = -1;	/* frame range to show */
  static int nwin=0;
  int w1=0, w2=0;
  int openFlag;
  int status, fd;
  static t_frame = 100;		/* time in msec to show each frame */
#if xnet
  char fname[Largs];
#endif
  CheckGraphics();
  if( argn < 1 ) {
    if(nframe<1) sendMsg("no movie frame.\n");
    else if(iend > 0)
      sendMsg2("current frame #%d, total %d frames.\n", iend, nframe);
    else sendMsg1("total %d frames.\n", nframe);
    return(OK);
  }
  IF( args[0], "take" ) {
    if( argn == 1 ) { 		/* take entire screen */
      CheckMovie();
      if((box.width<0 && Err( get_window_size( 0, &box ))) || 
	 Err( frame[nframe++] = take_frame( &box ) ) ) return( ERR );
    }      
    for( j=1; j < argn; j++ ) {     	/* otherwise wN-M -> windows N-M */
      if( args[j][0]=='w' && find_range( args[j]+1, &w1, &w2 ));
      else if( find_range( args[j], &w1, &w2 ));  /* or N-M is OK. */
      else Erreturn("syntax: movie take [wN-M [...]]");
      for( nwin = w1; nwin <= w2; nwin++ ) {
	CheckMovie();
	if(Err( get_window_size( nwin, &box )) || 
	   Err( frame[nframe++] = take_frame( &box ) ) ) return( ERR );
      }
    }
    return(OK);
  }
  else IF( args[0], "copy" ) {	/* copy raster from one window to another */
    if( argn < 2 ) Erreturn("syntax: movie copy W1 W2");
    GetWindowNumber( args[1], w1 ); CheckWindow( w1 );
    GetWindowNumber( args[2], w2 ); CheckWindow( w2 );
    return( copy_frame( &Wframe( w1 ), &Wframe( w2 ) ) );
  }
  else IF( args[0], "time" ) {
    if( argn < 2 ) sendMsg1("time per frame = %d msec.\n", t_frame );
    else if(AtoI(args[1], t_frame)!=1) Erreturn("syntax: movie time T (msec)");
    return(OK);
  }
  else IF( args[0], "clear" ) {		/* clear all frames */
    for( i=0; i<nframe; i++ ) 
#ifdef xnet
      erase_frame(frame[i]);
#else
      erase_frame(&frame[i]);
#endif
    nframe = 0; iend = 0;
    return( OK );
  }
  else IF( args[0], "frame" ) {		/* set frame for movie */
    if( argn > 1 && get_flag_i( argn, args, "w%d", &nwin ) ) {
      IfErr( get_window_size( nwin, &box ) ) return( ERR );
    }
    else if( get_flag( argn, args, "all")) return( copy_box_size( NULL, &box));
    else {
#ifdef use_mouse
      sendMsg("Select two corners of picture frame with mouse button.\n");
      IfErr(locate_box( &box )) Erreturn( "cancelled" );
#else
      Erreturn("specify window (wN): mouse available only in SunNet");
#endif
    }
    return( OK );
  }
  else IF( args[0], "save" ) {		/* save movie into file */
    if( argn < 2 ) Erreturn("syntax: movie save <filename> [+]");
#ifndef xnet
    openFlag = O_WRONLY|O_CREAT ;
    if( get_flag(argn, args, "+")) openFlag |= O_APPEND;
    if( 0>( fd = open(args[1], openFlag, 00644)))
      Erreturn1("cannot open file %s", args[1]);
#endif
    if( argn < 3 ) {			/* save all frames */
      for( i=0; i<nframe; i++ ) {
#ifdef xnet
	sprintf( fname, "%s.%d", args[1], i );
	IfErr(save_frame(fname, frame[i])) return(ERR);
#else
	save_frame(fd, frame[i]);
#endif
      }
    }      
    else for( j=2; j< argn; j++ ) {	/* save some frames */
      IF(args[j], "+") continue;	/* this can appear anywhere */
      IfErr( find_range( args[j], &i1, &i2 ) )
	Erreturn("syntax: movie save <file> N-M ...");
      if( i1 <= 0 || i1 > i2 || i2 > nframe )
	Erreturn2("%s?: current frame range 1-%d", args[j], nframe);
      for( i=i1; i<i2; i++ ) {
#ifdef xnet
	sprintf( fname, "%s.%d", args[1], i );
	IfErr(save_frame(fname, frame[i-1])) return(ERR);
#else
	save_frame(fd, frame[i-1]);
#endif
      }
    }
    close( fd );return( OK );
  }
  else IF( args[0], "read" ) {		/* read movie from file */
    if( argn < 2 ) Erreturn("syntax: movie read <file1> <file2> .. [+]");
    if( !get_flag( argn, args, "+" )) {	  /* if no '+', clear movie */
      if( nframe ) c_movie( 1, "clear" ); /* if '+', append to current movie */
      nframe = 0; istart = 0; iend = 0; 
    }
    for( beginMsg(""), i=1; i<argn; i++ ) {
#ifdef xnet
      IfErr( frame[nframe] = read_frame( args[i] ) ) return(ERR);
      nframe++;
#else
      IF(args[i], "+") continue;
      if( 0>( fd = open(args[i], O_RDONLY, 00644)))
	Erreturn1("cannot open file %s", args[i]);
      for(j=0 ; nframe<MaxFrame ; nframe++, j++ ) {
	IfErr( status = read_frame(fd, &frame[nframe])) {
	  close( fd );
	  Erreturn2("%s: cannot read frame from %s", ERR_MSG, args[i] );
	}
	if( status == EOF ) break;
      }
      close( fd );
      addMsg3("%s (%d frame%s)", args[i], j, j>1? "s":"" );
#endif
    }
    addMsg("\n"); endMsg();
    return( OK );
  }
  else if( nframe < 1 ) { Erreturn("no movie frame"); }
  else IF( args[0], "rewind" ) {
    istart = 0; iend = 0;
    return( OK );
  }
		/* if we are here, we should play some movie */
  start_movie();
  for( j=0; j<argn; j++ ) {
    IF( args[j], "+" ) { istart = ++iend; }
    else IF( args[j], "-" ) { istart = --iend; }
    else IF( args[j], "=" ) ;
    else if( sscanf( args[j], "+%d", &inc ))  { istart = iend += inc ; }
    else if( sscanf( args[j], "-%d", &inc ))  { istart = iend -= inc ; }
    else IF( args[j], "all" ) { istart = 1; iend = nframe; }
    else if( find_range( args[j], &i1, &i2 ) ) {
      if( i1 <= 0 || i1 > i2 || i2 > nframe ) {
	end_movie(); 
	Erreturn2("%s?: current frame range 1-%d", args[j], nframe);
      }
      istart = i1; iend = i2 ;
    }
    else if( args[j][0] == 'w' && find_range( args[j]+1, &w1, &w2 ) ) continue;
    else if( sscanf( args[j], "t%d", &t_frame )) continue;
    else { end_movie(); Erreturn(get_syntax("movie")); }
    if( iend > nframe ) { iend=nframe; puts("end of movie");}
    if( istart > nframe ) { istart=nframe; puts("end of movie");}
    if( iend < 1 ) { iend=1; puts("beginning of movie");}
    if( istart < 1 ) { istart=1; puts("beginning of movie");}
    if( w1 > 0 ) nwin = w1;	/* start from w1 if it's specified */
    for( i=istart ; i<=iend && i<=nframe ; i++ ) {
      DoOrCut( get_window_size( nwin, &box ) );
      CheckInterrupt("movie");
      DoOrCut( frame[i-1] );
      DoOrCut(show_frame( frame[i-1], box.x, box.y, t_frame )) ;
      if( nwin < w2 ) nwin++;	/* increment window until its w2 */
    }
  }
  end_movie();
  return( OK );
}

get_window_size( nwin, boxP )
int nwin; BOX *boxP;
{
  if( nwin==0 )  return( copy_box_size( NULL, boxP ) );
  CheckWindow( nwin );
  return( copy_box_size( &Wframe( nwin ), boxP ));
}

#endif sun

merge_box( b1, b2, b3 )
BOX *b1, *b2, *b3;
{
  if( Err(b1) || Err(b2) || Err(b3) ) return;
  b3->x = min( b1->x, b2->x );  b3->y = min( b1->y, b2->y );
  b3->width = max( b1->x+b1->width, b2->x+b2->width ) - b3->x ;
  b3->height = max( b1->y+b1->height, b2->y+b2->height ) - b3->y ;
}

/**
.CO "redraw" "redraw screen"	DISPLAY-COMMAND
.SY "redraw"
.BB
Clears and redisplays all objects on the screen.  No effect in XNet.
.EE
**/
c_redraw( argn, args )
     int	argn; char args[][ Largs ];
{
  CheckGraphics();
  redraw_display();
  frame_screen(VERSION);
  return( OK );
}
/**
.CO "erase" "erase display objects"	DISPLAY-COMMAND
.SY "erase {graph/screen/all} / erase window [all/[N/N-M] ...]"
.BI
\fBerase window\fP or \fBerase window all\fP erases all windows. 
.NI
\fBerase window N1 N2 .. N3-N4 ..\fP erases window #N1, #N2, #s N3 through N4 ...
.NI
\fBerase graph\fP erases the current graph.
.NI
\fBerase screen\fP erases objects displayed by reading screen file.
.NI
\fBerase all\fP erases all display objects.
.EE
**/
c_erase( argn, args )
     int	argn; char args[][ Largs ];
{
  int i, n, n1, n2;

  CheckGraphics();
  if( argn < 1 ) Erreturn( get_syntax( "erase" ) );
  IF( args[0], "window") {
    if( argn == 1 || EQL(args[1], "all"))
      for( i=0; i<MaxWindow; i++) { 		/* clear all windows */
	CheckInterrupt("erase");
	if( Window[i] ) wipe_window( Window[i] );
      }
    else for( i=1; i< argn; i++ ) 
      if( find_range( args[i], &n1, &n2 ) )
	for( n=n1; n <= n2; n++ ) {
	  if( n<MaxWindow && Window[n] ) wipe_window( Window[n] );
	  else sendMsg1("\twindow # %d not open.\n", n);
	}
  }
  else IF( args[0], "screen" )  erase_screen();
  
  else IF( args[0], "graph" ) 		/* erase current graph */
    { c_graph( 1, "erase" ); }
  else IF( args[0], "all" ) {
    wipe_all_graphics();
    delete_graph( Graph ); Graph = NULL;
    frame_screen(VERSION);
  }
  else Erreturn( get_syntax("erase"));

  return( OK );
}
/**
.CO "echo" "print text in window"	DISPLAY-COMMAND
.SY "echo N [-C<color>] <some text ...>"
.BB
Prints the arguments in window # N. Number of words is limited to 15.
.NI
An optional flag \fB-C<color>\fP paints the window with <color> (-Cblack,
-Cgrey).  For a SUN with a color monitor, \fB-CN\fP specifies the color in the
color table entry #N.  This flag may not work in XNet.
.NI
The largest font size is chosen that allows to fit the text within the window.
Only one line of text can be displayed.  XNet uses only one font type,
and does not change the font size.
.NI
A double quote (") by itself is replaced by a space, which can be used to get
desired spacing between two words.
.EE
**/
c_echo( argn, args )
int	argn; char args[][ Largs ];
{
  register int i;
  int	nwin;
  char color[16];	/* color name of background */
  BINARY color_set = OFF;	/* ON if a color is set */
  char	*para, str[Largs], *index();
  
  CheckGraphics();
  if( argn < 1 ) Erreturn(get_syntax( "echo" ) );
  GetWindowNumber( args[0], nwin );
  CheckWindow(nwin);
  wipe_window( Window[nwin] );
  strcpy( Text, "" );
  i = 1;
#if sunnet|planet
  if( sscanf( args[1], "-C%s", color )) {
    if( ColorSun ) {
      sprintf( args[1], "w%s", color ); strcpy(color, args[1] );
    }
    set_color( color );
    paint_box( &Wframe(nwin));
    i++; color_set = ON;
  }
#endif
  for( ; i<argn; i++ ) {
    IF( args[i], "\"" );	/* quote - this should be in read_command() */
    else strcat( Text, args[i] );
    strcat( Text, " " );
  }
  text_in_window( Window[nwin], Text );
#if sunnet|planet
  if( ColorSun && color_set == ON ) set_color( "white" );
#endif
  return( OK );
}
/**
.CO "screen" "read screen specification"	SCREEN-COMMAND
.SY "screen <file> [-w] [-f] / screen -c <screen command>"
.BB
Reads screen specification from <file>.  See below for about the format
of a screen specification file.
.sp
If flag \fB-w\fP is given, window specifications in the file are
ignored.
.sp
If flag \fB-f\fP is given, windows are not framed when opened.
.sp
As a special case, \fBscreen -c <screen command>\fP as in \fBscreen -c
circle 3x4 w5\fP executes <screen command>.  Screen commands are explained
below.
.sp
The file \fIscr.4.2.4\fP in the \fIexample/scr\fP directory
is an example of a screen specification file for a 3-layer network
with four input, two hidden and four output units.  It displays the
structure of the network, weight matrices, activation patterns in the
layers, and a pair of input/target patterns.  It also displays a title
and some learning parameters.
.sp
The portion of the file above the keyword \fIend\fP is called the
display field and is used to specify locations of various items to be
displayed on the screen.  Each item in the display field (an item is a
string of nonwhite characters) will be displayed at the location in the
actual display area on the screen corresponding to its location in the
display field.  If there are \fIN\fP lines in the display field, the
Nx80 array of characters in it will be proportionally mapped onto the
actual screen.  So, you can arrange various items in the display field
as if the field is the actual display area itself.  Items that start
with @, $, or [, or items that end with ], are interpreted specially
and will be explained below.  Any other items (strings) will be
displayed in the display area as they are.  This enables you to put
arbitrary strings of characters at arbitrary locations in the display
area.  The portion of the file below the display field is used for
commands for drawing in the display field as well as executing
\fBSunNet\fP commands (explained below).
.BI
\fIWindows\fP: A pair of items of the forms \fI[N\fP and \fIN]\fP,
where \fIN\fP is 0 or a positive integer, designates a rectangle in the
display area where window \fIN\fP is opened.  \fI[N\fP and \fIN]\fP
correspond to the upper-left corner and the lower-right corner of the
rectangle, respectively.  Windows 1 through 7 are opened in this screen
file.
.NI
\fIParameters\fP: An item that starts with a $ followed by the name of
a \fBSunNet\fP parameter, such as $\fIeta\fP, is replaced by the actual
value of the parameter.  (The display value should be updated whenever
a parameter is changed, but this has not been implemented in the
current version.)
.NI
\fIPoints\fP: An item that starts with an \fI@\fP
followed by a single character, such as \fI@a\fP, designates a point in
the display area.  A point is not displayed by itself but can be used
to draw lines by specifying two points to be connected.  See below.
.NI
If a line in the screen field starts with \fB.N\fP, N blank lines are
inserted.
.NI
If a line in the screen field starts with \fB.fF\fP (eg. .f0.8), the
font size is changed to F times the size of each character in the
screen file.  This works (approximately) for output generated by the
command "dprint".  This has no effect in XNet.
.NI
After the keyword \fIend\fP the following \fIscreen commands\fP can be 
used to draw additional objects.
.Ni
\fILine\fP: the command \fBline A B C\fP after the keyword \fIend\fP 
connects the three points designated by @A, @B, and @C with straight lines.  The
command \fBlinestyle\fP defines the style of lines to be drawn.  There
are four line styles available: \fIsolid\fP (default), \fIdotted,
dashed\fP, and \fIdotdashed\fP.  
.Ni
\fIArrow\fP: The command \fBarrow\fP can be used
instead of \fBline\fP to connect two points with an arrow leading to
the second point.  It is also possible to draw lines or arrows between
two groups of points, as in \fBarrow abcd jk\fP in the file.
\fBArrow head 0.8\fP defines the \fIhead\fP of arrows to be 0.8 times
as big as a character (default=1.0), and \fBarrow angle 15\fP defines
the opening of the arrow head to be 15 degrees (default=30).
\fBarrow wW1-W2 NxM\fP draws NxM arrows from window W1 to window W2.
.Ni
\fICircle\fP: \fBcircle <points>\fP draws a circle around each point
in <points>.  This is used in the file to draw a picture of network units.
\fBcircle radius R\fP specifies the radius of circles to be R.
\fBcircle NxM wW\fP draws N times M cicles arranged in a matrix with
N rows by M columns in window #W.
.NI
\fBfont {roman/greek/script/oldenglish/stick/symbols}\fP changes the
font.  This has no effect in XNet.
.NI
\fICommand\fP: Any \fBSunNet\fP command can be executed from a screen
file.  Examples of this are
found at the end of the file, where a display list is set up to display
network states in the windows.
.EE
**/ 
c_screen( argn, args ) 
int     argn; char args[][ Largs ]; 
{
  FILE  *fp, *open_file(); 
  struct stat fstat; char  fname[Nfilename];
  int   nrow,ncol; 
  int   ftype; int status;
  int   frame_window = 1, erase_window  =1;

  CheckGraphics(); 
  if( argn < 1 ) Erreturn( get_syntax( "screen" ) );
  if( argn == 1 && EQL( args[0], "command" )) {
    sendMsg("end\n");
    if( Err( c_window( 1, "command")) ||
       Err( c_dlist( 1, "command")) ||
       Err( c_graph( 1, "command")) ||
       Err( c_glist( 1, "command")) ||
       Err( c_plotlist( 1, "command")) ) return( ERR );
    return( OK );
  }
  if( get_flag(argn, args, "-w") ) erase_window = 0; 
  if( get_flag(argn,  args, "-f") ) frame_window = 0; 
  IF( args[0], "-c" )       /* execute a screen command, eg, circle. */
    return( eval_screen_command( args[1], argn-2, args[2], Window ) );

  IfErr( ftype = find_file( args, argn, ScreenDir, fname, &fstat ) )
    Erreturn1("cannot find file %s",args[0]); 
  IfErr( fp = open_file(  fname, ftype ) )
    Erreturn1("cannot open file %s",fname); 
  get_screen_size( fp, &nrow,  &ncol ); 
  close_file( fp, ftype );
  IfErr( fp = open_file(  fname, ftype ) )
    Erreturn1("cannot open file %s",fname); 
  if(Err( c_erase( 1, "screen" )) ||
     (erase_window && Err( c_erase( 1, "window" ) ))) return(ERR);
  status = get_screen( fp, Window, nrow, ncol,
		    erase_window, frame_window, 0 ); /*last arg not used*/
  close_file(fp,ftype);
  return( status );
} 
/**
.CO "parameter" "display values of parameters/variables" DISPLAY-COMMAND
.SY "parameter W {<parameter>/<variable>/network/pattern} ..."
.BB
Displays values of a set of parameters/variables in window W.
\fBnetwork\fP or \fBpattern\fP can be specified to display the name of
the network file or the pattern file.  If no arguments, \fInetwork,
pattern, min, weight, eta,\fP and \fIalpha\fP are the defaults.
.EE
**/ 
c_parameter( argn, args ) 
int     argn; char args[][ Largs ]; 
{
  char str[ Largs ]; 
  register int i; 
  int nwin; 
  CheckGraphics(); 
  if( argn < 1 ) Erreturn( get_syntax("parameter")); 
  GetWindowNumber( args[0], nwin ); 
  CheckWindow( nwin ); 
  if( argn < 2 ) 
    sprintf( Text, 
	"pattern=%s network=%s min=%3.2f weight=%3.2f eta=%3.2f alpha=%3.2f", 
	PatFileName, NetFileComm, MINACTV, INITWEIGHT,
	 ETA, ALPHA ); 
  else for( i=1, Text[0] = NULL ; i < argn; i++ )
  {
    IF( args[i], "network" ) strcpy( str, NetFileComm ); 
    else IF( args[i], "pattern" ) strcpy( str, PatFileName ); 
    else if(Err( get_parameter_string( args[i], str )) &&
	    Err( get_variable_string( Net, args[i], str )))
      Erreturn1("parameter %s not found", args[i] ); 
    sprintf( Text, "%s %s=%s ", Text, args[i], str ); 
  }

  wipe_window( Window[nwin] ); 
  text_in_window( Window[nwin], Text );
  return( OK ); 
} 
/**
.CO "plotlist" "specify items to be plotted"    LIST-COMMAND
.SY "plotlist <Xexpr> <Yexpr> {<Marker>/line} [Xscale Yscale] "
.BI
Adds an item into the \fBplot list\fP to be plotted.
.NI
\fB<Xexpr>\fP and \fB<Yexpr>\fP can be any vectors or expressions.
Expressions are evaluated before each plotting and the results are treated
as vectors.  If the two vectors differ in size, extra values are
ignored.
.NI
\fB<Marker>\fP is a character to be used for plotting the points.
.NI
\fBline\fP means points in the item are connected by straight lines.
.NI
If Xexpr and Yexpr evaluate to two matrices of the same size, the points 
in each column as well as the points in each row are connected together to 
form a mesh.
.NI
Xscale and Yscale, if given, are multiplied to the vectors before
plotting.
.NI
Type \fBhelp list\fP for how to turn on/off or remove items.~H See
\fBlist commands\fP for how to turn on/off or remove itesm.~R
.NI
\fBplotlist command\fP prints out plotlist commands that can be saved in a file
('plotlist command > file') and later used to set up the same plotlist
('source file').
.EE
**/ 
c_plotlist( argn, args ) 
int     argn; char      args[][ Largs ]; 
{
  int nitem; 
  if( argn < 1 ) return( print_plotlist_names() ); 
  if( argn == 1 ) {
    IF( args[0], "clear" ) return( plot_list( Net, "clear" ) ); 
    IF( args[0], "command" ) return( print_plotlist_commands() );
    Erreturn(get_syntax( "plotlist" ) ); 
  }
  if( EQL(args[0], "+") || EQL(args[0], "-") || EQL(args[0], "all"))
    return( list( "Plot", argn, args )); 
  if( argn < 3 ) Erreturn( get_syntax( "plotlist" )); 
  CheckNet(); 
  if( AtoI(args[0], nitem) )
    return( plot_list( Net, args[1], args[2], argn-3, args[3], nitem)); 
  return( plot_list( Net, args[0], args[1], argn-2, args[2], 0 )); 
} 
/**
.CO "plot" "open plots and do plotting"  PLOT-COMMAND
.SY "plot NxM [P] [wW] / plot {N/+/\(mi/=} [new] / plot N label <some text>"
.BI
\fBplot NxM [P]\fP opens N times M plots arranged in N rows and M
columns starting from plot #P (default=1, if not given).  If flag
\fBwW\fP is given, plots are opened in window #W.  Otherwise, the user
is prompted to place the plots with mouse (SunNet/XNet) or the entire
screen is used (PlaNet/AllieNet).
The X and Y range between 0 and 1 by default but, as in the command 'graph', 
X and Y ranges can be specified by a flag starting with 'x' or 'y':
for example, if \fBx0-300@50\fP appears anywhere on the line, the plots
will be initialized with the X ranging from 0 to 300, and with the X axis
numbered at intervals of 50.
.NI
\fBplot command\fP prints out a command for opening each of the currently
open plots, which can be saved in a file and used later to open the same set 
of plots.
.NI
\fBplot N\fP plots items in plot list in plot # N (default=0).  Plot #
can be specified as \fB+\fP (next plot), \fB\(mi\fP (previous plot), or
\fB=\fP (same plot).  If \fBnew\fP is given, the plot is erased first.
.Ni
Type \fBhelp plotlist\fP for how to set up plot list.~H See
\fBplotlist\fP for how to set up plot list.~R
.NI
\fBplot N label <some text>\fP displays <some text> below plot #N.
.EE
**/ 
#ifdef demo 
#define Plotspace 0.0 
#else 
#define Plotspace 0.05
#endif 
c_plot( argn, args ) 
int     argn; 
char      args[][ Largs ]; 
{
  static int    n_plot; 
  static float	start_x=0.0, end_x=1.0, num_x=1.0;
  static float	start_y=0.0, end_y=1.0, num_y=1.0;
  int n, n1, n2, pstart = 1 ;
  int   ncol, nrow;
  int   nwin; 
  BOX   box;                    /* region in which  plots */ 
  int   i; 
  char label[BUFSIZE]; 
  float move_x, move_y; 
  float width, height;                  /* size of each plot */
  CheckGraphics();

  if( argn && EQL( args[0], "command" )) { /* print plot opening commands */
    for( i=0; i<MaxPlot; i++) {
      if( Plot[i] ) {
	copy_box_size( &Plot[i]->Window->frame, &box );
	sendMsg1("plot 1x1 %d ", i);
	sendMsg6("x%g-%g@%g y%g-%g@%g",
		 start_x,end_x,num_x,start_y,end_y,num_y);
	sendMsg4(" X%g,%g Y%g,%g\n",
		 box.x, box.width, box.y, box.height);
      }
    }
    return(OK);
  }
					/* open new plots */
  if( argn > 0 && sscanf( args[0], "%dx%d", &nrow, &ncol ) == 2 ) {
    	/* plot configuration */
    if( (Nplot = ncol*nrow) < 1 ) Erreturn1("% plots?", args[0] ); 
	/* first plot # to be opened */
    if( argn > 1 && AtoI( args[1], pstart ) && pstart < 1 )
      Erreturn1("invalid plot # %d", pstart ); 

    if( pstart+Nplot > MaxPlot )
      Erreturn1("Sorry, cannot open more than %d plots",MaxPlot);

	/* determine where to open the plots */
    if( argn > 1 && get_flag_i( argn, args, "w%d", &nwin ) ) {/* in a window*/
      CheckWindow(nwin); 
      IfErr(copy_box_size( &Window[nwin]->frame, &box )) return(ERR); 
      wipe_window( Window[nwin] ); 
    } 
    else 	/* given on the command line */
      if(get_flag_ff(argn-1, args[1], "X%f,%f",&box.x,&box.width)&&
	 get_flag_ff(argn-1,args[1], "Y%f,%f",&box.y,&box.height));
    else {	/* get location with mouse */
#ifdef use_mouse
      sendMsg("Use mouse button to locate region in which to open plots.\n"); 
      IfErr(locate_box( &box )) Erreturn("cancelled");
#else
      Erreturn("specify window (wN): mouse available only in SunNet");
#endif
    }
		
    if( Nplot == 1 ) 	/* only one plot - use full space */
      move_x = box.width, move_y = box.height;
    else {		/* small spacings between adjacent plots */
      move_x = box.width/(ncol-Plotspace);
      move_y = box.height/(nrow-Plotspace);
    }
    width = move_x * (1-Plotspace);		/* width of each plot */
    height = move_y * (1-Plotspace);		/* height of each plot */

			 	   /* get flags for ranges of plot values */
    get_flag_fff(argn-1, args[1], "x%f-%f@%f", &start_x,&end_x,&num_x);
    get_flag_fff(argn-1, args[1], "y%f-%f@%f", &start_y,&end_y,&num_y);

    for( i=0; i<Nplot; i++) {		/* now open plots */
      n = pstart+i;
      if( Plot[n] ) wipe_graph( Plot[n] );
      else IfErr( Plot[n] = new( GRAPH ) ) Erreturn( "not enough space");
      sprintf( label, "%d", n );
      if(Err(make_graph(Plot[n], start_x, end_x, num_x, start_y, end_y, num_y,
			label )) ||
	 Err(set_graph_size(Plot[n],
			    box.x+move_x*(i%ncol), box.y+move_y*(i/ncol),
			    width, height, label ) ))
	Erreturn1("%s: cannot create new plot", ERR_MSG);
      IfErr( draw_graph(Plot[n])) Erreturn1("%s: cannot draw plot", ERR_MSG);
/*    IfErr( draw_box_for_plot( Plot[n], label ) ) return(ERR);*/
    }
    n_plot = pstart;
    return( OK );
  }	

  else IF( args[0], "erase" ) {	      /* erase plots */
    if( argn < 2 )  Erreturn("syntax: plot erase {all/N}");
    IF( args[1], "all" ) {
      for( i=1; i < MaxPlot; i++ ) {	/* erase all plots */
	CheckInterrupt("plot");
	if( Plot[i] ) wipe_graph( Plot[i] ); 
      }
      return( OK );
    }
    if( sscanf( args[1], "%d-%d", &n1, &n2 ) == 2 ) { /* erase some plots */
      for( n=n1; n <= n2; n++ ) {
	CheckInterrupt("plot");
	if(Plot[n]) wipe_graph( Plot[n] );
      }
      return( OK );
    }
    else IfErr(AtoI(args[1], n ) ) Erreturn("syntax: plot erase {all/N}");
    if( n < 1 || n >= MaxPlot ) Erreturn1("invalid plot #%d",n);
    IfErr( Plot[n] ) Erreturn1("plot # %d not open", n );
    wipe_graph( Plot[n] );		/* erase one plot */
    return( OK );
  }			
			/* plot plotlist items - select a plot for plotting */
  else if( argn < 1 ) {
#if use_mouse
    sendMsg("Select a plot with mouse\n");
    while((n=which_plot())<0 ) {
      sendMsg("No plot there.\n");
      CheckInterrupt("plot");
    }
    n_plot = n;
#else
    Erreturn("specify plot #: mouse unavailable");
#endif
  }
  else IF( args[0], "+" ) n_plot=(n_plot<MaxPlot-1)? n_plot+1: 1;
  else IF( args[0], "-" ) n_plot=(n_plot>1)? n_plot-1: MaxPlot-1;
  else IF( args[0], "=" ) ;
  else if( AtoI( args[0], n_plot ) ) ;
  else Erreturn1("invalid plot # %s", args[0] );
  if( n_plot < 1 || n_plot >= MaxPlot ) Erreturn1("no plot # %d", n_plot );
  IfErr( Plot[n_plot] ) Erreturn1("plot #%d not open", n_plot);
  if( argn > 1 ) {
    IF( args[1], "new" ) { 		/* erase plot first */
      wipe_graph( Plot[n_plot] );
#ifndef demo
      IfErr( draw_graph( Plot[n_plot] ) ) return(ERR);
/*    IfErr( draw_box_for_plot( Plot[n_plot], args[0] ) ) return(ERR);*/
#endif
    }
    else IF( args[1], "label" ) {	/* just label plot */
      *label = NULL;
      for( i=2; i < argn; i++ ) sprintf( label, "%s %s", label, args[i] );
      label_graph( Plot[n_plot], label );
      return( OK );
    }
    else IF( args[1], "leftlabel" ) { /* display a label on the left side */
      if( argn == 1 ) Erreturn( get_syntax( "window" ) );
      label[0] = NULL;
      for( i=2; i < argn; i++ ) sprintf( label, "%s %s", label, args[i]);
      label_window_left( Plot[n_plot]->Window , label, 0 );
    }
  }					/* do plotting */
  return( plot_all_items( Plot[n_plot] )) ;
}
/*
.CO "dprint" "open/close file/printer to send display"	DISPLAY-COMMAND
.SY "dprint <file> / dprint -P<printer> / dprint close / dprint"
.BI
\fBdprint <file>\fP opens a file for sending subsequent display in
postscript format.
.NI
\fBdprint -P<printer>\fP opens a connection to a printer for
sending subsequent displays to.  The printer name can be omitted as in
\fBdprint -P\fP and the previously specified printer will be used if any,
or the value of the environment variable PRINTER will be used.  
.NI
Anything displayed afterward will be sent to the printer or written to the 
file until it is closed with \fBdprint close\fP.  The printer must understand 
postscript format.
.EE
*/
c_dprint( argn, args )
int	argn; char args[][ Largs ];
{
  register int n;
  char *fname, *whatis_display_printer(), *getenv();
  static char pname[BUFSIZE] = "";
  static BINARY printer = OFF;

  if( argn < 1 ) { 
    sendMsg1("\tdisplay file/printer = %s\n", 
			   strlen( fname=whatis_display_printer())? 
			   fname : "undefined");
    return( OK ); 
  }
  IF( args[0] , "close" ) return( printer==ON? close_display_printer():
				 	       close_display_file() );
  if( args[0][0] == '|' ) 
    Erreturn("please use 'dprint -P<printername>' to specify a printer");

  if( cmp_str(args[0],"-P") ) {
    if( strlen(args[0])==2 ) {  /* printer name not given */
      if( !strlen( pname ) ) fname=pname; /* use previously used printer */
      else if( fname = getenv( "PRINTER" ) );
      else Erreturn("printer name not given and PRINTER environment not defined.");
    }
    else fname = &args[0][2];
    IfErr( open_display_printer( fname ) ) return( NULL );
    sendMsg1("\tdisplay will be sent to printer %s.\n", fname );
    strcpy( pname, fname );
    printer = ON;
    return( OK );
  }
  else { 
    IfErr( open_display_file( args[0] ) ) return( NULL );
    sendMsg1("\tdisplay will be sent to file %s.\n", args[0] );
    printer = OFF;
    return( OK );
  }
}

/*
.CO "color" "change colors for display"	DISPLAY-COMMAND
.SY "color {positive/negative/window/background/line/text}N /color map N <mix>"
.BI
This command is available only for SUNs with color momitors.
.NI
\fBcolor <type>N\fP, where <type> is one of positive, negative, window, 
background, line, and text (each can be abbreviated by the first character), 
and N is an integer (0<N<16), specifies the Nth entry in the current color 
table to be used for displaying items of <type>.
.NI
\fBcolor map N <mix>\fP changes the Nth entry in the color table to the color
given by <mix>.  <mix> is a string of three digits R, G, and B, specifying the
intensity of red, green, and blue, respectively.  The character 'a' is treated
like a digit 10.  For example, 'a0a' gives purple, '555' is grey, etc.
.EE
*/
c_color(argn, args )
int	argn; char args[][ Largs ];
{
#if sunnet|planet
  register int n; int indx;
  if( ! ColorSun ) Erreturn("color not available on monochrome monitor");
  IF( args[0], "map" ) {
    if( argn < 3 ) Erreturn("syntax: color map index red-green-blue");
    if( Err(AtoI(args[1], indx)))
      Erreturn("syntax: color map index red-green-blue");
    return(change_color_map( indx, args[2] ));
  }
  for(n=0; n < argn; n++) IfErr(set_color(args[n])) 
    sendMsg1("\t%s.\n",ERR_MSG);
  return(OK);
#else
  Erreturn("color available only on SunNet");
#endif
}

#if 0
c_clickLocation(argn, args )
int	argn; char args[][ Largs ];
{
  float x,y; int i, nwin;
#if planet
  Erreturn("mouse not available in PlaNet");
#endif
  locate_mouse( &x, &y, 10000000 );
  if( argn == 0 ) {
    sendMsg2("%g\t%g\n", x, y );
    return(OK);
  }
  IF( args[0], "window" ) {
    for( i=0, nwin=0; i< MaxWindow; i++ ) {
      if( Window[i] == NULL ) continue;
      if( inside_window( Window[i], x, y ) ) {
	sendMsg1("%d ", i ); nwin++;
      }
    }
    if( nwin == 0 ) sendMsg("no window");
    sendMsg("\n");
  }
  return(OK);
}
#endif 0

draw_box_for_plot( plot, label )
GRAPH	*plot;
char	*label;
{
  IfErr( plot ) Erreturn( "plot not open" );
  IfErr( draw_box_in_window( plot->Window ) ) 
    Erreturn1("%s: in plot", ERR_MSG) ;
  IfErr( label_graph( plot, plot->label? NULL : label ) ) /* put label if not*/
    Erreturn1("%s: in labeling plot", ERR_MSG) ;	  /* already defined */
  return(OK);
}

which_window()
{
  register int i;
  static float x1,y1;
  float x=x1,y=y1;
  int npicked=0, nwin = -1;
  int winID= -1;
  while( x==x1 && y==y1 ) {
    locate_mouse( &x, &y, 10000000 );
  }
  x1 = x; y1 = y;
  for( i=0; i< MaxWindow; i++ ) {
    if( Window[i] == NULL ) continue;
	/* BUG: this doesn't seem to be working */
    if( inside_window( Window[i], x, y ) && Window[i]->id > winID ) {
      winID = Window[i]->id;	/* pick the newest window if more than one */
/*    sendMsg1("\tpicked window # %d\n", i );*/
      npicked++; nwin = i;
    }
  }	/* return -1 => no window; -1 => multiple windows;window# picked
  return( npicked==0? -1: npicked>1? -2 : nwin );*/
  return( nwin );
}

windows_opened()
{
  register int i;
  int nopen=0;
  for( i=0; i< MaxWindow; i++ ) if( Window[i] ) nopen++;
  return( nopen );
}

void print_window_command()
{
  register int i;
  BOX *frame;
  for( i=0; i< MaxWindow; i++ ) if( Window[i] ) {
    frame = &Window[i]->frame;
    sendMsg5("window %d x%g y%g w%g h%g\n", i,
	     frame->x, frame->y, frame->width, frame->height );
  }
}

which_plot()
{
  int i;
  float x,y;
  locate_mouse( &x, &y, 10000000 );
  for( i=0; i< MaxPlot; i++ )
    if( Plot[i] && Plot[i]->Window && inside_window( Plot[i]->Window, x, y ) ) 
      return( i );
  return( -1 );
}

plots_opened()
{
  register int i;
  int nopen=0;
  for( i=0; i< MaxPlot; i++ ) if( Plot[i] ) nopen++;
  return( nopen );
}

eraseON()
{
  return( Erase == ON? OK : ERR );
}
