/* $Header: /soma/users/miyata/planet/src/RCS/graph.h,v 5.6.0.4 91/02/13 15:42:45 miyata Exp $ */
#include "movie.h"
extern float XMIN, XMAX;/* ranges of x, y coordinates */
extern float YMIN, YMAX;/* ranges of x, y coordinates */

typedef struct _box {
  	float	x,y, width,height;
} BOX;

typedef struct _window {
	int	segment_name;
	BOX	frame;
	BOX	data;
	float	lmargin;	/* left margin */
	float	bmargin;	/* bottom margin */
	int	status;
	int	id;		/* window id number */
	RASTER  *bg;		/* background raster */
} WINDOW;

#define MaxSegment 512

typedef struct _graph {
	WINDOW	*Window;
	float	origin_x;
	float	origin_y;
	float	scale_x;
	float	scale_y;
	float	range_x;
	float	range_y;
	float	num_x;
	float	num_y;
	int	segment_name;
	int     n_segment;
	int     segments[ MaxSegment ];
	int	label_segment;
	char	*label;
	int     visible;
} GRAPH;

extern  WINDOW * new_window();
extern	GRAPH * new_graph();
extern	GRAPH * new_box();

#define BLANK 0
#define NUMBERED 3
#define CLOSED 1
#define DELETED 2

	/* environment WINDOW_GFX is the window to which graphics output *
	 * is directed.  If there's no graphics window attached,  it is  *
	 * the same as WINDOW_ME: so if they differ, you can do graphics */

#define SunWindow 	getenv( "WINDOW_ME" )
#if sunnet
#define GraphicsWindow	( getenv( "WINDOW_ME") && \
		strcmp( getenv("WINDOW_ME"), getenv("WINDOW_GFX") ) )
#else
#define GraphicsWindow 1	/* assume PlaNet is in graphics window */
#endif

#define NormFlag 0x1
#define TransFlag 0x2
#define SquareFlag 0x4
#define XnumFlag 0x8
#define YnumFlag 0x10
#define WeightFlag 0x20
#define NumberFlag 0x40
#define BgFlag 0x80
#define EraseFlag 0x100
#define LabelFlag 0x200
