			extern char ERR_MSG[];
%%
			float *val, *find_name_vector(); int nval;
			VECTOR **find_expression_arg(); double atof();
			CONNECT *connect, *which_connection();
			MATRIX *matrix, *which_matrix();
"->"			{ return( TO ); }
"**"			{ return( MULTI ); }
"=="			{ yylval.cval = EQ ; return( CMP ); }
"!="			{ yylval.cval = NEQ ; return( CMP ); }
">"			{ yylval.cval = GT ; return( CMP ); }
">="			{ yylval.cval = GEQ ; return( CMP ); }
"<"			{ yylval.cval = LT ; return( CMP ); }
"<="			{ yylval.cval = LEQ ; return( CMP ); }
"&&"			{ yylval.cval = LAND ; return( LOGIC ); }
"||"			{ yylval.cval = LOR ; return( LOGIC ); }
"="			{ yylval.cval = '='; return( ASSIGN ); }
"+="			{ yylval.cval = '+'; return( ASSIGN ); }
"-="			{ yylval.cval = '-'; return( ASSIGN ); }
"*="			{ yylval.cval = '*'; return( ASSIGN ); }
"/="			{ yylval.cval = '/'; return( ASSIGN ); }

[$a-zA-Z][a-zA-Z0-9_:.]*"(" {	/* NAME( -> function */
	yytext[strlen(yytext)-1] = NULL;
	if( yyInProc ) return( PROCNAME );
	if( find_function(yytext, &yylval.funcval) )
	  return( FUNC );
	if( find_random_function(yytext, &yylval.funcval) )
	  return( RANDOMFUNC );
	}
[$a-zA-Z][a-zA-Z0-9_:.]* {	/* NAME -> object */
	/* find_object() finds most objects including argments */
	if( yyInProc ) return( NEWNAME );
	if( find_object(yyNet,yytext,&yylval.vval)) {
	  return( VEC );
	}	/* this finds misc. vectors like $Error */
	if( yylval.vval.value = find_name_vector(yyNet, yytext,
					   &yylval.vval.nvalue)) {
	  yylval.vval.nvalue1=yylval.vval.nvalue2=0;
	  yylval.vval.accessfunc = NULL, yylval.vval.object = NULL;
	  yylval.vval.name = new_string(yytext,NULL);
	  return( VEC );
	}	/* not defined */
	sprintf(ERR_MSG, "%s not found", yytext);
	yylval.sval = new_string(yytext,NULL); 
	return( NEWNAME );  /* undefined string */
	} 
[ \t]+			{ }
[0-9]*"."[0-9]+		{ yylval.fval = atof(yytext); return(REAL); }
[0-9]+			{ yylval.ival = atoi(yytext); return(INTGR); }
[^a-z0-9]		{ return(yytext[0]); }
%%

yywrap() {return(1);}
# ifdef input	
# undef input	/* these are def'ed in lex.yy.c */
# undef output
# undef unput
# endif

input()
{
  char c;
  if( (c = *NextChar) == NULL ) return(0);
  NextChar++ ;
  return( c );
}
output(c) char c; {}

unput(c) char c; {
  if(NextChar>Buf) *(--NextChar) = c;
}

