# file: example/net/n.cl 
# Competitive Learning network for binary or continuous inputs.
# example usage: network nIn=6 nOut=8 Binary=0 n.cl
define ErrMsg \n\tread\swith\s'network\snIn=<no-of-input>\snOut=<no-of-output>\sn.cl'\n
IFNDEF nIn;  printf ErrMsg; exit; ENDIF
IFNDEF nOut; printf ErrMsg; exit; ENDIF

layer Input nIn
layer Output nOut

connect InputOutput Input to Output

input nIn

define Binary 1     # default is continuous input vector

scalar winner        # winner output unit

procedure activate
    scalar totalinput
    if ((totalinput=sum(input)) == 0) stop
IF Binary==1        # for binary input vector
    winner= indexmax(InputOutput**T(Input=input/totalinput))
ELSE                # for continuous input vector
    winner= indexmin(sumrow((InputOutput-(Input=input/totalinput))^2))
ENDIF
    (Output=$min)[winner]=$max
    $Error = average((InputOutput[winner]-Input)^2)
end

procedure learn
    call activate
                                      # adjust the winner's weights
    InputOutput[winner] += $eta * (Input - InputOutput[winner])
end

procedure reset                        # reset the weights
    InputOutput = urandom(InputOutput=1) # initialize weights
    scalar n;    n = 0
    repeat nOut                        # sum of each weight vector should be 1.
        InputOutput[n] /= sum(InputOutput[n])
        n += 1
    endrepeat
    $epoch = 0
end
exec reset
