##################################################################
## RunNet.ksh : ksh script for running PlaNet system from ksh.  ##
##################################################################

###############################################
## Change this to the source directory.      ##
###############################################
NETDIR=/soma/users/miyata/planet

# ARCH=hp 	# set to machine architecture name if the
		# machine does not implement the program arch.
		# eg. hp (for HP bobcats).

########################################
## Some primitive user interface .. ####
########################################
if( test -x /usr/ucb/fmt ) then
  function MSG
  { /bin/echo "
$* " | /usr/ucb/fmt ; }
else  
  function MSG
  { /bin/echo "
$* " ; }
fi

###################################################
## Find out what architecture this machine is #####
###################################################

if( test ${ARCH:-NULL} != NULL ) then
  /bin/echo ARCH=$ARCH
elif( test -x /bin/arch ) then
  ARCH = `/bin/arch`
elif( test -x /usr/bin/arch ) then
  ARCH = `/usr/bin/arch`
elif( test -x /usr/local/bin/arch ) then
  ARCH = `/usr/local/bin/arch`
fi

if( test ${ARCH:-NULL} = NULL ) then
  MSG "Program arch not found on your machine.  Please set the variable\
 ARCH in me to the name of the architecture and run me again."
  return
fi

#########################################
## Check if it's the right directory.  ##
#########################################

if ( test -d $NETDIR ) then
  :
else
{
  MSG "I cannot find the directory $NETDIR.  Please set variable NETDIR\
in file RunNet to the appropriate directory and try again."
  return
}
fi
DIR=$PWD

#######################################
## Find out what machine we are on.  ##
#######################################

HOST=`hostname`
/bin/echo "Your machine $HOST is a $ARCH, "

###########################################
## Check which window system we are in.  ##
###########################################
if( test ${NETPROG:-NULL} != NULL ) then
{
  PROG=$NETPROG
}
elif( test ${DISPLAY:-NULL} != NULL ) then
{
  /bin/echo "and I assume your window system is X (with server $DISPLAY)."
  PROG=XNet
}
elif( test ${WINDOW_ME:-NULL} != NULL ) then
{
  /bin/echo "and your window system is suntools."
  PROG=SunNet
}
elif( test $TERM = sun ) then
{
  /bin/echo "and I assume your window system is suntools."
  PROG=PlaNet
}
else
{
  /bin/echo "and it appears you are not in a window system."
  PROG=StarNet
}
fi

MSG "For this configuration, use program $NETDIR/$ARCH/$PROG.\
"

######################
## Label the window ##
######################

# if( $PROG =~ SunNet ) then
  # alias LABEL '/bin/echo -n "${E}]l$PROG \!*${E}\"'
  # LABEL
# else
  # alias LABEL
# endif

#####################################################
## If from suntools, make sure we are in gfxtool.  ##
#####################################################

if( test ${WINDOW_ME:-NULL} != NULL ) then
{
 if( test $WINDOW_ME = $WINDOW_GFX ) then
    MSG  "	Not in a graphics tool window.  Graphics disabled"
 fi
}
fi

##############################################################
## Make sure we are authorized to connect to the X server.  ##
##############################################################

# if( test $PROG = XNet ) then
# {
  # if( xhost > /dev/null ) then
    # :
  # else
  # {
    # MSG  "	We cannot connect to the X server. Please run 'xhost\
# $HOST' on the server machine and run me again."
    # return
  # }
  # fi
# }
# fi

###################################################################
## Secure a command port.  Use planet.$USER.x or port.tutorial.  ##
###################################################################

if( test ${USER:-NULL} = NULL ) then
  USER=$PPID
fi
port=0
while ( test -w /tmp/planet.$USER.$port ) do
  { let "port=$port+1" ; }
done

export NETPORT=/tmp/planet.$USER.$port

##############################
## Start the main program.  ##
##############################

if ( test -x $NETDIR/$ARCH/$PROG ) then
  :
else
{
  MSG "$NETDIR/$ARCH/$PROG not installed.  Run $NETDIR/Install."
  return
}
fi

if( test "${XNetARGS:-NULL}" != NULL ) then
  PROG="$PROG $XNetARGS"
fi

MSG  "\
Running $NETDIR/$ARCH/$PROG in the background."
$NETDIR/$ARCH/$PROG </dev/null > /dev/null &

######################
## Run netcsh file ###
######################

MSG  "\
Running $NETDIR/netkorn."
. $NETDIR/netkorn

MSG  "\
$PROG is ready.  Type in any $PROG commands."

# unalias MSG
NETDIR=/soma/users/miyata/planet
# DIR=
# PROG=
# unalias FMT
# unalias MSG
