/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>
#include <stdio.h>

extern char *atomname[];
extern int functors[];
extern int arities[];

/* print(x, output) */
print_partially(x, depth, length)
     q x;
     unsigned int depth, length;
/*     FILE *output; */
{
  struct global_variables *glbl = &globals;
  int HeapSize = calcHeapSize();
  q* HeapTop = heaptop;
  int leng = length;
#ifdef TRACE
  extern int verbose_print;
#endif

  deref_and_switch(x, var, atomic, cons, composite);

 atomic:
  switch (atagof(x)) {
  case INT:
/*     fprintf(output, "%d", intval(x)); */
    printf("%d", intval(x));
    return;
  case SYM:
    if (x == NILATOM) {
/*      fprintf(output, "[]"); */
      printf( "[]");
    } else {
/*      fprintf(output, "%s", atomname[symval(x)-1024]); */
      printf( "%s", atom_name(x));
    }
    return;
  }

 var:
/*  fprintf(output, "_%x", addressof(x)); */
#ifdef TRACE
  if(!verbose_print || derefone(x) == x){
#endif
    if (!within_heap(x)) x = derefone(x);
    /* printf( "_%x", addressof(x)); */
    printf("_%X", (q*)x-heaptop);
    /* printf("%c", '*'); */
#ifdef TRACE
  } else {
    if (within_heap(x)) x = derefone(x);

    {
      q *hook = getnexthook(x);
      
      printf( "<");
      {
	q *loophook = hook;
	do{
	  struct goalrec *g;
	  g = ((struct shook *)loophook)->goals;
	  verbose_print = 0;
	  print_goal(g, 0);
	  verbose_print = 1;
	  loophook = getnexthook(loophook);
	  printf("->");
	}while((q)loophook != x);
	printf( ">");
      }
    }
  }
#endif
  return;
    
 cons:
/*  fprintf(output, "["); */
#ifdef GCDEBUG
  printf(" %x", x);
#endif
  printf( "[");
  if (depth == 0) {
    printf("..]");
    return;
  }
  while (1) {
/*    print(car_of(x), output); */
    print_partially(car_of(x), depth-1, length);
    x = cdr_of(x);
    deref_and_switch(x, othercdr, atomiccdr, conscdr, othercdr);
  conscdr:
/*    fprintf(output, ","); */
    printf( ",");
    if (--leng) continue;
    printf("..");
    goto listtail;
  }
 atomiccdr:
  if (issym(x) && symval(x) == 0) goto listtail;
 othercdr:
/*  fprintf(output, "|"); */
  printf( "|");
/*  print(x, output); */
  print_partially(x, depth-1, length);
 listtail:
/*  fprintf(output, "]"); */
  printf( "]");
  return;

 composite:
/*  fprintf(output, "FUNCTOR NOT IMPLEMENTED YET"); */
  { int i,j;
    q f = functor_of(x);
#ifdef GCDEBUG
    printf(" %x", x);
#endif
    if(isatomic(f)){
      if (f == makesym(functor_VECT)){
	printf("{");
	if (depth == 0) {
	  printf("..}");
	  return;
	}
	j = intval(arg(x,0));
	for(i=1; i < j; i++) {
	  print_partially(arg(x,i), depth-1, length);
	  printf(",");
	  if (i > length) {
	    printf("..");
	    goto vect_tail;
	  }
	}
	print_partially(arg(x,j), depth-1, length);
      vect_tail:
	printf("}");
      } else {
	printf("%s(",functoratomname(f));
	if (depth == 0) {
	  printf("..)");
	  return;
	}
	for (i = 0; i < arityof(f)-1; i++) {
	  print_partially(arg(x,i), depth-1, length);
	  printf(",");
	  if (i > length) {
	    printf("..");
	    goto funct_tail;
	  }
	}
	print_partially(arg(x,arityof(f)-1), depth-1, length);
      funct_tail:
	printf(")");
      }
    } else{
      printf("Invalid functor : %x\n", f);
    }
  }

/*   printf( "FUNCTOR NOT IMPLEMENTED YET"); */
  return;
}

print(x)
     q x;
{
  print_partially(x, (unsigned int)-1, (unsigned int)-1);
}

void printl(x)
q x;
{
  print(x);
  putc('\n',stdout);}

void *print_module();
struct predicate predicate_print__print__1 = { print_module, 0, 1 };

void *print_module(glbl, qp, allocp, fg, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     struct goalrec *fg;
     q *allocp;
     Const struct predicate *toppred;
{
  q reason;
  q a0;

 module_top:
  a0 = qp->args[0];
  print(a0);
  putc('\n',stdout);
}
