/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <string.h>
#include <klic/nametable.h>

char *malloc();

static unsigned int hash_name(name)
     char *name;
{
  unsigned int value = 0;
  char c;
  for (value = 0;
       c = *name++;
       value = 3*value + c)
    ;
  return value;
}

nametable create_nametable(n)
     int n;
{
  nametable table =
    (nametable) malloc(sizeof(struct nametable) +
		       (n-1) * sizeof(struct nametable_entry *));
  table->size = n;
  while (n--) table->table[n] = &table->sentinel;
  return table;
}

void update_nametable(table, name, value)
     nametable table; char *name; void *value;
{
  unsigned int index = hash_name(name)%table->size;
  struct nametable_entry *entry = table->table[index];
  table->sentinel.name = name;
  while (strcmp(entry->name, name)) entry = entry->next;
  if (entry == &table->sentinel) {
    struct nametable_entry *new =
      (struct nametable_entry *) malloc(sizeof(struct nametable_entry));
    new->name = name;
    new->value = value;
    new->next = table->table[index];
    table->table[index] = new;
  } else {
    entry->value = value;
  }
}

void * search_nametable(table, name)
     nametable table; char *name;
{
  unsigned int index = hash_name(name)%table->size;
  struct nametable_entry *entry = table->table[index];
  table->sentinel.name = name;
  while (strcmp(entry->name, name)) entry = entry->next;
  return ( entry == &table->sentinel ? 0 : entry->value );
}

void * get_nametable_entry(table, name)
     nametable table; char *name;
{
  unsigned int index;
  for (index = 0;
       index < table->size;
       index++) {
    struct nametable_entry *entry = table->table[index];
    if (entry != &table->sentinel) {
      table->table[index] = entry->next;
      (void) strcpy(name, entry->name);
      return entry->value;
    }
  }
  return 0;
}
