/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#include <klic/control.h>

static
struct goalrec *
do_fail(qp, reasonp)
     struct goalrec *qp;
     q *reasonp;
{
  /* Dummy definition */
  printf("!!! Reduction Failure !!!\n");
#ifdef TRACE
  trace_failure(qp);
#endif
  fatal("Failure handling mechanism not implemented yet\n");
}

struct goalrec *
interrupt_goal(qp, reasonp)
     struct goalrec *qp;
     q *reasonp;
{
  struct global_variables *glbl = &globals;
  int HeapSize;
  q* HeapTop;

#ifdef TRACE
  extern int trace_flag;
  if (trace_flag && (reasonp > reasons)) {
    trace_susp(qp, reasonp);
  }
#endif
  if (reasonp == 0) {
    /* Interrupt by some external event, such as: */
    /*   - A higher priority goal got ready for execution */
    /*   - Garbage collection required */
    /* In such cases, the interrupted goal is pushed down */
    /* Currently only garbage collection cases are handled */
    return qp;
  } else if (reasonp == &reasons[1] ||
	     /* single suspension, absolutely */
	     isSingleSuspension(reasonp)){
    /*
      single suspension
      */
    q reason = *(reasonp-1);
    struct goalrec *retval = qp->next;
    q tmp = derefone(reason);

#ifdef CSUSPS
    suspensions++;
#endif

    if(derefone(tmp) == tmp){
      /* susprec has not allocated yet */
      struct susprec *susp;
      struct shook *newrec;
      makesusprec(susp);
      makeshook(newrec, susp);
      newrec->goals = qp;
      initsusprec(susp, tmp, newrec);
#ifdef DEBUG
/*      dumpsrec(reason, susp);
      dumpshook(susp, newrec); */
#endif
    } else {
      /* "reason" is a pointer to suspension record */
      /*   with already suspended goals */
      struct shook *newrec;
      struct shook *oldrec;
      struct susprec *susprecord;
      q *first; q *next;

      HeapSize = calcHeapSize();
      HeapTop = heaptop;
      if(within_heap(tmp)){
	susprecord = (struct susprec *)refp(derefone(tmp));
      } else {
	susprecord = (struct susprec *)refp(tmp);
      }
      oldrec = (struct shook *)getnexthook(susprecord);
      makeshook(newrec, oldrec);
      if(ismhook(oldrec))
	setbackhook(mhookp(oldrec), newrec);
      newrec->goals = qp;
      setnexthook(susprecord, newrec);
#ifdef DEBUG
/*      dumpsrec(reason, susprecord);
      dumpshook(susprecord, newrec); */
#endif
    }
    return retval;
  } else if(reasonp > &reasons[1]) {
    /* Multiple suspension */
    q *loopp;
    struct mhook *prev = (void *)0;
    struct mhook *top = (void *)0;
    struct goalrec *retval = qp->next;
    struct mhook *beginning = (void *)0;

    HeapSize = calcHeapSize();
    HeapTop = heaptop;
#ifdef CSUSPS
    suspensions++;
#endif

    for(loopp=&reasons[0]; loopp<reasonp; ++loopp){
      q tmp = derefone(*loopp);
      if(tmp == *loopp) {
	/* has not suspended yet. */
	struct susprec *susp;
	struct mhook *newrec;
	makesusprec(susp);
	makemhook(newrec, susp);
	if(!beginning) beginning = newrec;
	/* future
	   qp->next = currentpriority;
	   */
	newrec->goals = qp;
	setbackhook(newrec, susp);
	newrec->pal = prev;
	prev = newrec;
	initsusprec(susp, *loopp, newrec) ;
	derefone(*loopp) = makeref(susp);
      } else {
	/* already suspended */
	struct susprec *susprecord;

	if(within_heap(tmp)){
	  susprecord = suspp(derefone(tmp));
	} else {
	  susprecord = suspp(tmp);
	}

	/* if next is msusp record AND next->goals == qp, no operation */
	if(isshook(getnexthook(susprecord)) || 
	   mhookp(getnexthook(susprecord))->goals != qp){
	  /* This goals has not hooked by to this variable */
	  struct mhook *newrec;
	  makemhook(newrec, getnexthook(susprecord));
	  if(!beginning) beginning = newrec;
	  newrec->goals = qp;
	  setbackhook(newrec, susprecord);
	  newrec->pal = prev;
	  prev = newrec;
	  setnexthook(susprecord, newrec);
	}
      }
    }
    /* now ''prev'' points the last msusp record */
    beginning->pal = prev;
    return(retval);
  }else if (reasonp < &reasons[1]) {
    return do_fail(qp, reasons[0]);
  }
}

/*
  decide single suspension or multiple suspension
*/

int isSingleSuspension(reasonp)
     q *reasonp;
{
  q *tmp;
  struct global_variables *glbl = &globals;
  if(reasonp>&reasons[0]){
    for(tmp=reasons; tmp<reasonp; ++tmp){
      if(*tmp!=reasons[0]){
	return(0);
      }
    }
    return(1);
  }
  return(0);
}
