/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/arith.h>
#include <klic/timing.h>
#include <klic/gb.h>
#include <stdio.h>

timerstruct before, after;

void *builtin_module();
Const struct predicate predicate_builtin__add__3 = { builtin_module, 0, 3 };
Const struct predicate predicate_builtin__sub__3 = { builtin_module, 1, 3 };
Const struct predicate predicate_builtin__mul__3 = { builtin_module, 2, 3 };
Const struct predicate predicate_builtin__div__3 = { builtin_module, 3, 3 };
Const struct predicate predicate_builtin__print__1 = { builtin_module, 4, 1};
Const struct predicate predicate_builtin__readint__1 = { builtin_module, 5, 1};
Const struct predicate predicate_builtin__start__measure__0
  = {builtin_module, 6, 0};
Const struct predicate predicate_builtin__report__measure__1
  = {builtin_module, 7, 1};
Const struct predicate predicate_builtin__merge__2 = { builtin_module, 8, 2};
Const struct predicate predicate_builtin__left__shift__3
  = { builtin_module, 9, 3};
Const struct predicate predicate_builtin__right__shift__3
  = { builtin_module, 10, 3};
Const struct predicate predicate_builtin__mod__3
  = { builtin_module, 11, 3};

void *builtin_module(glbl, qp, allocp, fg, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  struct goalrec *fg;
  q *allocp;
  Const struct predicate *toppred;
{
  q a0, a1, a2;

  q *reasonp;
 module_top:
  switch_on_pred() {
    case_pred(0, add_3_top);
    case_pred(1, sub_3_top);
    case_pred(2, mul_3_top);
    case_pred(3, div_3_top);
    case_pred(4, print_1_top);
    case_pred(5, readint_1_top);
    case_pred(6, start_measure_0_top);
    case_pred(7, report_measure_0_top);
/*    last_case_pred(8, merger_2_top);*/
    case_pred(8, merger_2_top);
    case_pred(9, shift_left_3_top);
    case_pred(10, shift_right_3_top);
    last_case_pred(11, mod_3_top);
  }

 add_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)+intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }
 sub_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)-intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }
 mul_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)*intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }
 div_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)/intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }
 print_1_top:
  {
    extern print();
    a0 = qp->args[0];
    print(a0);
    putc('\n', stdout);
    proceed();
  }
 readint_1_top:
  {
    int n;
    q x0;
    a0 = qp->args[0];
    fprintf(stdout, "> ");
    fscanf(stdin, "%d", &n);
    while (getc(stdin) != '\n')
      ;
    x0 = makeint(n);
    unify(a0, x0);
    proceed();
  }

/* system merger */
 merger_2_top:
  {
    struct global_variables *glbl = &globals;
    int HeapSize = calcHeapSize();
    q* HeapTop = heaptop;

    a0 = qp->args[0];
    a1 = qp->args[1];
    {
      struct susprec *s;
      struct merger *m;
      struct merger_common *c;
      int need_resume_goals = 0;
      q x0;

      /* unify(c->variable, a1);*/
      /* deref and tag dispatch on output */
     again:
      if(isref(a1)){
	q tmp = derefone(a1);
	if(tmp == a1) {
	  goto alloc_merger;
	} else if (!within_heap(a1)){
	  /* output is undefined variable */
	  struct susprec *olds = suspp(a1);
	  if(ismerger(getnexthook(olds))){
	    struct merger *oldm = (struct merger *)getnexthook(olds);
	    makesusprec(s);
	    makemerger(m, s);
	    initsusprec(s, a1, m);
	    ++(oldm->common->counter);
	    m->common = oldm->common;
	    goto unify_input;
	  } else {
	    need_resume_goals = 1;
	  }
	} else {
	  a1 = tmp;
	  goto again;
	}
      }
     alloc_merger:
      makemergercommon(c);
      c->variable = a1;
      c->counter = 1;
      makesusprec(s);
      makemerger(m, s);
      initsusprec(s, a1, m);
      m->common = c;

     unify_input:
      *(allocp) = makeref(s);
      x0 = makeref(allocp++);
      unify(x0, a0);
      proceed();
    }
  }

 shift_left_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)<<intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }

 shift_right_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)>>intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }


 mod_3_top:
  {
    a0 = qp->args[0];
    a1 = qp->args[1];
    a2 = qp->args[2];
    reasonp = reasons;
    deref(a0, interrupt_3);
    deref(a1, interrupt_3);
    if (isint(a0) && isint(a1)) {
      q x = makeint(intval(a0)%intval(a1));
      unify(a2, x);
      proceed();
    } else {
      goto interrupt_3;
    }
  }

    
 start_measure_0_top:
  {
    measure(before);
    proceed();
  }
 report_measure_0_top:
  {
    q x0;
    a0 = qp->args[0];
    measure(after);
    printf("heap size = %d words\n", heapsize);
    {
#ifdef SYSV
      long u_msec = (int) tick2msec(diff(tms_utime));
      long s_msec = (int) tick2msec(diff(tms_stime));
      long t_msec =
	(int) (tick2msec(diff(tms_utime)) + tick2msec(diff(tms_stime)));
      x0 = makeint(t_msec);
      printf("%d ms total; %d user; %d system\n",
	     t_msec, u_msec, s_msec);
#else SYSV
      long u_usec = diff_usec(ru_utime);
      long s_usec = diff_usec(ru_stime);
      long t_usec = u_usec + s_usec;
      long swaps = diff(ru_nswap);
      long minflt = diff(ru_minflt);
      long majflt = diff(ru_majflt);
      long inblock = diff(ru_inblock);
      long outblock = diff(ru_oublock);
      long nvcsw = diff(ru_nvcsw);
      long nivcsw = diff(ru_nivcsw);
      x0 = makeint(t_usec/1000);
      printf("%d ms total; %d user; %d system\n",
	     t_usec/1000, u_usec/1000, s_usec/1000);
      printf("  %d swaps; %d minor page faults; %d major page faults\n",
	     swaps, minflt, majflt);
      printf("  %d block input; %d block output\n",
	     inblock, outblock);
      printf("  %d context switches (%d voluntary)\n",
	     nvcsw+nivcsw, nvcsw);
#endif
      printf("  ");
      if (measure_gc) {
	printf("%d ms utime & %d ms stime in ",
	       gcums, gcsms);
      }
      printf("%d GC\n", gctimes);
    }
    unify(a0, x0);
    proceed();
  }
 interrupt_3:
  qp->args[2] = a2;
 interrupt_2:
  qp->args[1] = a1;
 interrupt_1:
  qp->args[0] = a0;
 interrupt_0:
  qp->pred = toppred;
  qp = interrupt_goal(qp, reasonp);
  goto proceed_after_interrupt;
 proceed_label:
  pop_goal();
 proceed_after_interrupt:
  loop_within_module(builtin_module);
}
