/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
extern struct goalrec *do_unify(), *do_unify_value();

#ifdef COMPACTCODE
#define unify(x, y) \
{ \
  qp = do_unify(qp, (x), (y), allocp); \
  allocp = heapp; \
}
#define unify_value(x, y) \
{ \
  qp = do_unify_value(qp, (x), (y), allocp); \
  allocp = heapp; \
}
#else
#define unify(x, y)\
{								\
  if (!isref(x) || derefone(x) != (x)) {			\
    qp = do_unify(qp, (x), (y), allocp);			\
    allocp = heapp;						\
  } else {							\
    derefone(x) = (y);						\
  }								\
}
#define unify_value(x, y)\
{								\
  if (!isref(x) || derefone(x) != (x)) {			\
    qp = do_unify_value(qp, (x), (y), heapp);			\
    allocp = heapp;						\
  } else {							\
    derefone(x) = (y);						\
  }								\
}
#endif

#define unify_with_ref(x, y)					\
{								\
  if (derefone(x) != (x)) {					\
    qp = do_unify(qp, (x), (y));				\
  } else {							\
    derefone(x) = (y);						\
  }								\
}

#define unify_integer(x, n)	{ unify((x), makeint(n)); }
#define unify_symbol(x, a)	{ unify((x), makesym(a)); }
