/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* Reasons of interruption */
#define EXTEVENT	makeint(0)
#define FAILURE		makeint(1)

struct goalrec *more_goal_records();
struct goalrec *interrupt_goal();
struct goalrec *interrupt_goal_m();

/* special memory allocation stuffs */
/*
  * struct susprec *initsusprec();
  * struct shookrec *initshooks();
  * struct mhookrec *initmhooks();
*/
struct susprec *more_susprec();
struct shookrec *more_shook_records();
struct mhookrec *more_mhook_records();

#define allocate_goalrec(gr)		\
{					\
  if (((gr) = fg) == 0) {		\
    (gr) = more_goal_records(glbl);	\
  }					\
  fg = (gr)->next;			\
}

#define extend_goalrec(orig, ext)	\
{					\
  struct goalrec *temp;			\
  allocate_goalrec(temp);		\
  (orig)->args[NUMGOALARGS-1] =		\
    (q)temp;				\
  (ext) = temp;				\
}

#define push_goal()			\
{					\
  struct goalrec *temp;			\
  allocate_goalrec(temp);		\
  temp->next = qp;			\
  qp = temp;				\
}

#define push_goal_from_secondary_pool()			\
{							\
  struct goalrec *temp;					\
  if ((temp = secondary_free) == 0) {			\
    temp = more_goal_records(glbl);			\
  }							\
  secondary_free = temp->next;				\
  temp->next = qp;					\
  qp = temp;						\
}

#define return_goalrec(gr)				\
{							\
  (gr)->next = fg;					\
  fg = (gr);						\
}

#define pop_goal()					\
{							\
  struct goalrec *temp;					\
  temp = qp->next;					\
  return_goalrec(qp);					\
  qp = temp;						\
}

#define switch_on_pred()	switch (toppred->pred)

#define case_pred(p, label)	case (p): goto label;

#define last_case_pred(p, label) default: goto label;

#define loop_within_module(f)				\
{							\
  loop_within_module_debug(toppred, &heapp, heaplimit, f, qp, queue, &freegoals); \
{ \
  module func;						\
  if (allocp >= heaplimit) {				\
    allocp = gc(qp, fg, allocp);			\
    qp = queue;						\
    fg = freegoals;					\
  }							\
  if ((func = (toppred = qp->pred)->func) == (f))	\
    goto module_top;					\
  heapp = allocp;					\
  queue = qp;						\
  freegoals = fg;					\
  return (void *)func;					\
} \
}

#ifdef LDEBUG
#define loop_within_module_debug(t, a, h, func, qp, q, fg) \
{ \
  printf("toppred:\t%x\n", toppred); \
  printf("allocp:\t%x\n", allocp); \
  printf("heaplimit:\t%x\n", heaplimit); \
  printf("current module:\t%x\n", func); \
  printf("qp:\t%x\n", qp); \
  printf("queue:\t%x\n", q); \
  printf("&fg\t%x\n", fg); \
}
#else
#define loop_within_module_debug(t, a, h, func, qp, q, fg)
#endif

#define execute(label)\
{\
  if (allocp < heaplimit) goto label;\
}

#define proceed()		\
{				\
  goto proceed_label;		\
}

