/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
q do_add(), do_subtract();

#define deref(x, susplab) \
{ \
  while (isref(x)) { \
    q temp0 = derefone(x); \
    if (isref(temp0)){ \
      q temp1 = derefone(temp0); \
      if((x) == temp1) { \
	*reasonp++ = (x); \
	goto susplab; \
      } else { /* temp0 is ref */ \
	(x) = temp1; \
      } \
    } else { /* temp0 is not ref */ \
      (x) = temp0; \
    } \
  } \
}

#define derefint(x, nonint)				\
{		    					\
  deref(x, nonint);					\
  if (!isint(x)) goto nonint;				\
}

#ifdef COMPACTCODE
#define arith_constant(x, n, y, label, routine, oprtr)\
{ (y) = routine((x), makeint(n)); }
#define arith(x, y, z, label, routine, oprtr)\
{ (z) = routine((x), (y)); }
#else
#define arith_constant(x, n, y, label, routine, oprtr)\
{\
  derefint((x), label);\
  (y) = makeint(intval(x) oprtr (n));\
  if (0) {\
  label: (y) = routine((x), makeint(n));\
  }\
}
#define arith(x, y, z, label, routine, oprtr)\
{\
  derefint((x), label);\
  derefint((y), label);\
  (z) = makeint(intval(x) oprtr intval(y));\
  if (0) {\
  label: (z) = routine((x), (y));\
  }\
}
#endif

#define add_constant(x, n, y, label)\
{ arith_constant((x), (n), (y), label, do_add, +); }

#define subtract_constant(x, n, y, label)\
{ arith_constant((x), (n), (y), label, do_subtract, -); }
