/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
write_out(module(Name, Preds, Info),InFile) :-
	write_module_header(Name,Preds,MinArity,MaxArity,MinSusp,MaxSusp,Info),
	write_predicates(Preds,Name,MinArity,Info,InFile),
	write_module_tailer(Name,MaxArity,MinSusp,MaxSusp).

write_module_header(Name,Predicates,MinArity,MaxArity,MinSusp,MaxSusp,Info) :-
	format("void *~a_module();~n", [Name]),
	write_pred_structs(Predicates, Name),
	declare_ext_preds(Info),
	format("~n", []),
	format("void *~a_module(glbl, qp, allocp, fg, toppred)~n", [Name]),
	format("  struct global_variables *glbl;~n", []),
	format("  struct goalrec *qp;~n", []),
	format("  struct goalrec *fg;~n", []),
	format("  q *allocp;~n", []),
	format("  Const struct predicate *toppred;~n", []),
	format("{~n", []),
	pred_min_max(Predicates, 99999, MinArity0, 0, MaxArity,
		     0, MinSusp, 0, MaxSusp),
	(
	    MinArity0 =\= MaxArity,
	    max_arg_pos(MAP),
	    MinArity0 =\= 0,
	    MinArity0 mod (MAP+1) =:= 0 ->
	    MinArity is MinArity0 - 1
	;
	    MinArity = MinArity0
	),
	format("  struct goalrec *xp;~n", []),
	declare_registers(MaxArity, "a"),
	format("~n", []),
	format("  q *reasonp;~n", []),
	format(" module_top:~n", []),
	write_get_args(0, MinArity),
	format("  switch_on_pred() {~n", []),
	write_pred_dispatch(Predicates),
	format("  }~n", []).

% Predicate information:
%	pred(Name, Arity, SeqNum, Works, MaxSusp, Object)

make_ext_table([],NA,NA,A,A,NF,NF,F,F,NP,NP,P,P).
make_ext_table([pred(_,_,_,_,_,Object)|Rest],
	       NA0,NA,A0,A,NF0,NF,F0,F,NP0,NP,P0,P) :-
	find_extern(Object,NA0,NA1,A0,A1,NF0,NF1,F0,F1,NP0,NP1,P0,P1),
	make_ext_table(Rest,NA1,NA,A1,A,NF1,NF,F1,F,NP1,NP,P1,P).

write_pred_structs([], _).
write_pred_structs([pred(Name, Arity, SeqNum, _, _, _)|Rest], Module) :-
	format("Const struct predicate ", []),
	write_pred_name(Module,Name,Arity),
	format(" = { ~a_module, ~d, ~d };~n", [Module, SeqNum, Arity]),
	write_pred_structs(Rest, Module).

declare_ext_preds([]).
declare_ext_preds([ext(Mod/Name/Arty)|T]) :-
	member(T,ext(Mod/Name/Arty)), !,
	declare_ext_preds(T).
declare_ext_preds([ext(Mod/Name/Arty)|T]) :- !,
	format("extern struct predicate ", []),
	write_pred_name(Mod, Name, Arty),
	format(";~n", []),
	declare_ext_preds(T).
declare_ext_preds([_|T]) :-
	declare_ext_preds(T).

pred_min_max([], MinA, MinA, MaxA, MaxA, MinS, MinS, MaxS, MaxS).
pred_min_max([pred(_,Arity,_,_,Susps,_)|Rest],
	     MinA0, MinA, MaxA0, MaxA, MinS0, MinS, MaxS0, MaxS) :-
	min(Arity, MinA0, MinA1),
	max(Arity, MaxA0, MaxA1),
	min(Susps, MinS0, MinS1),
	max(Susps, MaxS0, MaxS1),
	pred_min_max(Rest, MinA1, MinA, MaxA1, MaxA, MinS1, MinS, MaxS1, MaxS).

declare_registers(0, _) :- !.
declare_registers(N, S) :-
	write_comma_list(N, S, "  q "),
	format(";~n", []).

write_comma_list(0, _, _) :- !.
write_comma_list(N, S, Header) :-
	N1 is N-1,
	format("~s", [Header]),
	write_comma_list1(0, N1, S),
	format("~s~d", [S,N1]).

write_comma_list1(N, N, _) :- !.
write_comma_list1(K, N, S) :-
	format("~s~d, ", [S,K]),
	K1 is K+1,
	write_comma_list1(K1, N, S).

declare_regs(N, N, _) :- !.
declare_regs(K, N, S) :-
	format("~s~d, ", [S,K]),
	K1 is K+1,
	declare_regs(K1, N, S).

write_pred_dispatch([pred(Name, Arity, SeqNum, _, _, _)]) :- !,
	format("    last_case_pred(~d, ~a_~d_top);~n", [SeqNum, Name, Arity]).
write_pred_dispatch([pred(Name, Arity, SeqNum, _, _, _)|Rest]) :-
	format("    case_pred(~d, ~a_~d_top);~n", [SeqNum, Name, Arity]),
	write_pred_dispatch(Rest).

write_predicates([],_,_,_,_).
write_predicates([pred(Name,Arity,_,Works,MaxSusp,Object)|Rest],
		 Module,Min,Info,InFile) :-
	format("~n", []),
	format(" ~a_~d_top: {~n", [Name, Arity]),
	declare_registers(Works, "x"),
	write_get_args(Min, Arity),
	format(" ~a_~d_clear_reason:~n", [Name, Arity]),
	format("  reasonp = reasons;~n", []),
	format(" ~a_~d_loop:~n", [Name, Arity]),
	write_object(Object, info(Module/Name/Arity,MaxSusp),InFile),
	format(" ~a_~d_ext_interrupt:~n", [Name,Arity]),
	format("  reasonp = 0;~n", []),
	format(" ~a_~d_interrupt:~n",[Name,Arity]),
	(
	    member(Info, exec(Name/Arity)) ->
	    format("  toppred = &", []),
	    write_pred_name(Module,Name,Arity),
	    format(";~n", [])
	;
	    true
	),
	format("  goto interrupt_~d;~n", [Arity]),
	format(" }~n", []),
	write_predicates(Rest,Module,Min,Info,InFile).

write_get_args(K, N) :-
	max_arg_pos(MAP),
	(
	    K =< MAP ->
	    write_get_args(K, N, qp)
	;
	    write_get_args(K, N, xp)
	).

write_get_args(N, N, GR) :- !,
	(
	    GR = xp ->
	    format("  return_goalrec(xp);~n", [])
	;
	    true
	).
write_get_args(K, N, GR0) :-
	max_arg_pos(MAP),
	(
	    K =\= N-1,
	    K mod (MAP+2) =:= MAP ->
	    (
		GR0 = xp ->
		format("  return_goalrec(xp);~n", [])
	    ;
		true
	    ),
	    format("  xp = (struct goalrec *)~w->args[~d];~n", [GR0,MAP]),
	    GR = xp,
	    P = -2
	;
	    GR = GR0,
	    P is (K+1) mod (MAP+2) - 1
	),
	format("  a~d = ~w->args[~d];~n", [K, GR, P]),
	K1 is K+1,
	write_get_args(K1, N, GR).

write_guard([]).
write_guard([H|T]) :- write_one_guard(H), write_guard(T).

write_one_guard(X) :- format("  ~w~n", [X]).

write_body([]).
write_body([H|T]) :- write_one_body(H), write_body(T).

write_one_body(X) :- format("  ~w~n", [X]).

write_module_tailer(Name, MaxArity, _MinSusp, _MaxSusp) :-
	write_interrupt_call(MaxArity, MaxArity),
	format(" proceed_label:~n", []),
	format("  pop_goal();~n", []),
	format(" proceed_after_interrupt:~n", []),
	format("  loop_within_module(~a_module);~n", [Name]),
	format("}~n", []).

/*
  Interrupt labels have the following structure.

  interrupt_N_cont:
    Entry for continued from N+1 argument case;
    If at the boundary,
      Store argument #(N-1) to goal record extension;
      Allocate goal record extension if needed;
      Store pointer to extension to qp or newly allocated extension;
      goto interrupt_(N-1)_cont;
    Otherwise,
      goto interrupt_N_common;
  interrupt_N:
    Entry for N argumeng case;
    Allocate goal record extension, if needed;
  interrupt_N_common:
    Store argument #(N-1) to goal record;
*/

write_interrupt_call(0, _) :- !,
	format(" interrupt_0_cont:~n", []),
	format(" interrupt_0:~n", []),
	format("  qp->pred = toppred;~n", []),
	format("  qp = interrupt_goal(qp, reasonp);~n", []),
	format("  goto proceed_after_interrupt;~n", []).
write_interrupt_call(N, Max) :-
	max_arg_pos(MAP),
	P is (N+1) mod (MAP+2) - 2,
	N1 is N-1,
	format(" interrupt_~d_cont:~n", [N]),
	(
	    P =:= -2 ->				% at the boundary
	    format("  xp->args[-2] = a~d;~n", [N1]),
	    (
		N > MAP+1 ->
		format("  {~n", []),
		format("    struct goalrec *xxp;~n", []),
		format("    allocate_goalrec(xxp);~n", []),
		format("    xxp->args[~d] = (q)xp;~n", [MAP]),
		format("    xp = xxp;~n", []),
		format("  }~n", [])
	    ;
		format("  qp->args[~d] = (q)xp;~n", [MAP])
	    ),
	    format("  goto interrupt_~d_cont;~n", [N1])
	;
	    format("  goto interrupt_~d_common;~n", [N])
	),
	format(" interrupt_~d:~n", [N]),
	(
	    N > MAP+1 ->
	    format("  allocate_goalrec(xp);~n", []),
	    GR = xp
	;
	    GR = qp
	),
	(
	    P =:= -2 ->
	    format("  ~w->args[~d] = a~d;~n", [GR, MAP, N1]),
	    format(" interrupt_~d_common:~n", [N])
	;
	    format(" interrupt_~d_common:~n", [N]),
	    format("  ~w->args[~d] = a~d;~n", [GR, P, N1])
	),
	write_interrupt_call(N1, Max).

% Writing out inter-module info to the header file

write_header_file(module(_, Preds, _)) :-
	make_ext_table(Preds,0,_,[],A,0,_,[],F,0,_,[],P),
	write_ext_atoms(A),
	write_ext_functs(F),
	write_ext_preds(P).

write_ext_atoms([]).
write_ext_atoms([A=_|T]) :-
	write_atom_name(A),
	enter_atom(A,_),
	format("~n", []),
	write_ext_atoms(T).

write_ext_functs([]).
write_ext_functs(['VECT'/_=_|T]):- !,
	write_ext_functs(T).
write_ext_functs([F/A=_|T]) :-
	write_funct_name(F,A),
	enter_functor(F,A,_),
	format("~n", []),
	write_ext_functs(T).

write_ext_preds([]).
write_ext_preds([Mod/Pred/Arity=_|T]) :-
	write_pred_name(Mod,Pred,Arity),
	format("~n", []),
	write_ext_preds(T).

% Subroutines for writing atom and functor names in a canonical manner

write_atom([]) :- !, format("NILATOM", []).
write_atom(N) :- integer(N), !, format("makeint(~d)", [N]).
write_atom(Atom) :-
	format("makesym(", []),
	write_atom_name(Atom),
	format(")", []).

write_atom_name(Atom) :-
	name(Atom, AtomName),
	make_atom_name_string(AtomName, AtomNameString),
	format("atom_~s", [AtomNameString]).

write_funct('VECT'/_) :- !,
	format("makesym(functor_VECT)",[]).
write_funct(Funct/Arity) :-
	format("makesym(", []),
	write_funct_name(Funct,Arity),
	format(")", []).

write_funct_name('VECT',1) :- !,
        format("functor_VECT",[]).
write_funct_name(Funct,Arity) :-
	name(Funct, FunctName),
	make_atom_name_string(FunctName, FunctNameString),
	format("functor_~s__~d", [FunctNameString, Arity]).

write_pred_name(Module,Pred,Arity) :-
	name(Module, ModuleName),
	make_atom_name_string(ModuleName, ModuleNameString),
	name(Pred, PredName),
	make_atom_name_string(PredName, PredNameString),
	format("predicate_~s__~s__~d",
	[ModuleNameString, PredNameString, Arity]).

make_atom_name_string([],Str) :- Str = [].
make_atom_name_string([H|T],Str) :-
	(
	    "0" =< H, H =< "9"
	;
	    "A" =< H, H =< "Z"
	;
	    "a" =< H, H =< "z"
	), !,
	Str = [H|StrT],
	make_atom_name_string(T, StrT).
make_atom_name_string([0'_|T],[0'_,0'_|StrT]) :-
	make_atom_name_string(T, StrT).
make_atom_name_string([H|T],[0'_|Str]) :-
	ascii_string(H, Str, StrT),
	make_atom_name_string(T, StrT).

ascii_string(C, [Upper, Lower|T], T) :-
	U is C>>4, hexchar(U, Upper),
	L is C/\15, hexchar(L, Lower).

hexchar(C, N) :- C < 10, !, N is "0" + C.
hexchar(C, N) :- N is "A" + C - 10.
