/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
:- op(1150, fx, (module)).
:- op(600, xfy, (:)).
:- op(700, xfx, (:=)).

max_arg_pos(5).				% max arg position in one goal rec

klcmp(Name) :-
	name(Name, CharList),
	append(CharList, ".kl1", InCharList),
	name(InFile, InCharList),
	append(CharList, ".c", OutCharList),
	name(OutFile, OutCharList),
	append(CharList, ".ext", HdrCharList),
	name(HdrFile, HdrCharList),
	compile(InFile, OutFile, HdrFile, CharList, InCharList).

compile(InFile, OutFile, HdrFile, CharList, InCharList) :-
	read_in(InFile, Modules),
	tell(OutFile),
	write_file_header(CharList),
	compile_modules(Modules, OutFile, HdrFile, InCharList),
	close(OutFile),
	close(HdrFile).

write_file_header(_Name) :-
	format("#include <klic/basic.h>~n", []),
	format("#include <klic/struct.h>~n", []),
	format("#include <klic/primitives.h>~n", []),
	format("#include <klic/unify.h>~n", []),
	format("#include <klic/index.h>~n", []),
	format("#include <klic/arith.h>~n", []),
	format("#include <klic/gb.h>~n", []),
	format("#include ""atom.h""~n", []),
	format("#include ""funct.h""~n", []),
	format("~n", []).

compile_modules([], _, _,_).
compile_modules([One|Rest], OutFile, HdrFile, InFile) :-
	analyze(One, Module),
	tell(OutFile),
	write_out(Module,InFile),
	tell(HdrFile),
	write_header_file(Module),
	compile_modules(Rest, OutFile, HdrFile, InFile).

read_in(InFile, Terms) :-
	nofileerrors,
	see(InFile),!,
	fileerrors,
	read(Term),
	read_all(Term, Terms),
	seen.
read_in(InFile, _) :-
	fileerrors,
	format("~a does Not exist !!~n",[InFile]),
	fail.

read_all(end_of_file, Tail) :- !, Tail = [].
read_all((:- module(X)), [[(:- module(X))|One]|Tail]) :- !,
	read(More), 
	read_one_module(More, One, Next),
	read_all(Next, Tail).

read_one_module(end_of_file, Tail, Next) :- !,
	Tail = [], Next = end_of_file.
read_one_module((:- module(X)), Tail, Next) :- !,
	Tail = [], Next = (:- module(X)).
read_one_module(':-'(_), Tail, Next) :- !,
	read(X),
	read_one_module(X, Tail, Next).
read_one_module(One, [One|Tail], Next) :-
	read(X),
	read_one_module(X, Tail, Next).

analyze([(:- module(Name))|Rest], module(Name, Predicates, Ex)) :- !,
	analyze_preds(Rest, 0, Predicates, Ex, []).
analyze([_|Rest], module(unknown, Predicates, Ex)) :-
	format(user_error, "Module delaration not found~n", []),
	analyze_preds(Rest, 0, Predicates, Ex, []).

analyze_preds([], _, [], Ex, Ex).
analyze_preds([Clause|Rest0], Seq0,
	      [pred(Name, Arity, Seq0, Works, Susps, Object) | OtherPreds],
	      Ex0, Ex) :-
	clause_format(Clause, Head, Guard, Body),
	functor(Head, Name, Arity),
	Clauses = [clause(Name/Arity/0, Head, Guard, Body)|OtherClauses], 
	collect_same(Rest0, Rest, Name, Arity, 1, OtherClauses),
	generate(Name/Arity, Clauses, Works, Susps, Exx, [], Object),
	remove(Exx, exec(Name/Arity), Ex0, Ex1),
	Seq1 is Seq0+1,
	analyze_preds(Rest, Seq1, OtherPreds, Ex1, Ex).

clause_format((Head :- Guard | Body), Head, Guard, Body) :- !.
clause_format((Head :- Body), Head, true, Body) :- !.
clause_format(otherwise,_,_,_) :- !, fail.
clause_format(alternatively,_,_,_) :- !, fail.
clause_format(Head, Head, true, true).

collect_same([Clause|Rest0], Rest, Name, Arity, K,
	[clause(Name/Arity/K, Head, Guard, Body)|OtherClauses]) :-
	clause_format(Clause, Head, Guard, Body),
	functor(Head, Name, Arity), !,	
	K1 is K+1,
	collect_same(Rest0, Rest, Name, Arity, K1, OtherClauses).
collect_same([otherwise|Rest0], Rest, Name, Arity, K,
	[otherwise|OtherClauses]) :- !,
	collect_same(Rest0, Rest, Name, Arity, K, OtherClauses).
collect_same([alternatively|Rest0], Rest, Name, Arity, K,
	[alternatively|OtherClauses]) :- !,
	collect_same(Rest0, Rest, Name, Arity, K, OtherClauses).
collect_same(Rest, Rest, _, _, _, []).
