/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/*
  module data type

+---------+
| methd   |
+---------+
| func()  |
+---------+
| symbol  |
+---------+
*/


#include <nlist.h>
#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

#include <klic/gmodule.h>

#define GD_CLASS_NAME() module
#define GD_OBJ_TYPE struct module_object
#define GD_OBJ_SIZE(obj) (sizeof(struct module_object))/sizeof(q)

#include <klic/gd_macro.h>

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->module != GD_OTHER->module)
    GD_GUNIFY_FAIL;
  else
    GD_GSUCCEED;
}


GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->module != GD_OTHER->module)
    GD_UNIFY_FAIL;
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->module = GD_SELF->module;
  newself->name = GD_SELF->name;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(name_1)
{
  G_STD_DECL;
  GD_UNIFY( GD_ARGV[0],GD_SELF->name);
  GD_RETURN;
}


GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_METHOD_CASE(name_1);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

GDDEF_PRINT()
{
  G_STD_DECL;
  GD_PRINT("<MODULE#");
  GD_PRINT_KL1_TERMS(GD_SELF->name, 0, 1);
  GD_PRINT(">");
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

GDDEF_GMETHOD(module_0)
{
 G_STD_DECL;
 if (G_SYMVAL(GD_SELF->module)) { GD_GSUCCEED; }
 else {GD_GFAIL;}
}

GDDEF_GGENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(module_0);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

/* define the method table structure of the vector */
#include <klic/gd_method_table.h>

/*  new_module function */
/*
  The argument is only one and it's the name of the module
*/

GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  q atom;
  char namebuf[1024];
  char tmpbuf[1024];
  struct nlist nl[2];

  GDSET_SYMARG_FOR_NEW(atom,GD_ARGV[0]);
  strcpy(namebuf, PREFIX_STRING);
  strcat(namebuf, "module_");
  strcat(namebuf, klic_encode(namestringof(atom), tmpbuf));
  nl[0].n_name = namebuf;
  nl[1].n_name = (char *)0;
  if((nlist(program_name, nl) != 0) ||
     !ISVALIDSYMBOL(nl[0])) {
    nl[0].n_value = 0;
/*
    char message[1024];
    sprintf(message,
	    "Nonexistent module ""%s""",
	    namestringof(atom));
    GD_ERROR_IN_NEW(message);
*/
  }
    
  {
    GD_OBJ_TYPE *newmodule;
    
    GDSET_NEWOBJ_FOR_NEW(newmodule,sizeof(struct module_object));
    newmodule->module = makesym(nl[0].n_value);
    newmodule->name = atom;
    GD_RETURN_FROM_NEW(newmodule);
  }
}
