/* ----------------------------------------------------------
%   (C)1993 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/timing.h>
#include <stdio.h>
#include <klic/functorstuffs.h>
#include <klic/gcdebug.h>
#include <klic/schedule.h>
#include <klic/gobj.h>
#include <klic/susp.h>

#ifdef GCSTATS
q* last_top = 0;
unsigned long vars_copied, long_lived, long_lived_vars;
#define VARCOPIED(x) \
{ \
  vars_copied++; \
  if ((q*)(x) < last_top) long_lived_vars++; \
}
#define TERMCOPIED(x) \
{ \
  if (isref(x)) { \
    q temp = derefone(x); \
    if ((x) == temp || (isref(temp) && derefone(temp) == x)) \
      VARCOPIED(x); \
  } \
}
#define COPIED(old,size) if ((q*)(old) < last_top) long_lived+=(size);
#else
#define VARCOPIED(x)
#define TERMCOPIED(x)
#define COPIED(x,s)
#endif

extern struct goalrec goal_queue_tail;
int copying_below = 1;

extern void *malloc(), *realloc();


q *gc(allocp, qp)
     q *allocp;
     struct goalrec *qp;
{
  declare_globals;
  timerstruct before, after;
  long retry;
  extern struct goalrec *interrupt_handler();
#ifdef TRACE
  extern int trace_flag;
  extern struct goalrec *trace_after();
#endif

 retry_top:
  retry = 0;

  {
    struct goalrec *rsmg = resumed_goals;
    if (rsmg != 0) {
      struct goalrec *newqp = rsmg->next;
      rsmg->next = qp;
      qp = newqp;
      resumed_goals = 0;
      if (interrupt_off) heaplimit = real_heaplimit;
    }
  }

#ifdef TRACE
  if (trace_flag) {
    qp = trace_after(qp, allocp);
    allocp = heapp;
  }
#endif
  /* interrupt */
  if (!interrupt_off) {
    if (!(qp = interrupt_handler(qp,allocp))) {
      qp = interrupt_qp;
      retry = 1;
      real_heaplimit = 0;
    }
  }
  /* priority support */
  if (higher_priority_goal) {
    put_priority_queue(qp, current_prio);
    qp = get_top_priority_queue();
    if (interrupt_off) heaplimit = real_heaplimit;
    else heaplimit = 0;
  }
  if (allocp >= real_heaplimit) {
    static struct goalrec *collect_garbage();
#ifdef GCSTATS
    vars_copied = 0;
    long_lived = 0;
    long_lived_vars = 0;
#endif
#ifdef GCDEBUG
    fprintf(stderr, "before GC\n");
    dump_queue(qp);
#endif
    if (measure_gc) measure(before);
    heapp = allocp;
    qp = collect_garbage(qp);
    allocp = heapp;
#ifdef GCDEBUG
    fprintf(stderr, "heaplimit : %x\nheapp : %x\n", heaplimit, heapp);
#endif
    if (real_heaplimit < allocp) {
      fatal("Not enough space collected");
    }
    copying_below ^= 1;
    gctimes++;
    if (measure_gc) {
      measure(after);
#ifdef SYSV
      gcums += (int) tick2msec(field_diff(tms_utime));
      gcsms += (int) tick2msec(field_diff(tms_stime));
#else SYSV
      gcums += diff_usec(ru_utime)/1000;
      gcsms += diff_usec(ru_stime)/1000;
#endif SYSV
    }
#ifdef GCDEBUG
    fprintf(stderr, "after GC\n");
    dump_queue(qp);
#endif
#ifdef GCSTATS
    fflush(stderr);
    fprintf(stderr, "GC#%3d: %8d%8d%8d%8d\n", gctimes,
	    heapp-new_space_top, vars_copied, long_lived, long_lived_vars);
    fflush(stderr);
    last_top = allocp;
#endif
    if (retry) goto retry_top;
  }
  queue = qp;
  return allocp;
}

q**
make_larger_stack(sp)
     q**sp;
{
  declare_globals;
  q **newstack;
  gcstack_size *= 2;
  newstack = (q**)realloc(gcstack, gcstack_size*sizeof(q*));
  sp = newstack+(sp-gcstack);
  gcstack = newstack;
  gcmax = newstack+gcstack_size;
  return sp;
}

#define within_new_space(x)	\
( (unsigned long)(x) - (unsigned long)ntop < hsize)

#define within_old_space(x)	\
( (unsigned long)(x) - (unsigned long)otop < hsize)

#define push_gc_stack(addr, sp, max)			\
{							\
  if ((sp) == max) {					\
    (sp) = make_larger_stack(sp);			\
    max = gcmax;					\
  }							\
  *(sp)++ = (addr);					\
}

#define reserve_copy(from, to, sp, max)			\
if (from == makeref(&from)) {				\
  VARCOPIED(from);					\
  to = from = makeref(&to);				\
} else {						\
  to = from;						\
  if (!isatomic(from) && within_old_space(from)) {	\
    TERMCOPIED(from);					\
    from = makeref(&to);				\
    push_gc_stack(&to, sp, max);			\
  }							\
}

#define copy_one_goal(goal, sp, max)			\
{							\
  struct goalrec *og=(goal);				\
  if (og->pred != 0) {					\
    int n = (og)->pred->arity;				\
    struct goalrec *ng = (struct goalrec *)hp;		\
    hp += n + 2;					\
    COPIED((q*)(og),n+2);				\
    ng->next = og->next;				\
    og->next = ng;					\
    ng->pred = og->pred;				\
    og->pred = 0;					\
    while (--n >= 0) {					\
      reserve_copy(og->args[n], ng->args[n], (sp), (max)); \
    }							\
    (goal) = ng;					\
  } else {						\
    (goal) = og->next;					\
  }							\
}

static q *
copy_terms(hp, ntop, otop, hsize, sp, max)
     q *hp;
     q *ntop, *otop;
     unsigned long hsize;
     q **sp, **max;
{
  declare_globals;
  while (sp > gcstack) {
    q *addr = *--sp;
    q obj = *addr;
  loop:
    switch (ptagof(obj)) {
    case ATOMIC:
      *addr = obj;
      break;
    case VARREF:
      {
	q value;
      deref:
	value = derefone(obj);
	switch (ptagof(value)) {
	case VARREF:
	  if (derefone(value) == obj) {
	    if (value == obj) {
	      *addr = derefone(obj) = *hp = makeref(hp);
	      hp++;
	      VARCOPIED(obj);
	    } else {
	      struct susprec *s = suspp(value);
	      struct hook *second_hook = s->first_hook.next;
	      struct hook *h = second_hook;
	      struct hook dummy;
	      struct hook *last = &dummy;
	      union goal_or_consumer lastu;
	      q newvar;

	      /* make a new variable, anyway */
	      newvar = *addr = derefone(obj) = *hp = makeref(hp);
	      hp++;
	      VARCOPIED(obj);
	      lastu.l = 0;
	      do {
		union goal_or_consumer u = h->u;
		if (u.l != 0) {
		  union goal_or_consumer nu;
		  nu.l = 0;
		  if (!is_consumer_hook(u)) {
		    /* suspended goal */
		    if (u.g->pred == 0) {
		      nu.g = u.g->next;
		    } else if (!isref(u.g->next)) {
		      copy_one_goal(u.g, sp, max);
		      nu.g = u.g;
		      COPIED(h, sizeof(struct hook)/sizeof(q));
		    } else {
		      goto not_a_valid_hook;
		    }
		  } else {
		    /* consumer object */
		    q newplace = (q)(untag_consumer_hook(u.o)->method_table);
		    if (isstruct(newplace)) {
		      nu.o = tag_consumer_hook(functorp(newplace));
		    } else {
		      struct consumer_object *newobj =
			(struct consumer_object *)
			  generic_gc(untag_consumer_hook(u.o), hp, sp);
		      sp = gcsp;
		      hp = heapp;
		      untag_consumer_hook(u.o)->method_table =
			(struct consumer_object_method_table *)
			  makefunctor(newobj);
		      nu.o = tag_consumer_hook(newobj);
		    }
		  }
		  if (lastu.l != 0) {
		    struct hook *nh = (struct hook *)hp;
		    hp += sizeof(struct hook)/sizeof(q);
		    COPIED(h, sizeof(struct hook)/sizeof(q));
		    nh->u = lastu;
		    last->next = nh;
		    last = nh;
		  }
		  lastu = nu;
		}
	      not_a_valid_hook:
		h = h->next;
	      } while (h != second_hook);
	      if (lastu.l != 0) {
		struct susprec *ns = (struct susprec *)hp;
		hp += sizeof(struct susprec)/sizeof(q);
		last->next = &ns->first_hook;
		ns->backpt = newvar;
		ns->first_hook.next = dummy.next;
		ns->first_hook.u = lastu;
		derefone(newvar) = (q)ns;
	      }
	    }
	  } else if (within_old_space(value)) {
	    obj = value;
	    goto deref;
	  } else {
	    *addr = value;
	  }
	  break;
	case CONS:
	  if (within_new_space(value)) {
	    *addr = makeref(&cdr_of(value));
	  } else {
	    obj = value;
	    goto cons_case;
	  }
	  break;
	case ATOMIC:
	  *addr = value;
	  break;
	default: /* FUNCTOR */
	  obj = value;
	  goto functor_case;
	}
      }
      break;
    case CONS:
    cons_case:
      if (within_old_space(obj)) {
	q cdr = cdr_of(obj);
	if (!isstruct(cdr) || !within_new_space(cdr)) {
	  q newcons = makecons(hp);
	  hp += 2;
	  COPIED(obj,2);
	  reserve_copy(car_of(obj), car_of(newcons), sp, max);
	  *addr = cdr_of(obj) = newcons;
	  if (isatomic(cdr)) {
	    cdr_of(newcons) = cdr;
	  } else {
	    if (cdr == makeref(&cdr_of(obj))) {
	      cdr_of(newcons) = makeref(&cdr_of(newcons));
	      VARCOPIED(cdr);
	    } else {
	      addr = &cdr_of(newcons);
	      obj = cdr;
	      goto loop;
	    }
	  }
	} else {
	  *addr = cdr;
	}
      } else {
	*addr = obj;
      }
      break;
    default: /* FUNCTOR */
    functor_case:
      if (within_old_space(obj)) {
	q f = functor_of(obj);
	if(!isstruct(f)){
	  if(isref(f)) {
	    struct data_object *oldobj
	      = (struct data_object *)functorp(obj);
	    q *newobj;
	    newobj = generic_gc(oldobj, hp, sp);
	    sp = gcsp;
	    hp = heapp;
	    *addr = functor_of(obj) = makefunctor(newobj);
	  } else {
	    q newfunct = makefunctor(hp);
	    int k = arityof(f);
	    hp += k+1;
	    COPIED(obj,k+1);
	    *addr = functor_of(obj) = newfunct;
	    functor_of(newfunct) = f;
	    while (--k >= 0) {
	      reserve_copy(arg(obj,k), arg(newfunct,k), sp, max);
	    }
	  }
	} else {
	  *addr = f;
	}
      } else {
	*addr = obj;
      }
      break;
    }
  }
  gcsp = sp;
  return hp;
}

struct goalrec *copy_one_queue(qp, hp, ntop, otop, hsize)
     struct goalrec *qp;
     q *hp;
     q *ntop, *otop;
     unsigned long hsize;
{
  declare_globals;
  struct goalrec *last, *next;

  /* Copy queue in reverse order */
  /* By this, variables will have better chance to be allocated */
  /* within the goal records or structures that'll be read after */
  /* their instantiation */

  /* First, reverse the goal queue */
  for (last=0; qp!=&goal_queue_tail; last=qp, qp=next) {
    next = qp->next;
    qp->next = last;
  }
  /* Then copy and rearrange the goal queue */
  qp = last;
  last = &goal_queue_tail;
  for (; qp != 0; qp=next) {
    next=qp->next;
    copy_one_goal(qp, gcsp, gcmax);
    hp = copy_terms(hp, ntop, otop, hsize, gcsp, gcmax);
    qp->next = last;
    last = qp;
  }
  heapp = hp;
  return last;
}

static struct goalrec *collect_garbage(qp)
     struct goalrec *qp;
{
  declare_globals;
  struct prioqrec *pq = prioq.next;
  q *ntop, *otop;
  unsigned long hsize;

  if (gctimes==0) {
    /* allocate GC stack on first GC */
    gcstack_size = GCSTACKSIZE;
    gcstack = (q**)malloc(gcstack_size*sizeof(q*));
    gcsp = gcstack;
    gcmax = gcstack+gcstack_size;
  }
  hsize = halfheapsize;
  if (copying_below) {
    otop = heaptop;
    ntop = (q*)((long)heaptop+(long)hsize);
  } else {
    ntop = heaptop;
    otop = (q*)((long)heaptop+(long)hsize);
  }
  new_space_top = heapp = ntop;
  old_space_top = otop;
  real_heaplimit = heapp+heapsize;
  if (interrupt_off) heaplimit = real_heaplimit;
  else heaplimit = 0;
  heapbottom = real_heaplimit+incrementsize;

  for(; pq->prio >= 0; pq = pq->next) {
    pq->q = copy_one_queue(pq->q, heapp, ntop, otop, hsize);
  }
  return copy_one_queue(qp, heapp, ntop, otop, hsize);
}


/*
  for generic object
*/
q
general_gc(term, allocp, sp)
     q *term;
     q *allocp;
     q **sp;
{
  declare_globals;
  push_gc_stack(term, sp, gcmax);
  heapp = copy_terms(/*heapp*/allocp, new_space_top, old_space_top,
		     halfheapsize, sp, gcmax);
  return *term;
}
