/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#define MAIN

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>

#include <stdio.h>
#include <setjmp.h>

extern void exit();
extern char *runtime_version, *runtime_date;

jmp_buf topmost;

void *module_main();

extern Const struct predicate predicate_main_xmain_0;

char *optarg;

int
parse_size(str)
     char *str;
{
  int n;
  char c[2];
  switch (sscanf(str, "%d%1s", &n, c)) {
  case 1: return n;
  case 2:
    if (c[0] == 'k' || c[0] == 'K') {
      return n*0x400;
    } else if (c[0] == 'm' || c[0] == 'M') {
      return n*0x100000;
    } else if (c[0] == 'g' || c[0] == 'G') {
      return n*0x40000000;
    }
  default:
    fprintf(stderr, "Error in option \"%s\"\n", str);
    exit(-1);
  }
}

main(argc, argv)
     int argc;
     char **argv;
{
  declare_globals;
  void initalloc();
  void initiate_prioq();
#ifdef TRACE
  extern void initiate_trace();
  extern struct goalrec *trace_goal();
#endif

  program_name = argv[0];
  heapsize = HEAPSIZE;
  incrementsize = INCREMENTSIZE;

  {
    extern char *optarg;
    extern int optind, opterr;
    int c;
    while ((c=getopt(argc,argv,"h:i:gv-")) != -1) {
      switch (c) {
      case 'h':
	heapsize = parse_size(optarg); break;
      case 'i':
	incrementsize = parse_size(optarg); break;
      case 'g':
	measure_gc = 1; break;
      case 'v':
	fprintf(stderr, "KLIC runtime version %s (%s)\n",
		runtime_version, runtime_date);
	exit(0);
      case '-':
	break;
      case '?':
	fprintf(stderr,
		"Usage: %s [-h heapwords] [-i incrementsize] [-g]\n",
		argv[0]);
      (void) exit(-1);
      }
    }
    command_argc = argc-optind;
    command_argv = argv+optind;
  }

  initalloc();
#ifdef CSUSPS /* count suspensions */
  suspensions = 0;
  resumes = 0;
#endif

  initiate_prioq();
  if (!setjmp(topmost)) {
    extern struct goalrec *get_top_priority_queue();
    q *allocp = heapp;
    struct goalrec *qp = (struct goalrec*)allocp;
    current_prio = -1;
    qp->pred = &predicate_main_xmain_0;
#ifdef TRACE
    initiate_trace();
    qp = trace_goal(qp, 1);
#endif
    (void) enqueue_goal(0, HIGHESTPRIO-1, qp, glbl);
    heapp = allocp + 2;
    queue = get_top_priority_queue();
    resumed_goals = 0;

    interrupt_off = -1;
    init_interrupt_handler();

    toploop();
  }
#ifdef CSUSPS
  {
    int diff = suspensions - resumes; 
    if (diff) {
      fprintf(stderr, "!!! %d suspending goal(s) !!!\n", diff);
      exit(-1);
    }
  }
#endif
 return 0;
}

toploop()
{
  declare_globals;
  struct goalrec *qp = queue;
  Const struct predicate *toppred = qp->pred;
  module func = toppred->func;
  while (1) {
    func = (module) func(glbl, qp, heapp, toppred);
    qp = queue;
    toppred = qp->pred;
  }
}

void *topsucceed(glbl, qp, allocp, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     q *allocp;
     Const struct predicate *toppred;
{
  longjmp(topmost, 1);
}
