/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/schedule.h>
#include <stdio.h>
#include <klic/gb.h>
#include <klic/gobj.h>

/* for priority support */

#define push_in_priority_queue(goal) \
{ \
  long gp = (long)((goal)->next); \
  long cp = (long)(current_prio); \
 \
  if(gp != cp) { \
    qp = enqueue_goal(qp, gp, (goal), glbl); \
  } else { \
    (goal)->next = qp; \
    qp = (goal); \
  } \
}

long higher_priority_goal = 0;
struct goalrec *do_unify_value();
static struct goalrec *resume_goals();
extern struct predicate predicate_unify__term__dcode_xunify_2;
#define enqueue_unify_terms(x, y) \
{ \
  struct goalrec *gp; \
  heapalloc(gp, 4, (struct goalrec *)); \
  gp->next = qp; \
  gp->pred = &predicate_unify__term__dcode_xunify_2; \
  gp->args[0] = x; \
  gp->args[1] = y; \
  qp = gp; \
}

struct goalrec *
do_unify(qp, x, y, allocp)
     struct goalrec *qp;
     q x, y;
     q * Const allocp;
{
#ifdef UNIFYDEBUG
  printf("Unify with ");
  print(x);
  printf(",");
  print(y);
  printf("\n");
#endif
  while (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      /* dereference y */
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      derefone(x) = y;		/* this also handles x==y cases */
      goto finish;
    }
    if (isref(temp) && derefone(temp) == x) {
      while(isref(y)){
	q ytemp = derefone(y);
	if(y == ytemp){
	  /* suspension record must points through REF. */
	  derefone(y) = x;
	  goto finish;
	}else{
	  if(isref(ytemp) && derefone(ytemp) == y){
	    y = ytemp;
            x =  temp;
	    goto both_queued;
	  }
	}
	y = ytemp;
      }
      /* x is hook variable and y points a real object */
      return resume_goals(qp, temp, y, allocp);
    }
    x = temp;
  }

  /* x is a real object */
  while(isref(y)){
    q temp = derefone(y);
    if(temp == y){ /* y is undef cell */
      derefone(y) = x;
      goto finish;
    }else{
      if(isref(temp) && derefone(temp) == y) {
	return(resume_goals(qp, temp, x, allocp));
      }
    }
    y = temp;
  }

  /* x and y points to real objects */
  /*  if(!isatomic(x) || !isatomic(y) || x != y){ */
  if(x != y) {
    struct global_variables *glbl = &globals;
    enqueue_unify_terms(x, y);
  } 
  goto finish;

 both_queued:
  if(x == y) goto finish;
    
  /* insert the goals connected y to x */
  {
    struct global_variables *glbl = &globals;
    struct susprec *sx = (struct susprec *)x;
    struct susprec *sy = (struct susprec *)y;
    q *topx = (q*)getnexthook(sx);
    q *topy = (q*)getnexthook(sy);
    q *lasty = (q*)getprevhook(sy);
    
#ifdef DEBUG
      void dump_suspension_structure();
#endif	
    
#ifdef DEBUG
    printf("\nUnification between %x and %x\n", topx, topy);
    dump_suspension_structure(topx);
    dump_suspension_structure(topy);
#endif
    /* connect sx and topy */
    setnexthook(sx, (struct shook *)topy);
    if(ismhook(topy)) {
      setbackhook((struct mhook *)topy, sx);
    }
    /* connext last and topx */
    setnexthook((struct shook *)lasty, (struct shook *)topx);
    if(ismhook(topx)){
      setbackhook((struct mhook *)topx, (struct shook *)lasty);
    }
    derefone(sy->marker) = derefone(sx);
    collectmhook((struct mhook *)sy);
  }

 finish:
  return qp;
}

/*
  do_unify_value(qp, x, y, allocp)
	"do_unify" for when "y" is known to be instantiated.
*/
struct goalrec *
do_unify_value(qp, x, y, allocp)
     struct goalrec *qp;
     q x, y;
     q * Const allocp;
{
  while (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      derefone(x) = y;
      return qp;
    }
    if (isref(temp) && derefone(temp) == x) {
      return resume_goals(qp, temp, y, allocp);
    }
    x = temp;
  }
  return do_unify(qp, x, y, allocp);
}

/*
  resume the goals which has been hooked to variable `x'.
  by the unification with `y'
*/

static struct goalrec *
resume_goals(qp, x, y, allocp)
     struct goalrec *qp;
     q x;
     q y;
     q * Const allocp;
{
  struct global_variables *glbl = &globals;

  /* Variable x with suspended goals is instantiated here */
  /* x points suspension record directly. */

  struct susprec *susprecord = suspp(x);
  q *top = getnexthook(susprecord);
  q *loopp = top;
#ifdef DEBUG
  void dump_suspension_structure();
#endif

#ifdef DEBUG
  printf("\nResume with "); print(y); putchar('\n');
  dump_suspension_structure(top);
#endif
  
  derefone(susprecord->marker) = y;
  
  do {
    q *keepnext = (q*)getnexthook(loopp);
    switch(hooktag(loopp)){
     case SSUSP:{
       struct shook *s = shookp(loopp);
       struct goalrec *g = s->goals;
       push_in_priority_queue(g);
       collectshook(s);
#ifdef CSUSPS
       resumes++;
#endif
#ifdef TRACE
       {
	 extern int trace_flag;
	 if(trace_flag) {
	   trace_resumption(g);
	 }
       }
#endif
     }
      break;
     case MSUSP:
      {
	struct mhook *m = mhookp(loopp);
	struct goalrec *g = m->goals;
	struct mhook *n;
	struct mhook *nextrecord;
	/* cancel neighbors */
	for (n = m->pal;
	     n != m;
	     n = nextrecord) {
	  q *next = getnexthook(n);
	  q *back = getprevhook(n);

	  nextrecord = n->pal;

	  if (next != back) {
	    setnexthook((struct shook *)back, (struct shook *)next);
	    if(ismhook(next)) {
	      setbackhook((struct mhook *)next, (struct shook *)back);
	    }
	  } else {
	    /* back pointer points a suspension record and
	     suspensing record is just me ! so REF must becom UNDEF. */
	    struct susprec *s = (struct susprec *)next;
	    q ref = s->marker;
	    derefone(ref) = makeref(ref);
	    collectsusprec(s);
	  }
	  collectmhook(n);
	}
	/* enqueue goal */
	push_in_priority_queue(g);
	collectmhook(m);
#ifdef CSUSPS
	resumes++;
#endif
#ifdef TRACE
       {
	 extern int trace_flag;
	 if(trace_flag) {
	   trace_resumption(g);
	 }
       }
#endif
      }
      break;
     default:
      /* consumer object */
      {
	struct mhook *m = mhookp(loopp);
	struct consumer_object *obj = (struct consumer_object *)(m->goals);

	qp = generic_active_unify(obj, y, qp, allocp);
	switch((long)method_result){
	case (long)GENERIC_FAILED:
	  fatal("unification failure on a consumer object");
	case (long)GENERIC_SUCCEEDED:
	  if(!rest_of_stream){
	    collectmhook(m);
	    goto consumer_terminate;
/*	    break; */
	  }
	  y  = rest_of_stream;
	  break;
	case (long)GENERIC_GCREQUEST:
	  break;
	default:
	  y = suspension_reason;
	}
	
	{
	  struct susprec *susp;
	  q newvar;
	  heapalloc(newvar, 1, makeref);
	  
	  makesusprec(susp);
	  setbackhook(m, susp);
	  setnexthook(m, susp);
	  initsusprec(susp, newvar, m);
	  derefone(newvar) = makeref(susp);
	  {
	    q temp = y;
	    if(derefone(temp) == temp) {
	      derefone(temp) = newvar;
	    } else {
	      enqueue_unify_terms(y, newvar);
	    }
	  }
	}
      consumer_terminate:;
      }
    }
    loopp = keepnext;
  } while (loopp != (q*)susprecord);

  collectsusprec(susprecord);

  return qp;
}

#ifdef DEBUG
#define dumpgoal(g) \
{ \
  if(g){ \
    printf("\tgoal:\t"); \
    printf("%x:%d/%d\n", g->pred->func, g->pred->pred, g->pred->arity); \
  } else { \
    printf("Illegal goal !: %x\n", g); \
  } \
}

void
dump_suspension_structure(x)
q *x;
{
  q *i = x;
  printf("Dump suspension structure : %x\n", x);
  do{
    switch(ptagof(*i)){
     case SSUSP:
      {
	struct shook *s = shookp(i);
	struct goalrec *g = s->goals;
	printf("Single suspension record : %x\n", s);
	dumpgoal(g);
      }
      break;
     case MSUSP:
      {
	struct mhook *m = mhookp(i);
	struct goalrec *g = m->goals;
	printf("Multiple suspension record : %x\n", m);
	dumpgoal(g);
	printf("back pointer:\t"); printf("%x\n", m->back);
	printf("related record:\t%x\n", m->next);
      }
      break;
     default:
      printf("Merger\n");
    }
    i = (q*)getnexthook(i);
  }while(getnexthook(i) != x);
}
#endif

