#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

struct merge_object {
  struct consumer_object_method_table *method_table;
  unsigned long count;
  q        outstream;
};

#define GC_CLASS_NAME() merge
#define GC_OBJ_TYPE struct merge_object
#define GC_OBJ_SIZE(obj)  G_SIZE_IN_Q(GC_OBJ_TYPE)

#include <klic/gc_macro.h>
#include <klic/gd_macro.h>

extern struct data_object_method_table *GD_method_table0(vector);
/* basic method definitions */

GCDEF_UNIFY()
{
  G_STD_DECL;

 top:
  GC_SWITCH_ON_TERM(list0,atomic0,functor0,generic_data0,susp0);

  list0:
    {
      q newout;
      GCSET_NEW_CONS(newout);
      G_CAR_OF(newout) = G_CAR_OF(GC_TERM);
      GCSET_VAR(G_CDR_OF(newout));
      GC_KL1_UNIFY(GC_SELF->outstream,newout);
      GC_SELF->outstream = G_CDR_OF(newout);
      GC_TERM = G_CDR_OF(GC_TERM);
      goto top;
    }
  atomic0:
    if (GC_TERM == NILATOM) {
      if (--(GC_SELF->count) <= 0) {
	GC_KL1_UNIFY(GC_SELF->outstream,NILATOM);
      }
      GC_TERMINATE;
    } else goto illegal_data;
  functor0:
    goto illegal_data;
  generic_data0:
    if (GD_IS_CLASS(vector,GC_TERM)) {
      unsigned long size;
      struct vector_object *vnew;
      unsigned long i;
      {
	q argv[1];
	GD_CALL_GMETHOD(GC_TERM,vector_1, argv);
	size = G_INTVAL(argv[0]);
	if (size == 0) goto illegal_data;
      }
      GC_SELF->count += size - 1;
      {
	q argv[2];
	q hook_var;
	for (i=0; i<size; i++) {
	  argv[0] = G_MAKEINT(i);
	  GD_CALL_GMETHOD(GC_TERM,element_2,argv);
	  hook_var = GC_MAKE_HOOK_VAR(GC_SELF);
	  GC_KL1_UNIFY(argv[1],hook_var);
	}
      }
      GC_TERMINATE;
    } else goto illegal_data;
 susp0: 
  GC_RETURN_WITH_HOOK(GC_TERM);
 illegal_data:
  GC_FAIL("Illegal data in merger");
}

GCDEF_GC()
{
  G_STD_DECL;
  GC_OBJ_TYPE *newself;

  GCSET_NEWOBJ_IN_NEWGEN(newself);
  newself->count = GC_SELF->count;
  G_COPY_KL1_TERM_TO_NEWGEN(GC_SELF->outstream,newself->outstream);
  GC_RETURN_FROM_GC(newself);
}


GCDEF_PRINT()
{
  G_STD_DECL;
  GC_PRINT("$$MERGER$");
  GC_RETURN_FROM_PRINT;
}

#define GCUSE_STD_REGIST
#define GCUSE_STD_DEALLOCATE
#define GCUSE_STD_CLOSE

/* define the method table structure of the merger */
#include <klic/gc_method_table.h>

/*  new_vector function */
GCDEF_NEW()
{
  GC_STD_DECL_FOR_NEW;
  GC_OBJ_TYPE *newmerger;
  q var;

  if (GC_ARGC != 1) GC_FAIL("arity mismatch in new_merger.");

  GCSET_NEWOBJ_FOR_NEW(newmerger,GC_OBJ_SIZE(newmerger));
  newmerger->count = 1;
  newmerger->outstream = GC_ARGV[0];
  var = GC_MAKE_HOOK_VAR(newmerger);
  GC_RETURN_FROM_NEW(var);
}
