#include <klic/gdobject.h>
#include <klic/functorstuffs.h>
#include <klic/atomstuffs.h>
#include <stdio.h>
#include <klic/gd_macro.h>

extern struct goalrec *temporary_queue;
extern int spontaneous_susp;
extern q gd_new_binaryp();
extern q gd_new_termp();


void *module_generic();

Extern Const struct predicate predicate_generic_xnew_3;
Extern Const struct predicate predicate_generic_xgeneric_2;

#define G_NEW_GOAL &predicate_generic_xnew_3
#define GD_GENERIC_GOAL &predicate_generic_xgeneric_2

/*************************** inlines *******************************/

Inline G_MAKE_VAR(x)
  q *x;
{
  G_STD_DECL;
  q *ptr;

  heapalloc(ptr,1,(q *));
  *(x) = (q)ptr;
  *ptr = *(x);
}

Inline G_SUSPEND(x,goal)
  q x;
  struct goalrec * goal;
{
  G_STD_DECL;
  reasons[0] = x;
#ifdef TRACE
  spontaneous_susp = 1;
#endif
  (void)interrupt_goal(goal, &reasons[1]);
}

Inline GD_MAKE_GENERIC_GOAL(goalp1,var,method_functor,argv)
     struct goalrec **goalp1;
     q var;
     unsigned long method_functor;
     q argv[];
{
  G_STD_DECL;
  unsigned long argc = arities[method_functor - FUNCTORNUMBERBASE];
  q* areap;
  struct functor * objp;
  int i;

  heapalloc(objp,G_SIZE_IN_Q(struct functor)+argc-1,
                                (struct functor *)makefunctor);
  functor_of(objp) = makesym(method_functor);
  for (i=0; i<argc; i++) {
    arg(objp,i) = argv[i];
  }

  heapalloc(*goalp1,G_SIZE_IN_Q(struct goalrec)-4,(struct goalrec *));
  (*goalp1)->pred    = GD_GENERIC_GOAL;
  (*goalp1)->args[0] = (q)objp;
  (*goalp1)->args[1] = var;
}

Inline G_MAKE_THE_NEW_GOAL(var,goalp1,myself,argc,argv,g_allocp)
     q *g_allocp;
     q *var;
     struct goalrec **goalp1;
     q (*myself)();
     unsigned long argc;
     q argv[];
{
  G_STD_DECL;
  q newobj,newobj2;
  newobj = gd_new_binaryp(myself,g_allocp);
  newobj2  = gd_new_termp(argc,argv,g_allocp);
  
  heapalloc(*goalp1,(G_SIZE_IN_Q(struct goalrec)-3),(struct goalrec *));
  G_MAKE_VAR(var);
  (*goalp1)->pred    = G_NEW_GOAL;
  (*goalp1)->args[0] = *var;
  (*goalp1)->args[1] = newobj;
  (*goalp1)->args[2] = newobj2;
}

/**********************************************************************/
#define GD_DEREF_FOR_GENERIC(obj) \
{ \
  while (1) { \
    if (!isstruct(obj)) { \
      if (atomicnotref(obj)) { \
        break; \
	} else { \
        q temp0 = derefone(obj); \
        if(isref(temp0) && (obj) == derefone(temp0)) { \
          struct goalrec *goal; \
          GD_MAKE_GENERIC_GOAL(&goal,(obj),g_method_functor,g_argv); \
          G_SUSPEND((obj),goal); \
          GD_RETURN; \
	  } else { \
          (obj) = temp0; \
	  } \
       } \
     } else { \
   break; \
  } \
 } \
}



/**********************************************************************/
struct goalrec *
gd_generic(g_object,g_method_functor,g_argv,g_qp,g_allocp)
    q g_object;
    long g_method_functor;
    q *g_argv;
    struct goalrec *g_qp;
    q *g_allocp;
{
  G_STD_DECL;

  GD_DEREF_FOR_GENERIC(g_object);
  if(!isfunctor(g_object)) GD_FAIL("is not functor");
  if(!isref(functorp(g_object))) GD_FAIL("is not functor");
  {
    struct data_object *g_obj = data_objectp(g_object);
    g_qp = (g_obj->method_table)
                ->body_generic(g_obj,g_method_functor,g_argv,g_qp,g_allocp);
  }
  GD_RETURN;

}


/**********************************************************************/
q
GC_MAKE_HOOK_VAR(obj)
     struct consumer_object *obj;
{
  struct global_variables *glbl = &globals;
  q newvar;
  struct susprec *s;
  struct mhook *newrec;

  heapalloc(newvar, 1, makeref);
  makesusprec(s);
  makegeneric(newrec, s);
  newrec->goals = (struct goalrec *)obj;
  setbackhook(newrec, s);
  initsusprec(s, newvar, newrec);
  return(makeref(newvar));
}


/************************* standard methods *************************/

q GD_STD_GUNIFY(GD_SELF, GD_OTHER) 
    struct data_object *GD_SELF; 
    struct data_object *GD_OTHER; 
{
  GD_GSUCCEED;
}

struct goalrec *GD_STD_UNIFY(GD_SELF, GD_OTHER, g_qp, g_allocp) 
    struct data_object *GD_SELF; 
    struct data_object *GD_OTHER; 
    struct goalrec *g_qp; 
    q *g_allocp;
{
  return(g_qp);
}

long GD_STD_PRINT(GD_SELF,g_fp,g_depth,g_length) 
    struct data_object *GD_SELF; 
    FILE *g_fp; 
    unsigned long g_depth; 
    unsigned long g_length;
{
  return(1L);
}

q *GD_STD_GC(GD_SELF,g_allocp, g_sp) 
    struct data_object *GD_SELF; 
    q *g_allocp;
    q **g_sp;
{
  struct global_variables *glbl = &globals;
  gcsp = g_sp;
  return(g_allocp);
}

long GD_STD_REGIST(GD_SELF,g_allocp) 
    struct data_object *GD_SELF; 
    q *g_allocp;
{
  return(1L);
}

long GD_STD_DEALLOCATE(GD_SELF) 
    struct data_object *GD_SELF;
{
  return(1L);
}

struct goalrec *GD_STD_CLOSE(GD_SELF,g_qp) 
    struct data_object *GD_SELF; 
    struct goalrec *g_qp;
{
  return(g_qp);
}


struct goalrec *GD_STD_GENERIC(GD_SELF, g_method_functor, GD_ARGV, g_qp, g_allocp)
    q *GD_SELF;
    long g_method_functor;
    q GD_ARGV[];
    struct goalrec *g_qp;
    q * g_allocp;
{
  return(g_qp);
}

q GD_STD_GGENERIC(GD_SELF, g_method_functor, GD_ARGV)
    struct data_object *GD_SELF;
    long g_method_functor;
    q GD_ARGV[];
{
  return(GENERIC_SUCCEEDED);
}

/*
  next variable for new method has not already used
struct generic *new_term;
*/
q method_result;

