/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#include <klic/control.h>

static
struct goalrec *
do_fail(qp, reasonp)
     struct goalrec *qp;
     q *reasonp;
{
  printf("!!! Reduction Failure !!!\n");
#ifdef TRACE
  trace_failure(qp);
#endif
  fatal("Failure handling mechanism not implemented yet\n");
  return(qp);
}

/*
  decide single suspension or multiple suspension
*/

static Inline int isSingleSuspension(reasonp, glbl)
     q *reasonp;
     struct global_variables *glbl;
{
  q *tmp;

  for(tmp=reasons; tmp<reasonp; ++tmp){
    if (*tmp!=reasons[0]) return 0;
  }
 last:
  return 1;
}

struct goalrec *
interrupt_goal(qp, reasonp)
     struct goalrec *qp;
     q *reasonp;
{
  struct global_variables *glbl = &globals;
  struct goalrec *retval = qp;

#ifdef TRACE
  extern int trace_flag;
  struct goalrec *trace_susp();
  if (trace_flag && (reasonp > reasons)) {
    qp = trace_susp(qp, reasonp);
  }
#endif

  if (reasonp == 0) {
    /* Interrupt by some external event, such as: */
    /*   - A higher priority goal got ready for execution */
    /*   - Garbage collection required */
    /* In such cases, the interrupted goal is pushed down */
    /* Currently only garbage collection cases are handled */
/*   return qp; */
    goto final;
  } else if (reasonp < &reasons[1]) {
    retval = do_fail(qp, reasons[0]);
    goto final;
  } else if (reasonp == &reasons[1] ||
	     /* single suspension, absolutely */
	     isSingleSuspension(reasonp, glbl)){
    /*
      single suspension
      */
    q reason = *(reasonp-1);
    q tmp = derefone(reason);

    retval = qp->next;

#ifdef CSUSPS
    suspensions++;
#endif

    if(reason == tmp){
      /* susprec has not allocated yet */
      struct susprec *susp;
      struct shook *newrec;
      q newvar;
      makesusprec(susp);
      makeshook(newrec, susp);
/* added for priority */
      qp->next = (struct goalrec *)current_prio;
/* end */
      newrec->goals = qp;
      heapalloc(newvar, 1, makeref);
      derefone(tmp) = newvar;
      initsusprec(susp, newvar, newrec);
#ifdef DEBUG
/*      dumpsrec(reason, susp);
      dumpshook(susp, newrec); */
#endif
    } else {
      /* "reason" is a pointer to a variable */
      /*   with already suspended goals */
      struct shook *newrec;
      struct shook *oldrec;
      struct susprec *susprecord;

      susprecord = (struct susprec *)refp(tmp);
      oldrec = (struct shook *)getnexthook(susprecord);
      makeshook(newrec, oldrec);
      if(ismhook(oldrec))
	setbackhook(mhookp(oldrec), newrec);
/* added for priority */
      qp->next = (struct goalrec *)current_prio;
/* end */
      newrec->goals = qp;
      setnexthook(susprecord, newrec);
#ifdef DEBUG
/*      dumpsrec(reason, susprecord);
      dumpshook(susprecord, newrec); */
#endif
    }
/*    return retval;*/
    goto final;
  } else if(reasonp > &reasons[1]) {
    /* Multiple suspension */
    q *loopp;
    struct mhook *prev = (struct mhook *)0;
    struct mhook *beginning = (struct mhook *)0;

    retval = qp->next;
/* added for priority */
    qp->next = (struct goalrec *)current_prio;
/* end */
#ifdef CSUSPS
    suspensions++;
#endif

    for (loopp=&reasons[0]; loopp<reasonp; ++loopp) {
      q tmp, tmp1;
      for (tmp = *loopp, tmp1 = derefone(tmp);
	   derefone(tmp1) != tmp;
	   tmp = tmp1, tmp1 = derefone(tmp))
	;
      if (tmp == tmp1) {
	/* has not suspended yet. */
	struct susprec *susp;
	struct mhook *newrec;
	q newvar;
	makesusprec(susp);
	makemhook(newrec, susp);
	if(!beginning) beginning = newrec;
	newrec->goals = qp;
	setbackhook(newrec, susp);
	newrec->pal = prev;
	prev = newrec;
	heapalloc(newvar, 1, makeref);
	derefone(tmp) = newvar;
	initsusprec(susp, newvar, newrec) ;
      } else {
	/* already suspended */
	struct susprec *susprecord;
	susprecord = suspp(tmp1);

	/* if next is msusp record AND next->goals == qp, no operation */
	if(isshook(getnexthook(susprecord)) || 
	   mhookp(getnexthook(susprecord))->goals != qp){
	  /* This goals has not hooked by to this variable */
	  struct mhook *newrec;
	  q *oldrec = getnexthook(susprecord);

	  makemhook(newrec, getnexthook(susprecord));
	  if(ismhook(oldrec)) setbackhook(mhookp(oldrec), newrec);
	  if(!beginning) beginning = newrec;
	  newrec->goals = qp;
	  setbackhook(newrec, susprecord);
	  newrec->pal = prev;
	  prev = newrec;
	  setnexthook(susprecord, newrec);
	}
      }
    }
    /* now ''prev'' points the last msusp record */
    beginning->pal = prev;
/*    return(retval);*/
    goto final;
  }
 final:
  return retval;
}
