/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/gb.h>
#include <klic/bb.h>

void *module_builtins();
Const struct predicate predicate_builtins_xadd_3
  = { module_builtins, 0, 3 };
Const struct predicate predicate_builtins_xsubtract_3
  = { module_builtins, 1, 3 };
Const struct predicate predicate_builtins_xmultiply_3
  = { module_builtins, 2, 3 };
Const struct predicate predicate_builtins_xdivide_3
  = { module_builtins, 3, 3 };
Const struct predicate predicate_builtins_xmodulo_3
  = { module_builtins, 4, 3 };
Const struct predicate predicate_builtins_xand_3
  = { module_builtins, 5, 3 };
Const struct predicate predicate_builtins_xor_3
  = { module_builtins, 6, 3 };
Const struct predicate predicate_builtins_xexclusive__or_3
  = { module_builtins, 7, 3 };
Const struct predicate predicate_builtins_xshift__right_3
  = { module_builtins, 8, 3 };
Const struct predicate predicate_builtins_xshift__left_3
  = { module_builtins, 9, 3 };
Const struct predicate predicate_builtins_xcomplement_2
  = { module_builtins, 10, 2 };
Const struct predicate predicate_builtins_xplus_2
  = { module_builtins, 11, 2 };
Const struct predicate predicate_builtins_xminus_2
  = { module_builtins, 12, 2 };

#ifdef TRACE
extern int trace_flag;
extern int spontaneous_susp;
#endif

void *module_builtins(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  struct goalrec *xp;
  q a0, a1, x0;

 module_top:
  a0 = qp->args[0l];
  a1 = qp->args[1l];
  switch_on_pred() {
    case_pred(0, add_3_top);
    case_pred(1, subtract_3_top);
    case_pred(2, multiply_3_top);
    case_pred(3, divide_3_top);
    case_pred(4, modulo_3_top);
    case_pred(5, and_3_top);
    case_pred(6, or_3_top);
    case_pred(7, exclusive_or_3_top);
    case_pred(8, shift_right_3_top);
    case_pred(9, shift_left_3_top);
    case_pred(10, complement_2_top);
    case_pred(11, plus_2_top);
    last_case_pred(12, minus_2_top);
  }

 add_3_top: {
  bblt_add(a0,a1,x0);
  goto unify_result_a2;
 }

 subtract_3_top: {
  bblt_sub(a0,a1,x0);
  goto unify_result_a2;
 }

 multiply_3_top: {
  bblt_mult(a0,a1,x0);
  goto unify_result_a2;
 }

 divide_3_top: {
  bblt_div(a0,a1,x0);
  goto unify_result_a2;
 }

 modulo_3_top: {
  bblt_mod(a0,a1,x0);
  goto unify_result_a2;
 }

 and_3_top: {
  bblt_and(a0,a1,x0);
  goto unify_result_a2;
 }

 or_3_top: {
  bblt_or(a0,a1,x0);
  goto unify_result_a2;
 }

 exclusive_or_3_top: {
  bblt_exclusive_or(a0,a1,x0);
  goto unify_result_a2;
 }

 shift_right_3_top: {
  bblt_rshift(a0,a1,x0);
  goto unify_result_a2;
 }

 shift_left_3_top: {
  bblt_lshift(a0,a1,x0);
  goto unify_result_a2;
 }

 complement_2_top: {
  bblt_complement(a0,x0);
  goto unify_result_a1;
 }

 plus_2_top: {
  bblt_plus(a0,x0);
  goto unify_result_a1;
 }

 minus_2_top: {
  bblt_minus(a0,x0);
  goto unify_result_a1;
 }

 unify_result_a1:
  unify(a1, x0, qp->next);
  proceed();

 unify_result_a2:
  unify(qp->args[2], x0, qp->next);
  proceed();

 proceed_label:
  loop_within_module(module_builtins);
}

#define builtin_body_3(macro_body, pred, name)		\
     q x, y;						\
{							\
  q z;							\
 deref_x:						\
  if (isint(x)) {					\
  x_ok:							\
  deref_y:						\
    if (isint(y)) {					\
    ok:							\
      macro_body(x, y, z);				\
      return z;						\
    } else if (isref(y)) {				\
      q yy;						\
      yy = derefone(y);					\
      if (isint(yy)) {					\
	y = yy;						\
	goto ok;					\
      } else if (isref(yy)) {				\
	if (yy == y) {					\
	  goto suspend_y;				\
	} else {					\
	  q yyy = derefone(yy);				\
	  if (yyy == y) {				\
	    goto suspend_y;				\
	  } else {					\
	    y = yy;					\
	    goto deref_y;				\
	  }						\
	}						\
      }							\
    }							\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
    if (isint(xx)) {					\
      x = xx;						\
      goto x_ok;					\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_3_type_error(x, y, &pred, name);		\
 suspend_x:						\
  return suspend_builtin_3(x, x, y, &pred);		\
 suspend_y:						\
  return suspend_builtin_3(y, x, y, &pred);		\
}

#define builtin_body_2(macro_body, pred, name)		\
     q x;						\
{							\
  q z;							\
 deref_x:						\
  if (isint(x)) {					\
  ok:							\
    macro_body(x, z);					\
    return z;						\
  } else if (isref(x)) {				\
    q xx;						\
    xx = derefone(x);					\
    if (isint(xx)) {					\
      x = xx;						\
      goto ok;						\
    } else if (isref(xx)) {				\
      if (xx == x) {					\
	goto suspend_x;					\
      } else {						\
	q xxx = derefone(xx);				\
	if (xxx == x) {					\
	  goto suspend_x;				\
	} else {					\
	  x = xx;					\
	  goto deref_x;					\
	}						\
      }							\
    }							\
  }							\
  builtin_2_type_error(x, &pred, name);			\
 suspend_x:						\
  return suspend_builtin_2(x, &pred);			\
}

static q suspend_builtin_3(v, x, y, pred)
     q v, x, y;
     Const struct predicate *pred;
{
  struct global_variables *glbl = &globals;
  struct goalrec *qp;
  q z;
  heapalloc(qp, 3+2, (struct goalrec *));
  z = makeref(&qp->args[2]);
  qp->pred = pred;
  qp->args[0] = x;
  qp->args[1] = y;
  qp->args[2] = z;
  reasons[0] = v;
#ifdef TRACE
  spontaneous_susp = 1;
#endif
  (void)interrupt_goal(qp, &reasons[1]);
  return z;
}

static q suspend_builtin_2(v, pred)
     q v;
     Const struct predicate *pred;
{
  struct global_variables *glbl = &globals;
  struct goalrec *qp = 0;
  q z;
  heapalloc(qp, 3+2, (struct goalrec *));
  z = makeref(&qp->args[2]);
  qp->pred = pred;
  qp->args[0] = v;
  qp->args[1] = z;
  reasons[0] = v;
#ifdef TRACE
  spontaneous_susp = 1;
#endif
  (void)interrupt_goal(qp, &reasons[1]);
  return z;
}

Volatile static builtin_3_type_error(x, y, pred, name)
     q x, y;
     struct predicate *pred;
     char *name;
{
  char buf[256];
  (void)sprintf(buf, "Argument type error in builtin predicate: %s\n", name);
  fatal(buf);
}

Volatile static builtin_2_type_error(x, pred, name)
     q x;
     struct predicate *pred;
     char *name;
{
  char buf[256];
  (void)strcpy(buf, "Argument type error in builtin predicate: ");
  (void)strcat(buf, name);
  (void)strcat(buf, "\n");
  fatal(buf);
}

q bblt_add_3(x, y)
builtin_body_3(bblt_add_no_check, predicate_builtins_xadd_3,
	       "add/3")

q bblt_sub_3(x, y)
builtin_body_3(bblt_sub_no_check, predicate_builtins_xsubtract_3,
	       "subtract/3")

q bblt_mult_3(x, y)
builtin_body_3(bblt_mult_no_check, predicate_builtins_xmultiply_3,
	       "multiply/3")

q bblt_div_3(x, y)
builtin_body_3(bblt_div_no_check, predicate_builtins_xdivide_3,
	       "divide/3")

q bblt_mod_3(x, y)
builtin_body_3(bblt_mod_no_check, predicate_builtins_xmodulo_3,
	       "modulo/3")

q bblt_and_3(x, y)
builtin_body_3(bblt_and_no_check, predicate_builtins_xand_3,
	       "and/3")

q bblt_or_3(x, y)
builtin_body_3(bblt_or_no_check, predicate_builtins_xor_3,
	       "or/3")

q bblt_exclusive_or_3(x, y)
builtin_body_3(bblt_exclusive_or_no_check,
	       predicate_builtins_xexclusive__or_3,
	       "exlclusive_or/3")

q bblt_rshift_3(x, y)
builtin_body_3(bblt_rshift_no_check,
	       predicate_builtins_xshift__right_3,
	       "shift_right/3")

q bblt_lshift_3(x, y)
builtin_body_3(bblt_lshift_no_check,
	       predicate_builtins_xshift__left_3,
	       "shift_left/3")

q bblt_plus_2(x)
builtin_body_2(bblt_plus_no_check,
	       predicate_builtins_xplus_2,
	       "plus/2")

q bblt_minus_2(x)
builtin_body_2(bblt_minus_no_check,
	       predicate_builtins_xminus_2,
	       "minus/2")

q bblt_complement_2(x)
builtin_body_2(bblt_complement_no_check,
	       predicate_builtins_xcomplement_2,
	       "complement/2")
