/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#define gblt_hash( x, h, fail) \
  h = (q)(((unsigned long)(x) & -16l) + INT)

#define gblt_wait( x, susp ) if isref(x) goto susp

#define gblt_list( x, fail )

#define gblt_atom( x, fail )

#define gblt_integer( x, fail )

#define gblt_greater( x, y, fail ) \
    if ((long)(x) <= (long)(y)) goto fail;

#define gblt_greater_or_eq( x, y, fail ) \
    if ((long)(x) < (long)(y)) goto fail;

#define gblt_less( x, y, fail ) \
    if ((long)(x) >= (long)(y)) goto fail;

#define gblt_less_or_eq( x, y, fail ) \
    if ((long)(x) > (long)(y)) goto fail;

#define gblt_eq( x, y,  fail ) \
    if ((long)(x) != (long)(y)) goto fail;

#define gblt_assign( x, y, fail )  x =  y; 

#define gblt_not_eq( x, y, fail ) \
    if ((long)(x) == (long)(y)) goto fail;

#define gblt_diff( x, y, fail ) \
    if ((x) == (y)) goto fail

#define gblt_and( x, y, z, fail ) \
    z = (q)((unsigned long)(x) & (unsigned long)(y));

#define gblt_or( x, y, z, fail ) \
    z = (q)((unsigned long)(x) | (unsigned long)(y));

#define gblt_exclusive_or( x, y, z, fail ) \
    z = (q)(((unsigned long)(x) ^ (unsigned long)(y)) + INT);

#define gblt_rshift( x, y, z, fail ) \
    z =  makeint(intval(x) >> intval(y));

#define gblt_lshift( x, y, z, fail ) \
    z =  (q)((((long)(x) - INT) << intval(y)) + INT);

#define gblt_add( x, y, z, fail ) \
    z = (q)((unsigned long)(x) + ((unsigned long)(y) - INT));

#define gblt_subtract( x, y, z, fail ) \
    z = (q)((unsigned long)(x) - ((unsigned long)(y) - INT)); 

#define gblt_multiply( x, y, z, fail ) \
    z = (q)(((long)(x) - INT) * (intval(y)) + INT);

#define gblt_divide( x, y, z, fail ) \
    z = makeint(((long)(x) - INT)/((long)(y) - INT));

#define gblt_modulo( x, y, z, fail ) \
    z = (q)(((long)(x) - INT) % ((long)(y) - INT) + INT);

#define gblt_complement( x, z, fail ) \
    z = makeint((long)(x) ^ ((-1l) << ATAGBITS));

#define gblt_plus( x, z, fail ) \
    z = x;

#define gblt_minus( x, z, fail ) \
    z = (q)(2*INT-(long)(x));

#define gblt_display_console(w,fail)  printl(w);

#define gblt_pfunctor( x, f, fail) \
    if (isatomic(x)) { \
      f = x; \
    } else if (iscons(x)) { \
      f = PERIODATOM; \
    } else if (!isref(functorp(x)->functor)) { \
      f = makesym(functoratom(functorp(x)->functor)); \
    } else  { \
      f = x; \
    }

#define gblt_arity( x, a, fail) \
    if (isatomic(x)) { \
      a = makeint(0); \
    } else if (iscons(x)) { \
      a = makeint(2); \
    } else if (!isref(functorp(x)->functor)) { \
      a = makeint(arityof(functorp(x)->functor)); \
    } else { \
      a = makeint(0); \
    }

#define gblt_arg( n, x, a, fail) \
    if (isatomic(x)) { \
      goto fail; \
    } else if (iscons(x)) { \
      if (n == makeint(1)) { \
	a = car_of(x); \
      } else if (n == makeint(2)) { \
	a = cdr_of(x); \
      } else { \
	goto fail; \
      } \
    } else { \
      long temp = intval(n); \
      if (temp <= 0 || temp > arityof(functorp(x)->functor)) \
      goto fail; \
      a = functorp(x)->args[temp-1]; \
    }

q eq_terms_body();

#ifdef COMPACTCODE
#define if_not_equal(x, y, faillab) \
{ \
  q retval; \
  switch((long)(retval = eq_terms_body((x), (y)))){ \
  case 1: break; \
  default: *reasonp++ = retval; /* fall thru */ \
  case 0: goto faillab; \
  } \
}
#else
#define if_not_equal(x, y, faillab) \
{ \
  if ((x)!=(y)) { \
    q retval; \
    if (isatomic(x) || isatomic(y)) goto faillab;\
    switch((long)(retval = eq_terms_body((x), (y)))){ \
    case 1: break; \
    default: *reasonp++ = retval; /* fall thru */ \
    case 0: goto faillab; \
    } \
  } \
}
#endif

#define otherwise(lab) \
{ if (reasonp != reasons) goto lab; }

#define alternatively

#define gblt_tag(x, y, faillab)   y = makeint(ptagof(x))
#define gblt_value(x, y, faillab) y = makeint(((unsigned long)x)>>ATAGBITS)
