/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
generate(_/Arty,Clauses,Works,Info0,Info,Code) :-
    separate_cond(Clauses,Cond),
    make_index_tree(Cond,[],e,Tree),
    make_arg_assoc(0,Arty,AL),
    gen_code(Tree,interrupt,lab(_Top),0,Works,0,_,AL,0,_,Info0,Info,Code,[]).

make_arg_assoc(K,K,[]) :- !.
make_arg_assoc(K,N,[arg(head,K)=(a(K):dk)|AL]) :-
    K1 is K+1, make_arg_assoc(K1,N,AL).

separate_cond([],[]).
separate_cond([otherwise|CT],[otherwise|CondT]) :- !,
    separate_cond(CT,CondT).
separate_cond([alternatively|CT],[alternatively|CondT]) :- !,
    separate_cond(CT,CondT).
separate_cond([clause(_ID,H,G,B)|CT],Clauses) :-
    norm_head(H,[],Vars0,Cond,Cond1),
    norm_guard(G,Vars0,B,Cond,Clauses,ClauseT,Cond1), !,
    separate_cond(CT,ClauseT).
separate_cond([clause(ID,_,_,_)|CT],CondT) :-
    warning("Clause deleted: ~w", [ID]),
    separate_cond(CT,CondT).

/*
  Normalize Clause

  a list of:
	Position:Pattern			% Guard unification
  or
	gb(Name(Position,...),OutputType)	% guard builtin with output
  or
	gp(Name(Position,...))			% guard builtin w/o output
  or
	il(Format,[Arg,...],Info)		% inline expansion
	  Arg is either a Position or "var(X)" which means a new variable.
	  Info is a list of elements of the form "K=(x(X):Type)".

  "Position" is one of:
	head			% head of the clause
	atom(Value)		% symbolic atom constant
	int(Value)		% integer constant
	list(Value)		% list constant
	funct(Value)		% functor constant
	arg(head,Position)	% arg "Pos" of the predicate
	arg(ValueID,Position)	% arg "Pos" (int const) of a functor
	gb(Name(Position,...)	% output of guard builtin predicate
	gg(Call,K)		% K'th output of guard generic method

  "Pattern" is either a position described above or one of:
	list			% list
	functor(F,Arity)	% functor
	bound			% bound to any value
	atom			% any atom
	int			% any integer
	atomic			% any atomic value
	functor			% any functor
	gobj			% any generic object
*/

norm_head(H,Vars0,Vars) -->
    { functor(H,_,NA) },
    norm_args(0,NA,H,head,Vars0,Vars).

norm_args(N,N,_,_,Vars,Vars) --> !.
norm_args(K,N,F,Fid,Vars0,Vars) -->
    { K1 is K+1, arg(K1,F,FK1) },
    norm_guard_term(FK1,arg(Fid,K),Vars0,Vars1),
    norm_args(K1,N,F,Fid,Vars1,Vars).

norm_guard_term('$VAR'(K),Pos,Vars0,Vars) --> { assoc(Vars0,K,Value) }, !,
    ( { Value=rename(J) } -> norm_guard_term('$VAR'(J),Pos,Vars0,Vars)
    ; { Vars=Vars0 }, [Pos:Value] ).
norm_guard_term('$VAR'(K),Pos,Vars0,[K=Pos|Vars0]) --> !.
norm_guard_term(A,Pos,Vars,Vars) --> { atom(A) }, !,
    [Pos:atom(A)].
norm_guard_term(A,Pos,Vars,Vars) --> { integer(A) }, !,
    [Pos:int(A)].
norm_guard_term([H|T],Pos,Vars0,Vars) --> !,
    [Pos:list],
    norm_guard_term(H,arg(Pos,car),Vars0,Vars1),
    norm_guard_term(T,arg(Pos,cdr),Vars1,Vars).
norm_guard_term(S,Pos,Vars0,Vars) --> { functor(S,F,A) },
    [Pos:functor(F,A)],
    norm_args(0,A,S,Pos,Vars0,Vars).

norm_guard([],Vars,B,CC,[CC-Body|CT],CT,[]) :- !,
    norm_body(B,Body,Vars).
norm_guard([(X0;Y0)|Rest],Vars0,B,CC,C,CT,[]) :- !,
    append(X0,Rest,X),
    append(CC,CCXT,CCX),
    norm_guard(X,Vars0,B,CCX,C,CT1,CCXT),
    append(Y0,Rest,Y),
    append(CC,CCYT,CCY),
    norm_guard(Y,Vars0,B,CCY,CT1,CT,CCYT).
norm_guard([One|Rest],Vars0,B,CC,C,CT,CCT) :-
    norm_guard_goal(One,Vars0,Vars,CCT,CCT1),
    norm_guard(Rest,Vars,B,CC,C,CT,CCT1).

norm_guard_goal(X=Y,Vars0,Vars,CCT0,CCT) :- !,
    norm_guard_unify(X,Y,Vars0,Vars,CCT0,CCT).
norm_guard_goal(generic:G,Vars0,Vars,CCT0,CCT) :- !,
    norm_guard_generic(G,Vars0,Vars,CCT0,CCT).
norm_guard_goal(inline:Format:Args0,Vars0,Vars,CCT0,CCT) :- !,
    norm_inline(Args0,Args,Args,[],Format,Vars0,Vars,CCT0,CCT).
norm_guard_goal(inline:Format,Vars0,Vars,CCT0,CCT) :- !,
    norm_inline([],Args,Args,[],Format,Vars0,Vars,CCT0,CCT).
norm_guard_goal(X,Vars0,Vars,CCT0,CCT) :-
    is_guard_builtin(X,Blts), !,
    norm_guard_builts(Blts,Vars0,Vars,CCT0,CCT).
norm_guard_goal(X,_Vars0,_Vars,_CCT0,_CCT) :-
    report_error("Guard not implemented (yet): ~w",[X]).

norm_inline([],[],Args,Info,Format,Vars,Vars) -->
    [il(Format,Args,Info)].
norm_inline([A0|Rest0],[A|Rest],Args,Info0,Format,Vars0,Vars) -->
    norm_inline_arg(A0,A,Info0,Info,Vars0,Vars1),
    norm_inline(Rest0,Rest,Args,Info,Format,Vars1,Vars).

norm_inline_arg('$VAR'(K)+Type,X,Info,Info,Vars,Vars) --> !,
    norm_gblt_arg('$VAR'(K),Type,X,Vars).
norm_inline_arg('$VAR'(K)-Type,var(K),
	Info,[K:Type|Info],Vars,[K=var(K)|Vars]) -->
    { ( assoc(Vars,K,_) ->
	warning("Non-first variable occurrence as inline output",[]),
	fail
      ; true ) }, !.
norm_inline_arg(Arg,_X,_Info,_Info,_Vars) -->
    { warning("Illegal argument to inline: ~w",[Arg]), fail }.

norm_guard_unify('$VAR'(K),X,Vars0,Vars) --> !,
    ( { assoc(Vars0,K,Pos) } ->
	( { Pos=rename(J) } -> norm_guard_unify('$VAR'(J),X,Vars0,Vars)
	; norm_guard_term(X,Pos,Vars0,Vars) )
    ; { norm_guard_unify_new(X,K,Vars0,Vars) } ).
norm_guard_unify(X,'$VAR'(K),Vars0,Vars) --> !,
    norm_guard_unify('$VAR'(K),X,Vars0,Vars).
norm_guard_unify([HX|TX],[HY|TY],Vars0,Vars) --> !,
    norm_guard_unify(HX,HY,Vars0,Vars1),
    norm_guard_unify(TX,TY,Vars1,Vars).
norm_guard_unify(X,Y,Vars0,Vars) -->
    { functor(X,F,A), functor(Y,F,A) }, !,
    { X=..[_|LX], Y=..[_|LY] },
    norm_guard_unify(LX,LY,Vars0,Vars).
norm_guard_unify(X,Y,Vars,Vars) -->
    { warning("Unification always fails: ~w=~w",[X,Y]), fail }.

norm_guard_unify_new('$VAR'(K),J,Vars0,Vars) :- !,
    ( assoc(Vars0,K,Pos) -> Vars=[J=Pos|Vars0]
    ; Vars=[J=rename(K)|Vars0] ).
norm_guard_unify_new(X,J,Vars,[J=atom(X)|Vars]) :- atom(X), !.
norm_guard_unify_new(X,J,Vars,[J=int(X)|Vars]) :- integer(X), !.
norm_guard_unify_new(X,_J,Vars,Vars) :-
    report_error("Structure allocation not allowed in guard: ~w", [X]).

is_const('$VAR'(_),_,_) :- !, fail.
is_const(A,atom(A),atom) :- atom(A), !.
is_const(N,int(N),int) :- integer(N), !.
is_const(X,_,_) :- atomic(X), !, fail.
is_const([H|T],list([H|T]),list) :- !, is_const(H,_,_), is_const(T,_,_).
is_const(F,functor(F),functor) :- F=..L, is_const(L,_,_).

norm_guard_generic(G0,Vars0,Vars) -->
    { norm_gg_in_out(G0,Funct,Obj0,In0,NumOuts,Out) },
    norm_gg_in(Obj0,gobj,Obj,Vars0),
    norm_gg_ins(In0,In,Vars0),
    [gg(gg(Funct,Obj,In),NumOuts)],
    { length(In,Nin) },
    norm_gg_outs(Out,Nin,gg(Funct,Obj,In),Vars0,Vars).

norm_gg_in_out(Goal:Out0,Funct,Obj,In,NumO,Outs) :- !,
    norm_gg_count_out(Out0,Outs,0,NumO),
    norm_gg(Goal,Funct,Obj,In).
norm_gg_in_out(Goal,Funct,Obj,In,0,[]) :-
    norm_gg(Goal,Funct,Obj,In).

norm_gg_count_out(One:Rest0,[One|Rest],N0,N) :-
    N1 is N0+1,
    norm_gg_count_out(Rest0,Rest,N1,N).
norm_gg_count_out(Last,[Last],N0,N) :- N is N0+1.

norm_gg(Goal,F/A,Obj,In) :-
    functor(Goal,F0,A0),
    ( F0=generic, A0=2 ->
      arg(1,Goal,Obj), arg(2,Goal,Term),
      functor(Term,F,A), Term=..[_|In]
    ; F=F0, A=A0, Goal=..[_,Obj|In] ).

norm_gg_ins([],[],_) --> !.
norm_gg_ins([In0|Ins0],[In|Ins],Vars) -->
    norm_gg_in(In0,bound,In,Vars),
    norm_gg_ins(Ins0,Ins,Vars).

norm_gg_in('$VAR'(K),Type,In,Vars) --> !,
    ( { assoc(Vars,K,Value) } ->
	( { Value=rename(J) } -> norm_gg_in('$VAR'(J),In,Vars)
	; { In=Value }, [Value:Type])
    ; { warning("Never proceeding guard generic call", []), fail } ).
norm_gg_in(C0,Type,C,_Vars) -->
    ( { is_const(C0,C,_Type) } ->
	( { Type=gobj } ->
	    { warning("Non-object given as generic call arg: ~w", [C0]) }
	; { true } )
    ; { warning("Non-const structure in guard generic call arg: ~w", [C0]),
	fail } ).

norm_gg_outs([],_,_,Vars,Vars) --> !.
norm_gg_outs([Out|Outs],K,Call,Vars0,Vars) --> !,
    norm_guard_term(Out,gg(Call,K),Vars0,Vars1),
    { K1 is K+1 },
    norm_gg_outs(Outs,K1,Call,Vars1,Vars).

norm_guard_builts([],Vars,Vars) --> !.
norm_guard_builts([$(In,Out,Pred/_Arity)|Blts],Vars0,Vars) -->
    norm_gblt_args(In,Inputs,Vars0),
    { Call=..[Pred|Inputs] },
    ( { Out = none } -> { Vars1=Vars0 }, [gp(Call)]
    ; { Out = (O:OType) } ->
	[gb(Call,OType)],
	norm_guard_term(O,gb(Call),Vars0,Vars1)),
    norm_guard_builts(Blts,Vars1,Vars).

norm_gblt_args([],[],_Vars) --> !.
norm_gblt_args([X0:Type|T],[X|VT],Vars) -->
    norm_gblt_arg(X0,Type,X,Vars),
    norm_gblt_args(T,VT,Vars).

norm_gblt_arg('$VAR'(K),Type,Pos,Vars) --> !,
    ( { Type=any } -> { true }
    ; { assoc(Vars,K,Value) } ->
	( { Value=rename(J) } -> norm_gblt_arg('$VAR'(J),Type,Pos,Vars)
	; { Pos=Value }, [Value:Type] )
    ; { warning("Never proceeding guard builtin", []), fail } ).
norm_gblt_arg(C0,Type,C,_Vars) -->
    ( { is_const(C0,C,Type0) } -> { check_gblt_input(Type0,Type) }
    ; { warning("Non-const structure in guard builtin arg: ~w", [C]),
	fail } ).

check_gblt_input(Type0,Type) :- subsumed_type(Type0,Type), !.
check_gblt_input(_,_) :-
    warning("Guard builtin arg type mismatch: ~w", []),
    fail.

norm_body([],[],_V) :- !.
norm_body([G0|Rest],[G|L],V0) :- norm_top_goal(G0,G,V0,V1), !,
    norm_body(Rest,L,V1).
norm_body(Goals,L,V) :- norm_body_tail(Goals,L,[],V).

norm_body_tail([],L,L,_V) :- !.
norm_body_tail([G0|Rest0],Rest,L,V0) :-
    norm_tail_goal(G0,G,V0,V1),
    norm_body_tail(Rest0,Rest,[G|L],V1).

norm_top_goal(X=Y,PosX=PosY,V0,V) :- !,
    norm_body_arg(X,PosX,V0,V1), norm_body_arg(Y,PosY,V1,V).
norm_top_goal(generic:G0@P,G,V0,V) :- !,
    warning("Ignored pragma for a generic call: ~w", [generic:G0@P]),
    norm_top_goal(G0,G,V0,V).
norm_top_goal(generic:G,gcall(F,A,Args),V0,V) :- !,
    norm_body_args(G,F,A,Args,V0,V).
norm_top_goal(G0,builtin(F,A,Args,IInfo,OInfo),V0,V) :-
    is_body_builtin(G0,G,IInfo,OInfo), !,
    norm_body_args(G,F,A,Args,V0,V).

norm_tail_goal(X=Y,PosX=PosY,V0,V) :- !,
    norm_body_arg(X,PosX,V0,V1), norm_body_arg(Y,PosY,V1,V).
norm_tail_goal('$macroexpanded'(Name,Args),Goal,V0,V) :- !,
    Goal0 =.. [Name|Args],
    norm_tail_goal(Goal0,Goal,V0,V).
norm_tail_goal(generic:G0@P,G,V0,V) :- !,
    warning("Ignored pragma for a generic call: ~w", [generic:G0@P]),
    norm_tail_goal(generic:G0,G,V0,V).
norm_tail_goal(generic:G,gcall(F,A,Args),V0,V) :- !,
    norm_body_args(G,F,A,Args,V0,V).
norm_tail_goal(Mod:G0@P,G,V0,V) :- !, norm_pragma(Mod:G0,G,V0,V,P).
norm_tail_goal(Mod:G0,xcall(Mod,F,A,Args),V0,V) :- !,
    norm_body_args(G0,F,A,Args,V0,V).
norm_tail_goal(G0@P,G,V0,V) :- !, norm_pragma(G0,G,V0,V,P).
norm_tail_goal(G0,xcall(builtins,F,A,Args),V0,V) :-
    is_body_builtin(G0,_G,_IInfo,_OInfo), !,
    norm_body_args(G0,F,A,Args,V0,V).
norm_tail_goal(G0,call(F,A,Args),V0,V) :-
    norm_body_args(G0,F,A,Args,V0,V).

norm_pragma(G0,G,V0,V,P) :-
    is_body_builtin(G0,_G1,_IInfo,_OInfo), !,
    norm_pragma(builtins:G0,G,V0,V,P).
norm_pragma(G0,G,V0,V,priority(P0)) :- !,
    ( G0=(M:G1) -> G=xpcall(P,M,F,A,Args)
    ; G1=G0, G=pcall(P,F,A,Args) ),
    norm_body_args(G1,F,A,Args,V0,V1),
    norm_body_arg(P0,P,V1,V).
norm_pragma(G0,G,V0,V,lower_priority) :- !,
    ( G0=(M:G1) -> G=xlcall(M,F,A,Args)
    ; G1=G0, G=lcall(F,A,Args) ),
    norm_body_args(G1,F,A,Args,V0,V).

norm_body_args(G0,F,A,Args,Vars0,Vars) :-
    functor(G0,F,A),
    G0=..[_|L0],
    norm_body_args(L0,Args,Vars0,Vars).

norm_body_arg('$VAR'(K),Pos,Vars0,Vars) :- assoc(Vars0,K,Value), !,
    ( Value=rename(J) -> norm_body_arg('$VAR'(J),Pos,Vars0,Vars)
    ; Pos=Value, Vars=Vars0 ).
norm_body_arg('$VAR'(K),var(K),Vars,[K=var(K)|Vars]) :- !.
norm_body_arg(C0,C,Vars,Vars) :- is_const(C0,C,_), !.
norm_body_arg(A,_,_,_) :- atomic(A), !,
    warning("Unknown atomic constant: ~w", [A]), fail.
norm_body_arg([H|T],cons(Vcar,Vcdr),Vars0,Vars) :- !,
    norm_body_arg(H,Vcar,Vars0,Vars1),
    norm_body_arg(T,Vcdr,Vars1,Vars).
norm_body_arg(S,mkfunct(F/A,L),Vars0,Vars) :-
    functor(S,F,A), S=..[_|L0],
    norm_body_args(L0,L,Vars0,Vars).

norm_body_args([],[],Vars,Vars).
norm_body_args([H0|T0],[H|T],Vars0,Vars) :-
    norm_body_arg(H0,H,Vars0,Vars1),
    norm_body_args(T0,T,Vars1,Vars).
