/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/*
  Code generation
*/

/*
  gen_code( Source code info to generate object,
	    Label to jump on suspension or failure,
	    lab(Label for this node) or none,
	    First work register number available,
	    Next work register number available,
	    First label number available,
	    Next label number available,
	    Position-value association list,
	    Possible suspensions so far,
	    Max number of suspension reasons,
	    Collected info top,
	    Collected info tail,
	    Top of the generated code,		% implicit argument
	    Tail of the generated code)		% implicit argument

  Value positions are one of the following.
	reg(Reg)		% on register numbered Reg
	atom(A)			% symbolic atom constant
	int(N)			% integer constant
	list(L)			% list constant
	functor(F)		% functor constant
	arg(head,Pos)		% arg "Pos" of the predicate
	arg(ValueID,Pos)	% arg "Pos" (int const) of a functor
	var(Id)			% newly created variable
	cons(ValueID,ValueID)	% create new cons
	mkfunct(F/A,[ValueID,..]) % create new functor

  Position-value association list has the elements of the format:
	Position=(Register:Type)
  where the type field is one of:
	dk			% unknown
	atom			% symbolic atom
	int			% integer
	list			% cons
	functor			% functor
*/

gen_code(other(SC,Next),Lint,Lab,W0,W,L0,L,AL,S0,S,I0,I) --> !,
    gen_code(SC,Loth,Lab,W0,W1,L0,Loth,AL,S0,S1,I0,I1),
    [label(Loth),otherwise],
    { L1 is Loth+1 },
    gen_code(Next,Lint,none,W0,W2,L1,L,AL,S0,S2,I1,I),
    { max(S1,S2,S), max(W1,W2,W) }.
gen_code(alter(SC,Next),Lint,Lab,W0,W,L0,L,AL,S0,S,I0,I) --> !,
    gen_code(SC,Lalt,Lab,W0,W1,L0,Lalt,AL,S0,S1,I0,I1),
    [label(Lalt),alternatively],
    { L1 is Lalt+1 },
    gen_code(Next,Lint,none,W0,W2,L1,L,AL,S1,S,I1,I),
    { max(W1,W2,W) }.
gen_code(e,Lint,Lab,W,W,L,L,_,S,S,I,I) --> !, { same_lab(Lab,Lint) }.
gen_code(l(Body),Lint,Lab,W0,W,L0,L,AL,S,S,I0,I) --> !,
    { L1 is L0+1 },
    gen_lab(Lab,L0),
    gen_body(Body,Lint,L1,L,W0,W,AL,S,I0,I,qp).
gen_code(v(P,e,e,e,B,U),Lint,Lab,W0,W,L0,L,AL0,S0,S,I0,I) --> !,
    { Loop is L0+1, L1 is L0+2 },
    gen_lab(Lab,L0),
    load_pos(P,W0,W1,AL0,AL,I0,I1,Reg),
    [label(Loop), if_ref(Reg,Ltest)],
    { add_info(Reg,bound,AL,ALB), S1 is S0+1 },
    gen_code(B,Luncond,none,W1,W2,L1,Ltest,ALB,S0,S2,I1,I2),
    { L2 is Ltest+1 },
    [label(Ltest), deref(Reg,Loop,Luncond)],
    { max(S1,S2,S3) },
    gen_code(U,Lint,lab(Luncond),W1,W3,L2,L,AL,S3,S,I2,I),
    { max(W2,W3,W) }.
/* Special clause for integer-only case */
gen_code(v(P,a([],e,IC,IN,e),e,e,e,U),Lint,Lab,W0,W,L0,L,AL0,S0,S,I0,I) -->
	{ IN \== e }, !, /* atomic test is better with no built-in */
    { Loop is L0+1, L1 is L0+2 },
    gen_lab(Lab,L0),
    load_pos(P,W0,W1,AL0,AL,I0,I1,Reg),
    [label(Loop), if_not_int(Reg,Ltest)],
    { add_info(Reg,int,AL,ALI) },
    gen_code(IN,Lcases,none,W1,W2,L1,L2,ALI,S0,S1,I1,I2),
    gen_cases(IC,Luncond,lab(Lcases),W2,W3,L2,Ltest,int,Reg,ALI,S0,S2,I2,I3),
    { max(S1,S2,S3), L3 is Ltest+1 },
    [label(Ltest), if_not_ref(Reg,Luncond), deref(Reg,Loop,Luncond)],
    { S4 is S0+1, max(S3,S4,S5) },
    gen_code(U,Lint,lab(Luncond),W1,W4,L3,L,AL,S5,S,I3,I),
    { max(W3,W4,W) }.
gen_code(v(P,A,C,F,B,U),Lint,Lab,W0,W,L00,L,AL0,S0,S,I00,I) --> !,
    gen_lab(Lab,L00),
    { Lloop is L00+1, L0 is L00+2 },
    load_pos(P,W0,W1,AL0,AL,I00,I0,Reg),
    [label(Lloop), sw_tag(Reg)],
    ( { C = e } -> { L1 = L0, S1 = S0, I1 = I0, W2=W1 }
    ; [case_label("CONS")],
      { add_info(Reg,list,AL,ALC) },
      gen_code(C,Lbound,none,W1,W2,L0,L1,ALC,S0,S1,I0,I1)),
    ( { A = e } -> { L2 = L1, S2 = S0, I2 = I1, W3=W2 }
    ; [case_label("ATOMIC")],
      { add_info(Reg,atomic,AL,ALA) },
      gen_atomic(A,Lbound,W1,W3,L1,L2,Reg,ALA,S0,S2,I1,I2)),
    ( { F = e } -> { L3 = L2, S3=S0, I3=I2, W4=W3 }
    ; [case_label("FUNCTOR")],
      { add_info(Reg,functor,AL,ALF) },
      gen_functs(F,Lbound,W1,W4,L2,L3,Reg,ALF,S0,S3,I2,I3)),
    [case_label("VARREF")],
    [deref(Reg,Lloop,Luncond)],
    [end_sw],
    [goto(Lbound)],
    { add_info(Reg,bound,AL,ALB) },
    gen_code(B,Luncond,lab(Lbound),W1,W5,L3,L4,ALB,S0,S4,I3,I4),
    {
	S5 is S0+1,
	max_list([S1,S2,S3,S4,S5], S6)
    },
    gen_code(U,Lint,lab(Luncond),W1,W6,L4,L,AL,S6,S,I4,I),
    { max_list([W2,W3,W4,W5,W6],W) }.
gen_code(x(If,Then,Uncond),Lint,Lab,W0,W,L00,L,AL0,S0,S,I0,I) -->
    gen_lab(Lab,L00),
    { L0 is L00+1 },
    gen_cond(If,Luncond,W0,W1,L0,L1,AL0,AL1,S0,S1,I0,I1),
    gen_code(Then,Luncond,none,W1,W2,L1,L2,AL1,S1,S2,I1,I2),
    gen_code(Uncond,Lint,lab(Luncond),W1,W3,L2,L,AL1,S1,S3,I2,I),
    { max(S2,S3,S), max(W2,W3,W) }.

gen_atomic(a(AC,AN,IC,IN,UN),Lint,W0,W,L0,L,Reg,AL,S0,S,I0,I) -->
    (
	{ AC=[], AN=e }
    ->
        { W2=W0, L2=L0, S1=S0, S2=S0, I2=I0 },
	( { IN=e, AC=[], AN=e } -> []; [if_not_int(Reg,Lint)] )
    ;
	( { AN=e, IC=[], IN=e } -> []; [if_int(Reg,Lic)] ),
	{ add_info(Reg,atom,AL,ALA) },
	gen_cases(AC,Lan,none,W0,W1,L0,L1,sym,Reg,ALA,S0,S1,I0,I1),
	gen_code(AN,Lun,lab(Lan),W1,W2,L1,L2,ALA,S0,S2,I1,I2)
    ),
    { add_info(Reg,int,AL,ALI) },
    gen_cases(IC,Lin,lab(Lic),W2,W3,L2,L3,int,Reg,ALI,S0,S3,I2,I3),
    gen_code(IN,Lun,lab(Lin),W3,W4,L3,L4,ALI,S0,S4,I3,I4),
    { max_list([S1,S2,S3,S4],SM) },
    gen_code(UN,Lint,lab(Lun),W4,W,L4,L,AL,SM,S,I4,I).

gen_functs(f(FC,FO,FN),Lint,W0,W,L0,L,Reg,AL,S0,S,I0,I) -->
    gen_cases(FC,Lfo,none,W0,W1,L0,L1,funct,Reg,AL,S0,S1,I0,I1),
    gen_gobjs(FO,Lfn,lab(Lfo),W1,W2,L1,L2,Reg,AL,S1,S2,I1,I2),
    gen_code(FN,Lint,lab(Lfn),W2,W,L2,L,AL,S2,S,I2,I).

gen_gobjs(e,Lint,Lab,W,W,L,L,_Reg,_AL,S,S,I,I) --> !, { same_lab(Lab,Lint) }.
gen_gobjs(Node,Lint,Lab,W0,W,L00,L,Reg,AL,S0,S,I0,I) -->
    gen_lab(Lab,L00),
    { L0 is L00+1 },
    [if_not_gobj(Reg,Lint)],
    gen_code(Node,Lint,none,W0,W,L0,L,AL,S0,S,I0,I).

gen_cases([],Lint,Lab,W,W,L,L,_What,_Reg,_AL,S,S,I,I) -->
	{ same_lab(Lab,Lint) }.
gen_cases([V-Node],Lint,Lab,W0,W,L00,L,What,Reg,AL,S0,S,I00,I) --> !,
    gen_lab(Lab,L00),
    ( { What=sym } -> [if_not(Reg,atom(V),Lint)], { I00=[atom(V)|I0] }
    ; { What=int } -> [if_not(Reg,int(V),Lint)], { I00=I0 }
    ; { What=funct } -> [if_funct_not(Reg,V,Lint)], { I00=[funct(V)|I0] } ),
    { L0 is L00+1 },
    gen_code(Node,Lint,none,W0,W,L0,L,AL,S0,S,I0,I).
gen_cases([H|T],Lint,Lab,W0,W,L00,L,What,Reg,AL,S0,S,I0,I) -->
    gen_lab(Lab,L00),
    ( { What=sym } -> [sw_sym(Reg)]
    ; { What=int } -> [sw_int(Reg)]
    ; { What=funct } -> [sw_funct(Reg)] ),
    { L0 is L00+1 },
    gen_all_cases([H|T],Lint,W0,W,L0,L,What,AL,S0,S,I0,I),
    [end_sw].

gen_all_cases([],Lint,W,W,L,L,_What,_AL,S,S,I,I) -->
    [case_default, goto(Lint)].
gen_all_cases([V-Node|T],Lint,W0,W,L0,L,What,AL,S0,S,I00,I) -->
    { ( What=sym -> Instr=case_sym(V), I00=[atom(V)|I0]
      ; What=int -> Instr=case_int(V), I0=I00
      ; What=funct -> Instr=case_funct(V), I00=[funct(V)|I0] ) },
    [Instr],
    gen_code(Node,Lint,none,W0,W1,L0,L1,AL,S0,S1,I0,I1),
    gen_all_cases(T,Lint,W0,W2,L1,L,What,AL,S0,S2,I1,I),
    { max(S1,S2,S), max(W1,W2,W) }.

gen_lab(lab(X),X) --> [label(X)].
gen_lab(none,_) --> [].

same_lab(lab(X),X).
same_lab(none,_).

add_info(Reg,NewT,AL,[Pos=(Reg:NewT)|AL]) :- assoc(AL,Pos,Reg:_Type).

gen_cond(gp(Call),Lint,W0,W,L,L,AL0,AL,S,S,I0,I) -->
    { functor(Call,F,A), Call=..[_|Args0] },
    prep_poss(Args0,W0,W,AL0,AL,I0,I,Args1),
    { strip_types(Args1,Args) },
    [gblt_pred(F,A,Args,Lint)].
gen_cond(gb(Call,Otype),Lint,W0,W,L,L,AL0,AL,S,S,I0,I) -->
    { functor(Call,F,A), Call=..[_|Args0] },
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I,Args1),
    { strip_types(Args1,Args2) },
    { append(Args2,[r(x(W1))],Args) },
    [gblt_pred(F,A,Args,Lint)],
    { AL=[gb(Call)=(x(W1):Otype)|AL1], W is W1+1 }.
gen_cond(gg(gg(F/A,Obj0,Args0),NumOuts),Lint,
	W0,W,L,L,AL0,AL,S,S,[funct(F/A1)|I0],I) -->
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args),
    set_generic_args(Args,0,W1,W2,AL1,AL2,I1,I2),
    load_pos(Obj0,W2,W3,AL2,AL3,I2,I3,Obj),
    { length(Args,Nin), A1 is A+NumOuts-1 },
    [guard_generic(r(Obj),F/A1,Nin,Lint)],
    load_guard_generic_out(Nin,A1,gg(F/A,Obj0,Args0),W3,W,AL3,AL,I3,I).
gen_cond(eq(X,Y),Lint,W0,W,L,L,AL0,AL,S0,S,I0,I) -->
    { S is S0+1 },
    load_pos(X,W0,W1,AL0,AL1,I0,I1,VX),
    load_pos(Y,W1,W,AL1,AL,I1,I,VY),
    [if_not_eq(VX,VY,Lint)].
gen_cond(il(Format,Args0,Info),Lint,W0,W,L,L,AL0,AL,S0,S,I0,I) -->
    { S is S0+1 },
    load_inline_args(Args0,W0,W,AL0,AL1,I0,I,Args),
    [inline(Format,Args,Lint)],
    { add_inline_info(Info,AL1,AL) }.

add_inline_info([],AL,AL).
add_inline_info([K:Type|Rest],AL0,AL) :-
    assoc(AL0,var(K),Where:_),
    add_inline_info(Rest,[var(K)=Where:Type|AL0],AL).

load_guard_generic_out(N,N,_,W,W,AL,AL,I,I) --> !.
load_guard_generic_out(K,N,Call,W0,W,AL0,
	[gg(Call,K)=(x(W0):unknown)|AL],I0,I) -->
    [load_generic_arg(x(W0),K)],
    { K1 is K+1, W1 is W0+1 },
    load_guard_generic_out(K1,N,Call,W1,W,AL0,AL,I0,I).

prep_poss([],W,W,AL,AL,I,I,[]) --> [].
prep_poss([H0|T0],W0,W,AL0,AL,I0,I,[H|T]) -->
    prep_pos(H0,W0,W1,AL0,AL1,I0,I1,H),
    prep_poss(T0,W1,W,AL1,AL,I1,I,T).

prep_pos(P,W,W,AL,AL,I,I,r(Reg):Type) --> { assoc(AL,P,Reg:Type) }, !.
prep_pos(cons(X0,Y0),W0,W,AL0,AL,I0,I,r(x(Reg)):cons) --> !,
    prep_pos(X0,W0,W1,AL0,AL1,I0,I1,X),
    prep_pos(Y0,W1,Reg,AL1,AL2,I1,I2,Y),
    { W2 is Reg+1 },
    alloc_args([Y,X],0,W2,W,AL2,AL,I2,I),
    [make_cons(x(Reg))],
    [make_space(2)].
prep_pos(mkfunct(F/A,Args0),W0,W,AL0,AL,
	[funct(F/A)|I0],I,r(x(Reg)):functor) --> !,
    prep_poss(Args0,W0,Reg,AL0,AL1,I0,I1,Args),
    [alloc_functor_id(F,A)],
    { W1 is Reg+1 },
    alloc_args(Args,1,W1,W,AL1,AL,I1,I),
    { A1 is A+1 },
    [make_functor(x(Reg))],
    [make_space(A1)].
prep_pos(atom(X),W,W,AL,AL,[atom(X)|I],I,atom(X)) --> !.
prep_pos(X,W,W,AL,AL,I,I,X) --> [].

alloc_args([],_,W,W,AL,AL,I,I) --> [].
alloc_args([H|T],K,W0,W,AL0,AL,I0,I) -->
    alloc_one(H,K,W0,W1,AL0,AL1,I0,I1),
    { K1 is K+1 },
    alloc_args(T,K1,W1,W,AL1,AL,I1,I).

alloc_one(r(Reg):_Type,K,W,W,AL,AL,I,I) --> !, [alloc_value(Reg,K)].
alloc_one(P,K,W0,W,AL0,AL,I0,I) --> { assoc(AL0,P,R:Type) }, !,
    alloc_one(r(R):Type,K,W0,W,AL0,AL,I0,I).
alloc_one(var(N),K,W0,W,AL,[var(N)=(x(W0):dk)|AL],I,I) -->
    { W is W0+1 },
    [alloc_var(x(W0),K)].
alloc_one(atom(A),K,W,W,AL,AL,I,I) --> [alloc_atomic(A,K)].
alloc_one(int(A),K,W,W,AL,AL,I,I) --> [alloc_atomic(A,K)].
alloc_one(arg(X0,J),K,W0,W,AL0,[arg(X0,J)=(x(W0):dk)|AL],I0,I) --> !,
    { W1 is W0+1 },
    load_pos(X0,W1,W,AL0,AL,I0,I,X),
    [get_elem(x(W0),X,J), alloc_value(x(W0),K)].
alloc_one(list(L),K,W,W,AL,AL,[const(Off,L)|I],I) -->
    [alloc_const(cons(Off),K)].
alloc_one(functor(F),K,W,W,AL,AL,[const(Off,F)|I],I) -->
    [alloc_const(funct(Off),K)].

load_inline_args([],W,W,AL,AL,I,I,[]) --> [].
load_inline_args([X|Xs],W0,W,AL0,AL,I0,I,[R|Rs]) -->
    load_pos(X,W0,W1,AL0,AL1,I0,I1,R),
    load_inline_args(Xs,W1,W,AL1,AL,I1,I,Rs).

load_pos(X0,W0,W,AL0,AL,I0,I,R) -->
    prep_pos(X0,W0,W1,AL0,AL1,I0,I1,X1),
    load_reg(X1,W1,W,AL1,AL,I1,I,R:_).

load_reg(r(X):Type,W,W,AL,AL,I,I,X:Type) --> !.
load_reg(P,W,W,AL,AL,I,I,RegType) --> { assoc(AL,P,RegType) }, !.
load_reg(arg(X0,K),W0,W,AL0,[arg(X0,K)=(x(W0):dk)|AL],I0,I,x(W0):dk) --> !,
    { W1 is W0+1 },
    load_pos(X0,W1,W,AL0,AL,I0,I,X),
    [get_elem(x(W0),X,K)].
load_reg(atom(A),W0,W,AL,[atom(A)=(x(W0):atom)|AL],I,I,x(W0):atom) -->
    [load_atom(x(W0),A)], { W is W0+1 }.
load_reg(int(A),W0,W,AL,[int(A)=(x(W0):int)|AL],I,I,x(W0):int) -->
    [load_atom(x(W0),A)], { W is W0+1 }.
load_reg(list(L),W0,W,AL,[list(L)=(x(W0):list)|AL],
	[const(Off,L)|I],I,x(W0):list) -->
    [load_const(x(W0),cons(Off))], { W is W0+1 }.
load_reg(functor(F),W0,W,AL,[functor(F)=(x(W0):functor)|AL],
	[const(Off,F)|I],I,x(W0):functor) -->
    [load_const(x(W0),funct(Off))], { W is W0+1 }.
load_reg(var(K),W0,W,AL,[var(K)=(x(W0):dk)|AL],I,I,x(W0):dk) -->
    [load_newvar(x(W0))], { W is W0+1 }.

gen_body([],_,L,L,W,W,_AL,_S,I,I,Q) --> [proceed(Q)].
gen_body([X0=Y0|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q0) --> !,
    prep_pos(X0,W0,W1,AL0,AL1,I0,I1,X),
    prep_pos(Y0,W1,W2,AL1,AL2,I1,I2,Y),
    body_unify(X,Y,W2,W3,AL2,AL3,I2,I3,Q0,Q),
    gen_body(T,Lint,L0,L,W3,W,AL3,S,I3,I,Q).
gen_body([builtin(F,A,Args,IInfo,OInfo)|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q0) -->
    body_builtin(Args,IInfo,OInfo,F,A,W0,W1,AL0,AL1,I0,I1,Q0,Q),
    gen_body(T,Lint,L0,L,W1,W,AL1,S,I1,I,Q).
gen_body([call(F,A,Args0)],_Lint,L,L,W0,W,AL0,S,[exec(F/A)|I0],I,Q) --> !,
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args),
    move_args(Args,0,W1,W,AL1,_AL,I1,I),
    [execute(F,A,S,Q)].
gen_body([call(F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_pred(F,A)]),
    gen_body(T,Lint,L0,L,W1,W,AL1,S,I1,I,Q).
gen_body([xcall(M,F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,[ext(M/F/A)|I0],I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_ext_pred(M,F,A)]),
    gen_body(T,Lint,L0,L,W1,W,AL1,S,I1,I,Q).
gen_body([gcall(new,A,[atom(Class),Obj0|Args0])|T],Lint,L0,L,W0,W,AL0,S,
	[gnew(Class)|I0],I,Q0) --> !,
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args),
    set_generic_args(Args,0,W1,Wobj,AL1,AL2,I1,I2),
    { A1 is A-2 },
    [new_generic(Class,A1,x(Wobj))],
    { W2 is Wobj+1 },
    prep_pos(Obj0,W2,W3,AL2,AL3,I2,I3,Obj),
    body_unify(Obj,r(x(Wobj)):gobj(Class),W3,W4,AL3,AL4,I3,I4,Q0,Q),
    gen_body(T,Lint,L0,L,W4,W,AL4,S,I4,I,Q).
gen_body([gcall(generic,2,[Obj0,Arg0])|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q) -->
    ( { Arg0 = mkfunct(F/A,A0) } -> { true }
    ; { Arg0 = atom(X) } -> { F=X, A0=[], A=0 }
    ; { Arg0 = functor(X) } -> { functor(X,F,A), X=..[_|A0] } ), !,
    { A1 is A+1 },
    gen_body([gcall(F,A1,[Obj0|A0])|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q).
gen_body([gcall(F,A,[Obj0|Args0])|T],
	Lint,L0,L,W0,W,AL0,S,[funct(F/A1)|I0],I,Q) --> !,
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args),
    set_generic_args(Args,0,W1,W2,AL1,AL2,I1,I2),
    load_pos(Obj0,W2,W3,AL2,AL3,I2,I3,Obj),
    { A1 is A-1 },
    [call_generic(r(Obj),F/A1,Q)],
    gen_body(T,Lint,L0,L,W3,W,AL3,S,I3,I,qp).
gen_body([pcall(P0,F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_pred(F,A)]),
    prep_pos(P0,W1,W2,AL1,AL2,I1,I2,P),
    enq_at_prio(P,W2,W3,AL2,AL3,I2,I3,Q0,Q),
    gen_body(T,Lint,L0,L,W3,W,AL3,S,I3,I,qp).
gen_body([xpcall(P0,M,F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,
	[ext(M/F/A)|I0],I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_ext_pred(M,F,A)]),
    prep_pos(P0,W1,W2,AL1,AL2,I1,I2,P),
    enq_at_prio(P,W2,W3,AL2,AL3,I2,I3,Q0,Q),
    gen_body(T,Lint,L0,L,W3,W,AL3,S,I3,I,qp).
gen_body([lcall(F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,I0,I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_pred(F,A)]),
    [enq_at_lower_prio(Q0,Q)],
    gen_body(T,Lint,L0,L,W1,W,AL1,S,I1,I,qp).
gen_body([xlcall(M,F,A,Args)|T],Lint,L0,L,W0,W,AL0,S,
	[ext(M/F/A)|I0],I,Q0) -->
    set_call(Args,W0,W1,AL0,AL1,I0,I1,
	[push_goal(Q0,Q), set_ext_pred(M,F,A)]),
    [enq_at_lower_prio(Q0,Q)],
    gen_body(T,Lint,L0,L,W1,W,AL1,S,I1,I,qp).

set_call(Args0,W0,W,AL0,AL,I0,I,Code) -->
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args),
    Code,
    set_args(Args,0,W1,W,AL1,AL,I1,I),
    { length(Args,Arity), Arity2 is Arity+2 },
    [make_space(Arity2)].

enq_at_prio(int(A),W,W,AL,AL,I,I,Q0,Q) --> !,
    [enq_at_prio_no_check(int(A),Q0,Q)].
enq_at_prio(r(Reg):Type,W,W,AL,AL,I,I,Q0,Q) --> !,
    ( { Type=int } -> [enq_at_prio_no_check(r(Reg),Q0,Q)]
    ; [enq_at_prio(r(Reg),Q0,Q)] ).
enq_at_prio(var(K),W0,W,AL0,AL,I0,I,Q0,Q) --> !,
    { W is W0+1, AL=[var(K)=(x(W0):dk)|AL0], I=I0 },
    [enq_at_prio(r(x(W0)),Q0,Q)].
enq_at_prio(X,W,W,AL,AL,I,I,_,_) -->
    [fail],
    { warning("Illegal priority value ~w", [X]) }.

body_unify(X,X,W,W,AL,AL,I,I,Q,Q) --> !.
body_unify(var(K),var(J),W0,W,AL,
	[var(K)=(x(W0):dk),var(J)=(x(W0):dk)|AL],I,I,Q,Q) --> !,
    { W is W0+1 },
    [alloc_var(x(W0),0), make_space(1)].
body_unify(var(K),Y,W0,W,AL0,[var(K)=R|AL],I0,I,Q,Q) --> !,
    load_reg(Y,W0,W,AL0,AL,I0,I,R).
body_unify(X,var(K),W0,W,AL0,[var(K)=R|AL],I0,I,Q,Q) --> !,
    load_reg(X,W0,W,AL0,AL,I0,I,R).
body_unify(X,Y,W0,W,AL0,AL,I0,I,Q0,qp) -->
    prep_call_arg(X,W0,W1,AL0,AL1,I0,I1,XX),
    prep_call_arg(Y,W1,W,AL1,AL,I1,I,YY),
    { ( XX=(Rx:TypeX) -> true; TypeX=known, Rx=XX ),
      ( YY=(Ry:TypeY) -> true; TypeY=known, Ry=YY ) },
    ( { TypeX=dk } ->
	( { TypeY=dk } -> [unify(Rx,Ry,Q0)]
	; [unify_value(Rx,Ry,Q0)] )
    ; { TypeY=dk } -> [unify_value(Ry,Rx,Q0)]
    ; [unify(Rx,Ry,Q0)] ).

body_builtin(Args0,IInfo,OInfo,F,_Arity,W0,W,AL0,AL,I0,I,Q0,Q) -->
    prep_poss(Args0,W0,W1,AL0,AL1,I0,I1,Args1),
    bb_in(Args1,ArgsN,1,IInfo,Checks,[],Inputs,W1,W2,AL1,AL2,I1,I2),
    [bblt(Checks,F,Inputs,OArgs)],
    bb_out(ArgsN,Checks,OInfo,OArgs,W2,W,AL2,AL,I2,I,Q0,Q).

bb_in(Args,Args,_,[],Check,Check,[],W,W,AL,AL,I,I) --> [].
bb_in([A0|Args0],Outs,N,[IType|IInfo],C0,C,[A|Args],W0,W,AL0,AL,I0,I) -->
    prep_call_arg(A0,W0,W1,AL0,AL1,I0,I1,A1),
    { ( A1=(A:Type) -> true; Type=A1, A1=A ) },
    { ( subsumed_type(Type,IType) -> C0=C1; C0=[N|C1] ) },
    { N1 is N+1 },
    bb_in(Args0,Outs,N1,IInfo,C1,C,Args,W1,W,AL1,AL,I1,I).

bb_out([],_Checks,[],[],W,W,AL,AL,I,I,Q,Q) --> [].
bb_out([A0|Args],Checks,[OType|OInfo],[r(x(W0))|OArgs],
	W0,W,AL0,AL,I0,I,Q0,Q) -->
    { W1 is W0+1 },
    { Checks=[] -> Type=OType; Type=dk },
    body_unify(A0,r(x(W0)):Type,W1,W2,AL0,AL1,I0,I1,Q0,Q1),
    bb_out(Args,Checks,OInfo,OArgs,W2,W,AL1,AL,I1,I,Q1,Q).

prep_call_arg(X0,W0,W,AL0,AL,I0,I,r(X):Type) -->
    { ( X0=var(_); X0=list(_); X0=functor(_); X0=arg(_,_) ) }, !,
    load_reg(X0,W0,W,AL0,AL,I0,I,X:Type).
prep_call_arg(X,W,W,AL,AL,I,I,X) --> [].

set_args([],_,W,W,AL,AL,I,I) --> [].
set_args([H|T],K,W0,W,AL0,AL,I0,I) -->
    set_one(H,K,W0,W1,AL0,AL1,I0,I1),
    { K1 is K+1 },
    set_args(T,K1,W1,W,AL1,AL,I1,I).

set_one(r(R):_,K,W,W,AL,AL,I,I) --> !, [set_value(K,R)].
set_one(P,K,W0,W,AL0,AL,I0,I) --> { assoc(AL0,P,R:Type) }, !,
    set_one(r(R):Type,K,W0,W,AL0,AL,I0,I).
set_one(atom(A),K,W,W,AL,AL,I,I) --> [set_atomic(K,A)].
set_one(int(A),K,W,W,AL,AL,I,I) --> [set_atomic(K,A)].
set_one(arg(X0,J),K,W0,W,AL0,[arg(X0,J)=(x(W0):dk)|AL],I0,I) --> !,
    { W1 is W0+1 },
    load_pos(X0,W1,W,AL0,AL,I0,I,X),
    [get_elem(x(W0),X,J), set_value(K,x(W0))].
set_one(list(L),K,W,W,AL,AL,[const(Off,L)|I],I) -->
    [set_const(K,cons(Off))].
set_one(functor(F),K,W,W,AL,AL,[const(Off,F)|I],I) -->
    [set_const(K,funct(Off))].
set_one(var(J),K,W0,W,AL,[var(J)=(x(W0):dk)|AL],I,I) -->
    [set_newvar(K,x(W0))], { W is W0+1 }.

set_generic_args([],_K,W,W,AL,AL,I,I) --> [].
set_generic_args([A0|Rest],K,W0,W,AL0,AL,I0,I) -->
    prep_call_arg(A0,W0,W1,AL0,AL1,I0,I1,A1),
    { ( A1=(A:Type) -> true; Type=A1, A1=A ) },
    [store_generic_arg(A,K)],
    { K1 is K+1 },
    set_generic_args(Rest,K1,W1,W,AL1,AL,I1,I).

move_args([],_,W,W,AL,AL,I,I) --> [].
move_args([H|T],K,W0,W,AL0,AL,I0,I) --> { used_in(T,a(K),AL0) }, !,
    ( { ( H=(r(a(_)):Type); H=arg(_,_); H=var(_) ) } ->
	{ V=(r(x(W0)):Type), W1 is W0+1 },
	move_one(H,x(W0),W1,W2,AL0,AL1,I0,I1)
    ; { W2=W0, AL1=AL0, I1=I0, V=H } ),
    { K1 is K+1 },
    move_args(T,K1,W2,W3,AL1,AL2,I1,I2),
    move_one(V,a(K),W3,W,AL2,AL,I2,I).
move_args([H|T],K,W0,W,AL0,AL,I0,I) -->
    move_one(H,a(K),W0,W1,AL0,AL1,I0,I1),
    { K1 is K+1 },
    move_args(T,K1,W1,W,AL1,AL,I1,I).

move_one(r(R):_,R,W,W,AL,AL,I,I) --> !.
move_one(r(R1):_,R2,W,W,AL,AL,I,I) --> !, [move(R2,R1)].
move_one(P,R,W0,W,AL0,AL,I0,I) --> { assoc(AL0,P,Reg:Type) }, !,
    move_one(r(Reg):Type,R,W0,W,AL0,AL,I0,I).
move_one(atom(A),R,W,W,AL,AL,I,I) --> [load_atom(R,A)].
move_one(int(A),R,W,W,AL,AL,I,I) --> [load_atom(R,A)].
move_one(arg(X0,J),R,W0,W,AL0,[arg(X0,J)=(R:dk)|AL],I0,I) -->
    load_pos(X0,W0,W,AL0,AL,I0,I,X),
    [get_elem(R,X,J)].
move_one(list(L),R,W,W,AL,AL,[const(Off,L)|I],I) -->
    [load_const(R,cons(Off))].
move_one(functor(F),R,W,W,AL,AL,[const(Off,F)|I],I) -->
    [load_const(R,funct(Off))].
move_one(var(K),R,W0,W,AL,[var(K)=(x(W0):dk)|AL],I,I) -->
    [load_newvar(x(W0)), move(R,x(W0))], { W is W0+1 }.

used_in([r(Reg):_Type|_],Reg,_) :- !.
used_in([arg(Pos,_)|_],Reg,AL) :- assoc(AL,Pos,Reg:_), !.
used_in([var(K)|_],Reg,AL) :- assoc(AL,var(K),Reg:_), !.
used_in([_|T],Reg,AL) :- used_in(T,Reg,AL).

strip_types([],[]).
strip_types([V:_Type|T0],[V|T]) :- !, strip_types(T0,T).
strip_types([H|T0],[H|T]) :- strip_types(T0,T).
