/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
make_ext_table([],A,A,F,F).
make_ext_table([atom([])|Rest],A0,A,F0,F) :- !,
	make_ext_table(Rest,A0,A,F0,F).
make_ext_table([atom(.)|Rest],A0,A,F0,F) :- !,
	make_ext_table(Rest,A0,A,F0,F).
make_ext_table([atom(Atom)|Rest],A0,[Atom|A],F0,F) :- !,
	make_ext_table(Rest,A0,A,F0,F).
make_ext_table([funct(FA)|Rest],A0,A,F0,[FA|F]) :- !,
	make_ext_table(Rest,A0,A,F0,F).
make_ext_table([const(_,Const)|Rest],A0,A,F0,F) :- !,
	ext_struct(Const,A0,A1,F0,F1),
	make_ext_table(Rest,A1,A,F1,F).
make_ext_table([_|Rest],A0,A,F0,F) :-
	make_ext_table(Rest,A0,A,F0,F).

ext_struct([],A,A,F,F) :- !.
ext_struct(.,A,A,F,F) :- !.
ext_struct(X,A,[X|A],F,F) :- atom(X), !.
ext_struct(I,A,A,F,F) :- integer(I), !.
ext_struct([H|T],A0,A,F0,F) :- !,
	ext_struct(H,A0,A1,F0,F1),
	ext_struct(T,A1,A,F1,F).
ext_struct(S,A0,A,F0,[Funct/Arity|F]) :-
	functor(S,Funct,Arity),
	S =.. [_|Args],
	ext_struct(Args,A0,A,F0,F).
