/*- -*- Mode: C -*-						       -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#ifndef DYNAMIC_LINK

#include <sys/file.h>
#include <a.out.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#ifndef NO_SYS_FCNTL_H
#include <unistd.h>
#endif

#include "aum/alloc.h"
#include "aum/error.h"


static void get_one_file_symbol_table (int fd, int offset, void (*) (...));
static int  read_string_table_length (int fd, int offset);
static struct nlist * read_symbols_and_strings (int fd, int, int);

static const char* Filename;
static struct exec Header;

void
get_symbol_table (const char* filename, void (*inifp)(...))
{
  char workarea[BUFSIZ];
  sprintf (workarea, "foreign_load \"%s\"", filename);
  Filename = workarea;
  {
    int fd = open (filename, O_RDONLY, 0);
    if (fd < 0)
      error (Filename, "Can't open file.");
    int len = read (fd, &Header, sizeof (struct exec));
    if (len != sizeof (struct exec))
      error (Filename, "Can't read file.");
    if (N_BADMAG (Header))
      error (Filename, "bad magic number.");
    get_one_file_symbol_table (fd, 0, inifp);
    close (fd);
  }
  Filename = NULL;
}

static void
get_one_file_symbol_table (int fd, int offset, void (*inifp)(...))
{
  int string_size = read_string_table_length (fd, offset);
  int symbol_size = N_STROFF (Header) - N_SYMOFF (Header);
  int n_symbols = symbol_size / sizeof (struct nlist);
  int nbytes = symbol_size + string_size;
  struct nlist *nls = read_symbols_and_strings (fd, offset, nbytes);
  {
    struct nlist *end = nls + n_symbols;
    char *strings = (char *) end;

    for (struct nlist *p = nls; p < end; p++) {
      if (p->n_type == (N_TEXT|N_EXT))
	if (p->n_un.n_strx) {
	  p->n_un.n_name = strings + p->n_un.n_strx;
#ifdef NAMES_HAVE_UNDERSCORE
	  if (p->n_un.n_name[0] == '_')
	    (*inifp) (p->n_un.n_name + 1, p->n_value);
	  else
	    (*inifp) (p->n_un.n_name, p->n_value);
#else /* NAMES_HAVE_UNDERSCORE */
	  (*inifp) (p->n_un.n_name, p->n_value);
#endif /* NAMES_HAVE_UNDERSCORE */
	}
    }
  }
  SHARED_FREE (nls, nbytes);
}

static int
read_string_table_length (int fd, int offset)
{
  int string_table_length;
  lseek (fd, N_STROFF (Header) + offset , 0);
  int len = read (fd, &string_table_length, sizeof (int));
  if (len != sizeof (int))
    fatal (Filename, "Can't read");
  return string_table_length;
}

static struct nlist *
read_symbols_and_strings (int fd, int offset, int nbytes)
{
  struct nlist *nls = (struct nlist *) SHARED_ALLOC (nbytes);

  lseek (fd, N_SYMOFF (Header) + offset, 0);
  int len = read (fd, nls, nbytes);
  if (len != nbytes)
    fatal (Filename, "Can't read");
  return nls;
}

/*
int
main (int argc, char *argv[])
{
  const char *filename = "a";
  get_symbol_table (filename);
}
*/

#endif /* DYNAMIC_LINK */
