/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"
#include "aum/error.h"
#include "utils/utils.h"
#include "aum/alloc.h"

#define PURE_STRING_SIZE	(1024*16)

char* strpcpy(char* to, const char* from)
    // {}
    // char *strcpy(char *to, char *from) Ʊ꥿ͤ
    // ۤʤ롥strcpy(to, from)  to ؤΥݥ󥿤֤ΤФơ
    // strpcpy(to,from)ϡto+strlen(from)ؤΥݥ󥿤֤
    // {}
{
    register char *t = to;
    register const char *f = from;

    while (*t = *f++)
	t++;
    return t;
}

#ifdef PAS_DEBUGGER
static char* curpos = 0;
void RefreshPureString()
{
    curpos = 0;
}
#endif

const char* SavePureString(const char* from)
    // ʸ from ΰ˥֤롥
{
    static char	 PureStringBuffer[PURE_STRING_SIZE];
#ifndef PAS_DEBUGGER
    static char* curpos = 0;
#endif
    if (!curpos) curpos = &PureStringBuffer[0];
    char* ret = curpos;
    curpos = strpcpy(curpos, from);
    *curpos++ = '\0';
    if (curpos-&PureStringBuffer[0] >= PURE_STRING_SIZE)
	fatal("SavePureString", "String Buffer Overflow");
    return ret;
}

char* SaveString(const char* from)
    // ΰݤơʸ from 򥻡֤롥
{
    char* to = SHARED_ALLOC(strlen(from)+1);
    strcpy(to, from);
    return to;
}

void CancellString(char* from)
    // ʸѤ˳ݤΰ롥
{
    SHARED_FREE(from, strlen((const char*)from));
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
