/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "utils/utils.h"
#include "aum/alloc.h"
#include "utils/cconv.h"

#define SI	('N'&0x1f)
#define SO	('O'&0x1f)
#define ESC	'\033'

#define iskin(p)  ( p[0] == '$' && (p[1] == 'B' || p[1] =='@') )
#define iskout(p) ( p[0] == '(' && (p[1] == 'B' || p[1] =='J' || p[1] == 'H') )

typedef enum {
    NOKANJI, ZENKAKU, HANKAKU,
} code_type;

int jis_to_euc(unsigned char *output, const unsigned char* input)
{
    register const unsigned char *in = input;
    register unsigned char *out = output;
    register unsigned int c;
    code_type kanji = NOKANJI;

    while (*in) {
	switch (c = *in++) {
	case ESC:
	    if (iskin(in)) kanji = ZENKAKU, in += 2;
	    else if (iskout(in)) kanji = NOKANJI, in += 2;
	    else goto default_l;
	    break;
	case SI:
	    if (kanji != NOKANJI) goto errorl;
	    kanji = HANKAKU;
	    break;
	case SO:
	    if (kanji != HANKAKU) goto errorl;
	    kanji = NOKANJI;
	    break;
	default_l:
	default:
	    int w = *(in-1);
	    if (w > DEL) {
		if (w < SJC){
		    /*shift jis*/
		    if (*in > SJS) {
			int s = (w <= 0x9f) ? 0x00e1 : 0x0161;
			w *= 2;
			w -= s;
			int sec = *in;
			if (sec >= 0x9f){
			    sec = sec - 0x7e;
			    w++;
			}else{
			    int sp = (sec > DEL) ? 32 : 31;
			    sec = sec - sp;
			}
			*out++ = (w & 0x7f) | 0x080;
			*out++ = (sec & 0x7f) | 0x080;
			in++;
		    }else
			goto errorl;
		    break;
		}else if (w < EJC) {
		    /*euc*/
		    *out++ = w;
		    *out++ = *in;
		    in++;
		    break;
		}
	    }
	    switch (kanji) {
	    case NOKANJI:
		*out++ = c;
		break;
	    case HANKAKU:
		*out++ = (0x80|SI);
		*out++ = (0x80|c);
		break;
	    case ZENKAKU:
		*out++ = (0x80|c);
		if ((c = *in++) <= ' ' || c >= 0x7F) goto errorl;
		*out++ = (0x80|c);
		break;
	    default:
		goto errorl;
	    }
	}
    }
    *out = '\0';
    return out-output;
 errorl:
    *out = '\0';
    return -1;
}

unsigned char* jis_to_euc(const unsigned char* from)
{
    int nbytes = strlen((char*)from)+1;
    unsigned char* to = (unsigned char*)PRIVATE_ALLOC(nbytes);
    jis_to_euc(to, from);
    return to;
}

int jstrlen(const unsigned char* str)
    // {}
    // ʸʸ ascii euc ɤ򤽤줾ʸȤ롣
    // {}
{
    int ret = 0;
    while((*str) != '\0')
	{
	    if(( (int)(*str) & 0x80) != 0 )
		{
		    ret++;
		    str+=2;
		}
	    else
		{
		    ret++;
		    str++;
		}

	}
    return ret;
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
