BEGIN{
# initialize output file
  comment = "/* This file generated by awk - do not edit! */";
  h_file = "userpid.gh";
  p_file = "userpid.gc";
  a_file = "useratom.gc";
#
  print comment > h_file;
  print comment > p_file;
  print comment > a_file;
#
  userpid = 0;
  atomnum = 0;
}
/^#/		{ next; }
/^[ \t]*$/	{ next; }
{
  name	  = $1;
  arity	  = $2;
  functor = $3;
  split(functor,xfunc,"/");
  pname = xfunc[1];
  modes = xfunc[2];
# ERROR CHECK
  {
    if (name !~ /^PID_[A-Z_]+/) {
      print "Invalid ProtocolID name: ", $0;
      next;
    }
    ln = length(modes);
    if (ln == 0) {
      print "use `name/void': ", name;
      next;
    }
    if (modes !~ /^void$/ && modes !~ /[+-]+/) {
      print "Invalid mode declaration:", name, functor;
      next;
    }
    if (modes !~ /^void$/) {
      if (ln != arity) {
	printf("Unmatch: %s. arity=%d, but modes=%s\n",\
	       name, arity, modes);
      }
    }
    else {
      if (arity != 0) {
	printf("Unmatch: %s. arity=%d, but modes=void\n",\
	       name, arity);
      }
    }
  }
  if (arity == 0) {
    printf("#define %s userAtom(%d)\n", name, useratom) > h_file;
# c file
    {
      printf("ReserveAtom (\"%s\", %s);\n",\
	     pname,  name) > a_file;
    }
    useratom++;
  }
  else {
# h file
    printf("#define %s userPID(%d,%d)\n", name, arity, userpid) > h_file;
# c file
    {
      max  = length(modes);
      if (max == 32 && modes == "++++++++++++++++++++++++++++++++") {
	printf("ReservePID (\"%s\", 32, 0xFFFFFFFF, %s);\n",\
	       pname, name) > p_file;
      }
      else {
	mode = 0;
	rank = 1;
	for (n = 1; n <= max; n++) {
	  if (substr(modes, n, 1) == "+")
	    mode += rank;
	  rank *= 2;
	}
	printf("ReservePID (\"%s\", %d, 0x%x, %s);\n",\
	       pname, arity, mode, name) > p_file;
      }
    }
    userpid++;
  }
}
END{
  close(h_file);
  close(c_file);
}
