/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include <stdio.h>
#include "aum/error.h"
#include "aum/global.h"
#include "aum/protocolid.h"
#include "table/protocol.h"
#include "table/atomhash.h"


ProtocolEntry* const
ProtocolID::get_ProtocolEntry()
    const
    // {}
    // Protocol ID ץȥơ֥γǡʥץȥϿ
    // äƤ롥ץȥϿ򳰤ˤϸʤΤǡδؿ
    //  private Ȥ롥
    // {}
{
    switch (Type()) {
    case PT_Compound:
	u_long index = Value();
	ProtocolEntry* pe = ProtocolTable->get_ProtocolEntry(index);
	return pe;

    default:
	static ProtocolEntry atomic;
	return &atomic;
    }
}


Name const ProtocolID::Name()
    const
    // {}
    // Protocol ID ᥽å̾øʸȤ֤
    // {}
{
    ProtocolEntry* pe = get_ProtocolEntry();
    return pe->Printname();
}

const u_long ProtocolID::Mode_mask()
    const
    // {}
    // Protocol ID Υ⡼ɤ֤
    // {}
{
    ProtocolEntry* pe = get_ProtocolEntry();
    return pe->Mode_mask();
}

Boolean ProtocolID::IsInlet(int i)
    const
    // {}
    //  i ܤΰüʤп򡤤Ǥʤе֤
    // {}
{
    if (Type() != PT_Compound)
	return FALSE;
    u_long x = 1 << i;
    u_int modes = Mode_mask();
    return (modes & x) ? FALSE : TRUE;
}


char*
sprint_protocol_mode(char* obuf, u_char arity, u_long modes)
{
    register char* p = obuf;
    register u_long x = 1;
    register int n = arity;
    while (--n >= 0) {
	char mode = (modes & x) ? '+' : '-';
	*p++ = mode;
	x <<= 1;
    }
    *p = '\0';
    return p;
}


Name ProtocolID::Printname()
    const
    // {}
    // Protocol ID ᥽å̾롥
    // : ᥽å̾ʡܡáݡ
    // {}
{

    static char buffer[LINEBUFSIZ];

    switch (Type()) {
    case PT_Atom:
	return AtomPrintname(Word(pid));

    case PT_Fixnum:
	sprintf(buffer, "%d", PID_VALUE_SHIFT_WIDTH >> pid);
	return buffer;

    case PT_Compound:
	{
	    sprintf(buffer, "%s", Name());
	    register char* p = strlen(buffer)+buffer;
#ifndef PAS_DEBUGGER
	    *p++ = '(';
		p = sprint_protocol_mode(p, Arity(), Mode_mask());
		     *p++ = ')';
	    *p = '\0';
#else
	    *p++ = '/';
	    p = sprint_protocol_mode(p, Arity(), Mode_mask());
	    *p = '\0';
#endif
	}
	return buffer;

    default:
	return "unknown";
    }
}


Name PidPrintname(ProtocolID pid)
{
    return pid.Printname();
}

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
