/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef table_protocol_h
#define table_protocol_h

// {}
// åץȥɽ
// {}
// åϡ̾Ȱοưˤäưդ˷ޤ롥
// åץȥɽϡץȥ뼱̻ҤȤƴ뤿
// ɽǤꡤƥΤǰ¸ߤ륰Х롦ơ֥Ǥ롥
//
// Ʊ̾οưĥåˡƱץȥ
// 뼱̻ҡʣУɣġˤդ٤ˡåץȥɽϥϥ
// ơ֥Ǽ¸롥
//
// å̾ϥȥǡθĿǡưθ
// ϣɡʣӥåȡˤΥӥåȥ٥ɽΤᡤθ
// κͤϣǤ롥
//
// ProtocolHashTable			      ProtocolTable
//  			  
//  	      			  pid 	
//  	      			  
//  	          Node	     >Functor ProtocolEntry
//     	     	       Modes	
//  Node>Entry 	      
//     		      	
//  	         Next  >	      	
//  	         		      	
//  	      			      	
//  	      			      	
//  			      
// {}

#include "config.h"
#include "aum/types.h"
#include "aum/protocolid.h"
#include "aum/alloc.h"


// ɸΥץȥɣĤθĿ (user+ system)
#ifndef MAX_PROTOCOL_ID
#define MAX_PROTOCOL_ID		(1*1024+START_USER_PID)
#endif

// ץȥϥåơ֥礭
#define PROTOCOL_HASH_SIZE	(509)

///////////////////////////////////////////////////////////////////////////////

#define PROE_ANUM_MASK		(0x00FFFFFF)
#define PROE_ARITY_SHIFT_WIDTH	(24)

class ProtocolEntry {
    // {}
    // 32      24	 16	    8	      0
    //	
    //	arity 	  Atom Number	      <= called Functor word
    //	
    //		   Modes (bits vector)	      
    //	
    // {}
private:
    u_long		functor;
    u_long		modes;
#ifdef PAS_DEBUGGER
    u_long		db_flags;
#endif
public:
    void		Initialize(const u_long, const u_long);
    //
    inline Boolean		Equal(const u_long, const u_long) const;
    Name const		Printname() const;
    const u_char	Arity() const;
    const u_long	Mode_mask() const;
#ifdef PAS_DEBUGGER
    inline void			 SetBreakPoint();
    inline void			 SetTracePoint();
    inline void			 UnSetBreakPoint();
    inline void			 UnSetTracePoint();
    inline Boolean		 IsBreakPoint();
    inline Boolean		 IsTracePoint();
#endif
};

inline void ProtocolEntry::Initialize(const u_long f, const u_long m)
{
    functor = f;
    modes = m;
#ifdef PAS_DEBUGGER
    db_flags = 0;;
#endif
}

inline Boolean ProtocolEntry::Equal(const u_long f, const u_long m) const
{
    return functor == f && modes == m;
}
#ifdef PAS_DEBUGGER
inline void ProtocolEntry::SetBreakPoint()
{
    db_flags |= 0x1;
}
inline void ProtocolEntry::SetTracePoint()
{
    db_flags |= 0x2;
}
inline void ProtocolEntry::UnSetBreakPoint()
{
    db_flags &= ~0x1;
}
inline void ProtocolEntry::UnSetTracePoint()
{
    db_flags &= ~0x2;
}
inline Boolean ProtocolEntry::IsBreakPoint()
{
    return  (db_flags & 0x1) ? TRUE:FALSE;
}
inline Boolean ProtocolEntry::IsTracePoint()
{
    return  (db_flags & 0x2)? TRUE:FALSE;
}
#endif

///////////////////////////////////////////////////////////////////////////////

class Node {
private:
    ProtocolEntry*	entry;
    Node*		next;

public:
    inline		Node(ProtocolEntry*, Node*);
    inline	       ~Node();
    //
    ProtocolEntry*	Entry() const;
    Node*		Next() const;
    //
    void*		operator new(size_t);
    void		operator delete(void*);
};

inline Node::Node(ProtocolEntry* pe, Node* pn)
{
    entry = pe;
    next = pn;
}

inline Node::~Node() {}

inline ProtocolEntry* Node::Entry() const
{
    return entry;
}

inline Node* Node::Next() const
{
    return next;
}

///////////////////////////////////////////////////////////////////////////////

class _ProtocolTable {
private:
    int			max_of_pids;
    int			no_of_pids;
    ProtocolEntry*	Array;

public:
    void		Initialize(int size);
    ProtocolEntry*	NextEntry(u_long, u_long);
    //
    ProtocolID		get_ProtocolID(const ProtocolEntry *address) const;
    ProtocolEntry*	get_ProtocolEntry(const int index);
    //
    int			No_of_pids() const;
#ifdef PAS_DEBUGGER
    void	       Dump(int ind);
    void	       End__ProtocolTable();
#endif
};

inline int _ProtocolTable::No_of_pids() const
{
    return no_of_pids;
}

extern _ProtocolTable*	ProtocolTable;
extern ProtocolID	intern_pid(Name, u_char, u_long);

#define SearchDefaultPID (ProtocolID((Word)(-1)))
#define IsUnKnownPID(x) ((x) == SearchDefaultPID)

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif	/* !table_protocol_h */
