/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#ifndef table_nlist_h
#define table_nlist_h

#include <stddef.h>
#include "aum/bool.h"

#define FOREIGN_MAXARGS 8

// ¾μ //
typedef enum foreign_language_type {
    FL_ERROR, FL_C, FL_CPLUSPLUS,
} FLType;

// ؿημ //
typedef enum foreign_parameter_type {
    FP_ERROR, FP_VOID, FP_INTEGER, FP_DOUBLE, FP_FOREIGN, FP_STRING,
} FPType;

// ¾ơ֥Ͽξ */
typedef enum foreign_function_status {
    FLE_UNDEF, FLE_MULTI, FLE_OK,
} FLEstatus;

// ؿؤΥݥ󥿡¾ؿؤΥݥ󥿤ɽ
class ForeignObject;
typedef ForeignObject* (*FLI_PFO)(...);
typedef void	       (*FLI_v)(...);
typedef int	       (*FLI_i)(...);
typedef double	       (*FLI_d)(...);
typedef char*	       (*FLI_Pc)(...);

// ¾ΰĤ
class ForeignNameList {
private:
    FPType		rtype;	// ͤη
    FLType		ltype;	// ¾μ
    char		arity;	// ο
    unsigned char	rc;	// Ȳ
    ForeignNameList*	nextl;	// ϥåơ֥μؤΥݥ
    const char*		pname;	// ¾δؿ̾³̾
    union {
	FLI_v		vfunc;	// ̵ͤؿؤΥݥ
	FLI_i		ifunc;	// ֤ؿؤΥݥ
	FLI_d		dfunc;	// ư֤ؿؤΥݥ
	FLI_Pc		sfunc;	// ʸ֤ؿؤΥݥ
	FLI_PFO		ffunc;	// ե󥪥֥ȤؤΥݥ
    } fp;
    FPType*		ptype;	// ؿѥ᡼η

public:
			ForeignNameList (const char* n, ForeignNameList* l);
    void* operator new (size_t);
    void operator delete (void*);
    //------------------------------------------------------------------
    FPType ReturnType () const
	{
	    return rtype;
	}
    const char* LanguageName () const;
    FLType LanguageType () const
	{
	    return ltype;
	}
    int Arity () const
	{
	    return arity;
	}
    const char* Name () const
	{
	    return pname;
	}
    int FunctionAddress () const
	{
	    return (int) fp.vfunc;
	}
    ForeignNameList* Next () const
	{
	    return nextl;
	}
    FPType* ParaTypes () const
	{
	    return ptype;
	}
    //------------------------------------------------------------------
    void ReturnType (FPType t)
	{
	    rtype = t;
	}
    void LanguageType (FLType t)
	{
	    ltype = t;
	}
    void Arity (int n)
	{
	    arity = n;
	}
    void Name (const char *n)
	{
	    pname = n;
	}
    void FunctionAddress (int a)
	{
	    fp.vfunc = (FLI_v) a;
	}
    void ParaTypes (FPType *pts)
	{
	    ptype = pts;
	}
    //------------------------------------------------------------------
    int	 RC () const
	{
	    return rc;
	}
    void RC_plus (int n)
	{
	    rc += n;
	}
    void Install (ForeignNameList*);
    Boolean Equal (ForeignNameList*) const;
};

extern FPType Foreign_parameter (const char*);
extern FLType Foreign_language (const char*);
extern const char* Foreign_parameter_name (FPType);
extern ForeignNameList* Intern_NameList (ForeignNameList *, FLEstatus&);

extern void dump_foreign_namelist (const ForeignNameList*);
extern void dump_foreign_namelists ();

// NameList loading flag
extern Boolean NameList_load_p;

#ifdef DYNAMIC_LINK

extern "C" {

    /* use GNU's dld library */

    const char*	  dld_find_executable (const char* filename);
    int		  dld_init (const char* filename);
    int		  dld_link (const char* filename);
    unsigned long dld_get_func (const char *func);
    const char**  dld_list_undefined_sym ();
    int		  dld_undefined_sym_count;
    void	  dld_perror (const char* user_mesg);
};

#endif /* DYNAMIC_LINK */

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-continued-brace-offset:0
 * c-brace-offset:0
 * c-brace-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-empty-arglist-indent:4
 * c++-friend-offset:0
 * c-imaginary-offset:0
 * c++-electric-colon:t
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !table_nlist_h */
