/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

#include "config.h"

#include <stdio.h>
#include "aum/global.h"
#include "aum/error.h"
#include "table/nlist.h"
#include "table/atomhash.h"
#include "utils/symbol.h"

static ForeignNameList * install_namelist (const char* name);

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

ForeignNameList::ForeignNameList (const char* name, ForeignNameList* next)
    // {}
    // nlist Υ󥹥ȥ饯̾ name, Υϥåݥ next 
    //  ForeignNameList 롥
    // {}
{
    rtype = FP_ERROR;
    ltype = FL_ERROR;
    arity = 0;
    rc = 0;
    nextl = next;
    pname = name;
    FunctionAddress (0);
    ptype = (FPType *) 0;
}

void*
ForeignNameList::operator new (size_t s)
{
    return SHARED_ALLOC (s);
}

void
ForeignNameList::operator delete (void* v)
{
    ForeignNameList* np = (ForeignNameList*) v;
    if (np->ptype != NULL)
	SHARED_FREE (np->ptype, sizeof (FPType) * np->arity);
    SHARED_FREE (v, sizeof(ForeignNameList));
}

const char*
ForeignNameList::LanguageName ()
    const
    // {}
    // ̾ʸ֤ǥХåѴؿ
    // {}
{
    switch (ltype) {
    case FL_C:
	return "C";
    case FL_CPLUSPLUS:
	return "C++";
    case FL_ERROR:
    default:
	return "ERROR";
    }
}

static FPType *
new_paratypes (int arity)
{
    return (FPType *) SHARED_ALLOC (arity * sizeof (FPType));
}

void
ForeignNameList::Install (ForeignNameList *np)
    // {}
    // np Ϳ nlist 򥳥ԡ롥̾ϥåݥ󥿤
    // ƴؿϰʳ np Ʊꤹ롥
    // {}
{
    rtype = np->rtype;
    ltype = np->ltype;
    arity = np->arity;
    if (arity > 0) {
	ptype = new_paratypes (arity);
	for (int i = 0; i < arity; i++)
	    ptype[i] = np->ptype[i];
    }
}

Boolean
ForeignNameList::Equal (ForeignNameList *np)
    const
    // {}
    // np ƱǤ뤫Ĵ٤롥ƱǤʤˤ FALSE ֤
    // {}
{
    if (rtype != np->rtype)
	return FALSE;
    if (ltype != np->ltype)
	return FALSE;
    if (arity != np->arity)
	return FALSE;
    if (arity > 0) {
	for (int i = 0; i < arity; i++)
	    if (ptype[i] != np->ptype[i])
		return FALSE;
    }
    return TRUE;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

static struct {
    const char *name;
    const FPType type;
} foreign_parameter_rec[] = {
    { "void",		FP_VOID, },
    { "integer",	FP_INTEGER, },
    { "double_float",	FP_DOUBLE, },
    { "foreign",	FP_FOREIGN, },
    { "string",		FP_STRING, },
    { NULL,		FP_VOID, },
};

FPType
Foreign_parameter (const char* name)
    // {}
    // ݡȤƤѿηʤз̾(FLType)֤Ǥ
    // СFP_ERROR ֤
    // {}
{
    for (int i = 0; foreign_parameter_rec[i].name; i++)
	if (strcmp (foreign_parameter_rec[i].name, name) == 0)
	    return foreign_parameter_rec[i].type;
    return FP_ERROR;
}

const char*
Foreign_parameter_name (FPType type)
    // {}
    // ѥ᡼ηͿơΰ̾ʸ֤
    // {}
{
    for (int i = 0; foreign_parameter_rec[i].name; i++)
	if (foreign_parameter_rec[i].type == type)
	    return foreign_parameter_rec[i].name;
    return "ERROR";
}

FLType
Foreign_language (const char* langname)
    // {}
    // ݡȤƤ¿̾ʤи̾(FLType)֤Ǥ
    // СFL_ERROR ֤
    // {}
{
    static struct {
	const char *name;
	const FLType type;
    } foreign_language_rec[] = {
	{ "C", FL_C, },
	{ "C++", FL_CPLUSPLUS, },
    };

    for (int i = 0; foreign_language_rec[i].name != NULL; i++)
	if (strcmp (foreign_language_rec[i].name, langname) == 0)
	    return foreign_language_rec[i].type;
    return FL_ERROR;
}

ForeignNameList *
Intern_NameList (ForeignNameList *np, FLEstatus& status)
    // {}
    // np Ϳ nlist õ¸ߤƤʤСؿ
    // 뤫ɤĴ٤롥̵ˤ̤Ȥ FLE_UNDEF
    // ֤ np Ƥ򥳥ԡFLE_OK ֤nlist
    // ¸ߤƤСƤӤ FLE_OF ֤
    // Ǥʤ FLE_MULTI ֤
    // {}
{
    ForeignNameList *op = install_namelist (np->Name ());
    if (op->ReturnType () == FP_ERROR) {
	if (op->FunctionAddress () == 0) {
	    status = FLE_UNDEF;
	    return NULL;
	}
	op->Install (np);
    }
    else {
	if (op->Equal (np) == FALSE) {
	    status = FLE_MULTI;
	    return NULL;
	}
    }
    status = FLE_OK;
    return op;
}

////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////

#define NAMELIST_HASHSIZE 2969
static ForeignNameList* NameList[NAMELIST_HASHSIZE];
static ForeignNameList *install_namelist (const char* name);

static ForeignNameList *
install_namelist (const char* name)
    // {}
    // name Ϳ̾ nlist õΥݥ󥿤֤
    // ¸ߤʤС롥
    // {}
{
    u_long index = Hash (name) % NAMELIST_HASHSIZE;
    for (ForeignNameList* np = NameList[index]; np; np = np->Next ()) {
	if (strcmp (name, np->Name ()) == 0)
	    return np;
    }
    np = new ForeignNameList (SaveString (name), NameList[index]);
    NameList[index] = np;
#ifdef DYNAMIC_LINK
    {
	int address = dld_get_func (name);
	np->FunctionAddress (address);
    }
#endif /* DYNAMIC_LINK */
    return np;
}

void
dump_foreign_namelists ()
    // {}
    // ϥåơ֥ϿƤ nlist ƤץȥȤ
    // 롥Ϸ nm -pg ƱǤ롥
    // {}
{
    for (int i = 0; i < NAMELIST_HASHSIZE; i++) {
	for (ForeignNameList* np = NameList[i]; np; np = np->Next ()) {
#ifdef NAMES_HAVE_UNDERSCORE
	    printf ("%08x  T _%s\n", np->FunctionAddress (), np->Name ());
#else /* NAMES_HAVE_UNDERSCORE */
	    printf ("%08x  T %s\n", np->FunctionAddress (), np->Name ());
#endif /* NAMES_HAVE_UNDERSCORE */
	    fflush (stdout);
	}
    }
}

void
dump_foreign_namelist (const ForeignNameList* np)
    // {}
    // np Ϳ nlist Ƥɽ롥δؿϥǥХåѤǤ롥
    // {}
{
    printf ("The %s function %s (rc=%d)\n",
	    np->LanguageName (), np->Name (), np->RC ());
    const char* s = Foreign_parameter_name (np->ReturnType ());
    printf ("	 has %d args and is a(n) %s type return.\n", np->Arity (), s);
    FPType *pts = np->ParaTypes ();
    for (int i = 0; i < np->Arity (); i++) {
	s = Foreign_parameter_name (pts[i]);
	printf ("    arg%d is %s\n", i, s);
    }
    fflush (stdout);
}

#ifndef DYNAMIC_LINK

static void
set_namelist_item (const char* name, int address)
{
    ForeignNameList *np = install_namelist (name);
    np->FunctionAddress (address);
    /* printf ("%x: %s\n", address, name); */
}

#endif /* DYNAMIC_LINK */

void
Initialize_NameList (const char* filename)
    // {}
    // filename Ϳ¹ԷΥ֥Ȥ nlist 
    // ؿ̾ȤϤνԤʤ
    // {}
{
#ifdef DYNAMIC_LINK
    if (dld_init (dld_find_executable (Program_filename)) != 0) {
	dld_perror (Program_filename);
	fatal (Program_filename,
	       "Can't load nlist.");
    }
#else /* DYNAMIC_LINK */
    get_symbol_table (filename, set_namelist_item);
    /* dump_foreign_namelists (); */
#endif /* DYNAMIC_LINK */
}


/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
