/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// {}
// ͢ɽ (Import Table)
// {}

#ifndef table_import_h
#define table_import_h

#include "aum/globalid.h"
#include "aum/types.h"
#include "aum/mj-imp.h"

#ifndef IMPORT_TABLE_SIZE
#define IMPORT_TABLE_SIZE	(4*1024)
#endif

class MJ_W_t;
class MJ_IMP_t;

class ImportEntry {
protected:
    GlobalID		gid;
    u_long		grc;
    MJ_IMP_t*		laddr;

public:

    void		Initialize();
    Boolean		IsEmpty() const;
    void		Install(const GlobalID&, const u_long);
    GlobalID		Export(GidHintBit);
    //
    GlobalID		GID() const;
    u_long&		GRC() /* const */;
    u_long		Divide_grc ();
    MJ_IMP_t*		Imported_joint() const;
    void		Imported_joint(MJ_IMP_t*);
};

inline void ImportEntry::Initialize()
{
    gid = GlobalID(0), grc = 0, laddr = (void*)0;
}

inline Boolean ImportEntry::IsEmpty() const
{
    return grc == 0 ? TRUE : FALSE;
}

inline void ImportEntry::Install(const GlobalID& i, u_long r)
{
    gid = i, grc = r;
}

inline GlobalID ImportEntry::GID() const
{
    return gid;
}

inline u_long& ImportEntry::GRC() /* const */
{
    return grc;
}

inline MJ_IMP_t* ImportEntry::Imported_joint() const
{
    return (MJ_IMP_t*)laddr;
}

inline void ImportEntry::Imported_joint(MJ_IMP_t* mj)
{
    laddr = mj;
}



///////////////////////////////////////////////////////////////////////////////

class ImportTableClass {

protected:
    int			max_of_imports;
    int			no_of_imports;
    ImportEntry*	Array;

    ImportEntry*	Hash(const u_int);
    int			Index(const ImportEntry*) const;

public:
    void		Initialize(int size);
    void		Terminate ();
    Boolean		TableisFull() const;
    void		Register(const GlobalID, u_long, MJ_W_t*, ObjectTag);
    Word		Register(const GlobalID&, GidHintBit);
    GlobalID		Export(MJ_IMP_t*, GidHintBit);
    u_long		Delete(MJ_IMP_t*);
    u_long&		GRC(MJ_IMP_t*);
    u_long		Divide_grc(MJ_IMP_t*);
    int			No_of_imports() const;
    void		Valid(int);
    void		pelog_grc(ImportEntry* eep, int dif) const;
#ifdef PAS_DEBUGGER
    void		Free();
#endif
};

inline Boolean ImportTableClass::TableisFull() const
{
    return (no_of_imports < max_of_imports) ? FALSE : TRUE;
}

inline int ImportTableClass::No_of_imports() const
{
    return no_of_imports;
}

inline u_long&	ImportTableClass::GRC(MJ_IMP_t* ptr)
{
    return Array[ptr->Index()].GRC();
}

inline u_long ImportTableClass::Divide_grc (MJ_IMP_t* ptr)
{
    return Array[ptr->Index()].Divide_grc ();
}

extern ImportTableClass*  ImportTable;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !table_import_h */
