/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/
//
// {}
// ͢ɽ (Import Table)
// {}
#include <assert.h>
#include <stdio.h>
#include "aum/stdlib.h"
#include "aum/globalid.h"
#include "aum/mj-nc.h"
#include "aum/mj-imp.h"
#include "aum/globlmsg.h"
#include "aum/trace.h"
#include "aum/alloc.h"
#include "aum/parallel.h"
#include "aum/global.h"
#include "table/import.h"

ImportTableClass *ImportTable;

extern Boolean DebugConnect;
extern void log_stream (const char *, const char *, int, const char *);

static const char TAG[] = "ImportTable";

void
Initialize_ImportTable (int size)
// {}
// ͢ɽΰݤ롥
// {}
{
    ImportTable = (ImportTableClass *) SHARED_ALLOC (sizeof (ImportTableClass));
    ImportTable->Initialize (size);
}

void
End_ImportTable ()
{
    ImportTable->Terminate ();
#ifdef PAS_DEBUGGER
    ImportTable->Free ();
#endif
    SHARED_FREE (ImportTable, sizeof (ImportTableClass));
    ImportTable = (ImportTableClass *) 0;
}


// /////////////////////////////////////////////////////////////////

inline u_long
part_of_Power2 (u_long rc, int &rest)
// {}
// Ȳ (1<<WEIGHT) 礭ˤϡrest  rc 
// (1<<WEIGHT) ͤ˥åȤ롥Ǥʤʬ򤹤롥
// Ȳ꾮Ѿο֤ rest ˤϡ
// ᤿Ѿ rc Ȥκʬ򥻥åȤ롥
// {}
{
    assert (rc != 0);
    if (rc > (1 << WEIGHT)) {
	rest = rc - (1 << WEIGHT);
	return (1 << WEIGHT);
    }
    else {
	register u_long x = (1 << WEIGHT);
	while ((x & rc) == 0)
	    x >>= 1;
	rest = rc - x;
	assert (x <= (1 << WEIGHT));
	return x;
    }
}

inline u_long
SplitWeight (u_long rc, int &rest)
// {}
// Ȳ (1<<WEIGHT) 礭ˤϡrest  rc 
// (1<<WEIGHT) ͤ˥åȤ롥Ǥʤʬ򤹤롥
// Ȳ 1/2 꾮Ѿο֤ rest
// ˤϡ᤿Ѿ rc Ȥκʬ򥻥åȤ롥
// {}
{
    assert (rc > 1);
    const int rc2 = rc / 2;

    if (rc2 > (1 << WEIGHT)) {
	rest = rc - (1 << WEIGHT);
	return (1 << WEIGHT);
    }
    else {
	register u_long x = (1 << WEIGHT);
	while ((x & rc2) == 0)
	    x >>= 1;
	rest = rc - x;
	assert (x <= (1 << WEIGHT));
	return x;
    }
}

// /////////////////////////////////////////////////////////////////

// /////////////////////////////////////////////////////////////////
// class ImportEntry
// /////////////////////////////////////////////////////////////////


// 祤ȤΥեޥå
// +-------+-------+---------------+
// | tag	|	| lrc		|
// +-------+-------+---------------+
// | gid				|
// +---------------+---------------+
// | msg_count	| index		|
// +---------------+---------------+

GlobalID
ImportEntry::Export (GidHintBit hint)
{
    GlobalID export;
    int	    rest;

    if (laddr->LRC () == 1) {

	// Ȳ 1 ǤäʤС͢Фˤäơ͢
	// ɽΥȥȥ祤ȤפȤʤΤǲ롥

	// ͢Фκݤˤϡ͢ɽ˳ǼƤȲ GID ź
	// դ롥GID ǤϳȲ 2 ζҾñ̤Ǥ뤳
	// ȤǤʤΤǡȲ 2 ζҾǤʤäˤϡ
	// Ĥ Close åˤäơΥ祤ȤؤƤ
	// ͢иˤ롥

	if (grc > 1) {

	    // split_weight  grc  1/2 ʲκ 2 ζҾ
	    // Τǡsplit_weight  2 ܤλȥȤ롥grc
	    //  2 ζҾʤСsplit_weight ֵͤ 2 ܤ grc
	    // Ǥ

	    // 祤Ȥ dest եɤϡindex, #PE ʳξ
	    // ʤȤ!!!

	    u_long  x = part_of_Power2 (grc, rest);

	    export = gid.Tagging (hint, x);

	    if (rest != 0) {

		// Ĥλȥ
		// Ĥ꤬ 0 ä顤Close ɬפϤʤ

		GlobalMessage *gm = new_ctl_GlobalMessage (Msg_Close);
		gm->set_CtlInfo (GlobalID (0), (u_long) rest);
		send_to_other_pe (gid, gm);
	    }
	    if (PElog) {
		x = rest - grc;
		grc = 0;
		ImportTable->pelog_grc (this, x);
	    }
	}
	else {

	    // 뻲ȥȤ 1 ʤΤǽŤߤɬפʤ

	    export = gid;
	    export.Hint (hint);
	}

	((MJ_IMP_t *) laddr)->Free ();
	Initialize ();
    }
    else {
	// Ȳ 1 Ǥʤʥ祤¤Ӥ͢ɽΥ
	// ʤ

	if (grc == 1) {

	    // Х뻲ȥȤ 1 ĤäƤʤΤǡʬ䤷
	    // ϤȤǤʤ

	    // 祤ȤΥɥ쥹

	    // laddr λȲ GlobalID::GlobalID()  -1 Τ
	    // ǹԤʤɬפϤʤ

	    export = GlobalID (ObjectWord (laddr), hint, WEIGHT);
	    if (PElog)
		ImportTable->pelog_grc (this, WEIGHT);
	}
	else {
	    laddr->LRC_plus (-1);

	    // ȲʬǤΤǡGID ʬźդ
	    // 

	    // grc.SplitWeight()  grc  1/2 ʲκ 2 ζҾ
	    // ֤rest ˤϻĤλȲåȤ롥

	    u_long  y = SplitWeight (grc, rest);

	    export = gid.Tagging (hint, y);
	    y = rest - grc;
	    grc = rest;
	    if (PElog)
		ImportTable->pelog_grc (this, y);
	}
    }
    return export;
}


u_long
ImportEntry::Divide_grc ()
{
    u_long  rc = grc / 2;
    if (rc > (1 << WEIGHT))
	rc = (1 << WEIGHT);
    grc = grc - rc;
    if (PElog)
	ImportTable->pelog_grc (this, -rc);
    return rc;
}

// /////////////////////////////////////////////////////////////////
// class ImportTableClass
// /////////////////////////////////////////////////////////////////

inline ImportEntry *
ImportTableClass::Hash (const u_int x)
{
    return &Array[((x >> 16) + x) % max_of_imports];
}

inline int
ImportTableClass::Index (const ImportEntry * x) const
{
    return x - &Array[0];
}

void
ImportTableClass::Initialize (int size)
{
    if (size < IMPORT_TABLE_SIZE)
	size = IMPORT_TABLE_SIZE;
    max_of_imports = size;
    no_of_imports = 0;

    Array = (ImportEntry *) SHARED_ALLOC (size * sizeof (ImportEntry));
    int	    n = size;
    while (--n >= 0)
	Array[n].Initialize ();
}

void
ImportTableClass::Terminate ()
{
    if (Warnning) {
	if (no_of_imports != 0) {
	    for (int n = 0; n < max_of_imports; n++) {
		if (!Array[n].IsEmpty ())
		    pelog ("Warning: rest importing object: %s",
			   Array[n].GID ().Print ());
	    }
	}
    }
}

void
ImportTableClass::Register (const GlobalID agid, u_long grc,
			    MJ_W_t * mj, ObjectTag objtag)
// {}
// gid 򥭡ȤõImportTable  mj Ͽ롥⤷Ͽ
// ƤʤСȥݤ gid, grc, mj Ͽ
// mj Υ objtag ˤ롥ϿƤˤϡ
//  grc ͤûmj ϿƤ른祤Ȥ
// ³롥ŤդȲʬ䤵ƤǽΡ
// gid.ReferenceCount() ѤͿƤ grc Ȥ
// {}
{
    if (TableisFull ())
	fatal (TAG, "Import Table Overflow");

    u_int   index = agid.Hashval ();
    GlobalID gid = GlobalID (index);

    for (int n = max_of_imports; --n >= 0; index++) {
	ImportEntry *eep = Hash (index);
	if (eep->IsEmpty ()) {
	    no_of_imports++;
	    eep->Install (gid, grc);
	    eep->Imported_joint (mj->mut2_MJ_IMP (objtag, gid, Index (eep)));
	    if (PElog)
		pelog_grc (eep, grc);
	    if (DebugConnect)
		log_stream ("open", gid.Print (), eep - &Array[0], mj->Print ());
	    return;
	}
	else if (eep->GID () == gid) {
	    // {}
	    // ϿƤ른祤ȤΥϡIMP_OBJ 
	    // IMP_OBJ_NT ǤϤ
	    // {}
	    assert ((eep->Imported_joint ()->Type () == IMP_OBJ
		     || eep->Imported_joint ()->Type () == IMP_OBJ_NT));
	    eep->GRC () += grc;
	    eep->Imported_joint ()->LRC ()++;
	    MJ_IMP_t *ij = eep->Imported_joint ();
	    mj->mut2_MJ_C (ij);
	    if (PElog)
		pelog_grc (eep, grc);
	    return;
	}
    }
    return;
}

Word
ImportTableClass::Register (const GlobalID & agid, GidHintBit hint)
// {}
//  register 2δؿ3ΤȤΤϰۤʤΤա
// @item ˡϿƤСŤդȲ ImportTable 
// Х뻲Ȳ˲ûΥ祤ȤΥɥ쥹֤
// @item Ǥʤˤϡ˥祤Ȥ ImportTable
// Ͽ롥λ GID ϽŤդȲ祤ȥס
// ƤϿ롥ImportTable ΥХ뻲Ȳ GID
// Фͤꤹ롥Ǹˡ祤Ȥ
// ɥ쥹֤
// {}
{
    assert (no_of_imports < max_of_imports);
    u_long  grc = agid.ReferenceCount ();
    assert (grc > 0);
    u_int   index = agid.Hashval ();
    GlobalID gid = GlobalID (index);

    for (int n = max_of_imports; --n >= 0; index++) {
	ImportEntry *eep = Hash (index);
	MJ_IMP_t *mj;
	if (eep->IsEmpty ()) {
	    ObjectTag otag;
	    no_of_imports++;
	    switch (hint) {
	    case GID_HINT_OBJECT:
		otag = IMP_OBJ;
		break;
	    case GID_HINT_OUTLET:
		otag = IMP_OUTLET;
		break;
	    case GID_HINT_MJ_INLET:
		otag = IMP_INLET;
		break;
	    default:
		abort ();
	    }
	    eep->Install (gid, grc);
	    eep->Imported_joint ((mj = new_MJ_IMP_t (otag, gid, Index (eep))));
	    if (PElog)
		pelog_grc (eep, grc);
	    return ObjectWord (mj);
	}
	else if (eep->GID () == gid) {
	    eep->GRC () += grc;
	    mj = eep->Imported_joint ();
	    mj->LRC () += 1;
	    if (PElog)
		pelog_grc (eep, grc);
	    assert (!(hint == GID_HINT_MJ_INLET && mj->oTag () == IMP_INLET));
	    return ObjectWord (mj);
	}
    }
    fatal (TAG, "Import Table Overflow");
    return NILATOM;
}

GlobalID
ImportTableClass::Export (MJ_IMP_t * ptr, GidHintBit hint)
{
    ImportEntry *eep = &Array[ptr->Index ()];
    return eep->Export (hint);
}

u_long
ImportTableClass::Delete (MJ_IMP_t * ptr)
// {}
// 祤ȤΥɥ쥹ȤΥ祤ȤϿκ
// ʤ ImportTable ϿƤ른祤Ȥ index ե
// ɤˡ ImportTableǤ index äƤ뤿ᡢϥåԤ
// 鷺ˤࡣ꥿ͤϡХ뻲ȥȤǤ롣
// {}
{
    assert (ptr->Index () >= 0 && ptr->Index () < max_of_imports);
    assert (Array[ptr->Index ()].GRC () > 0);

    ImportEntry *eep = &Array[ptr->Index ()];
    u_long  grc = eep->GRC ();
    if (DebugConnect)
	log_stream ("close", eep->GID ().Print (), ptr->Index (), ptr->Print ());
    if (PElog) {
	eep->GRC () = 0;
	pelog_grc (eep, -grc);
    }
    eep->Initialize ();
    --no_of_imports;
    return grc;
}

void
ImportTableClass::Valid (int index)
// {}
// ǥХåѴؿindex Ϳ륨ȥ꤬ɤĴ
// ٤
// {]
{
    if (index < 0 || index > max_of_imports)
	abort ();
    if (Array[index].GRC () == 0)
	abort ();
}

void
ImportTableClass::pelog_grc (ImportEntry * eep, int dif)
const
{
    if (!ShowRC)
	return;
    u_long  index = eep - &Array[0];
    u_long  result = eep->GRC ();
    u_long  old = result - dif;
    char    op = (dif < 0) ? '-' : '+';
    dif = (dif < 0) ? -dif : dif;
    {
	char	tem[128];
	sprintf (tem, "<%d> GRC: %d %c %d = %d", index, old, op, dif, result);
	if (old == 0)
	    pelog ("%s; import %s", tem, eep->Imported_joint ()->Print ());
	else if (result == 0)
	    pelog ("%s; unimport %s", tem, eep->Imported_joint ()->Print ());
	else
	    pelog (tem);
    }
}

#ifdef PAS_DEBUGGER
void
ImportTableClass::Free ()
{
    SHARED_FREE (Array, max_of_imports * sizeof (ImportEntry));
}
#endif

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
