/*- -*- Mode: C++ -*-							 -*/
/*- Copyright (C) 1992 Institute for New Generation Computer Technology. -*/
/*- $BG[IU$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F$/$@$5$$!%(B                  -*/
/*- (Read COPYRIGHT for detailed information.)                           -*/
/*-                                                                      -*/
/*-		    Author: Shinji Yanagida (yanagida@nsis.cl.nec.co.jp) -*/
/*-		    Author: Toshio Tange (t-tange@nsis.cl.nec.co.jp)	 -*/

// {}
// ͢ɽ (Export Table)
// {}

#ifndef table_export_h
#define table_export_h

#include "config.h"
#include "aum/types.h"
#include "aum/header.h"
#include "aum/globalid.h"

#ifndef EXPORT_TABLE_SIZE
#define EXPORT_TABLE_SIZE	(4*1024)
#endif

class ExportEntry {
private:
    Word		local;
    u_long		grc;

protected:

public:
    void		Initialize();
    Boolean		IsEmpty() const;
    void		Install(Word, u_long);
    u_long&		GRC() /* const */;
    Word		Local() const;
    Boolean		EqualLocalAddress(Header*) const;
    Word		DereferenceLocal();
};

inline void ExportEntry::Initialize()
{
    local = SINKOBJ, grc = 0;
}

inline Boolean ExportEntry::IsEmpty() const
{
    return grc == 0 ? TRUE : FALSE;
}

inline void ExportEntry::Install(Word l, u_long w)
{
    local = l, grc = w;
}

inline u_long& ExportEntry::GRC() /* const */
{
    return grc;
}

inline Word ExportEntry::Local() const
{
    return local;
}

inline Boolean ExportEntry::EqualLocalAddress(Header* ptr) const
{
    return IsPointer(local) && Pointer(local) == ptr ? TRUE : FALSE;
}

class ExportTableClass {

protected:
    int			max_of_exports;
    int			no_of_exports;
    ExportEntry*	Array;

    ExportEntry*	Hash(const u_long);
    u_long		Index(const ExportEntry*) const;
    void		pelog_grc(ExportEntry*, int) const;

public:
    void		Initialize(int size);
    void		Terminate ();
    Boolean		TableisFull() const;
    GlobalID		Register(Header*, int);
    Word		Lookup(const GlobalID);
    u_long		GRC(const GlobalID&);
    u_long		GRCminus(const GlobalID&, u_long);
    u_long		decrGRC(const GlobalID&);
    int			No_of_exports() const;
#ifdef PAS_DEBUGGER
    void		Free();
#endif
};

inline Boolean ExportTableClass::TableisFull() const
{
    return (no_of_exports < max_of_exports) ? FALSE : TRUE;
}

inline int ExportTableClass::No_of_exports() const
{
    return no_of_exports;
}

//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//
//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//\\//

extern ExportTableClass*	ExportTable;

/*-----------------
 * Local Variables:
 * c-indent-level:4
 * c-continued-statement-offset:4
 * c-brace-offset:0
 * c-imaginary-offset:0
 * c-argdecl-indent:4
 * c-label-offset:-4
 * c++-electric-colon:t
 * c++-empty-arglist-indent:nil
 * c++-friend-offset:-4
 * c++-member-init-indent-offset:0
 * c++-continued-member-init-offset:nil
 * End:
 */
#endif /* !table_export_h */
